/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim.aggregator;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.aggregator.DifferentiableLossAggregator;
import org.apache.spark.ml.util.TestingUtils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001\u0002\u000b\u0016\u0001\tBQa\n\u0001\u0005\u0002!Bqa\u000b\u0001C\u0002\u0013%A\u0006\u0003\u0004:\u0001\u0001\u0006I!\f\u0005\bu\u0001\u0011\r\u0011\"\u0003<\u0011\u0019\u0011\u0005\u0001)A\u0005y!)1\t\u0001C\u0005\t\u001e)q,\u0006E\u0001A\u001a)A#\u0006E\u0001C\")q\u0005\u0003C\u0001Q\u001a!\u0011\u000e\u0003\u0001k\u0011!q'B!A!\u0002\u0013y\u0007\u0002\u0003:\u000b\u0005\u0003\u0005\u000b\u0011B:\t\u000b\u001dRA\u0011A=\t\u000fuT!\u0019!C)}\"1qP\u0003Q\u0001\n=Dq!!\u0001\u000b\t\u0003\n\u0019\u0001\u0003\u0005\u0002\n!!\t!GA\u0006\u0011!\t9\u0003\u0003C\u00013\u0005%\u0002\"CA\u001e\u0011\u0005\u0005I\u0011BA\u001f\u0005\u0005\"\u0015N\u001a4fe\u0016tG/[1cY\u0016dun]:BO\u001e\u0014XmZ1u_J\u001cV/\u001b;f\u0015\t1r#\u0001\u0006bO\u001e\u0014XmZ1u_JT!\u0001G\r\u0002\u000b=\u0004H/[7\u000b\u0005iY\u0012AA7m\u0015\taR$A\u0003ta\u0006\u00148N\u0003\u0002\u001f?\u00051\u0011\r]1dQ\u0016T\u0011\u0001I\u0001\u0004_J<7\u0001A\n\u0003\u0001\r\u0002\"\u0001J\u0013\u000e\u0003mI!AJ\u000e\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0006\u0005\u0002+\u00015\tQ#\u0001\u0006j]N$\u0018M\\2fgF*\u0012!\f\t\u0004]E\u001aT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\u000b\u0005\u0013(/Y=\u0011\u0005Q:T\"A\u001b\u000b\u0005YJ\u0012a\u00024fCR,(/Z\u0005\u0003qU\u0012\u0001\"\u00138ti\u0006t7-Z\u0001\fS:\u001cH/\u00198dKN\f\u0004%\u0001\u0006j]N$\u0018M\\2fgJ*\u0012\u0001\u0010\t\u0004{\u0001\u001bT\"\u0001 \u000b\u0005}z\u0013AC2pY2,7\r^5p]&\u0011\u0011I\u0010\u0002\u0004'\u0016\f\u0018aC5ogR\fgnY3te\u0001\n1\"Y:tKJ$X)];bYV\u0019Q\t\u0015.\u0015\u0007\u0019KU\f\u0005\u0002/\u000f&\u0011\u0001j\f\u0002\u0005+:LG\u000fC\u0003K\r\u0001\u00071*\u0001\u0003bO\u001e\f\u0004\u0003\u0002\u0016M\u001dfK!!T\u000b\u00039\u0011KgMZ3sK:$\u0018.\u00192mK2{7o]!hOJ,w-\u0019;peB\u0011q\n\u0015\u0007\u0001\t\u0015\tfA1\u0001S\u0005\u0005!\u0016CA*W!\tqC+\u0003\u0002V_\t9aj\u001c;iS:<\u0007C\u0001\u0018X\u0013\tAvFA\u0002B]f\u0004\"a\u0014.\u0005\u000bm3!\u0019\u0001/\u0003\u0007\u0005;w-\u0005\u0002T\u0017\")aL\u0002a\u0001\u0017\u0006!\u0011mZ43\u0003\u0005\"\u0015N\u001a4fe\u0016tG/[1cY\u0016dun]:BO\u001e\u0014XmZ1u_J\u001cV/\u001b;f!\tQ\u0003bE\u0002\tE\u0016\u0004\"AL2\n\u0005\u0011|#AB!osJ+g\r\u0005\u0002/M&\u0011qm\f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0002A\nqA+Z:u\u0003\u001e<'/Z4bi>\u00148c\u0001\u0006cWB!!\u0006T\u001am!\ti'\"D\u0001\t\u0003-qW/\u001c$fCR,(/Z:\u0011\u00059\u0002\u0018BA90\u0005\rIe\u000e^\u0001\rG>,gMZ5dS\u0016tGo\u001d\t\u0003i^l\u0011!\u001e\u0006\u0003mf\ta\u0001\\5oC2<\u0017B\u0001=v\u0005\u00191Vm\u0019;peR\u0011!\u0010 \u000b\u0003YnDQA]\u0007A\u0002MDQA\\\u0007A\u0002=\f1\u0001Z5n+\u0005y\u0017\u0001\u00023j[\u0002\n1!\u00193e)\ra\u0017Q\u0001\u0005\u0007\u0003\u000f\u0001\u0002\u0019A\u001a\u0002\u0011%t7\u000f^1oG\u0016\f\u0001dZ3u%\u0016<'/Z:tS>t7+^7nCJL'0\u001a:t)\u0011\ti!a\t\u0011\u000f9\ny!a\u0005\u0002\u0014%\u0019\u0011\u0011C\u0018\u0003\rQ+\b\u000f\\33!\u0011\t)\"a\b\u000e\u0005\u0005]!\u0002BA\r\u00037\tAa\u001d;bi*\u0019\u0011QD\u000e\u0002\u000b5dG.\u001b2\n\t\u0005\u0005\u0012q\u0003\u0002\u001d\u001bVdG/\u001b<be&\fG/Z(oY&tWmU;n[\u0006\u0014\u0018N_3s\u0011\u0019\t)#\u0005a\u0001[\u0005I\u0011N\\:uC:\u001cWm]\u0001\u001dO\u0016$8\t\\1tg&4\u0017nY1uS>t7+^7nCJL'0\u001a:t)\u0011\tY#!\u000f\u0011\u000f9\ny!a\u0005\u0002.A!\u0011qFA\u001b\u001b\t\t\tDC\u0002\u00024e\tab\u00197bgNLg-[2bi&|g.\u0003\u0003\u00028\u0005E\"\u0001F'vYRL7\t\\1tgN+X.\\1sSj,'\u000f\u0003\u0004\u0002&I\u0001\r!L\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002@A!\u0011\u0011IA&\u001b\t\t\u0019E\u0003\u0003\u0002F\u0005\u001d\u0013\u0001\u00027b]\u001eT!!!\u0013\u0002\t)\fg/Y\u0005\u0005\u0003\u001b\n\u0019E\u0001\u0004PE*,7\r\u001e")
public class DifferentiableLossAggregatorSuite
extends SparkFunSuite {
    private final Instance[] instances1 = (Instance[])((Object[])new Instance[]{new Instance(0.0, 0.1, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))), new Instance(1.0, 0.5, Vectors$.MODULE$.dense(1.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new Instance(2.0, 0.3, Vectors$.MODULE$.dense(4.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5})))});
    private final Seq<Instance> instances2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Instance[]{new Instance(0.2, 0.4, Vectors$.MODULE$.dense(0.8, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.5}))), new Instance(0.8, 0.9, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.3}))), new Instance(1.5, 0.2, Vectors$.MODULE$.dense(3.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.2})))}));

    private Instance[] instances1() {
        return this.instances1;
    }

    private Seq<Instance> instances2() {
        return this.instances2;
    }

    private <T, Agg extends DifferentiableLossAggregator<T, Agg>> void assertEqual(DifferentiableLossAggregator<T, Agg> agg1, DifferentiableLossAggregator<T, Agg> agg2) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)agg1.weight()));
        double $org_scalatest_assert_macro_right = agg2.weight();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)agg1.loss()));
        double $org_scalatest_assert_macro_right2 = agg2.loss();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(agg1.gradient());
        Vector $org_scalatest_assert_macro_right3 = agg2.gradient();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
    }

    public static final /* synthetic */ double $anonfun$new$17(Vector coefficients$1, Instance x0$1) {
        Instance instance = x0$1;
        if (instance == null) {
            throw new MatchError((Object)instance);
        }
        double label = instance.label();
        Vector features = instance.features();
        double d = label - BLAS$.MODULE$.dot(features, coefficients$1);
        return d;
    }

    public static final /* synthetic */ double $anonfun$new$18(Tuple2 x0$2) {
        double d;
        Instance instance;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x0$2;
                if (tuple2 == null) break block2;
                double error = tuple2._1$mcD$sp();
                instance = (Instance)tuple2._2();
                d = error;
                if (instance != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        Instance instance2 = instance;
        double d2 = instance2.weight() * d * d / 2.0;
        return d2;
    }

    public static final /* synthetic */ void $anonfun$new$19(Vector expectedGradient$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double error = tuple2._1$mcD$sp();
        Instance instance = (Instance)tuple2._2();
        BLAS$.MODULE$.axpy(instance.weight() * error, instance.features(), expectedGradient$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public DifferentiableLossAggregatorSuite() {
        this.test("empty aggregator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int numFeatures = 5;
            Vector coef = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(numFeatures, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0, ClassTag$.MODULE$.Double()));
            TestAggregator agg = new TestAggregator(numFeatures, coef);
            this.withClue("cannot get loss for empty aggregator", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> agg.loss(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55)));
            return (IllegalArgumentException)this.withClue("cannot get gradient for empty aggregator", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> agg.gradient(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60)));
        }, new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        this.test("aggregator initialization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int numFeatures = 3;
            Vector coef = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(numFeatures, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0, ClassTag$.MODULE$.Double()));
            TestAggregator agg = new TestAggregator(numFeatures, coef);
            agg.add(new Instance(1.0, 0.3, Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(numFeatures, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0, ClassTag$.MODULE$.Double()))));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)agg.gradient().size()));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)agg.weight()));
            double $org_scalatest_assert_macro_right2 = 0.3;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        }, new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        this.test("merge aggregators", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Vector coefficients = Vectors$.MODULE$.dense(0.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.1}));
            TestAggregator agg1 = new TestAggregator(2, coefficients);
            TestAggregator agg2 = new TestAggregator(2, coefficients);
            TestAggregator aggBadDim = new TestAggregator(1, Vectors$.MODULE$.dense(0.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])));
            aggBadDim.add(new Instance(1.0, 1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances1())).foreach((Function1 & Serializable & scala.Serializable)instance -> agg1.add((Instance)instance));
            this.withClue("cannot merge aggregators with different dimensions", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (TestAggregator)agg1.merge(aggBadDim), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85)));
            TestAggregator mergedEmptyOther = (TestAggregator)agg1.merge(agg2);
            this.assertEqual(mergedEmptyOther, agg1);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(mergedEmptyOther);
            TestAggregator $org_scalatest_assert_macro_right = agg1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
            TestAggregator agg3 = new TestAggregator(2, coefficients);
            TestAggregator mergedEmptyThis = (TestAggregator)agg3.merge(agg1);
            this.assertEqual(mergedEmptyThis, agg1);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(mergedEmptyThis);
            TestAggregator $org_scalatest_assert_macro_right2 = agg1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "!==", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$bang$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
            this.instances2().foreach((Function1 & Serializable & scala.Serializable)instance -> agg2.add((Instance)instance));
            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)agg1.loss()), (Object)BoxesRunTime.boxToDouble((double)agg1.weight()), (Object)agg1.gradient());
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            double loss1 = BoxesRunTime.unboxToDouble((Object)tuple3._1());
            double weight1 = BoxesRunTime.unboxToDouble((Object)tuple3._2());
            Vector grad1 = (Vector)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)loss1), (Object)BoxesRunTime.boxToDouble((double)weight1), (Object)grad1);
            Tuple3 tuple33 = tuple32;
            double loss12 = BoxesRunTime.unboxToDouble((Object)tuple33._1());
            double weight12 = BoxesRunTime.unboxToDouble((Object)tuple33._2());
            Vector grad12 = (Vector)tuple33._3();
            Tuple3 tuple34 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)agg2.loss()), (Object)BoxesRunTime.boxToDouble((double)agg2.weight()), (Object)agg2.gradient());
            if (tuple34 == null) {
                throw new MatchError((Object)tuple34);
            }
            double loss2 = BoxesRunTime.unboxToDouble((Object)tuple34._1());
            double weight2 = BoxesRunTime.unboxToDouble((Object)tuple34._2());
            Vector grad2 = (Vector)tuple34._3();
            Tuple3 tuple35 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)loss2), (Object)BoxesRunTime.boxToDouble((double)weight2), (Object)grad2);
            Tuple3 tuple36 = tuple35;
            double loss22 = BoxesRunTime.unboxToDouble((Object)tuple36._1());
            double weight22 = BoxesRunTime.unboxToDouble((Object)tuple36._2());
            Vector grad22 = (Vector)tuple36._3();
            TestAggregator merged = (TestAggregator)agg1.merge(agg2);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(merged);
            TestAggregator $org_scalatest_assert_macro_right3 = agg1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)merged.loss()));
            double $org_scalatest_assert_macro_right4 = (loss12 * weight12 + loss22 * weight22) / (weight12 + weight22);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)merged.weight()));
            double $org_scalatest_assert_macro_right5 = weight12 + weight22;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
            Vector addedGradients = Vectors$.MODULE$.dense((double[])grad12.toArray().clone());
            BLAS$.MODULE$.scal(weight12, addedGradients);
            BLAS$.MODULE$.axpy(weight22, grad22, addedGradients);
            BLAS$.MODULE$.scal(1.0 / (weight12 + weight22), addedGradients);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(merged.gradient());
            Vector $org_scalatest_assert_macro_right6 = addedGradients;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        }, new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        this.test("loss, gradient, weight", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Vector coefficients = Vectors$.MODULE$.dense(0.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.1}));
            TestAggregator agg = new TestAggregator(2, coefficients);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances1())).foreach((Function1 & Serializable & scala.Serializable)instance -> agg.add((Instance)instance));
            double[] errors = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances1())).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)DifferentiableLossAggregatorSuite.$anonfun$new$17(coefficients, x0$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            double[] expectedLoss = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(errors)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])this.instances1()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToDouble((double)DifferentiableLossAggregatorSuite.$anonfun$new$18(x0$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            Vector expectedGradient = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(errors)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])this.instances1()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                DifferentiableLossAggregatorSuite.$anonfun$new$19(expectedGradient, x0$3);
                return BoxedUnit.UNIT;
            });
            BLAS$.MODULE$.scal(1.0 / agg.weight(), expectedGradient);
            double weightSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances1())).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToDouble((double)x$3.weight()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(agg.weight()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(weightSum).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(agg.weight).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(weightSum).relTol(1.0E-5))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(agg.loss()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(expectedLoss)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / weightSum).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(agg.loss).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(scala.Predef.doubleArrayOps(expectedLoss).sum[Double](math.this.Numeric.DoubleIsFractional)./(weightSum)).relTol(1.0E-5))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(agg.gradient()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(expectedGradient).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(agg.gradient).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expectedGradient).relTol(1.0E-5))", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        }, new Position("DifferentiableLossAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
    }

    public static class TestAggregator
    implements DifferentiableLossAggregator<Instance, TestAggregator> {
        private final Vector coefficients;
        private final int dim;
        private double weightSum;
        private double lossSum;
        private double[] gradientSumArray;
        private volatile boolean bitmap$0;

        public DifferentiableLossAggregator merge(DifferentiableLossAggregator other) {
            return DifferentiableLossAggregator.merge$((DifferentiableLossAggregator)this, (DifferentiableLossAggregator)other);
        }

        public Vector gradient() {
            return DifferentiableLossAggregator.gradient$((DifferentiableLossAggregator)this);
        }

        public double weight() {
            return DifferentiableLossAggregator.weight$((DifferentiableLossAggregator)this);
        }

        public double loss() {
            return DifferentiableLossAggregator.loss$((DifferentiableLossAggregator)this);
        }

        public double weightSum() {
            return this.weightSum;
        }

        public void weightSum_$eq(double x$1) {
            this.weightSum = x$1;
        }

        public double lossSum() {
            return this.lossSum;
        }

        public void lossSum_$eq(double x$1) {
            this.lossSum = x$1;
        }

        private double[] gradientSumArray$lzycompute() {
            TestAggregator testAggregator = this;
            synchronized (testAggregator) {
                if (!this.bitmap$0) {
                    this.gradientSumArray = DifferentiableLossAggregator.gradientSumArray$((DifferentiableLossAggregator)this);
                    this.bitmap$0 = true;
                }
            }
            return this.gradientSumArray;
        }

        public double[] gradientSumArray() {
            return !this.bitmap$0 ? this.gradientSumArray$lzycompute() : this.gradientSumArray;
        }

        public int dim() {
            return this.dim;
        }

        public TestAggregator add(Instance instance) {
            double error = instance.label() - BLAS$.MODULE$.dot(this.coefficients, instance.features());
            this.weightSum_$eq(this.weightSum() + instance.weight());
            this.lossSum_$eq(this.lossSum() + instance.weight() * error * error / 2.0);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.dim()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
                $this.gradientSumArray()[j] = this.gradientSumArray()[j] + instance.weight() * error * instance.features().apply(j);
            });
            return this;
        }

        public TestAggregator(int numFeatures, Vector coefficients) {
            this.coefficients = coefficients;
            DifferentiableLossAggregator.$init$((DifferentiableLossAggregator)this);
            this.dim = numFeatures;
        }
    }
}

