/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim.aggregator;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.aggregator.DifferentiableLossAggregatorSuite$;
import org.apache.spark.ml.optim.aggregator.LeastSquaresAggregator;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.ml.util.TestingUtils$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u001d4A!\u0004\b\u00017!)\u0001\u0006\u0001C\u0001S!IA\u0006\u0001a\u0001\u0002\u0004%\t!\f\u0005\nu\u0001\u0001\r\u00111A\u0005\u0002mB\u0011\"\u0011\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u0018\t\u0013\u0019\u0003\u0001\u0019!a\u0001\n\u0003i\u0003\"C$\u0001\u0001\u0004\u0005\r\u0011\"\u0001I\u0011%Q\u0005\u00011A\u0001B\u0003&a\u0006C\u0005M\u0001\u0001\u0007\t\u0019!C\u0001[!IQ\n\u0001a\u0001\u0002\u0004%\tA\u0014\u0005\n!\u0002\u0001\r\u0011!Q!\n9BQA\u0015\u0001\u0005BMCQ\u0001\u0016\u0001\u0005\nU\u00131\u0004T3bgR\u001c\u0016/^1sKN\fum\u001a:fO\u0006$xN]*vSR,'BA\b\u0011\u0003)\twm\u001a:fO\u0006$xN\u001d\u0006\u0003#I\tQa\u001c9uS6T!a\u0005\u000b\u0002\u00055d'BA\u000b\u0017\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0002$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00023\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\b\u0011\u0011\u0005uqR\"\u0001\u000b\n\u0005}!\"!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\"M5\t!E\u0003\u0002$I\u0005!Q\u000f^5m\u0015\t)C#A\u0003nY2L'-\u0003\u0002(E\t)R\n\u00147jER+7\u000f^*qCJ\\7i\u001c8uKb$\u0018A\u0002\u001fj]&$h\bF\u0001+!\tY\u0003!D\u0001\u000f\u0003%Ign\u001d;b]\u000e,7/F\u0001/!\ry#\u0007N\u0007\u0002a)\t\u0011'A\u0003tG\u0006d\u0017-\u0003\u00024a\t)\u0011I\u001d:bsB\u0011Q\u0007O\u0007\u0002m)\u0011qGE\u0001\bM\u0016\fG/\u001e:f\u0013\tIdG\u0001\u0005J]N$\u0018M\\2f\u00035Ign\u001d;b]\u000e,7o\u0018\u0013fcR\u0011Ah\u0010\t\u0003_uJ!A\u0010\u0019\u0003\tUs\u0017\u000e\u001e\u0005\b\u0001\u000e\t\t\u00111\u0001/\u0003\rAH%M\u0001\u000bS:\u001cH/\u00198dKN\u0004\u0003F\u0001\u0003D!\tyC)\u0003\u0002Fa\tIAO]1og&,g\u000e^\u0001\u0019S:\u001cH/\u00198dKN\u001cuN\\:uC:$h)Z1ukJ,\u0017\u0001H5ogR\fgnY3t\u0007>t7\u000f^1oi\u001a+\u0017\r^;sK~#S-\u001d\u000b\u0003y%Cq\u0001\u0011\u0004\u0002\u0002\u0003\u0007a&A\rj]N$\u0018M\\2fg\u000e{gn\u001d;b]R4U-\u0019;ve\u0016\u0004\u0003FA\u0004D\u0003YIgn\u001d;b]\u000e,7oQ8ogR\fg\u000e\u001e'bE\u0016d\u0017AG5ogR\fgnY3t\u0007>t7\u000f^1oi2\u000b'-\u001a7`I\u0015\fHC\u0001\u001fP\u0011\u001d\u0001\u0015\"!AA\u00029\nq#\u001b8ti\u0006t7-Z:D_:\u001cH/\u00198u\u0019\u0006\u0014W\r\u001c\u0011)\u0005)\u0019\u0015!\u00032fM>\u0014X-\u00117m)\u0005a\u0014\u0001E4fi:+w/Q4he\u0016<\u0017\r^8s)\u00111\u0016L\u00172\u0011\u0005-:\u0016B\u0001-\u000f\u0005YaU-Y:u'F,\u0018M]3t\u0003\u001e<'/Z4bi>\u0014\b\"\u0002\u0017\r\u0001\u0004q\u0003\"B.\r\u0001\u0004a\u0016\u0001D2pK\u001a4\u0017nY5f]R\u001c\bCA/a\u001b\u0005q&BA0\u0013\u0003\u0019a\u0017N\\1mO&\u0011\u0011M\u0018\u0002\u0007-\u0016\u001cGo\u001c:\t\u000b\rd\u0001\u0019\u00013\u0002\u0019\u0019LG/\u00138uKJ\u001cW\r\u001d;\u0011\u0005=*\u0017B\u000141\u0005\u001d\u0011un\u001c7fC:\u0004")
public class LeastSquaresAggregatorSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient Instance[] instances;
    private transient Instance[] instancesConstantFeature;
    private transient Instance[] instancesConstantLabel;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public Instance[] instances() {
        return this.instances;
    }

    public void instances_$eq(Instance[] x$1) {
        this.instances = x$1;
    }

    public Instance[] instancesConstantFeature() {
        return this.instancesConstantFeature;
    }

    public void instancesConstantFeature_$eq(Instance[] x$1) {
        this.instancesConstantFeature = x$1;
    }

    public Instance[] instancesConstantLabel() {
        return this.instancesConstantLabel;
    }

    public void instancesConstantLabel_$eq(Instance[] x$1) {
        this.instancesConstantLabel = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
        this.instances_$eq((Instance[])((Object[])new Instance[]{new Instance(0.0, 0.1, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))), new Instance(1.0, 0.5, Vectors$.MODULE$.dense(1.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new Instance(2.0, 0.3, Vectors$.MODULE$.dense(4.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5})))}));
        this.instancesConstantFeature_$eq((Instance[])((Object[])new Instance[]{new Instance(0.0, 0.1, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))), new Instance(1.0, 0.5, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new Instance(2.0, 0.3, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5})))}));
        this.instancesConstantLabel_$eq((Instance[])((Object[])new Instance[]{new Instance(1.0, 0.1, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))), new Instance(1.0, 0.5, Vectors$.MODULE$.dense(1.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new Instance(1.0, 0.3, Vectors$.MODULE$.dense(4.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5})))}));
    }

    private LeastSquaresAggregator getNewAggregator(Instance[] instances, org.apache.spark.ml.linalg.Vector coefficients, boolean fitIntercept) {
        Tuple2<MultivariateOnlineSummarizer, MultivariateOnlineSummarizer> tuple2 = DifferentiableLossAggregatorSuite$.MODULE$.getRegressionSummarizers(instances);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        MultivariateOnlineSummarizer featuresSummarizer = (MultivariateOnlineSummarizer)tuple2._1();
        MultivariateOnlineSummarizer ySummarizer = (MultivariateOnlineSummarizer)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)featuresSummarizer, (Object)ySummarizer);
        Tuple2 tuple23 = tuple22;
        MultivariateOnlineSummarizer featuresSummarizer2 = (MultivariateOnlineSummarizer)tuple23._1();
        MultivariateOnlineSummarizer ySummarizer2 = (MultivariateOnlineSummarizer)tuple23._2();
        double yStd = package$.MODULE$.sqrt(ySummarizer2.variance().apply(0));
        double yMean = ySummarizer2.mean().apply(0);
        double[] featuresStd = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(featuresSummarizer2.variance().toArray())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.sqrt(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        Broadcast bcFeaturesStd = this.spark().sparkContext().broadcast((Object)featuresStd, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Vector featuresMean = featuresSummarizer2.mean();
        Broadcast bcFeaturesMean = this.spark().sparkContext().broadcast((Object)featuresMean.toArray(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Broadcast bcCoefficients = this.spark().sparkContext().broadcast((Object)coefficients, ClassTag$.MODULE$.apply(org.apache.spark.ml.linalg.Vector.class));
        return new LeastSquaresAggregator(yStd, yMean, fitIntercept, bcFeaturesStd, bcFeaturesMean, bcCoefficients);
    }

    private final void testImplicits$lzycompute$1() {
        LeastSquaresAggregatorSuite leastSquaresAggregatorSuite = this;
        synchronized (leastSquaresAggregatorSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ double $anonfun$new$13(int numFeatures$1, double[] featuresMean$1, double[] featuresStd$1, double yMean$1, double yStd$1, org.apache.spark.ml.linalg.Vector coefficients$1, Instance x0$1) {
        Instance instance = x0$1;
        if (instance == null) {
            throw new MatchError((Object)instance);
        }
        double l = instance.label();
        org.apache.spark.ml.linalg.Vector f = instance.features();
        double[] scaledFeatures = (double[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numFeatures$1).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)j -> (f.toArray()[j] - featuresMean$1[j]) / featuresStd$1[j], IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
        double scaledLabel = (l - yMean$1) / yStd$1;
        double d = BLAS$.MODULE$.dot(coefficients$1, Vectors$.MODULE$.dense(scaledFeatures)) - scaledLabel;
        return d;
    }

    public static final /* synthetic */ double $anonfun$new$15(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double error = tuple2._1$mcD$sp();
        Instance instance = (Instance)tuple2._2();
        double d = instance.weight() * error * error / 2.0;
        return d;
    }

    public static final /* synthetic */ void $anonfun$new$16(int numFeatures$1, double[] featuresStd$1, org.apache.spark.ml.linalg.Vector expectedGradient$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double error = tuple2._1$mcD$sp();
        Instance instance = (Instance)tuple2._2();
        double[] scaledFeatures = (double[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numFeatures$1).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)j -> instance.weight() * instance.features().toArray()[j] / featuresStd$1[j], IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
        BLAS$.MODULE$.axpy(error, Vectors$.MODULE$.dense(scaledFeatures), expectedGradient$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public LeastSquaresAggregatorSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("aggregator add method input size", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            org.apache.spark.ml.linalg.Vector coefficients = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}));
            LeastSquaresAggregator agg = this.getNewAggregator(this.instances(), coefficients, true);
            return (IllegalArgumentException)this.withClue("LeastSquaresAggregator features dimension must match coefficients dimension", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> agg.add(new Instance(1.0, 1.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("LeastSquaresAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73)));
        }, new Position("LeastSquaresAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        this.test("negative weight", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            org.apache.spark.ml.linalg.Vector coefficients = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}));
            LeastSquaresAggregator agg = this.getNewAggregator(this.instances(), coefficients, true);
            return (IllegalArgumentException)this.withClue("LeastSquaresAggregator does not support negative instance weights.", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> agg.add(new Instance(1.0, -1.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0})))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("LeastSquaresAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83)));
        }, new Position("LeastSquaresAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        this.test("check sizes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            org.apache.spark.ml.linalg.Vector coefficients = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}));
            LeastSquaresAggregator aggIntercept = this.getNewAggregator(this.instances(), coefficients, true);
            LeastSquaresAggregator aggNoIntercept = this.getNewAggregator(this.instances(), coefficients, false);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)instance -> aggIntercept.add(instance));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)instance -> aggNoIntercept.add(instance));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)aggIntercept.gradient().size()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LeastSquaresAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)aggNoIntercept.gradient().size()));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LeastSquaresAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        }, new Position("LeastSquaresAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        this.test("check correctness", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            org.apache.spark.ml.linalg.Vector coefficients = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}));
            int numFeatures = coefficients.size();
            Tuple2<MultivariateOnlineSummarizer, MultivariateOnlineSummarizer> tuple2 = DifferentiableLossAggregatorSuite$.MODULE$.getRegressionSummarizers(this.instances());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            MultivariateOnlineSummarizer featuresSummarizer = (MultivariateOnlineSummarizer)tuple2._1();
            MultivariateOnlineSummarizer ySummarizer = (MultivariateOnlineSummarizer)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)featuresSummarizer, (Object)ySummarizer);
            Tuple2 tuple23 = tuple22;
            MultivariateOnlineSummarizer featuresSummarizer2 = (MultivariateOnlineSummarizer)tuple23._1();
            MultivariateOnlineSummarizer ySummarizer2 = (MultivariateOnlineSummarizer)tuple23._2();
            double[] featuresStd = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(featuresSummarizer2.variance().toArray())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.sqrt(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            double[] featuresMean = featuresSummarizer2.mean().toArray();
            double yStd = package$.MODULE$.sqrt(ySummarizer2.variance().apply(0));
            double yMean = ySummarizer2.mean().apply(0);
            LeastSquaresAggregator agg = this.getNewAggregator(this.instances(), coefficients, true);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)instance -> agg.add(instance));
            double[] errors = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)LeastSquaresAggregatorSuite.$anonfun$new$13(numFeatures, featuresMean, featuresStd, yMean, yStd, coefficients, x0$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            double[] expectedLoss = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(errors)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])this.instances()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToDouble((double)LeastSquaresAggregatorSuite.$anonfun$new$15(x0$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            org.apache.spark.ml.linalg.Vector expectedGradient = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(errors)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])this.instances()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                LeastSquaresAggregatorSuite.$anonfun$new$16(numFeatures, featuresStd, expectedGradient, x0$3);
                return BoxedUnit.UNIT;
            });
            double weightSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToDouble((double)x$3.weight()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            BLAS$.MODULE$.scal(1.0 / weightSum, expectedGradient);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(agg.loss()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(expectedLoss)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / weightSum).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(agg.loss).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(scala.Predef.doubleArrayOps(expectedLoss).sum[Double](math.this.Numeric.DoubleIsFractional)./(weightSum)).relTol(1.0E-5))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LeastSquaresAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(agg.gradient()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(expectedGradient).relTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(agg.gradient).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expectedGradient).relTol(1.0E-5))", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LeastSquaresAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        }, new Position("LeastSquaresAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
        this.test("check with zero standard deviation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            org.apache.spark.ml.linalg.Vector coefficients = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}));
            LeastSquaresAggregator aggConstantFeature = this.getNewAggregator(this.instancesConstantFeature(), coefficients, true);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)instance -> aggConstantFeature.add(instance));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)aggConstantFeature.gradient().apply(0)));
            double $org_scalatest_assert_macro_right = 0.0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LeastSquaresAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
            return (IllegalArgumentException)this.withClue("LeastSquaresAggregator does not support zero standard deviation of the label", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.getNewAggregator(this.instancesConstantLabel(), coefficients, true), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("LeastSquaresAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155)));
        }, new Position("LeastSquaresAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
    }
}

