/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim.aggregator;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.classification.MultiClassSummarizer;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.aggregator.DifferentiableLossAggregatorSuite$;
import org.apache.spark.ml.optim.aggregator.LogisticAggregator;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.ml.util.TestingUtils$;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001%4A!\u0004\b\u00017!)\u0001\u0006\u0001C\u0001S!IA\u0006\u0001a\u0001\u0002\u0004%\t!\f\u0005\nu\u0001\u0001\r\u00111A\u0005\u0002mB\u0011\"\u0011\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u0018\t\u0013\u0019\u0003\u0001\u0019!a\u0001\n\u0003i\u0003\"C$\u0001\u0001\u0004\u0005\r\u0011\"\u0001I\u0011%Q\u0005\u00011A\u0001B\u0003&a\u0006C\u0005M\u0001\u0001\u0007\t\u0019!C\u0001[!IQ\n\u0001a\u0001\u0002\u0004%\tA\u0014\u0005\n!\u0002\u0001\r\u0011!Q!\n9BQA\u0015\u0001\u0005BMCQ\u0001\u0016\u0001\u0005\nU\u0013q\u0003T8hSN$\u0018nY!hOJ,w-\u0019;peN+\u0018\u000e^3\u000b\u0005=\u0001\u0012AC1hOJ,w-\u0019;pe*\u0011\u0011CE\u0001\u0006_B$\u0018.\u001c\u0006\u0003'Q\t!!\u001c7\u000b\u0005U1\u0012!B:qCJ\\'BA\f\u0019\u0003\u0019\t\u0007/Y2iK*\t\u0011$A\u0002pe\u001e\u001c\u0001aE\u0002\u00019\u0001\u0002\"!\b\u0010\u000e\u0003QI!a\b\u000b\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t\tc%D\u0001#\u0015\t\u0019C%\u0001\u0003vi&d'BA\u0013\u0015\u0003\u0015iG\u000e\\5c\u0013\t9#EA\u000bN\u00192L'\rV3tiN\u0003\u0018M]6D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\u0005Q\u0003CA\u0016\u0001\u001b\u0005q\u0011!C5ogR\fgnY3t+\u0005q\u0003cA\u00183i5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004GA\u0003BeJ\f\u0017\u0010\u0005\u00026q5\taG\u0003\u00028%\u00059a-Z1ukJ,\u0017BA\u001d7\u0005!Ien\u001d;b]\u000e,\u0017!D5ogR\fgnY3t?\u0012*\u0017\u000f\u0006\u0002=\u007fA\u0011q&P\u0005\u0003}A\u0012A!\u00168ji\"9\u0001iAA\u0001\u0002\u0004q\u0013a\u0001=%c\u0005Q\u0011N\\:uC:\u001cWm\u001d\u0011)\u0005\u0011\u0019\u0005CA\u0018E\u0013\t)\u0005GA\u0005ue\u0006t7/[3oi\u0006A\u0012N\\:uC:\u001cWm]\"p]N$\u0018M\u001c;GK\u0006$XO]3\u00029%t7\u000f^1oG\u0016\u001c8i\u001c8ti\u0006tGOR3biV\u0014Xm\u0018\u0013fcR\u0011A(\u0013\u0005\b\u0001\u001a\t\t\u00111\u0001/\u0003eIgn\u001d;b]\u000e,7oQ8ogR\fg\u000e\u001e$fCR,(/\u001a\u0011)\u0005\u001d\u0019\u0015\u0001I5ogR\fgnY3t\u0007>t7\u000f^1oi\u001a+\u0017\r^;sK\u001aKG\u000e^3sK\u0012\fA%\u001b8ti\u0006t7-Z:D_:\u001cH/\u00198u\r\u0016\fG/\u001e:f\r&dG/\u001a:fI~#S-\u001d\u000b\u0003y=Cq\u0001Q\u0005\u0002\u0002\u0003\u0007a&A\u0011j]N$\u0018M\\2fg\u000e{gn\u001d;b]R4U-\u0019;ve\u00164\u0015\u000e\u001c;fe\u0016$\u0007\u0005\u000b\u0002\u000b\u0007\u0006I!-\u001a4pe\u0016\fE\u000e\u001c\u000b\u0002y\u0005\u0001r-\u001a;OK^\fum\u001a:fO\u0006$xN\u001d\u000b\u0006-fS&m\u001a\t\u0003W]K!\u0001\u0017\b\u0003%1{w-[:uS\u000e\fum\u001a:fO\u0006$xN\u001d\u0005\u0006Y1\u0001\rA\f\u0005\u000672\u0001\r\u0001X\u0001\rG>,gMZ5dS\u0016tGo\u001d\t\u0003;\u0002l\u0011A\u0018\u0006\u0003?J\ta\u0001\\5oC2<\u0017BA1_\u0005\u00191Vm\u0019;pe\")1\r\u0004a\u0001I\u0006aa-\u001b;J]R,'oY3qiB\u0011q&Z\u0005\u0003MB\u0012qAQ8pY\u0016\fg\u000eC\u0003i\u0019\u0001\u0007A-A\u0007jg6+H\u000e^5o_6L\u0017\r\u001c")
public class LogisticAggregatorSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient Instance[] instances;
    private transient Instance[] instancesConstantFeature;
    private transient Instance[] instancesConstantFeatureFiltered;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public Instance[] instances() {
        return this.instances;
    }

    public void instances_$eq(Instance[] x$1) {
        this.instances = x$1;
    }

    public Instance[] instancesConstantFeature() {
        return this.instancesConstantFeature;
    }

    public void instancesConstantFeature_$eq(Instance[] x$1) {
        this.instancesConstantFeature = x$1;
    }

    public Instance[] instancesConstantFeatureFiltered() {
        return this.instancesConstantFeatureFiltered;
    }

    public void instancesConstantFeatureFiltered_$eq(Instance[] x$1) {
        this.instancesConstantFeatureFiltered = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
        this.instances_$eq((Instance[])((Object[])new Instance[]{new Instance(0.0, 0.1, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))), new Instance(1.0, 0.5, Vectors$.MODULE$.dense(1.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new Instance(2.0, 0.3, Vectors$.MODULE$.dense(4.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5})))}));
        this.instancesConstantFeature_$eq((Instance[])((Object[])new Instance[]{new Instance(0.0, 0.1, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))), new Instance(1.0, 0.5, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new Instance(2.0, 0.3, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5})))}));
        this.instancesConstantFeatureFiltered_$eq((Instance[])((Object[])new Instance[]{new Instance(0.0, 0.1, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new Instance(1.0, 0.5, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new Instance(2.0, 0.3, Vectors$.MODULE$.dense(0.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])))}));
    }

    private LogisticAggregator getNewAggregator(Instance[] instances, Vector coefficients, boolean fitIntercept, boolean isMultinomial) {
        Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> tuple2 = DifferentiableLossAggregatorSuite$.MODULE$.getClassificationSummarizers(instances);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        MultivariateOnlineSummarizer featuresSummarizer = (MultivariateOnlineSummarizer)tuple2._1();
        MultiClassSummarizer ySummarizer = (MultiClassSummarizer)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)featuresSummarizer, (Object)ySummarizer);
        Tuple2 tuple23 = tuple22;
        MultivariateOnlineSummarizer featuresSummarizer2 = (MultivariateOnlineSummarizer)tuple23._1();
        MultiClassSummarizer ySummarizer2 = (MultiClassSummarizer)tuple23._2();
        int numClasses = ySummarizer2.histogram().length;
        double[] featuresStd = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(featuresSummarizer2.variance().toArray())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.sqrt(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        Broadcast bcFeaturesStd = this.spark().sparkContext().broadcast((Object)featuresStd, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Broadcast bcCoefficients = this.spark().sparkContext().broadcast((Object)coefficients, ClassTag$.MODULE$.apply(Vector.class));
        return new LogisticAggregator(bcFeaturesStd, numClasses, fitIntercept, isMultinomial, bcCoefficients);
    }

    private final void testImplicits$lzycompute$1() {
        LogisticAggregatorSuite logisticAggregatorSuite = this;
        synchronized (logisticAggregatorSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$new$14(Instance x$3) {
        return x$3.label() < 2.0;
    }

    public static final /* synthetic */ double $anonfun$new$26(Tuple3 x0$2) {
        Tuple3 tuple3 = x0$2;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        double l = BoxesRunTime.unboxToDouble((Object)tuple3._1());
        double w = BoxesRunTime.unboxToDouble((Object)tuple3._2());
        DenseVector p = (DenseVector)tuple3._3();
        double d = w * p.apply((int)l);
        return d;
    }

    public static final /* synthetic */ double $anonfun$new$27(Tuple3 x0$3) {
        Tuple3 tuple3 = x0$3;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        double w = BoxesRunTime.unboxToDouble((Object)tuple3._2());
        DenseVector p = (DenseVector)tuple3._3();
        double d = w * package$.MODULE$.log(BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(p.values())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.exp(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)));
        return d;
    }

    public static final /* synthetic */ void $anonfun$new$29(Vector intercepts$1, int numClasses$1, int numFeatures$1, double[] stdCoef$1, double[] gradientCoef$1, double[] featuresStd$1, double[] gradientIntercept$1, Instance x0$4) {
        Instance instance = x0$4;
        if (instance == null) {
            throw new MatchError((Object)instance);
        }
        double l = instance.label();
        double w = instance.weight();
        Vector f = instance.features();
        DenseVector margin = intercepts$1.copy().toDense();
        BLAS$.MODULE$.gemv(1.0, Matrices$.MODULE$.dense(numClasses$1, numFeatures$1, stdCoef$1), f, 1.0, margin);
        double sum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(margin.values())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.exp(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientCoef$1)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            double fStd = f.apply(i / numClasses$1) / featuresStd$1[i / numClasses$1];
            int cidx = i % numClasses$1;
            if (cidx == (int)l) {
                gradientCoef$1[i] = gradientCoef$1[i] - w * fStd;
            }
            gradientCoef$1[i] = gradientCoef$1[i] + w * package$.MODULE$.exp(margin.apply(cidx)) / sum * fStd;
        });
        new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientIntercept$1)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int cidx = i % numClasses$1;
            if (cidx == (int)l) {
                gradientIntercept$1[i] = gradientIntercept$1[i] - w;
            }
            gradientIntercept$1[i] = gradientIntercept$1[i] + w * package$.MODULE$.exp(margin.apply(cidx)) / sum;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ double $anonfun$new$40(double[] stdCoef$2, double intercept$1, Instance x0$5) {
        Instance instance = x0$5;
        if (instance == null) {
            throw new MatchError((Object)instance);
        }
        double l = instance.label();
        double w = instance.weight();
        Vector f = instance.features();
        double margin = BLAS$.MODULE$.dot(Vectors$.MODULE$.dense(stdCoef$2), f) + intercept$1;
        double prob = 1.0 / (1.0 + package$.MODULE$.exp(-margin));
        double d = -w * l * package$.MODULE$.log(prob) - w * (1.0 - l) * package$.MODULE$.log1p(-prob);
        return d;
    }

    public static final /* synthetic */ void $anonfun$new$41(double[] coefArray$2, double intercept$1, double[] gradientCoef$2, double[] featuresStd$2, DoubleRef gradientIntercept$2, Instance x0$6) {
        Instance instance = x0$6;
        if (instance != null) {
            double l = instance.label();
            double w = instance.weight();
            Vector f = instance.features();
            double margin = BLAS$.MODULE$.dot(f, Vectors$.MODULE$.dense(coefArray$2)) + intercept$1;
            new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientCoef$2)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                gradientCoef$2[i] = gradientCoef$2[i] + w * (1.0 / (1.0 + package$.MODULE$.exp(-margin)) - l) * f.apply(i) / featuresStd$2[i];
            });
            gradientIntercept$2.elem += w * (1.0 / (1.0 + package$.MODULE$.exp(-margin)) - l);
        } else {
            throw new MatchError((Object)instance);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Assertion $anonfun$new$49(LogisticAggregatorSuite $this, Vector grad$1, int numCoefficientSets$1, Vector gradFiltered$1, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToDouble((double)grad$1.apply(i)));
        double $org_scalatest_assert_macro_right = 0.0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
        double $org_scalatest_assert_macro_left2 = grad$1.apply(numCoefficientSets$1 + i);
        double $org_scalatest_assert_macro_right2 = gradFiltered$1.apply(i);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
    }

    private final void validateGradient$1(Vector grad, Vector gradFiltered, int numCoefficientSets) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numCoefficientSets).foreach((Function1 & Serializable & scala.Serializable)i -> LogisticAggregatorSuite.$anonfun$new$49(this, grad, numCoefficientSets, gradFiltered, BoxesRunTime.unboxToInt((Object)i)));
    }

    public LogisticAggregatorSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("aggregator add method input size", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double[] coefArray = new double[]{1.0, 2.0, -2.0, 3.0, 0.0, -1.0};
            double[] interceptArray = new double[]{4.0, 2.0, -3.0};
            LogisticAggregator agg = this.getNewAggregator(this.instances(), Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(interceptArray)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), true, true);
            return (IllegalArgumentException)this.withClue("LogisticAggregator features dimension must match coefficients dimension", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> agg.add(new Instance(1.0, 1.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73)));
        }, new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        this.test("negative weight", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double[] coefArray = new double[]{1.0, 2.0, -2.0, 3.0, 0.0, -1.0};
            double[] interceptArray = new double[]{4.0, 2.0, -3.0};
            LogisticAggregator agg = this.getNewAggregator(this.instances(), Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(interceptArray)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), true, true);
            return (IllegalArgumentException)this.withClue("LogisticAggregator does not support negative instance weights", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> agg.add(new Instance(1.0, -1.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0})))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85)));
        }, new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        this.test("check sizes multinomial", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Random rng = new Random();
            int numFeatures = ((Instance)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).head()).features().size();
            int numClasses = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble((double)x$2.label()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).toSet().size();
            Vector coefWithIntercept = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(numClasses * (numFeatures + 1), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rng.nextDouble(), ClassTag$.MODULE$.Double()));
            Vector coefWithoutIntercept = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(numClasses * numFeatures, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rng.nextDouble(), ClassTag$.MODULE$.Double()));
            LogisticAggregator aggIntercept = this.getNewAggregator(this.instances(), coefWithIntercept, true, true);
            LogisticAggregator aggNoIntercept = this.getNewAggregator(this.instances(), coefWithoutIntercept, false, true);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)instance -> aggIntercept.add(instance));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)instance -> aggNoIntercept.add(instance));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)aggIntercept.gradient().size()));
            int $org_scalatest_assert_macro_right = (numFeatures + 1) * numClasses;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)aggNoIntercept.gradient().size()));
            int $org_scalatest_assert_macro_right2 = numFeatures * numClasses;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        }, new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        this.test("check sizes binomial", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Random rng = new Random();
            Instance[] binaryInstances = (Instance[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LogisticAggregatorSuite.$anonfun$new$14(x$3)));
            int numFeatures = ((Instance)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])binaryInstances)).head()).features().size();
            Vector coefWithIntercept = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(numFeatures + 1, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rng.nextDouble(), ClassTag$.MODULE$.Double()));
            Vector coefWithoutIntercept = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(numFeatures, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rng.nextDouble(), ClassTag$.MODULE$.Double()));
            LogisticAggregator aggIntercept = this.getNewAggregator(binaryInstances, coefWithIntercept, true, false);
            LogisticAggregator aggNoIntercept = this.getNewAggregator(binaryInstances, coefWithoutIntercept, false, false);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])binaryInstances)).foreach((Function1 & Serializable & scala.Serializable)instance -> aggIntercept.add(instance));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])binaryInstances)).foreach((Function1 & Serializable & scala.Serializable)instance -> aggNoIntercept.add(instance));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)aggIntercept.gradient().size()));
            int $org_scalatest_assert_macro_right = numFeatures + 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)aggNoIntercept.gradient().size()));
            int $org_scalatest_assert_macro_right2 = numFeatures;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        }, new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        this.test("check correctness multinomial", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double[] coefArray = new double[]{1.0, 2.0, -2.0, 3.0, 0.0, -1.0};
            double[] interceptArray = new double[]{4.0, 2.0, -3.0};
            int numFeatures = ((Instance)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).head()).features().size();
            int numClasses = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToDouble((double)x$4.label()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).toSet().size();
            Vector intercepts = Vectors$.MODULE$.dense(interceptArray);
            Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> tuple2 = DifferentiableLossAggregatorSuite$.MODULE$.getClassificationSummarizers(this.instances());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            MultivariateOnlineSummarizer featuresSummarizer = (MultivariateOnlineSummarizer)tuple2._1();
            MultiClassSummarizer ySummarizer = (MultiClassSummarizer)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)featuresSummarizer, (Object)ySummarizer);
            Tuple2 tuple23 = tuple22;
            MultivariateOnlineSummarizer featuresSummarizer2 = (MultivariateOnlineSummarizer)tuple23._1();
            MultiClassSummarizer ySummarizer2 = (MultiClassSummarizer)tuple23._2();
            double[] featuresStd = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(featuresSummarizer2.variance().toArray())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.sqrt(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            double weightSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToDouble((double)x$6.weight()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            LogisticAggregator agg = this.getNewAggregator(this.instances(), Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(interceptArray)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), true, true);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)instance -> agg.add(instance));
            double[] stdCoef = (double[])((TraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray)).indices().map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> coefArray[i] / featuresStd[i / numClasses], IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
            Tuple3[] linearPredictors = (Tuple3[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Instance instance = x0$1;
                if (instance == null) {
                    throw new MatchError((Object)instance);
                }
                double l = instance.label();
                double w = instance.weight();
                Vector f = instance.features();
                DenseVector result = intercepts.copy().toDense();
                BLAS$.MODULE$.gemv(1.0, Matrices$.MODULE$.dense(numClasses, numFeatures, stdCoef), f, 1.0, result);
                Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)l), (Object)BoxesRunTime.boxToDouble((double)w), (Object)result);
                return tuple3;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
            double sumLinear = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])linearPredictors)).map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToDouble((double)LogisticAggregatorSuite.$anonfun$new$26(x0$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            double sumLogs = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])linearPredictors)).map((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToDouble((double)LogisticAggregatorSuite.$anonfun$new$27(x0$3)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            double loss = (sumLogs - sumLinear) / weightSum;
            double[] gradientCoef = new double[numFeatures * numClasses];
            double[] gradientIntercept = new double[numClasses];
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                LogisticAggregatorSuite.$anonfun$new$29(intercepts, numClasses, numFeatures, stdCoef, gradientCoef, featuresStd, gradientIntercept, x0$4);
                return BoxedUnit.UNIT;
            });
            Vector gradient = Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientCoef)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientIntercept)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$7 -> x$7 / weightSum, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(loss).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(agg.loss()).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(loss).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(agg.loss).relTol(0.01))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(gradient).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(agg.gradient()).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(gradient).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(agg.gradient).relTol(0.01))", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
        }, new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        this.test("check correctness binomial", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            MultivariateOnlineSummarizer featuresSummarizer;
            Instance[] binaryInstances = (Instance[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)instance -> instance.label() <= 1.0 ? instance : new Instance(0.0, instance.weight(), instance.features()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Instance.class)));
            double[] coefArray = new double[]{1.0, 2.0};
            double intercept = 1.0;
            int numFeatures = ((Instance)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])binaryInstances)).head()).features().size();
            Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> tuple2 = DifferentiableLossAggregatorSuite$.MODULE$.getClassificationSummarizers(binaryInstances);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            MultivariateOnlineSummarizer multivariateOnlineSummarizer = featuresSummarizer = (MultivariateOnlineSummarizer)tuple2._1();
            MultivariateOnlineSummarizer featuresSummarizer2 = multivariateOnlineSummarizer;
            double[] featuresStd = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(featuresSummarizer2.variance().toArray())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.sqrt(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            double weightSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])binaryInstances)).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToDouble((double)x$8.weight()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            LogisticAggregator agg = this.getNewAggregator(binaryInstances, Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(new double[]{intercept})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), true, false);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])binaryInstances)).foreach((Function1 & Serializable & scala.Serializable)instance -> agg.add(instance));
            double[] stdCoef = (double[])((TraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray)).indices().map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> coefArray[i] / featuresStd[i], IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
            double lossSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])binaryInstances)).map((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToDouble((double)LogisticAggregatorSuite.$anonfun$new$40(stdCoef, intercept, x0$5)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            double loss = lossSum / weightSum;
            double[] gradientCoef = new double[numFeatures];
            DoubleRef gradientIntercept = DoubleRef.create((double)0.0);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])binaryInstances)).foreach((Function1 & Serializable & scala.Serializable)x0$6 -> {
                LogisticAggregatorSuite.$anonfun$new$41(coefArray, intercept, gradientCoef, featuresStd, gradientIntercept, x0$6);
                return BoxedUnit.UNIT;
            });
            Vector gradient = Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientCoef)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(new double[]{gradientIntercept.elem})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$9 -> x$9 / weightSum, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(loss).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(agg.loss()).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(loss).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(agg.loss).relTol(0.01))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(gradient).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(agg.gradient()).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(gradient).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(agg.gradient).relTol(0.01))", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
        }, new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
        this.test("check with zero standard deviation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Instance[] binaryInstances = (Instance[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instancesConstantFeature())).map((Function1 & Serializable & scala.Serializable)instance -> instance.label() <= 1.0 ? instance : new Instance(0.0, instance.weight(), instance.features()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Instance.class)));
            Instance[] binaryInstancesFiltered = (Instance[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instancesConstantFeatureFiltered())).map((Function1 & Serializable & scala.Serializable)instance -> instance.label() <= 1.0 ? instance : new Instance(0.0, instance.weight(), instance.features()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Instance.class)));
            double[] coefArray = new double[]{1.0, 2.0, -2.0, 3.0, 0.0, -1.0};
            double[] coefArrayFiltered = new double[]{3.0, 0.0, -1.0};
            double[] interceptArray = new double[]{4.0, 2.0, -3.0};
            LogisticAggregator aggConstantFeature = this.getNewAggregator(this.instancesConstantFeature(), Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(interceptArray)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), true, true);
            LogisticAggregator aggConstantFeatureFiltered = this.getNewAggregator(this.instancesConstantFeatureFiltered(), Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArrayFiltered)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(interceptArray)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), true, true);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instancesConstantFeature())).foreach((Function1 & Serializable & scala.Serializable)instance -> aggConstantFeature.add(instance));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instancesConstantFeatureFiltered())).foreach((Function1 & Serializable & scala.Serializable)instance -> aggConstantFeatureFiltered.add(instance));
            this.validateGradient$1(aggConstantFeature.gradient(), aggConstantFeatureFiltered.gradient(), 3);
            double[] binaryCoefArray = new double[]{1.0, 2.0};
            double[] binaryCoefArrayFiltered = new double[]{2.0};
            double intercept = 1.0;
            LogisticAggregator aggConstantFeatureBinary = this.getNewAggregator(binaryInstances, Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(binaryCoefArray)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(new double[]{intercept})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), true, false);
            LogisticAggregator aggConstantFeatureBinaryFiltered = this.getNewAggregator(binaryInstancesFiltered, Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(binaryCoefArrayFiltered)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(new double[]{intercept})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), true, false);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])binaryInstances)).foreach((Function1 & Serializable & scala.Serializable)instance -> aggConstantFeatureBinary.add(instance));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])binaryInstancesFiltered)).foreach((Function1 & Serializable & scala.Serializable)instance -> aggConstantFeatureBinaryFiltered.add(instance));
            this.validateGradient$1(aggConstantFeatureBinary.gradient(), aggConstantFeatureBinaryFiltered.gradient(), 1);
        }, new Position("LogisticAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
    }
}

