/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim.loss;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.loss.L2Regularization;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001e1AAA\u0002\u0001!!)Q\u0003\u0001C\u0001-\t\tC)\u001b4gKJ,g\u000e^5bE2,'+Z4vY\u0006\u0014\u0018N_1uS>t7+^5uK*\u0011A!B\u0001\u0005Y>\u001c8O\u0003\u0002\u0007\u000f\u0005)q\u000e\u001d;j[*\u0011\u0001\"C\u0001\u0003[2T!AC\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u00051i\u0011AB1qC\u000eDWMC\u0001\u000f\u0003\ry'oZ\u0002\u0001'\t\u0001\u0011\u0003\u0005\u0002\u0013'5\t\u0011\"\u0003\u0002\u0015\u0013\ti1\u000b]1sW\u001a+hnU;ji\u0016\fa\u0001P5oSRtD#A\f\u0011\u0005a\u0001Q\"A\u0002")
public class DifferentiableRegularizationSuite
extends SparkFunSuite {
    public DifferentiableRegularizationSuite() {
        this.test("L2 regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Vector gradStdZero;
            JFunction1.mcZI.sp & Serializable & scala.Serializable shouldApply = (JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> true;
            double regParam = 0.3;
            Vector coefficients = Vectors$.MODULE$.dense(new double[]{1.0, 3.0, -2.0});
            int numFeatures = coefficients.size();
            L2Regularization regFun = new L2Regularization(regParam, (Function1)shouldApply, (Option)None$.MODULE$);
            Tuple2 tuple2 = regFun.calculate(coefficients);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double loss = tuple2._1$mcD$sp();
            Vector grad = (Vector)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)loss), (Object)grad);
            Tuple2 tuple23 = tuple22;
            double loss2 = tuple23._1$mcD$sp();
            Vector grad2 = (Vector)tuple23._2();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)loss2));
            double $org_scalatest_assert_macro_right = 0.5 * regParam * BLAS$.MODULE$.dot(coefficients, coefficients);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DifferentiableRegularizationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(grad2);
            Vector $org_scalatest_assert_macro_right2 = Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefficients.toArray())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$3 -> x$3 * regParam, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DifferentiableRegularizationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
            double[] featuresStd = new double[]{0.1, 1.1, 0.5};
            L2Regularization regFunStd = new L2Regularization(regParam, (Function1)shouldApply, (Option)new Some((Object)Predef$.MODULE$.wrapDoubleArray(featuresStd)));
            Tuple2 tuple24 = regFunStd.calculate(coefficients);
            if (tuple24 == null) {
                throw new MatchError((Object)tuple24);
            }
            double lossStd = tuple24._1$mcD$sp();
            Vector gradStd = (Vector)tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)lossStd), (Object)gradStd);
            Tuple2 tuple26 = tuple25;
            double lossStd2 = tuple26._1$mcD$sp();
            Vector gradStd2 = (Vector)tuple26._2();
            double expectedLossStd = 0.5 * regParam * BoxesRunTime.unboxToDouble((Object)((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numFeatures).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)j -> coefficients.apply(j) * coefficients.apply(j) / (featuresStd[j] * featuresStd[j]), IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            Vector expectedGradientStd = Vectors$.MODULE$.dense((double[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numFeatures).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)j -> regParam * coefficients.apply(j) / (featuresStd[j] * featuresStd[j]), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)lossStd2));
            double $org_scalatest_assert_macro_right3 = expectedLossStd;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DifferentiableRegularizationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(gradStd2);
            Vector $org_scalatest_assert_macro_right4 = expectedGradientStd;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DifferentiableRegularizationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
            JFunction1.mcZI.sp & Serializable & scala.Serializable shouldApply2 = (JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> i == 1;
            L2Regularization regFunApply = new L2Regularization(regParam, (Function1)shouldApply2, (Option)None$.MODULE$);
            Tuple2 tuple27 = regFunApply.calculate(coefficients);
            if (tuple27 == null) {
                throw new MatchError((Object)tuple27);
            }
            double lossApply = tuple27._1$mcD$sp();
            Vector gradApply = (Vector)tuple27._2();
            Tuple2 tuple28 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)lossApply), (Object)gradApply);
            Tuple2 tuple29 = tuple28;
            double lossApply2 = tuple29._1$mcD$sp();
            Vector gradApply2 = (Vector)tuple29._2();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)lossApply2));
            double $org_scalatest_assert_macro_right5 = 0.5 * regParam * coefficients.apply(1) * coefficients.apply(1);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DifferentiableRegularizationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(gradApply2);
            Vector $org_scalatest_assert_macro_right6 = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{coefficients.apply(1) * regParam, 0.0}));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DifferentiableRegularizationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
            double[] featuresStdZero = new double[]{0.1, 0.0, 0.5};
            L2Regularization regFunStdZero = new L2Regularization(regParam, (Function1)shouldApply, (Option)new Some((Object)Predef$.MODULE$.wrapDoubleArray(featuresStdZero)));
            Tuple2 tuple210 = regFunStdZero.calculate(coefficients);
            if (tuple210 == null) {
                throw new MatchError((Object)tuple210);
            }
            Vector vector = gradStdZero = (Vector)tuple210._2();
            Vector gradStdZero2 = vector;
            double $org_scalatest_assert_macro_left7 = gradStdZero2.apply(1);
            double $org_scalatest_assert_macro_right7 = 0.0;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DifferentiableRegularizationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        }, new Position("DifferentiableRegularizationSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 24));
    }
}

