/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.recommendation;

import java.io.File;
import java.io.Serializable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.recommendation.ALS;
import org.apache.spark.ml.recommendation.ALS$;
import org.apache.spark.ml.recommendation.ALSCleanerSuite$;
import org.apache.spark.ml.recommendation.ALSModel;
import org.apache.spark.ml.recommendation.ALSSuite$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction2;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001!2A\u0001B\u0003\u0001!!)1\u0004\u0001C\u00019!)q\u0004\u0001C!A!)q\u0005\u0001C!A\ty\u0011\tT*DY\u0016\fg.\u001a:Tk&$XM\u0003\u0002\u0007\u000f\u0005q!/Z2p[6,g\u000eZ1uS>t'B\u0001\u0005\n\u0003\tiGN\u0003\u0002\u000b\u0017\u0005)1\u000f]1sW*\u0011A\"D\u0001\u0007CB\f7\r[3\u000b\u00039\t1a\u001c:h\u0007\u0001\u00192\u0001A\t\u0016!\t\u00112#D\u0001\n\u0013\t!\u0012BA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003-ei\u0011a\u0006\u0006\u000315\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005i9\"A\u0005\"fM>\u0014X-\u00118e\u0003\u001a$XM]#bG\"\fa\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"A\u0003\u0002\u0015\t,gm\u001c:f\u000b\u0006\u001c\u0007\u000eF\u0001\"!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0011)f.\u001b;\u0002\u0013\u00054G/\u001a:FC\u000eD\u0007")
public class ALSCleanerSuite
extends SparkFunSuite {
    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
        Utils$.MODULE$.clearLocalRootDirs();
    }

    public void afterEach() {
        Utils$.MODULE$.clearLocalRootDirs();
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    private static final Set getAllFiles$1(File localDir$1) {
        return ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(FileUtils.listFiles((File)localDir$1, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE)).asScala()).toSet();
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$109(int x) {
        return new Tuple2.mcII.sp(x % 20, 1);
    }

    private static final Set getAllFiles$2(File localDir$2) {
        return ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(FileUtils.listFiles((File)localDir$2, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE)).asScala()).toSet();
    }

    public ALSCleanerSuite() {
        this.test("ALS shuffle cleanup standalone", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Long l;
            SparkConf conf = new SparkConf();
            File localDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            File checkpointDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            try {
                conf.set("spark.local.dir", localDir.getAbsolutePath());
                SparkContext sc = new SparkContext("local[2]", "test", conf);
                try {
                    sc.setCheckpointDir(checkpointDir.getAbsolutePath());
                    RDD input = sc.parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 1000), sc.parallelize$default$2(), ClassTag$.MODULE$.Int());
                    RDD keyed = input.map((Function1 & Serializable & scala.Serializable)x -> ALSCleanerSuite.$anonfun$new$109(BoxesRunTime.unboxToInt((Object)x)), ClassTag$.MODULE$.apply(Tuple2.class));
                    RDD shuffled = RDD$.MODULE$.rddToPairRDDFunctions(keyed, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$34, x$35) -> x$34 + x$35);
                    RDD keysOnly = RDD$.MODULE$.rddToPairRDDFunctions(shuffled, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).keys();
                    Seq deps = keysOnly.dependencies();
                    keysOnly.count();
                    ALS$.MODULE$.cleanShuffleDependencies(sc, deps, true);
                    Set resultingFiles = ALSCleanerSuite.getAllFiles$1(localDir);
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(resultingFiles);
                    Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1007));
                    l = BoxesRunTime.boxToLong((long)keysOnly.count());
                }
                finally {
                    sc.stop();
                }
            }
            finally {
                Utils$.MODULE$.deleteRecursively(localDir);
                Utils$.MODULE$.deleteRecursively(checkpointDir);
            }
            return l;
        }, new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 987));
        this.test("ALS shuffle cleanup in algorithm", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            SparkConf conf = new SparkConf();
            File localDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            File checkpointDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            try {
                conf.set("spark.local.dir", localDir.getAbsolutePath());
                SparkContext sc = new SparkContext("local[2]", "ALSCleanerSuite", conf);
                try {
                    RDD training;
                    sc.setCheckpointDir(checkpointDir.getAbsolutePath());
                    Tuple2<RDD<ALS.Rating<Object>>, RDD<ALS.Rating<Object>>> tuple2 = ALSSuite$.MODULE$.genImplicitTestData(sc, 20, 5, 1, 0.2, 0L);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    RDD rDD = training = (RDD)tuple2._1();
                    RDD training2 = rDD;
                    SparkSession spark = SparkSession$.MODULE$.builder().sparkContext(sc).getOrCreate();
                    ALS als = new ALS().setRank(1).setRegParam(1.0E-5).setSeed(0L).setCheckpointInterval(1).setMaxIter(7);
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ALSCleanerSuite.class.getClassLoader());
                    public final class Org_apache_spark_ml_recommendation_ALSCleanerSuite$$typecreator5$6
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("org")), (Symbols.SymbolApi)$m.staticPackage("org.apache")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark.ml")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark.ml.recommendation")), (Symbols.SymbolApi)$m.staticModule("org.apache.spark.ml.recommendation.ALS")), (Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.recommendation.ALS.Rating"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                        }

                        public Org_apache_spark_ml_recommendation_ALSCleanerSuite$$typecreator5$6(ALSCleanerSuite $outer) {
                        }
                    }
                    ALSModel model = als.fit(spark.implicits().rddToDatasetHolder(training2, spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSCleanerSuite$$typecreator5$6(null)))).toDF());
                    Set resultingFiles = ALSCleanerSuite.getAllFiles$2(localDir);
                    Regex pattern = new StringOps(Predef$.MODULE$.augmentString("shuffle_(\\d+)_.+\\.data")).r();
                    Set rddIds = (Set)resultingFiles.flatMap((Function1 & Serializable & scala.Serializable)f -> pattern.findAllIn((CharSequence)f.getName()).matchData().map((Function1 & Serializable & scala.Serializable)x$36 -> x$36.group(1)), Set$.MODULE$.canBuildFrom());
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)rddIds.size()));
                    int $org_scalatest_assert_macro_right = 4;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1050));
                }
                finally {
                    sc.stop();
                }
            }
            finally {
                Utils$.MODULE$.deleteRecursively(localDir);
                Utils$.MODULE$.deleteRecursively(checkpointDir);
            }
            return assertion;
        }, new Position("ALSSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1019));
    }
}

