/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.regression.FMRegressionModel;
import org.apache.spark.ml.regression.FMRegressorSuite$;
import org.apache.spark.ml.regression.FactorizationMachines$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Random;

public final class FMRegressorSuite$
implements scala.Serializable {
    public static FMRegressorSuite$ MODULE$;
    private final Map<String, Object> allParamSettings;

    static {
        new FMRegressorSuite$();
    }

    public Map<String, Object> allParamSettings() {
        return this.allParamSettings;
    }

    public Tuple2<Dataset<Row>, double[]> generateFactorInteractionInput(SparkSession spark, int factorSize, int numFeatures, int numSamples, int seed, boolean fitIntercept, boolean fitLinear) {
        Random rnd;
        SparkContext sc = spark.sparkContext();
        int coefficientsSize = factorSize * numFeatures + (fitLinear ? numFeatures : 0) + (fitIntercept ? 1 : 0);
        double[] coefficients = (double[])Array$.MODULE$.fill(coefficientsSize, (Function0)((JFunction0.mcD.sp & Serializable & scala.Serializable)() -> FMRegressorSuite$.$anonfun$generateFactorInteractionInput$1(rnd = new Random(seed))), ClassTag$.MODULE$.Double());
        Tuple3 tuple3 = FactorizationMachines$.MODULE$.splitCoefficients(Vectors$.MODULE$.dense(coefficients), numFeatures, factorSize, fitIntercept, fitLinear);
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        double intercept = BoxesRunTime.unboxToDouble((Object)tuple3._1());
        Vector linear = (Vector)tuple3._2();
        Matrix factors = (Matrix)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)intercept), (Object)linear, (Object)factors);
        Tuple3 tuple33 = tuple32;
        double intercept2 = BoxesRunTime.unboxToDouble((Object)tuple33._1());
        Vector linear2 = (Vector)tuple33._2();
        Matrix factors2 = (Matrix)tuple33._3();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_regression_FMRegressorSuite$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.DenseVector").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_regression_FMRegressorSuite$$typecreator5$1() {
            }
        }
        Dataset X = spark.implicits().rddToDatasetHolder(sc.parallelize((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSamples), sc.parallelize$default$2(), ClassTag$.MODULE$.Int()).map((Function1 & Serializable & scala.Serializable)i -> FMRegressorSuite$.$anonfun$generateFactorInteractionInput$2(numFeatures, rnd, BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(Tuple2.class)), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_FMRegressorSuite$$typecreator5$1()))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "features"}));
        FMRegressionModel fmModel = new FMRegressionModel("fmr_test", intercept2, linear2, factors2);
        fmModel.set((Param)fmModel.factorSize(), (Object)BoxesRunTime.boxToInteger((int)factorSize));
        fmModel.set((Param)fmModel.fitIntercept(), (Object)BoxesRunTime.boxToBoolean((boolean)fitIntercept));
        fmModel.set((Param)fmModel.fitLinear(), (Object)BoxesRunTime.boxToBoolean((boolean)fitLinear));
        Dataset data = fmModel.transform(X).withColumnRenamed("prediction", "label").select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label"}));
        return new Tuple2((Object)data, (Object)coefficients);
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ double $anonfun$generateFactorInteractionInput$1(Random rnd$1) {
        return rnd$1.nextDouble() - 0.5;
    }

    public static final /* synthetic */ Tuple2 $anonfun$generateFactorInteractionInput$2(int numFeatures$3, Random rnd$1, int i) {
        DenseVector x = new DenseVector((double[])Array$.MODULE$.fill(numFeatures$3, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rnd$1.nextDouble() - 0.5, ClassTag$.MODULE$.Double()));
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)x);
    }

    private FMRegressorSuite$() {
        MODULE$ = this;
        this.allParamSettings = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"featuresCol"), (Object)"myFeatures"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labelCol"), (Object)"myLabel"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"predictionCol"), (Object)"prediction"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"factorSize"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fitIntercept"), (Object)BoxesRunTime.boxToBoolean((boolean)false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fitLinear"), (Object)BoxesRunTime.boxToBoolean((boolean)false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"regParam"), (Object)BoxesRunTime.boxToDouble((double)0.01)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"miniBatchFraction"), (Object)BoxesRunTime.boxToDouble((double)0.1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"initStd"), (Object)BoxesRunTime.boxToDouble((double)0.01)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxIter"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stepSize"), (Object)BoxesRunTime.boxToDouble((double)0.1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tol"), (Object)BoxesRunTime.boxToDouble((double)1.0E-4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"solver"), (Object)"gd"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"seed"), (Object)BoxesRunTime.boxToLong((long)11L))}));
    }
}

