/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.util;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MyParams;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00052AAA\u0002\u0001\u001d!)a\u0004\u0001C\u0001?\t)B)\u001a4bk2$(+Z1e/JLG/Z*vSR,'B\u0001\u0003\u0006\u0003\u0011)H/\u001b7\u000b\u0005\u00199\u0011AA7m\u0015\tA\u0011\"A\u0003ta\u0006\u00148N\u0003\u0002\u000b\u0017\u00051\u0011\r]1dQ\u0016T\u0011\u0001D\u0001\u0004_J<7\u0001A\n\u0005\u0001=\u0019\"\u0004\u0005\u0002\u0011#5\tq!\u0003\u0002\u0013\u000f\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"\u0001\u0006\r\u000e\u0003UQ!\u0001\u0002\f\u000b\u0005]9\u0011!B7mY&\u0014\u0017BA\r\u0016\u0005UiE\n\\5c)\u0016\u001cHo\u00159be.\u001cuN\u001c;fqR\u0004\"a\u0007\u000f\u000e\u0003\rI!!H\u0002\u0003)\u0011+g-Y;miJ+\u0017\rZ,sSR,G+Z:u\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0005\u0005\u0002\u001c\u0001\u0001")
public class DefaultReadWriteSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest.testDefaultReadWrite$(this, instance, testParams);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest.testDefaultReadWrite$default$2$(this);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, Dataset<?> dataset, Map<String, Object> testEstimatorParams, Map<String, Object> testModelParams, Function2<M, M, BoxedUnit> checkModelData) {
        DefaultReadWriteTest.testEstimatorAndModelReadWrite$(this, estimator, dataset, testEstimatorParams, testModelParams, checkModelData);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private final void testImplicits$lzycompute$1() {
        DefaultReadWriteSuite defaultReadWriteSuite = this;
        synchronized (defaultReadWriteSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public DefaultReadWriteSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        DefaultReadWriteTest.$init$(this);
        this.test("default read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            MyParams myParams = new MyParams("my_params");
            return this.testDefaultReadWrite(myParams, this.testDefaultReadWrite$default$2());
        }, new Position("DefaultReadWriteTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
        this.test("default param shouldn't become user-supplied param after persistence", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            MyParams myParams = new MyParams("my_params");
            myParams.set(myParams.shouldNotSetIfSetintParamWithDefault(), BoxesRunTime.boxToInteger((int)1));
            myParams.checkExclusiveParams();
            MyParams loadedMyParams = this.testDefaultReadWrite(myParams, this.testDefaultReadWrite$default$2());
            loadedMyParams.checkExclusiveParams();
            Option $org_scalatest_assert_macro_left = loadedMyParams.getDefault(loadedMyParams.intParamWithDefault());
            Option $org_scalatest_assert_macro_right = myParams.getDefault(myParams.intParamWithDefault());
            Option option = $org_scalatest_assert_macro_left;
            Option option2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", $org_scalatest_assert_macro_right, !(option != null ? !option.equals(option2) : option2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultReadWriteTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
            loadedMyParams.set(myParams.intParamWithDefault(), BoxesRunTime.boxToInteger((int)1));
            return (SparkException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> loadedMyParams.checkExclusiveParams(), ClassTag$.MODULE$.apply(SparkException.class), new Position("DefaultReadWriteTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
        }, new Position("DefaultReadWriteTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
        this.test("User-supplied value for default param should be kept after persistence", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            MyParams myParams = new MyParams("my_params");
            myParams.set(myParams.intParamWithDefault(), BoxesRunTime.boxToInteger((int)100));
            MyParams loadedMyParams = this.testDefaultReadWrite(myParams, this.testDefaultReadWrite$default$2());
            int $org_scalatest_assert_macro_left = BoxesRunTime.unboxToInt((Object)loadedMyParams.get(myParams.intParamWithDefault()).get());
            int $org_scalatest_assert_macro_right = 100;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultReadWriteTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
        }, new Position("DefaultReadWriteTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
        this.test("Read metadata without default field prior to 2.4", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String metadata = new StringOps(Predef$.MODULE$.augmentString("{\"class\":\"org.apache.spark.ml.util.MyParams\",\n      |\"timestamp\":1518852502761,\"sparkVersion\":\"2.3.0\",\n      |\"uid\":\"my_params\",\n      |\"paramMap\":{\"intParamWithDefault\":0}}")).stripMargin();
            DefaultParamsReader.Metadata parsedMetadata = DefaultParamsReader$.MODULE$.parseMetadata(metadata, DefaultParamsReader$.MODULE$.parseMetadata$default$2());
            MyParams myParams = new MyParams("my_params");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(myParams.isSet((Param<?>)myParams.intParamWithDefault()), "myParams.isSet(myParams.intParamWithDefault)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultReadWriteTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
            parsedMetadata.getAndSetParams((Params)myParams, parsedMetadata.getAndSetParams$default$2());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(myParams.isSet((Param<?>)myParams.intParamWithDefault()), "myParams.isSet(myParams.intParamWithDefault)", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultReadWriteTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
        }, new Position("DefaultReadWriteTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
        this.test("Should raise error when read metadata without default field after Spark 2.4", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            MyParams myParams = new MyParams("my_params");
            String metadata1 = new StringOps(Predef$.MODULE$.augmentString("{\"class\":\"org.apache.spark.ml.util.MyParams\",\n      |\"timestamp\":1518852502761,\"sparkVersion\":\"2.4.0\",\n      |\"uid\":\"my_params\",\n      |\"paramMap\":{\"intParamWithDefault\":0}}")).stripMargin();
            DefaultParamsReader.Metadata parsedMetadata1 = DefaultParamsReader$.MODULE$.parseMetadata(metadata1, DefaultParamsReader$.MODULE$.parseMetadata$default$2());
            IllegalArgumentException err1 = (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> parsedMetadata1.getAndSetParams((Params)myParams, parsedMetadata1.getAndSetParams$default$2()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DefaultReadWriteTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
            String $org_scalatest_assert_macro_left = err1.getMessage();
            String $org_scalatest_assert_macro_right = "Cannot recognize JSON metadata";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultReadWriteTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
            String metadata2 = new StringOps(Predef$.MODULE$.augmentString("{\"class\":\"org.apache.spark.ml.util.MyParams\",\n      |\"timestamp\":1518852502761,\"sparkVersion\":\"3.0.0\",\n      |\"uid\":\"my_params\",\n      |\"paramMap\":{\"intParamWithDefault\":0}}")).stripMargin();
            DefaultParamsReader.Metadata parsedMetadata2 = DefaultParamsReader$.MODULE$.parseMetadata(metadata2, DefaultParamsReader$.MODULE$.parseMetadata$default$2());
            IllegalArgumentException err2 = (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> parsedMetadata2.getAndSetParams((Params)myParams, parsedMetadata2.getAndSetParams$default$2()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DefaultReadWriteTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
            String $org_scalatest_assert_macro_left2 = err2.getMessage();
            String $org_scalatest_assert_macro_right2 = "Cannot recognize JSON metadata";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultReadWriteTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
        }, new Position("DefaultReadWriteTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
    }
}

