/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.Vector$;
import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.classification.NaiveBayes;
import org.apache.spark.mllib.classification.NaiveBayes$;
import org.apache.spark.mllib.classification.NaiveBayesModel;
import org.apache.spark.mllib.classification.NaiveBayesModel$;
import org.apache.spark.mllib.classification.NaiveBayesSuite$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.exceptions.TestFailedException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dt!\u0002\n\u0014\u0011\u0003qb!\u0002\u0011\u0014\u0011\u0003\t\u0003\"B\u0016\u0002\t\u0003a\u0003\"B\u0017\u0002\t\u0013q\u0003\"\u0002\u001f\u0002\t\u0003i\u0004b\u00023\u0002#\u0003%\t!\u001a\u0005\ba\u0006\t\n\u0011\"\u0001r\u0011\u001d\u0019\u0018A1A\u0005\nQDa\u0001_\u0001!\u0002\u0013)\bbB=\u0002\u0005\u0004%I\u0001\u001e\u0005\u0007u\u0006\u0001\u000b\u0011B;\t\u000fm\f\u0011\u0011!C\u0005y\u001a)\u0001e\u0005\u0001\u0002\f!11\u0006\u0004C\u0001\u0003CAq!!\n\r\t\u0003\t9\u0003C\u0004\u0002:1!\t!a\u000f\t\u000f\u0005%C\u0002\"\u0003\u0002L!9\u0011q\f\u0007\u0005\n\u0005\u0005\u0014a\u0004(bSZ,')Y=fgN+\u0018\u000e^3\u000b\u0005Q)\u0012AD2mCN\u001c\u0018NZ5dCRLwN\u001c\u0006\u0003-]\tQ!\u001c7mS\nT!\u0001G\r\u0002\u000bM\u0004\u0018M]6\u000b\u0005iY\u0012AB1qC\u000eDWMC\u0001\u001d\u0003\ry'oZ\u0002\u0001!\ty\u0012!D\u0001\u0014\u0005=q\u0015-\u001b<f\u0005\u0006LXm]*vSR,7cA\u0001#QA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t1\u0011I\\=SK\u001a\u0004\"aI\u0015\n\u0005)\"#\u0001D*fe&\fG.\u001b>bE2,\u0017A\u0002\u001fj]&$h\bF\u0001\u001f\u0003%\u0019\u0017\r\\2MC\n,G\u000eF\u00020e]\u0002\"a\t\u0019\n\u0005E\"#aA%oi\")1g\u0001a\u0001i\u0005\t\u0001\u000f\u0005\u0002$k%\u0011a\u0007\n\u0002\u0007\t>,(\r\\3\t\u000ba\u001a\u0001\u0019A\u001d\u0002\u0005AL\u0007cA\u0012;i%\u00111\b\n\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0018O\u0016tWM]1uK:\u000b\u0017N^3CCf,7/\u00138qkR$rA\u0010)R)ZC&\rE\u0002@\u000f*s!\u0001Q#\u000f\u0005\u0005#U\"\u0001\"\u000b\u0005\rk\u0012A\u0002\u001fs_>$h(C\u0001&\u0013\t1E%A\u0004qC\u000e\\\u0017mZ3\n\u0005!K%aA*fc*\u0011a\t\n\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001bV\t!B]3he\u0016\u001c8/[8o\u0013\tyEJ\u0001\u0007MC\n,G.\u001a3Q_&tG\u000fC\u00039\t\u0001\u0007\u0011\bC\u0003S\t\u0001\u00071+A\u0003uQ\u0016$\u0018\rE\u0002$ueBQ!\u0016\u0003A\u0002=\nqA\u001c)pS:$8\u000fC\u0003X\t\u0001\u0007q&\u0001\u0003tK\u0016$\u0007bB-\u0005!\u0003\u0005\rAW\u0001\n[>$W\r\u001c+za\u0016\u0004\"aW0\u000f\u0005qk\u0006CA!%\u0013\tqF%\u0001\u0004Qe\u0016$WMZ\u0005\u0003A\u0006\u0014aa\u0015;sS:<'B\u00010%\u0011\u001d\u0019G\u0001%AA\u0002=\naa]1na2,\u0017!I4f]\u0016\u0014\u0018\r^3OC&4XMQ1zKNLe\u000e];uI\u0011,g-Y;mi\u0012*T#\u00014+\u0005i;7&\u00015\u0011\u0005%tW\"\u00016\u000b\u0005-d\u0017!C;oG\",7m[3e\u0015\tiG%\u0001\u0006b]:|G/\u0019;j_:L!a\u001c6\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0011hK:,'/\u0019;f\u001d\u0006Lg/\u001a\"bs\u0016\u001c\u0018J\u001c9vi\u0012\"WMZ1vYR$c'F\u0001sU\tys-\u0001\u000bcS:\f'/\u001f\"fe:|W\u000f\u001c7j\u001b>$W\r\\\u000b\u0002kB\u0011qD^\u0005\u0003oN\u0011qBT1jm\u0016\u0014\u0015-_3t\u001b>$W\r\\\u0001\u0016E&t\u0017M]=CKJtw.\u001e7mS6{G-\u001a7!\u0003Y\u0011\u0017N\\1ss6+H\u000e^5o_6L\u0017\r\\'pI\u0016d\u0017a\u00062j]\u0006\u0014\u00180T;mi&tw.\\5bY6{G-\u001a7!\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0003u\u00042A`A\u0004\u001b\u0005y(\u0002BA\u0001\u0003\u0007\tA\u0001\\1oO*\u0011\u0011QA\u0001\u0005U\u00064\u0018-C\u0002\u0002\n}\u0014aa\u00142kK\u000e$8#\u0002\u0007\u0002\u000e\u0005U\u0001\u0003BA\b\u0003#i\u0011aF\u0005\u0004\u0003'9\"!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0003\u0002\u0018\u0005uQBAA\r\u0015\r\tY\"F\u0001\u0005kRLG.\u0003\u0003\u0002 \u0005e!!F'MY&\u0014G+Z:u'B\f'o[\"p]R,\u0007\u0010\u001e\u000b\u0003\u0003G\u0001\"a\b\u0007\u0002%Y\fG.\u001b3bi\u0016\u0004&/\u001a3jGRLwN\u001c\u000b\u0007\u0003S\ty#!\u000e\u0011\u0007\r\nY#C\u0002\u0002.\u0011\u0012A!\u00168ji\"9\u0011\u0011\u0007\bA\u0002\u0005M\u0012a\u00039sK\u0012L7\r^5p]N\u00042aP$5\u0011\u0019\t9D\u0004a\u0001}\u0005)\u0011N\u001c9vi\u0006\u0001b/\u00197jI\u0006$X-T8eK24\u0015\u000e\u001e\u000b\t\u0003S\ti$!\u0011\u0002F!1\u0011qH\bA\u0002e\na\u0001]5ECR\f\u0007BBA\"\u001f\u0001\u00071+A\u0005uQ\u0016$\u0018\rR1uC\"1\u0011qI\bA\u0002U\fQ!\\8eK2\f\u0001%\u001a=qK\u000e$X\rZ'vYRLgn\\7jC2\u0004&o\u001c2bE&d\u0017\u000e^5fgR)\u0011(!\u0014\u0002P!1\u0011q\t\tA\u0002UDq!!\u0015\u0011\u0001\u0004\t\u0019&\u0001\u0005uKN$H)\u0019;b!\u0011\t)&a\u0017\u000e\u0005\u0005]#bAA-+\u00051A.\u001b8bY\u001eLA!!\u0018\u0002X\t1a+Z2u_J\fa$\u001a=qK\u000e$X\r\u001a\"fe:|W\u000f\u001c7j!J|'-\u00192jY&$\u0018.Z:\u0015\u000be\n\u0019'!\u001a\t\r\u0005\u001d\u0013\u00031\u0001v\u0011\u001d\t\t&\u0005a\u0001\u0003'\u0002")
public class NaiveBayesSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static int generateNaiveBayesInput$default$6() {
        return NaiveBayesSuite$.MODULE$.generateNaiveBayesInput$default$6();
    }

    public static String generateNaiveBayesInput$default$5() {
        return NaiveBayesSuite$.MODULE$.generateNaiveBayesInput$default$5();
    }

    public static Seq<LabeledPoint> generateNaiveBayesInput(double[] dArray, double[][] dArray2, int n, int n2, String string, int n3) {
        return NaiveBayesSuite$.MODULE$.generateNaiveBayesInput(dArray, dArray2, n, n2, string, n3);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public void validatePrediction(Seq<Object> predictions, Seq<LabeledPoint> input) {
        int numOfPredictions;
        int $org_scalatest_assert_macro_left = numOfPredictions = ((TraversableOnce)predictions.zip(input, Seq$.MODULE$.canBuildFrom())).count((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)NaiveBayesSuite.$anonfun$validatePrediction$1(x0$1)));
        int $org_scalatest_assert_macro_right = input.length() / 5;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NaiveBayesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
    }

    public void validateModelFit(double[] piData, double[][] thetaData, NaiveBayesModel model) {
        IndexedSeq modelIndex = (IndexedSeq)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(piData)).indices().zip((GenIterable)Predef$.MODULE$.wrapIntArray((int[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(model.labels())).map((Function1)(JFunction1.mcID.sp & Serializable & scala.Serializable)x$5 -> (int)x$5, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))), IndexedSeq$.MODULE$.canBuildFrom());
        try {
            modelIndex.foreach((Function1 & Serializable & scala.Serializable)i -> {
                NaiveBayesSuite.$anonfun$validateModelFit$2(this, piData, model, thetaData, i);
                return BoxedUnit.UNIT;
            });
        }
        catch (TestFailedException e) {
            throw e.modifyMessage((Function1 & Serializable & scala.Serializable)x$6 -> x$6.map((Function1 & Serializable & scala.Serializable)orig -> NaiveBayesSuite.msg$1(orig, piData, thetaData, model)));
        }
    }

    private double[] expectedMultinomialProbabilities(NaiveBayesModel model, Vector testData) {
        DenseVector.mcD.sp piVector = new DenseVector.mcD.sp(model.pi());
        DenseMatrix thetaMatrix = (DenseMatrix)new DenseMatrix.mcD.sp(model.theta()[0].length, model.theta().length, (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.theta())).flatten((Function1 & Serializable & scala.Serializable)xs -> Predef$.MODULE$.wrapDoubleArray(xs), ClassTag$.MODULE$.Double())).t(DenseMatrix$.MODULE$.canTranspose());
        breeze.linalg.Vector logClassProbs = (breeze.linalg.Vector)piVector.$plus(thetaMatrix.$times((Object)testData.asBreeze(), (UFunc.UImpl2)DenseMatrix$.MODULE$.op_DM_V_Double()), DenseVector$.MODULE$.canAddD());
        double[] classProbs = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(logClassProbs.toArray$mcD$sp(ClassTag$.MODULE$.Double()))).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.exp(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double classProbsSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(classProbs)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        return (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(classProbs)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$10 -> x$10 / classProbsSum, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    private double[] expectedBernoulliProbabilities(NaiveBayesModel model, Vector testData) {
        DenseVector.mcD.sp piVector = new DenseVector.mcD.sp(model.pi());
        DenseMatrix thetaMatrix = (DenseMatrix)new DenseMatrix.mcD.sp(model.theta()[0].length, model.theta().length, (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.theta())).flatten((Function1 & Serializable & scala.Serializable)xs -> Predef$.MODULE$.wrapDoubleArray(xs), ClassTag$.MODULE$.Double())).t(DenseMatrix$.MODULE$.canTranspose());
        DenseMatrix negThetaMatrix = (DenseMatrix)new DenseMatrix.mcD.sp(model.theta()[0].length, model.theta().length, (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.theta())).flatten((Function1 & Serializable & scala.Serializable)xs -> Predef$.MODULE$.wrapDoubleArray(xs), ClassTag$.MODULE$.Double()))).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)v -> package$.MODULE$.log1p(-package$.MODULE$.exp(v)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).t(DenseMatrix$.MODULE$.canTranspose());
        breeze.linalg.Vector testBreeze = testData.asBreeze();
        DenseVector negTestBreeze = (DenseVector)new DenseVector.mcD.sp((double[])Array$.MODULE$.fill(testBreeze.size(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0, ClassTag$.MODULE$.Double())).$minus((Object)testBreeze, (UFunc.UImpl2)DenseVector$.MODULE$.dv_v_Op_Double_OpSub());
        breeze.linalg.Vector piTheta = (breeze.linalg.Vector)piVector.$plus(thetaMatrix.$times((Object)testBreeze, (UFunc.UImpl2)DenseMatrix$.MODULE$.op_DM_V_Double()), DenseVector$.MODULE$.canAddD());
        breeze.linalg.Vector logClassProbs = (breeze.linalg.Vector)piTheta.$plus(negThetaMatrix.$times((Object)negTestBreeze, (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DVD_eq_DVD()), Vector$.MODULE$.castOps(Predef$.MODULE$.$conforms(), Predef$.MODULE$.$conforms(), (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpAdd()));
        double[] classProbs = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(logClassProbs.toArray$mcD$sp(ClassTag$.MODULE$.Double()))).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.exp(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double classProbsSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(classProbs)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        return (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(classProbs)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$14 -> x$14 / classProbsSum, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    private final void testImplicits$lzycompute$1() {
        NaiveBayesSuite naiveBayesSuite = this;
        synchronized (naiveBayesSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$validatePrediction$1(Tuple2 x0$1) {
        LabeledPoint expected;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double prediction = tuple2._1$mcD$sp();
        boolean bl = prediction != (expected = (LabeledPoint)tuple2._2()).label();
        return bl;
    }

    public static final /* synthetic */ Assertion $anonfun$validateModelFit$3(NaiveBayesSuite $this, double[][] thetaData$1, Tuple2 i$1, NaiveBayesModel model$1, int j) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(package$.MODULE$.exp(thetaData$1[i$1._2$mcI$sp()][j])).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(package$.MODULE$.exp(model$1.theta()[i$1._1$mcI$sp()][j])).absTol(0.05)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.math.`package`.exp(thetaData.apply(i._2).apply(j))).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.math.`package`.exp(model.theta.apply(i._1).apply(j))).absTol(0.05))", Prettifier$.MODULE$.default());
        return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NaiveBayesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
    }

    public static final /* synthetic */ void $anonfun$validateModelFit$2(NaiveBayesSuite $this, double[] piData$1, NaiveBayesModel model$1, double[][] thetaData$1, Tuple2 i) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(package$.MODULE$.exp(piData$1[i._2$mcI$sp()])).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(package$.MODULE$.exp(model$1.pi()[i._1$mcI$sp()])).absTol(0.05)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.math.`package`.exp(piData.apply(i._2))).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.math.`package`.exp(model.pi.apply(i._1))).absTol(0.05))", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NaiveBayesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(thetaData$1[i._2$mcI$sp()])).indices().foreach((Function1 & Serializable & scala.Serializable)j -> NaiveBayesSuite.$anonfun$validateModelFit$3($this, thetaData$1, i, model$1, BoxesRunTime.unboxToInt((Object)j)));
    }

    private static final String arr2str$1(double[] a) {
        return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(a)).mkString("[", ", ", "]");
    }

    private static final String msg$1(String orig, double[] piData$1, double[][] thetaData$1, NaiveBayesModel model$1) {
        return new StringBuilder(84).append(orig).append("\nvalidateModelFit:\n").append(" piData: ").append(NaiveBayesSuite.arr2str$1(piData$1)).append("\n").append(" thetaData: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])thetaData$1)).map((Function1 & Serializable & scala.Serializable)a -> NaiveBayesSuite.arr2str$1(a), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("\n")).append("\n").append(" model.labels: ").append(NaiveBayesSuite.arr2str$1(model$1.labels())).append("\n").append(" model.pi: ").append(NaiveBayesSuite.arr2str$1(model$1.pi())).append("\n").append(" model.theta: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model$1.theta())).map((Function1 & Serializable & scala.Serializable)a -> NaiveBayesSuite.arr2str$1(a), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("\n")).toString();
    }

    public static final /* synthetic */ void $anonfun$new$10(NaiveBayesSuite $this, NaiveBayesModel model$2, Vector features) {
        double[] predicted = model$2.predictProbabilities(features).toArray();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(predicted)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).relTol(1.0E-10)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.Predef.doubleArrayOps(predicted).sum[Double](math.this.Numeric.DoubleIsFractional)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).relTol(1.0E-10))", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NaiveBayesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        double[] expected = $this.expectedMultinomialProbabilities(model$2, features);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(expected)).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(predicted), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double e = tuple2._1$mcD$sp();
            double p = tuple2._2$mcD$sp();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(e).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(p).relTol(1.0E-10)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(e).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(p).relTol(1.0E-10))", Prettifier$.MODULE$.default());
            Assertion assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NaiveBayesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
            return assertion;
        });
    }

    public static final /* synthetic */ void $anonfun$new$19(NaiveBayesSuite $this, NaiveBayesModel model$3, Vector features) {
        double[] predicted = model$3.predictProbabilities(features).toArray();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(predicted)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).relTol(1.0E-10)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.Predef.doubleArrayOps(predicted).sum[Double](math.this.Numeric.DoubleIsFractional)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).relTol(1.0E-10))", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NaiveBayesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
        double[] expected = $this.expectedBernoulliProbabilities(model$3, features);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(expected)).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(predicted), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double e = tuple2._1$mcD$sp();
            double p = tuple2._2$mcD$sp();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(e).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(p).relTol(1.0E-10)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(e).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(p).relTol(1.0E-10))", Prettifier$.MODULE$.default());
            Assertion assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NaiveBayesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
            return assertion;
        });
    }

    public NaiveBayesSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("model types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(NaiveBayes$.MODULE$.Multinomial());
            String $org_scalatest_assert_macro_right = "multinomial";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NaiveBayesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(NaiveBayes$.MODULE$.Bernoulli());
            String $org_scalatest_assert_macro_right2 = "bernoulli";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("NaiveBayesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        }, new Position("NaiveBayesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        this.test("get, set params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            NaiveBayes nb = new NaiveBayes();
            nb.setLambda(2.0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)nb.getLambda()));
            double $org_scalatest_assert_macro_right = 2.0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NaiveBayesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
            nb.setLambda(3.0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)nb.getLambda()));
            double $org_scalatest_assert_macro_right2 = 3.0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("NaiveBayesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
        }, new Position("NaiveBayesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
        this.test("Naive Bayes Multinomial", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int nPoints = 1000;
            double[] pi = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(new double[]{0.5, 0.1, 0.4})).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.log(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            double[][] theta = (double[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new double[][]{{0.7, 0.1, 0.1, 0.1}, {0.1, 0.7, 0.1, 0.1}, {0.1, 0.1, 0.7, 0.1}})).map((Function1 & Serializable & scala.Serializable)x$7 -> (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x$7)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.log(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
            Seq<LabeledPoint> testData = NaiveBayesSuite$.MODULE$.generateNaiveBayesInput(pi, theta, nPoints, 42, NaiveBayes$.MODULE$.Multinomial(), NaiveBayesSuite$.MODULE$.generateNaiveBayesInput$default$6());
            RDD testRDD = this.sc().parallelize(testData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
            testRDD.cache();
            NaiveBayesModel model = NaiveBayes$.MODULE$.train(testRDD, 1.0, NaiveBayes$.MODULE$.Multinomial());
            this.validateModelFit(pi, theta, model);
            Seq<LabeledPoint> validationData = NaiveBayesSuite$.MODULE$.generateNaiveBayesInput(pi, theta, nPoints, 17, NaiveBayes$.MODULE$.Multinomial(), NaiveBayesSuite$.MODULE$.generateNaiveBayesInput$default$6());
            RDD validationRDD = this.sc().parallelize(validationData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
            this.validatePrediction((Seq<Object>)Predef$.MODULE$.wrapDoubleArray((double[])model.predict(validationRDD.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.features(), ClassTag$.MODULE$.apply(Vector.class))).collect()), validationData);
            this.validatePrediction((Seq<Object>)((Seq)validationData.map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToDouble((double)model.predict(row.features())), Seq$.MODULE$.canBuildFrom())), validationData);
            ((IterableLike)validationData.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.features(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)features -> {
                NaiveBayesSuite.$anonfun$new$10(this, model, features);
                return BoxedUnit.UNIT;
            });
        }, new Position("NaiveBayesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        this.test("Naive Bayes Bernoulli", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int nPoints = 10000;
            double[] pi = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(new double[]{0.5, 0.3, 0.2})).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.log(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            double[][] theta = (double[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new double[][]{{0.5, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.4}, {0.02, 0.7, 0.1, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02}, {0.02, 0.02, 0.6, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.3}})).map((Function1 & Serializable & scala.Serializable)x$11 -> (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x$11)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.log(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
            Seq<LabeledPoint> testData = NaiveBayesSuite$.MODULE$.generateNaiveBayesInput(pi, theta, nPoints, 45, NaiveBayes$.MODULE$.Bernoulli(), NaiveBayesSuite$.MODULE$.generateNaiveBayesInput$default$6());
            RDD testRDD = this.sc().parallelize(testData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
            testRDD.cache();
            NaiveBayesModel model = NaiveBayes$.MODULE$.train(testRDD, 1.0, NaiveBayes$.MODULE$.Bernoulli());
            this.validateModelFit(pi, theta, model);
            Seq<LabeledPoint> validationData = NaiveBayesSuite$.MODULE$.generateNaiveBayesInput(pi, theta, nPoints, 20, NaiveBayes$.MODULE$.Bernoulli(), NaiveBayesSuite$.MODULE$.generateNaiveBayesInput$default$6());
            RDD validationRDD = this.sc().parallelize(validationData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
            this.validatePrediction((Seq<Object>)Predef$.MODULE$.wrapDoubleArray((double[])model.predict(validationRDD.map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.features(), ClassTag$.MODULE$.apply(Vector.class))).collect()), validationData);
            this.validatePrediction((Seq<Object>)((Seq)validationData.map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToDouble((double)model.predict(row.features())), Seq$.MODULE$.canBuildFrom())), validationData);
            ((IterableLike)validationData.map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.features(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)features -> {
                NaiveBayesSuite.$anonfun$new$19(this, model, features);
                return BoxedUnit.UNIT;
            });
        }, new Position("NaiveBayesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
        this.test("detect negative values", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq dense = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledPoint[]{new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(-1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])))}));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> NaiveBayes$.MODULE$.train(this.sc().makeRDD(dense, 2, ClassTag$.MODULE$.apply(LabeledPoint.class))), ClassTag$.MODULE$.apply(SparkException.class), new Position("NaiveBayesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
            Seq sparse = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledPoint[]{new LabeledPoint(1.0, Vectors$.MODULE$.sparse(1, new int[]{0}, new double[]{1.0})), new LabeledPoint(0.0, Vectors$.MODULE$.sparse(1, new int[]{0}, new double[]{-1.0})), new LabeledPoint(1.0, Vectors$.MODULE$.sparse(1, new int[]{0}, new double[]{1.0})), new LabeledPoint(1.0, Vectors$.MODULE$.sparse(1, (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double())))}));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> NaiveBayes$.MODULE$.train(this.sc().makeRDD(sparse, 2, ClassTag$.MODULE$.apply(LabeledPoint.class))), ClassTag$.MODULE$.apply(SparkException.class), new Position("NaiveBayesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
            Seq nan = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledPoint[]{new LabeledPoint(1.0, Vectors$.MODULE$.sparse(1, new int[]{0}, new double[]{1.0})), new LabeledPoint(0.0, Vectors$.MODULE$.sparse(1, new int[]{0}, new double[]{Double.NaN})), new LabeledPoint(1.0, Vectors$.MODULE$.sparse(1, new int[]{0}, new double[]{1.0})), new LabeledPoint(1.0, Vectors$.MODULE$.sparse(1, (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double())))}));
            return (SparkException)this.intercept((Function0 & Serializable & scala.Serializable)() -> NaiveBayes$.MODULE$.train(this.sc().makeRDD(nan, 2, ClassTag$.MODULE$.apply(LabeledPoint.class))), ClassTag$.MODULE$.apply(SparkException.class), new Position("NaiveBayesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
        }, new Position("NaiveBayesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
        this.test("detect non zero or one values in Bernoulli", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq badTrain = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledPoint[]{new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])))}));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> NaiveBayes$.MODULE$.train(this.sc().makeRDD(badTrain, 2, ClassTag$.MODULE$.apply(LabeledPoint.class)), 1.0, NaiveBayes$.MODULE$.Bernoulli()), ClassTag$.MODULE$.apply(SparkException.class), new Position("NaiveBayesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280));
            Seq okTrain = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledPoint[]{new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])))}));
            Seq badPredict = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))}));
            NaiveBayesModel model = NaiveBayes$.MODULE$.train(this.sc().makeRDD(okTrain, 2, ClassTag$.MODULE$.apply(LabeledPoint.class)), 1.0, NaiveBayes$.MODULE$.Bernoulli());
            return (SparkException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (double[])model.predict(this.sc().makeRDD(badPredict, 2, ClassTag$.MODULE$.apply(Vector.class))).collect(), ClassTag$.MODULE$.apply(SparkException.class), new Position("NaiveBayesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301));
        }, new Position("NaiveBayesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
        this.test("model save/load: 2.0 to 2.0", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            String path = tempDir.toURI().toString();
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NaiveBayesModel[]{NaiveBayesSuite$.MODULE$.org$apache$spark$mllib$classification$NaiveBayesSuite$$binaryBernoulliModel(), NaiveBayesSuite$.MODULE$.org$apache$spark$mllib$classification$NaiveBayesSuite$$binaryMultinomialModel()}))).foreach((Function1 & Serializable & scala.Serializable)model -> {
                Assertion assertion;
                try {
                    model.save(this.sc(), path);
                    NaiveBayesModel sameModel = NaiveBayesModel$.MODULE$.load(this.sc(), path);
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(model.labels());
                    double[] $org_scalatest_assert_macro_right = sameModel.labels();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NaiveBayesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(model.pi());
                    double[] $org_scalatest_assert_macro_right2 = sameModel.pi();
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("NaiveBayesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 317));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(model.theta());
                    double[][] $org_scalatest_assert_macro_right3 = sameModel.theta();
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("NaiveBayesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(model.modelType());
                    String $org_scalatest_assert_macro_right4 = sameModel.modelType();
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("NaiveBayesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
                }
                finally {
                    Utils$.MODULE$.deleteRecursively(tempDir);
                }
                return assertion;
            });
        }, new Position("NaiveBayesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
        this.test("model save/load: 1.0 to 2.0", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            NaiveBayesModel model = NaiveBayesSuite$.MODULE$.org$apache$spark$mllib$classification$NaiveBayesSuite$$binaryMultinomialModel();
            File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            String path = tempDir.toURI().toString();
            try {
                NaiveBayesModel.SaveLoadV1_0$.Data data = new NaiveBayesModel.SaveLoadV1_0$.Data(model.labels(), model.pi(), model.theta());
                NaiveBayesModel.SaveLoadV1_0$.MODULE$.save(this.sc(), path, data);
                NaiveBayesModel sameModel = NaiveBayesModel$.MODULE$.load(this.sc(), path);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(model.labels());
                double[] $org_scalatest_assert_macro_right = sameModel.labels();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NaiveBayesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(model.pi());
                double[] $org_scalatest_assert_macro_right2 = sameModel.pi();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("NaiveBayesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(model.theta());
                double[][] $org_scalatest_assert_macro_right3 = sameModel.theta();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("NaiveBayesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(model.modelType());
                String $org_scalatest_assert_macro_right4 = NaiveBayes$.MODULE$.Multinomial();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("NaiveBayesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 340));
            }
            finally {
                Utils$.MODULE$.deleteRecursively(tempDir);
            }
            return assertion;
        }, new Position("NaiveBayesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
    }
}

