/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.evaluation;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.evaluation.AreaUnderCurve$;
import org.apache.spark.mllib.evaluation.BinaryClassificationMetrics;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001a3A!\u0002\u0004\u0001#!)A\u0004\u0001C\u0001;!)\u0001\u0005\u0001C\u0005C!)1\b\u0001C\u0005y!)1\t\u0001C\u0005\t\n\u0001#)\u001b8bef\u001cE.Y:tS\u001aL7-\u0019;j_:lU\r\u001e:jGN\u001cV/\u001b;f\u0015\t9\u0001\"\u0001\u0006fm\u0006dW/\u0019;j_:T!!\u0003\u0006\u0002\u000b5dG.\u001b2\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001%Y\u0001\"a\u0005\u000b\u000e\u0003)I!!\u0006\u0006\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t9\"$D\u0001\u0019\u0015\tI\u0002\"\u0001\u0003vi&d\u0017BA\u000e\u0019\u0005UiE\n\\5c)\u0016\u001cHo\u00159be.\u001cuN\u001c;fqR\fa\u0001P5oSRtD#\u0001\u0010\u0011\u0005}\u0001Q\"\u0001\u0004\u0002)\u0005\u001c8/\u001a:u'\u0016\fX/\u001a8dKNl\u0015\r^2i)\r\u0011\u0003&\u000f\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0005+:LG\u000fC\u0003*\u0005\u0001\u0007!&\u0001\u0004bGR,\u0018\r\u001c\t\u0004WM2dB\u0001\u00172\u001d\ti\u0003'D\u0001/\u0015\ty\u0003#\u0001\u0004=e>|GOP\u0005\u0002K%\u0011!\u0007J\u0001\ba\u0006\u001c7.Y4f\u0013\t!TGA\u0002TKFT!A\r\u0013\u0011\u0005\r:\u0014B\u0001\u001d%\u0005\u0019!u.\u001e2mK\")!H\u0001a\u0001U\u0005AQ\r\u001f9fGR,G-A\rbgN,'\u000f\u001e+va2,7+Z9vK:\u001cWm]'bi\u000eDGc\u0001\u0012>\u0005\")\u0011f\u0001a\u0001}A\u00191fM \u0011\t\r\u0002eGN\u0005\u0003\u0003\u0012\u0012a\u0001V;qY\u0016\u0014\u0004\"\u0002\u001e\u0004\u0001\u0004q\u0014a\u0004<bY&$\u0017\r^3NKR\u0014\u0018nY:\u0015\u0013\t*%\n\u0014(Q%R3\u0006\"\u0002$\u0005\u0001\u00049\u0015aB7fiJL7m\u001d\t\u0003?!K!!\u0013\u0004\u00037\tKg.\u0019:z\u00072\f7o]5gS\u000e\fG/[8o\u001b\u0016$(/[2t\u0011\u0015YE\u00011\u0001+\u0003I)\u0007\u0010]3di\u0016$G\u000b\u001b:fg\"|G\u000eZ:\t\u000b5#\u0001\u0019\u0001 \u0002!\u0015D\b/Z2uK\u0012\u0014vjQ\"veZ,\u0007\"B(\u0005\u0001\u0004q\u0014aD3ya\u0016\u001cG/\u001a3Q%\u000e+(O^3\t\u000bE#\u0001\u0019\u0001\u0016\u0002%\u0015D\b/Z2uK\u00124U*Z1tkJ,7/\r\u0005\u0006'\u0012\u0001\rAK\u0001\u0013Kb\u0004Xm\u0019;fI\u001akW-Y:ve\u0016\u001c(\u0007C\u0003V\t\u0001\u0007!&\u0001\nfqB,7\r^3e!J,7-[:j_:\u001c\b\"B,\u0005\u0001\u0004Q\u0013aD3ya\u0016\u001cG/\u001a3SK\u000e\fG\u000e\\:")
public class BinaryClassificationMetricsSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private void assertSequencesMatch(Seq<Object> actual, Seq<Object> expected) {
        ((IterableLike)actual.zip(expected, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double a = tuple2._1$mcD$sp();
            double e = tuple2._2$mcD$sp();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(a).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(e).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(a).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(e).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BinaryClassificationMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 27));
            return assertion;
        });
    }

    private void assertTupleSequencesMatch(Seq<Tuple2<Object, Object>> actual, Seq<Tuple2<Object, Object>> expected) {
        ((IterableLike)actual.zip(expected, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            double ay;
            double ax;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$1;
                    if (tuple22 == null) break block2;
                    Tuple2 tuple23 = (Tuple2)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple23 == null) break block2;
                    ax = tuple23._1$mcD$sp();
                    ay = tuple23._2$mcD$sp();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            double ex = tuple2._1$mcD$sp();
            double ey = tuple2._2$mcD$sp();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(ax).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(ex).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(ax).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(ex).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BinaryClassificationMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(ay).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(ey).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(ay).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(ey).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BinaryClassificationMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
            return assertion;
        });
    }

    private void validateMetrics(BinaryClassificationMetrics metrics, Seq<Object> expectedThresholds, Seq<Tuple2<Object, Object>> expectedROCCurve, Seq<Tuple2<Object, Object>> expectedPRCurve, Seq<Object> expectedFMeasures1, Seq<Object> expectedFmeasures2, Seq<Object> expectedPrecisions, Seq<Object> expectedRecalls) {
        this.assertSequencesMatch((Seq<Object>)Predef$.MODULE$.wrapDoubleArray((double[])metrics.thresholds().collect()), expectedThresholds);
        this.assertTupleSequencesMatch((Seq<Tuple2<Object, Object>>)Predef$.MODULE$.wrapRefArray((Object[])metrics.roc().collect()), expectedROCCurve);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.areaUnderROC()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(AreaUnderCurve$.MODULE$.of(expectedROCCurve)).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.areaUnderROC()).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(AreaUnderCurve.of(expectedROCCurve)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BinaryClassificationMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        this.assertTupleSequencesMatch((Seq<Tuple2<Object, Object>>)Predef$.MODULE$.wrapRefArray((Object[])metrics.pr().collect()), expectedPRCurve);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.areaUnderPR()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(AreaUnderCurve$.MODULE$.of(expectedPRCurve)).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.areaUnderPR()).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(AreaUnderCurve.of(expectedPRCurve)).absTol(1.0E-5))", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BinaryClassificationMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
        this.assertTupleSequencesMatch((Seq<Tuple2<Object, Object>>)Predef$.MODULE$.wrapRefArray((Object[])metrics.fMeasureByThreshold().collect()), (Seq<Tuple2<Object, Object>>)((Seq)expectedThresholds.zip(expectedFMeasures1, Seq$.MODULE$.canBuildFrom())));
        this.assertTupleSequencesMatch((Seq<Tuple2<Object, Object>>)Predef$.MODULE$.wrapRefArray((Object[])metrics.fMeasureByThreshold(2.0).collect()), (Seq<Tuple2<Object, Object>>)((Seq)expectedThresholds.zip(expectedFmeasures2, Seq$.MODULE$.canBuildFrom())));
        this.assertTupleSequencesMatch((Seq<Tuple2<Object, Object>>)Predef$.MODULE$.wrapRefArray((Object[])metrics.precisionByThreshold().collect()), (Seq<Tuple2<Object, Object>>)((Seq)expectedThresholds.zip(expectedPrecisions, Seq$.MODULE$.canBuildFrom())));
        this.assertTupleSequencesMatch((Seq<Tuple2<Object, Object>>)Predef$.MODULE$.wrapRefArray((Object[])metrics.recallByThreshold().collect()), (Seq<Tuple2<Object, Object>>)((Seq)expectedThresholds.zip(expectedRecalls, Seq$.MODULE$.canBuildFrom())));
    }

    private final void testImplicits$lzycompute$1() {
        BinaryClassificationMetricsSuite binaryClassificationMetricsSuite = this;
        synchronized (binaryClassificationMetricsSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ double $anonfun$new$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int t = tuple2._1$mcI$sp();
        int f = tuple2._2$mcI$sp();
        double d = (double)t / (double)(t + f);
        return d;
    }

    public static final /* synthetic */ double $anonfun$new$5(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double r = tuple2._1$mcD$sp();
        double p = tuple2._2$mcD$sp();
        double d = 2.0 * (p * r) / (p + r);
        return d;
    }

    public static final /* synthetic */ double $anonfun$new$6(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double r = tuple2._1$mcD$sp();
        double p = tuple2._2$mcD$sp();
        double d = 5.0 * (p * r) / (4.0 * p + r);
        return d;
    }

    public static final /* synthetic */ double $anonfun$new$8(Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double t = tuple2._1$mcD$sp();
        double f = tuple2._2$mcD$sp();
        double d = t / (t + f);
        return d;
    }

    public static final /* synthetic */ double $anonfun$new$11(Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double r = tuple2._1$mcD$sp();
        double p = tuple2._2$mcD$sp();
        double d = 2.0 * (p * r) / (p + r);
        return d;
    }

    public static final /* synthetic */ double $anonfun$new$12(Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double r = tuple2._1$mcD$sp();
        double p = tuple2._2$mcD$sp();
        double d = 5.0 * (p * r) / (4.0 * p + r);
        return d;
    }

    public static final /* synthetic */ double $anonfun$new$14(Tuple2 x0$7) {
        Tuple2 tuple2 = x0$7;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double r = tuple2._1$mcD$sp();
        double p = tuple2._2$mcD$sp();
        double d = 2.0 * (p * r) / (p + r);
        return d;
    }

    public static final /* synthetic */ double $anonfun$new$15(Tuple2 x0$8) {
        Tuple2 tuple2 = x0$8;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double r = tuple2._1$mcD$sp();
        double p = tuple2._2$mcD$sp();
        double d = 5.0 * (p * r) / (4.0 * p + r);
        return d;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ double $anonfun$new$17(Tuple2 x0$9) {
        Tuple2 tuple2 = x0$9;
        if (tuple2 != null) {
            double d = tuple2._1$mcD$sp();
            double d2 = tuple2._2$mcD$sp();
            if (0.0 == d && 0.0 == d2) {
                return 0.0;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        double r = tuple2._1$mcD$sp();
        double p = tuple2._2$mcD$sp();
        return 2.0 * (p * r) / (p + r);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ double $anonfun$new$18(Tuple2 x0$10) {
        Tuple2 tuple2 = x0$10;
        if (tuple2 != null) {
            double d = tuple2._1$mcD$sp();
            double d2 = tuple2._2$mcD$sp();
            if (0.0 == d && 0.0 == d2) {
                return 0.0;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        double r = tuple2._1$mcD$sp();
        double p = tuple2._2$mcD$sp();
        return 5.0 * (p * r) / (4.0 * p + r);
    }

    public BinaryClassificationMetricsSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("binary evaluation metrics", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            RDD scoreAndLabels = this.sc().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.1, 0.0), new Tuple2.mcDD.sp(0.1, 1.0), new Tuple2.mcDD.sp(0.4, 0.0), new Tuple2.mcDD.sp(0.6, 0.0), new Tuple2.mcDD.sp(0.6, 1.0), new Tuple2.mcDD.sp(0.6, 1.0), new Tuple2.mcDD.sp(0.8, 1.0)})), 2, ClassTag$.MODULE$.apply(Tuple2.class));
            BinaryClassificationMetrics metrics = new BinaryClassificationMetrics(scoreAndLabels);
            Seq thresholds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.8, 0.6, 0.4, 0.1}));
            Seq numTruePositives = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 3, 4}));
            Seq numFalsePositives = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
            int numPositives = 4;
            int numNegatives = 3;
            Seq precisions = (Seq)((TraversableLike)numTruePositives.zip((GenIterable)numFalsePositives, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)BinaryClassificationMetricsSuite.$anonfun$new$2(x0$1)), Seq$.MODULE$.canBuildFrom());
            Seq recalls = (Seq)numTruePositives.map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)t -> (double)t / (double)numPositives, Seq$.MODULE$.canBuildFrom());
            Seq fpr = (Seq)numFalsePositives.map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)f -> (double)f / (double)numNegatives, Seq$.MODULE$.canBuildFrom());
            Seq rocCurve = (Seq)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.0, 0.0)}))).$plus$plus((GenTraversableOnce)fpr.zip((GenIterable)recalls, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(1.0, 1.0)})), Seq$.MODULE$.canBuildFrom());
            Seq pr = (Seq)recalls.zip((GenIterable)precisions, Seq$.MODULE$.canBuildFrom());
            Seq prCurve = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.0, 1.0)}))).$plus$plus((GenTraversableOnce)pr, Seq$.MODULE$.canBuildFrom());
            Seq f1 = (Seq)pr.map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToDouble((double)BinaryClassificationMetricsSuite.$anonfun$new$5(x0$2)), Seq$.MODULE$.canBuildFrom());
            Seq f2 = (Seq)pr.map((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToDouble((double)BinaryClassificationMetricsSuite.$anonfun$new$6(x0$3)), Seq$.MODULE$.canBuildFrom());
            this.validateMetrics(metrics, (Seq<Object>)thresholds, (Seq<Tuple2<Object, Object>>)rocCurve, (Seq<Tuple2<Object, Object>>)prCurve, (Seq<Object>)f1, (Seq<Object>)f2, (Seq<Object>)precisions, (Seq<Object>)recalls);
        }, new Position("BinaryClassificationMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        this.test("binary evaluation metrics with weights", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            double w1 = 1.5;
            double w2 = 0.7;
            double w3 = 0.4;
            RDD scoreAndLabelsWithWeights = this.sc().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.1), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)w1)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.1), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)w2)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.4), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)w1)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.6), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)w3)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.6), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)w2)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.6), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)w2)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.8), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)w1))})), 2, ClassTag$.MODULE$.apply(Tuple3.class));
            BinaryClassificationMetrics metrics = new BinaryClassificationMetrics(scoreAndLabelsWithWeights, 0);
            Seq thresholds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.8, 0.6, 0.4, 0.1}));
            Seq numTruePositives = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0 * w1, 1.0 * w1 + (double)2 * w2, 1.0 * w1 + (double)2 * w2, (double)3 * w2 + 1.0 * w1}));
            Seq numFalsePositives = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.0 * w3, 1.0 * w1 + 1.0 * w3, 1.0 * w3 + 2.0 * w1}));
            double numPositives = (double)3 * w2 + 1.0 * w1;
            double numNegatives = (double)2 * w1 + w3;
            Seq precisions = (Seq)((TraversableLike)numTruePositives.zip((GenIterable)numFalsePositives, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToDouble((double)BinaryClassificationMetricsSuite.$anonfun$new$8(x0$4)), Seq$.MODULE$.canBuildFrom());
            Seq recalls = (Seq)numTruePositives.map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$1 -> x$1 / numPositives, Seq$.MODULE$.canBuildFrom());
            Seq fpr = (Seq)numFalsePositives.map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$2 -> x$2 / numNegatives, Seq$.MODULE$.canBuildFrom());
            Seq rocCurve = (Seq)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.0, 0.0)}))).$plus$plus((GenTraversableOnce)fpr.zip((GenIterable)recalls, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(1.0, 1.0)})), Seq$.MODULE$.canBuildFrom());
            Seq pr = (Seq)recalls.zip((GenIterable)precisions, Seq$.MODULE$.canBuildFrom());
            Seq prCurve = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.0, 1.0)}))).$plus$plus((GenTraversableOnce)pr, Seq$.MODULE$.canBuildFrom());
            Seq f1 = (Seq)pr.map((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToDouble((double)BinaryClassificationMetricsSuite.$anonfun$new$11(x0$5)), Seq$.MODULE$.canBuildFrom());
            Seq f2 = (Seq)pr.map((Function1 & Serializable & scala.Serializable)x0$6 -> BoxesRunTime.boxToDouble((double)BinaryClassificationMetricsSuite.$anonfun$new$12(x0$6)), Seq$.MODULE$.canBuildFrom());
            this.validateMetrics(metrics, (Seq<Object>)thresholds, (Seq<Tuple2<Object, Object>>)rocCurve, (Seq<Tuple2<Object, Object>>)prCurve, (Seq<Object>)f1, (Seq<Object>)f2, (Seq<Object>)precisions, (Seq<Object>)recalls);
        }, new Position("BinaryClassificationMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        this.test("binary evaluation metrics for RDD where all examples have positive label", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            RDD scoreAndLabels = this.sc().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.5, 1.0), new Tuple2.mcDD.sp(0.5, 1.0)})), 2, ClassTag$.MODULE$.apply(Tuple2.class));
            BinaryClassificationMetrics metrics = new BinaryClassificationMetrics(scoreAndLabels);
            Seq thresholds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5}));
            Seq precisions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}));
            Seq recalls = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}));
            Seq fpr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}));
            Seq rocCurve = (Seq)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.0, 0.0)}))).$plus$plus((GenTraversableOnce)fpr.zip((GenIterable)recalls, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(1.0, 1.0)})), Seq$.MODULE$.canBuildFrom());
            Seq pr = (Seq)recalls.zip((GenIterable)precisions, Seq$.MODULE$.canBuildFrom());
            Seq prCurve = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.0, 1.0)}))).$plus$plus((GenTraversableOnce)pr, Seq$.MODULE$.canBuildFrom());
            Seq f1 = (Seq)pr.map((Function1 & Serializable & scala.Serializable)x0$7 -> BoxesRunTime.boxToDouble((double)BinaryClassificationMetricsSuite.$anonfun$new$14(x0$7)), Seq$.MODULE$.canBuildFrom());
            Seq f2 = (Seq)pr.map((Function1 & Serializable & scala.Serializable)x0$8 -> BoxesRunTime.boxToDouble((double)BinaryClassificationMetricsSuite.$anonfun$new$15(x0$8)), Seq$.MODULE$.canBuildFrom());
            this.validateMetrics(metrics, (Seq<Object>)thresholds, (Seq<Tuple2<Object, Object>>)rocCurve, (Seq<Tuple2<Object, Object>>)prCurve, (Seq<Object>)f1, (Seq<Object>)f2, (Seq<Object>)precisions, (Seq<Object>)recalls);
        }, new Position("BinaryClassificationMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        this.test("binary evaluation metrics for RDD where all examples have negative label", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            RDD scoreAndLabels = this.sc().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.5, 0.0), new Tuple2.mcDD.sp(0.5, 0.0)})), 2, ClassTag$.MODULE$.apply(Tuple2.class));
            BinaryClassificationMetrics metrics = new BinaryClassificationMetrics(scoreAndLabels);
            Seq thresholds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5}));
            Seq precisions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}));
            Seq recalls = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}));
            Seq fpr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}));
            Seq rocCurve = (Seq)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.0, 0.0)}))).$plus$plus((GenTraversableOnce)fpr.zip((GenIterable)recalls, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(1.0, 1.0)})), Seq$.MODULE$.canBuildFrom());
            Seq pr = (Seq)recalls.zip((GenIterable)precisions, Seq$.MODULE$.canBuildFrom());
            Seq prCurve = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.0, 0.0)}))).$plus$plus((GenTraversableOnce)pr, Seq$.MODULE$.canBuildFrom());
            Seq f1 = (Seq)pr.map((Function1 & Serializable & scala.Serializable)x0$9 -> BoxesRunTime.boxToDouble((double)BinaryClassificationMetricsSuite.$anonfun$new$17(x0$9)), Seq$.MODULE$.canBuildFrom());
            Seq f2 = (Seq)pr.map((Function1 & Serializable & scala.Serializable)x0$10 -> BoxesRunTime.boxToDouble((double)BinaryClassificationMetricsSuite.$anonfun$new$18(x0$10)), Seq$.MODULE$.canBuildFrom());
            this.validateMetrics(metrics, (Seq<Object>)thresholds, (Seq<Tuple2<Object, Object>>)rocCurve, (Seq<Tuple2<Object, Object>>)prCurve, (Seq<Object>)f1, (Seq<Object>)f2, (Seq<Object>)precisions, (Seq<Object>)recalls);
        }, new Position("BinaryClassificationMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        this.test("binary evaluation metrics with downsampling", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq scoreAndLabels = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.1, 0.0), new Tuple2.mcDD.sp(0.2, 0.0), new Tuple2.mcDD.sp(0.3, 1.0), new Tuple2.mcDD.sp(0.4, 0.0), new Tuple2.mcDD.sp(0.5, 0.0), new Tuple2.mcDD.sp(0.6, 1.0), new Tuple2.mcDD.sp(0.7, 1.0), new Tuple2.mcDD.sp(0.8, 0.0), new Tuple2.mcDD.sp(0.9, 1.0)}));
            RDD scoreAndLabelsRDD = this.sc().parallelize(scoreAndLabels, 1, ClassTag$.MODULE$.apply(Tuple2.class));
            BinaryClassificationMetrics original = new BinaryClassificationMetrics(scoreAndLabelsRDD);
            List originalROC = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])original.roc().collect())).sorted(Ordering$.MODULE$.Tuple2((Ordering)Ordering.Double$.MODULE$, (Ordering)Ordering.Double$.MODULE$)))).toList();
            int $org_scalatest_assert_macro_left = 2 + scoreAndLabels.size();
            int $org_scalatest_assert_macro_right = originalROC.size();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BinaryClassificationMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
            List $org_scalatest_assert_macro_left2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.0, 0.0), new Tuple2.mcDD.sp(0.0, 0.25), new Tuple2.mcDD.sp(0.2, 0.25), new Tuple2.mcDD.sp(0.2, 0.5), new Tuple2.mcDD.sp(0.2, 0.75), new Tuple2.mcDD.sp(0.4, 0.75), new Tuple2.mcDD.sp(0.6, 0.75), new Tuple2.mcDD.sp(0.6, 1.0), new Tuple2.mcDD.sp(0.8, 1.0), new Tuple2.mcDD.sp(1.0, 1.0), new Tuple2.mcDD.sp(1.0, 1.0)}));
            List $org_scalatest_assert_macro_right2 = originalROC;
            List list = $org_scalatest_assert_macro_left2;
            List list2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(list != null ? !list.equals(list2) : list2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BinaryClassificationMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
            int numBins = 4;
            BinaryClassificationMetrics downsampled = new BinaryClassificationMetrics(scoreAndLabelsRDD, numBins);
            List downsampledROC = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])downsampled.roc().collect())).sorted(Ordering$.MODULE$.Tuple2((Ordering)Ordering.Double$.MODULE$, (Ordering)Ordering.Double$.MODULE$)))).toList();
            int $org_scalatest_assert_macro_left3 = 2 + (numBins + (scoreAndLabels.size() % numBins == 0 ? 0 : 1));
            int $org_scalatest_assert_macro_right3 = downsampledROC.size();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BinaryClassificationMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
            .colon.colon $org_scalatest_assert_macro_left4 = new .colon.colon((Object)new Tuple2.mcDD.sp(0.0, 0.0), (List)new .colon.colon((Object)new Tuple2.mcDD.sp(0.2, 0.25), (List)new .colon.colon((Object)new Tuple2.mcDD.sp(0.2, 0.75), (List)new .colon.colon((Object)new Tuple2.mcDD.sp(0.6, 0.75), (List)new .colon.colon((Object)new Tuple2.mcDD.sp(0.8, 1.0), (List)new .colon.colon((Object)new Tuple2.mcDD.sp(1.0, 1.0), (List)new .colon.colon((Object)new Tuple2.mcDD.sp(1.0, 1.0), (List)Nil$.MODULE$)))))));
            List $org_scalatest_assert_macro_right4 = downsampledROC;
            .colon.colon colon2 = $org_scalatest_assert_macro_left4;
            List list3 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(colon2 != null ? !colon2.equals(list3) : list3 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("BinaryClassificationMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
            List downsampledRecall = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])downsampled.recallByThreshold().collect())).sorted(Ordering$.MODULE$.Tuple2((Ordering)Ordering.Double$.MODULE$, (Ordering)Ordering.Double$.MODULE$)))).toList();
            int $org_scalatest_assert_macro_left5 = numBins + (scoreAndLabels.size() % numBins == 0 ? 0 : 1);
            int $org_scalatest_assert_macro_right5 = downsampledRecall.size();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("BinaryClassificationMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
            .colon.colon $org_scalatest_assert_macro_left6 = new .colon.colon((Object)new Tuple2.mcDD.sp(0.1, 1.0), (List)new .colon.colon((Object)new Tuple2.mcDD.sp(0.2, 1.0), (List)new .colon.colon((Object)new Tuple2.mcDD.sp(0.4, 0.75), (List)new .colon.colon((Object)new Tuple2.mcDD.sp(0.6, 0.75), (List)new .colon.colon((Object)new Tuple2.mcDD.sp(0.8, 0.25), (List)Nil$.MODULE$)))));
            List $org_scalatest_assert_macro_right6 = downsampledRecall;
            .colon.colon colon3 = $org_scalatest_assert_macro_left6;
            List list4 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(colon3 != null ? !colon3.equals(list4) : list4 != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("BinaryClassificationMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
        }, new Position("BinaryClassificationMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
    }
}

