/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.internal.config.Kryo$;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.feature.Word2Vec;
import org.apache.spark.mllib.feature.Word2VecModel;
import org.apache.spark.mllib.feature.Word2VecModel$;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001u1AAA\u0002\u0001\u001d!)\u0011\u0004\u0001C\u00015\tiqk\u001c:eeY+7mU;ji\u0016T!\u0001B\u0003\u0002\u000f\u0019,\u0017\r^;sK*\u0011aaB\u0001\u0006[2d\u0017N\u0019\u0006\u0003\u0011%\tQa\u001d9be.T!AC\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0011aA8sO\u000e\u00011c\u0001\u0001\u0010'A\u0011\u0001#E\u0007\u0002\u000f%\u0011!c\u0002\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005Q9R\"A\u000b\u000b\u0005Y)\u0011\u0001B;uS2L!\u0001G\u000b\u0003+5cE.\u001b2UKN$8\u000b]1sW\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011a\u0001")
public class Word2VecSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private final void testImplicits$lzycompute$1() {
        Word2VecSuite word2VecSuite = this;
        synchronized (word2VecSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public Word2VecSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("Word2Vec", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Tuple2[] syms;
            String sentence = new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString("a b ")).$times(100)).append(new StringOps(Predef$.MODULE$.augmentString("a c ")).$times(10)).toString();
            Seq localDoc = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sentence, sentence}));
            SparkContext qual$1 = this.sc();
            Seq x$12 = localDoc;
            int x$22 = qual$1.parallelize$default$2();
            RDD doc = qual$1.parallelize(x$12, x$22, ClassTag$.MODULE$.apply(String.class)).map((Function1 & Serializable & scala.Serializable)line -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])line.split(" "))).toSeq(), ClassTag$.MODULE$.apply(Seq.class));
            Word2VecModel model = new Word2Vec().setVectorSize(10).setSeed(42L).fit(doc);
            Tuple2[] $org_scalatest_assert_macro_left = syms = model.findSynonyms("a", 2);
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("Word2VecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
            String $org_scalatest_assert_macro_left2 = (String)syms[0]._1();
            String $org_scalatest_assert_macro_right2 = "b";
            String string = $org_scalatest_assert_macro_left2;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("Word2VecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
            String $org_scalatest_assert_macro_left3 = (String)syms[1]._1();
            String $org_scalatest_assert_macro_right3 = "c";
            String string3 = $org_scalatest_assert_macro_left3;
            String string4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("Word2VecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
            Map word2VecMap = model.getVectors();
            Word2VecModel newModel = new Word2VecModel(word2VecMap);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(newModel.getVectors().mapValues((Function1 & Serializable & scala.Serializable)x$1 -> new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(x$1)).toSeq()));
            Map $org_scalatest_assert_macro_right4 = word2VecMap.mapValues((Function1 & Serializable & scala.Serializable)x$2 -> new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(x$2)).toSeq());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("Word2VecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        }, new Position("Word2VecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
        this.test("Word2Vec throws exception when vocabulary is empty", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> {
            String sentence = "a b c";
            Seq localDoc = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sentence, sentence}));
            SparkContext qual$2 = this.sc();
            Seq x$3 = localDoc;
            int x$4 = qual$2.parallelize$default$2();
            RDD doc = qual$2.parallelize(x$3, x$4, ClassTag$.MODULE$.apply(String.class)).map((Function1 & Serializable & scala.Serializable)line -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])line.split(" "))).toSeq(), ClassTag$.MODULE$.apply(Seq.class));
            return new Word2Vec().setMinCount(10).fit(doc);
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("Word2VecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50)), new Position("Word2VecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        this.test("Word2VecModel", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Tuple2[] syms;
            int num = 2;
            Map word2VecMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"china", (Object)new float[]{0.5f, 0.5f, 0.5f, 0.5f}), new Tuple2((Object)"japan", (Object)new float[]{0.4f, 0.5f, 0.5f, 0.5f}), new Tuple2((Object)"taiwan", (Object)new float[]{0.6f, 0.5f, 0.5f, 0.5f}), new Tuple2((Object)"korea", (Object)new float[]{0.45f, 0.6f, 0.6f, 0.6f})}));
            Word2VecModel model = new Word2VecModel(word2VecMap);
            Tuple2[] $org_scalatest_assert_macro_left = syms = model.findSynonyms("china", num);
            int $org_scalatest_assert_macro_right = num;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("Word2VecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
            String $org_scalatest_assert_macro_left2 = (String)syms[0]._1();
            String $org_scalatest_assert_macro_right2 = "taiwan";
            String string = $org_scalatest_assert_macro_left2;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("Word2VecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
            String $org_scalatest_assert_macro_left3 = (String)syms[1]._1();
            String $org_scalatest_assert_macro_right3 = "japan";
            String string3 = $org_scalatest_assert_macro_left3;
            String string4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("Word2VecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        }, new Position("Word2VecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        this.test("findSynonyms doesn't reject similar word vectors when called with a vector", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Tuple2[] syms;
            int num = 2;
            Map word2VecMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"china", (Object)new float[]{0.5f, 0.5f, 0.5f, 0.5f}), new Tuple2((Object)"japan", (Object)new float[]{0.4f, 0.5f, 0.5f, 0.5f}), new Tuple2((Object)"taiwan", (Object)new float[]{0.6f, 0.5f, 0.5f, 0.5f}), new Tuple2((Object)"korea", (Object)new float[]{0.45f, 0.6f, 0.6f, 0.6f})}));
            Word2VecModel model = new Word2VecModel(word2VecMap);
            Tuple2[] $org_scalatest_assert_macro_left = syms = model.findSynonyms(Vectors$.MODULE$.dense(new double[]{0.52, 0.5, 0.5, 0.5}), num);
            int $org_scalatest_assert_macro_right = num;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("Word2VecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            String $org_scalatest_assert_macro_left2 = (String)syms[0]._1();
            String $org_scalatest_assert_macro_right2 = "china";
            String string = $org_scalatest_assert_macro_left2;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("Word2VecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            String $org_scalatest_assert_macro_left3 = (String)syms[1]._1();
            String $org_scalatest_assert_macro_right3 = "taiwan";
            String string3 = $org_scalatest_assert_macro_left3;
            String string4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("Word2VecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
        }, new Position("Word2VecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        this.test("model load / save", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            Map word2VecMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"china", (Object)new float[]{0.5f, 0.5f, 0.5f, 0.5f}), new Tuple2((Object)"japan", (Object)new float[]{0.4f, 0.5f, 0.5f, 0.5f}), new Tuple2((Object)"taiwan", (Object)new float[]{0.6f, 0.5f, 0.5f, 0.5f}), new Tuple2((Object)"korea", (Object)new float[]{0.45f, 0.6f, 0.6f, 0.6f})}));
            Word2VecModel model = new Word2VecModel(word2VecMap);
            File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            String path = tempDir.toURI().toString();
            try {
                model.save(this.sc(), path);
                Word2VecModel sameModel = Word2VecModel$.MODULE$.load(this.sc(), path);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(sameModel.getVectors().mapValues((Function1 & Serializable & scala.Serializable)x$3 -> new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(x$3)).toSeq()));
                Map $org_scalatest_assert_macro_right = model.getVectors().mapValues((Function1 & Serializable & scala.Serializable)x$4 -> new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(x$4)).toSeq());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("Word2VecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            }
            finally {
                Utils$.MODULE$.deleteRecursively(tempDir);
            }
            return assertion;
        }, new Position("Word2VecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        this.test("big model load / save", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            String oldBufferConfValue = this.spark().conf().get(Kryo$.MODULE$.KRYO_SERIALIZER_BUFFER_SIZE().key(), "64m");
            String oldBufferMaxConfValue = this.spark().conf().get(Kryo$.MODULE$.KRYO_SERIALIZER_MAX_BUFFER_SIZE().key(), "64k");
            String oldSetCommandRejectsSparkCoreConfs = this.spark().conf().get(SQLConf$.MODULE$.SET_COMMAND_REJECTS_SPARK_CORE_CONFS().key(), "true");
            this.spark().conf().set(SQLConf$.MODULE$.SET_COMMAND_REJECTS_SPARK_CORE_CONFS().key(), "false");
            this.spark().conf().set(Kryo$.MODULE$.KRYO_SERIALIZER_BUFFER_SIZE().key(), "50b");
            Map word2VecMap = (Map)Predef$.MODULE$.Map().apply((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable & scala.Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)String.valueOf(BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)))), Array$.MODULE$.fill(10, (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> 0.1f, ClassTag$.MODULE$.Float())), IndexedSeq$.MODULE$.canBuildFrom()));
            Word2VecModel model = new Word2VecModel(word2VecMap);
            File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            String path = tempDir.toURI().toString();
            try {
                try {
                    model.save(this.sc(), path);
                    Word2VecModel sameModel = Word2VecModel$.MODULE$.load(this.sc(), path);
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(sameModel.getVectors().mapValues((Function1 & Serializable & scala.Serializable)x$5 -> new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(x$5)).toSeq()));
                    Map $org_scalatest_assert_macro_right = model.getVectors().mapValues((Function1 & Serializable & scala.Serializable)x$6 -> new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(x$6)).toSeq());
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("Word2VecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
                }
                catch (Throwable t) {
                    throw this.fail("exception thrown persisting a model that spans over multiple partitions", t, new Position("Word2VecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
                }
            }
            finally {
                Utils$.MODULE$.deleteRecursively(tempDir);
                this.spark().conf().set(Kryo$.MODULE$.KRYO_SERIALIZER_BUFFER_SIZE().key(), oldBufferConfValue);
                this.spark().conf().set(Kryo$.MODULE$.KRYO_SERIALIZER_MAX_BUFFER_SIZE().key(), oldBufferMaxConfValue);
                this.spark().conf().set(SQLConf$.MODULE$.SET_COMMAND_REJECTS_SPARK_CORE_CONFS().key(), oldSetCommandRejectsSparkCoreConfs);
            }
            return assertion;
        }, new Position("Word2VecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        this.test("test similarity for word vectors with large values is not Infinity or NaN", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            float[] vecA = (float[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(new double[]{-4.331467827487745E21, -5.26707742075006E21, 5.63551690626524E21, 2.833692188614257E21, -1.968816E21f, -4.933950659913092E21, -2.7401535502536787E21, -1.418671793782632E20})).map((Function1)(JFunction1.mcFD.sp & Serializable & scala.Serializable)x$7 -> (float)x$7, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
            float[] vecB = (float[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(new double[]{-3.985017545110323E16, -3.4829783883841536E16, 9.421469251534848E15, 4.406968446667981E16, 7.20936298872832E15, -4.288330283037491E16, -3.60558E16f, -2.8151294422155264E16})).map((Function1)(JFunction1.mcFD.sp & Serializable & scala.Serializable)x$8 -> (float)x$8, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
            float[] vecC = (float[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(new double[]{-1.922738E16f, -3.907009342603264E16, 2.110207626838016E15, -4.877006661065114E16, -1.973496455574323E16, -3.2206001247617024E16, 2.772535822044365E16, 3.1618718156980224E16})).map((Function1)(JFunction1.mcFD.sp & Serializable & scala.Serializable)x$9 -> (float)x$9, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
            Map wordMapIn = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"A", (Object)vecA), new Tuple2((Object)"B", (Object)vecB), new Tuple2((Object)"C", (Object)vecC)}));
            Word2VecModel model = new Word2VecModel(wordMapIn);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.findSynonyms("A", 5))).foreach((Function1 & Serializable & scala.Serializable)pair -> {
                Bool $org_scalatest_assert_macro_left = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.double2Double(pair._2$mcD$sp()).isInfinite(), "scala.Predef.double2Double(pair._2).isInfinite()", Prettifier$.MODULE$.default());
                Bool $org_scalatest_assert_macro_right = $org_scalatest_assert_macro_left.value() ? Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default()) : Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.double2Double(pair._2$mcD$sp()).isNaN(), "scala.Predef.double2Double(pair._2).isNaN()", Prettifier$.MODULE$.default());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "||", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$bar$bar((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("Word2VecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
            });
        }, new Position("Word2VecSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
    }
}

