/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.fpm;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.fpm.PrefixSpan;
import org.apache.spark.mllib.fpm.PrefixSpan$;
import org.apache.spark.mllib.fpm.PrefixSpanModel;
import org.apache.spark.mllib.fpm.PrefixSpanModel$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001i3A!\u0002\u0004\u0001#!)A\u0004\u0001C\u0001;!)\u0001\u0005\u0001C\u0005C!)1\n\u0001C\u0005\u0019\")Q\u000b\u0001C\u0005-\ny\u0001K]3gSb\u001c\u0006/\u00198Tk&$XM\u0003\u0002\b\u0011\u0005\u0019a\r]7\u000b\u0005%Q\u0011!B7mY&\u0014'BA\u0006\r\u0003\u0015\u0019\b/\u0019:l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0005\f\u0011\u0005M!R\"\u0001\u0006\n\u0005UQ!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u001855\t\u0001D\u0003\u0002\u001a\u0011\u0005!Q\u000f^5m\u0013\tY\u0002DA\u000bN\u00192L'\rV3tiN\u0003\u0018M]6D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\u0005q\u0002CA\u0010\u0001\u001b\u00051\u0011AD2p[B\f'/\u001a*fgVdGo]\u000b\u0003EU\"2aI\u0015B!\t!s%D\u0001&\u0015\u00051\u0013!B:dC2\f\u0017B\u0001\u0015&\u0005\u0011)f.\u001b;\t\u000b)\u0012\u0001\u0019A\u0016\u0002\u001b\u0015D\b/Z2uK\u00124\u0016\r\\;f!\r!CFL\u0005\u0003[\u0015\u0012Q!\u0011:sCf\u0004B\u0001J\u00182}%\u0011\u0001'\n\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007\u0011b#\u0007E\u0002%YM\u0002\"\u0001N\u001b\r\u0001\u0011)aG\u0001b\u0001o\t!\u0011\n^3n#\tA4\b\u0005\u0002%s%\u0011!(\n\u0002\b\u001d>$\b.\u001b8h!\t!C(\u0003\u0002>K\t\u0019\u0011I\\=\u0011\u0005\u0011z\u0014B\u0001!&\u0005\u0011auN\\4\t\u000b\t\u0013\u0001\u0019A\"\u0002\u0017\u0005\u001cG/^1m-\u0006dW/\u001a\t\u0004I1\"\u0005cA#Ig9\u0011qDR\u0005\u0003\u000f\u001a\t!\u0002\u0015:fM&D8\u000b]1o\u0013\tI%J\u0001\u0007Ge\u0016\f8+Z9vK:\u001cWM\u0003\u0002H\r\u000512m\\7qCJ,\u0017J\u001c;fe:\fGNU3tk2$8\u000fF\u0002$\u001bRCQAK\u0002A\u00029\u00032\u0001\n\u0017P!\u0011!s\u0006\u0015 \u0011\u0007\u0011b\u0013\u000b\u0005\u0002%%&\u00111+\n\u0002\u0004\u0013:$\b\"\u0002\"\u0004\u0001\u0004q\u0015\u0001G2p[B\f'/Z%oi\u0016\u0014h.\u00197TKF,XM\\2fgR\u00191eV-\t\u000b)\"\u0001\u0019\u0001-\u0011\u0007\u0011b\u0003\u000bC\u0003C\t\u0001\u0007\u0001\f")
public class PrefixSpanSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private <Item> void compareResults(Tuple2<Object[], Object>[] expectedValue, PrefixSpan.FreqSequence<Item>[] actualValue) {
        Set expectedSet = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expectedValue)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            long count;
            Object[] pattern;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$1;
                    if (tuple2 == null) break block2;
                    pattern = (Object[])tuple2._1();
                    count = tuple2._2$mcJ$sp();
                    if (pattern != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            Object[] objectArray = pattern;
            long l = count;
            Tuple2 tuple2 = new Tuple2((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(objectArray)).map((Function1 & Serializable & scala.Serializable)itemSet -> Predef$.MODULE$.genericArrayOps(itemSet).toSet(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Set.class))))).toSeq(), (Object)BoxesRunTime.boxToLong((long)l));
            return tuple2;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toSet();
        Set actualSet = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])actualValue)).map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(x.sequence())).map((Function1 & Serializable & scala.Serializable)x$5 -> Predef$.MODULE$.genericArrayOps(x$5).toSet(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Set.class))))).toSeq(), (Object)BoxesRunTime.boxToLong((long)x.freq())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toSet();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(expectedSet);
        Set $org_scalatest_assert_macro_right = actualSet;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PrefixSpanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 445));
    }

    private void compareInternalResults(Tuple2<int[], Object>[] expectedValue, Tuple2<int[], Object>[] actualValue) {
        Set expectedSet = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expectedValue)).map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])x._1())).toSeq(), (Object)BoxesRunTime.boxToLong((long)x._2$mcJ$sp())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toSet();
        Set actualSet = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])actualValue)).map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])x._1())).toSeq(), (Object)BoxesRunTime.boxToLong((long)x._2$mcJ$sp())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toSet();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(expectedSet);
        Set $org_scalatest_assert_macro_right = actualSet;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PrefixSpanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 453));
    }

    private void compareInternalSequences(int[][] expectedValue, int[][] actualValue) {
        Set expectedSet = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expectedValue)).map((Function1 & Serializable & scala.Serializable)x -> new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(x)).toSeq(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class))))).toSet();
        Set actualSet = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])actualValue)).map((Function1 & Serializable & scala.Serializable)x -> new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(x)).toSeq(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class))))).toSet();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(expectedSet);
        Set $org_scalatest_assert_macro_right = actualSet;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PrefixSpanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 461));
    }

    private final void testImplicits$lzycompute$1() {
        PrefixSpanSuite prefixSpanSuite = this;
        synchronized (prefixSpanSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public PrefixSpanSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("PrefixSpan internal (integer seq, 0 delim) run, singleton itemsets", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int[][] sequences = (int[][])((Object[])new int[][]{{0, 1, 0, 3, 0, 4, 0, 5, 0}, {0, 2, 0, 3, 0, 1, 0}, {0, 2, 0, 4, 0, 1, 0}, {0, 3, 0, 1, 0, 3, 0, 4, 0, 5, 0}, {0, 3, 0, 4, 0, 4, 0, 3, 0}, {0, 6, 0, 5, 0, 3, 0}});
            RDD rdd = this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])sequences), 2, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))).cache();
            RDD result1 = PrefixSpan$.MODULE$.genFreqPatterns(rdd, 2L, 50, 16L);
            Tuple2[] expectedValue1 = (Tuple2[])((Object[])new Tuple2[]{new Tuple2((Object)new int[]{0, 1, 0}, (Object)BoxesRunTime.boxToLong((long)4L)), new Tuple2((Object)new int[]{0, 1, 0, 3, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 1, 0, 3, 0, 4, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 1, 0, 3, 0, 4, 0, 5, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 1, 0, 3, 0, 5, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 1, 0, 4, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 1, 0, 4, 0, 5, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 1, 0, 5, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 2, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 2, 0, 1, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 3, 0}, (Object)BoxesRunTime.boxToLong((long)5L)), new Tuple2((Object)new int[]{0, 3, 0, 1, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 3, 0, 3, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 3, 0, 4, 0}, (Object)BoxesRunTime.boxToLong((long)3L)), new Tuple2((Object)new int[]{0, 3, 0, 4, 0, 5, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 3, 0, 5, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 4, 0}, (Object)BoxesRunTime.boxToLong((long)4L)), new Tuple2((Object)new int[]{0, 4, 0, 5, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 5, 0}, (Object)BoxesRunTime.boxToLong((long)3L))});
            this.compareInternalResults(expectedValue1, (Tuple2[])result1.collect());
            RDD result2 = PrefixSpan$.MODULE$.genFreqPatterns(rdd, 3L, 50, 32L);
            Tuple2[] expectedValue2 = (Tuple2[])((Object[])new Tuple2[]{new Tuple2((Object)new int[]{0, 1, 0}, (Object)BoxesRunTime.boxToLong((long)4L)), new Tuple2((Object)new int[]{0, 3, 0}, (Object)BoxesRunTime.boxToLong((long)5L)), new Tuple2((Object)new int[]{0, 3, 0, 4, 0}, (Object)BoxesRunTime.boxToLong((long)3L)), new Tuple2((Object)new int[]{0, 4, 0}, (Object)BoxesRunTime.boxToLong((long)4L)), new Tuple2((Object)new int[]{0, 5, 0}, (Object)BoxesRunTime.boxToLong((long)3L))});
            this.compareInternalResults(expectedValue2, (Tuple2[])result2.collect());
            RDD result3 = PrefixSpan$.MODULE$.genFreqPatterns(rdd, 2L, 2, 32L);
            Tuple2[] expectedValue3 = (Tuple2[])((Object[])new Tuple2[]{new Tuple2((Object)new int[]{0, 1, 0}, (Object)BoxesRunTime.boxToLong((long)4L)), new Tuple2((Object)new int[]{0, 1, 0, 3, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 1, 0, 4, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 1, 0, 5, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 2, 0, 1, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 2, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 3, 0}, (Object)BoxesRunTime.boxToLong((long)5L)), new Tuple2((Object)new int[]{0, 3, 0, 1, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 3, 0, 3, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 3, 0, 4, 0}, (Object)BoxesRunTime.boxToLong((long)3L)), new Tuple2((Object)new int[]{0, 3, 0, 5, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 4, 0}, (Object)BoxesRunTime.boxToLong((long)4L)), new Tuple2((Object)new int[]{0, 4, 0, 5, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 5, 0}, (Object)BoxesRunTime.boxToLong((long)3L))});
            this.compareInternalResults(expectedValue3, (Tuple2[])result3.collect());
        }, new Position("PrefixSpanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 25));
        this.test("PrefixSpan internal (integer seq, -1 delim) run, variable-size itemsets", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int[][] sequences = (int[][])((Object[])new int[][]{{0, 1, 0, 1, 2, 3, 0, 1, 3, 0, 4, 0, 3, 6, 0}, {0, 1, 4, 0, 3, 0, 2, 3, 0, 1, 5, 0}, {0, 5, 6, 0, 1, 2, 0, 4, 6, 0, 3, 0, 2, 0}, {0, 5, 0, 7, 0, 1, 6, 0, 3, 0, 2, 0, 3, 0}});
            RDD rdd = this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])sequences), 2, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))).cache();
            RDD result = PrefixSpan$.MODULE$.genFreqPatterns(rdd, 2L, 5, 128L);
            Tuple2[] expectedValue = (Tuple2[])((Object[])new Tuple2[]{new Tuple2((Object)new int[]{0, 1, 0}, (Object)BoxesRunTime.boxToLong((long)4L)), new Tuple2((Object)new int[]{0, 2, 0}, (Object)BoxesRunTime.boxToLong((long)4L)), new Tuple2((Object)new int[]{0, 3, 0}, (Object)BoxesRunTime.boxToLong((long)4L)), new Tuple2((Object)new int[]{0, 4, 0}, (Object)BoxesRunTime.boxToLong((long)3L)), new Tuple2((Object)new int[]{0, 5, 0}, (Object)BoxesRunTime.boxToLong((long)3L)), new Tuple2((Object)new int[]{0, 6, 0}, (Object)BoxesRunTime.boxToLong((long)3L)), new Tuple2((Object)new int[]{0, 1, 0, 6, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 2, 0, 6, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 5, 0, 6, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 1, 2, 0, 6, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 1, 0, 4, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 2, 0, 4, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 1, 2, 0, 4, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 1, 0, 3, 0}, (Object)BoxesRunTime.boxToLong((long)4L)), new Tuple2((Object)new int[]{0, 2, 0, 3, 0}, (Object)BoxesRunTime.boxToLong((long)3L)), new Tuple2((Object)new int[]{0, 2, 3, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 3, 0, 3, 0}, (Object)BoxesRunTime.boxToLong((long)3L)), new Tuple2((Object)new int[]{0, 4, 0, 3, 0}, (Object)BoxesRunTime.boxToLong((long)3L)), new Tuple2((Object)new int[]{0, 5, 0, 3, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 6, 0, 3, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 5, 0, 6, 0, 3, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 6, 0, 2, 0, 3, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 5, 0, 2, 0, 3, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 5, 0, 1, 0, 3, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 2, 0, 4, 0, 3, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 1, 0, 4, 0, 3, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 1, 2, 0, 4, 0, 3, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 1, 0, 3, 0, 3, 0}, (Object)BoxesRunTime.boxToLong((long)3L)), new Tuple2((Object)new int[]{0, 1, 2, 0, 3, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 1, 0, 2, 0, 3, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 1, 0, 2, 3, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 1, 0, 2, 0}, (Object)BoxesRunTime.boxToLong((long)4L)), new Tuple2((Object)new int[]{0, 1, 2, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 3, 0, 2, 0}, (Object)BoxesRunTime.boxToLong((long)3L)), new Tuple2((Object)new int[]{0, 4, 0, 2, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 5, 0, 2, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 6, 0, 2, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 5, 0, 6, 0, 2, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 6, 0, 3, 0, 2, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 5, 0, 3, 0, 2, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 5, 0, 1, 0, 2, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 4, 0, 3, 0, 2, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 1, 0, 3, 0, 2, 0}, (Object)BoxesRunTime.boxToLong((long)3L)), new Tuple2((Object)new int[]{0, 5, 0, 6, 0, 3, 0, 2, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 5, 0, 1, 0, 3, 0, 2, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 1, 0, 1, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 2, 0, 1, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 3, 0, 1, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 5, 0, 1, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 2, 3, 0, 1, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 1, 0, 3, 0, 1, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 1, 0, 2, 3, 0, 1, 0}, (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)new int[]{0, 1, 0, 2, 0, 1, 0}, (Object)BoxesRunTime.boxToLong((long)2L))});
            this.compareInternalResults(expectedValue, (Tuple2[])result.collect());
        }, new Position("PrefixSpanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        this.test("PrefixSpan projections with multiple partial starts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq sequences = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new int[][][]{(int[][])((Object[])new int[][]{{1, 2}, {1, 2, 3}})}));
            RDD rdd = this.sc().parallelize(sequences, 2, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))));
            PrefixSpan prefixSpan = new PrefixSpan().setMinSupport(1.0).setMaxPatternLength(2);
            PrefixSpanModel model = prefixSpan.run(rdd, ClassTag$.MODULE$.Int());
            Tuple2[] expected = (Tuple2[])((Object[])new Tuple2[]{new Tuple2((Object)((Object[])new int[][]{{1}}), (Object)BoxesRunTime.boxToLong((long)1L)), new Tuple2((Object)((Object[])new int[][]{{1, 2}}), (Object)BoxesRunTime.boxToLong((long)1L)), new Tuple2((Object)((Object[])new int[][]{{1}, {1}}), (Object)BoxesRunTime.boxToLong((long)1L)), new Tuple2((Object)((Object[])new int[][]{{1}, {2}}), (Object)BoxesRunTime.boxToLong((long)1L)), new Tuple2((Object)((Object[])new int[][]{{1}, {3}}), (Object)BoxesRunTime.boxToLong((long)1L)), new Tuple2((Object)((Object[])new int[][]{{1, 3}}), (Object)BoxesRunTime.boxToLong((long)1L)), new Tuple2((Object)((Object[])new int[][]{{2}}), (Object)BoxesRunTime.boxToLong((long)1L)), new Tuple2((Object)((Object[])new int[][]{{2, 3}}), (Object)BoxesRunTime.boxToLong((long)1L)), new Tuple2((Object)((Object[])new int[][]{{2}, {1}}), (Object)BoxesRunTime.boxToLong((long)1L)), new Tuple2((Object)((Object[])new int[][]{{2}, {2}}), (Object)BoxesRunTime.boxToLong((long)1L)), new Tuple2((Object)((Object[])new int[][]{{2}, {3}}), (Object)BoxesRunTime.boxToLong((long)1L)), new Tuple2((Object)((Object[])new int[][]{{3}}), (Object)BoxesRunTime.boxToLong((long)1L))});
            this.compareResults(expected, (PrefixSpan.FreqSequence[])model.freqSequences().collect());
        }, new Position("PrefixSpanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
        this.test("PrefixSpan Integer type, variable-size itemsets", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq sequences = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new int[][][]{(int[][])((Object[])new int[][]{{1, 2}, {3}}), (int[][])((Object[])new int[][]{{1}, {3, 2}, {1, 2}}), (int[][])((Object[])new int[][]{{1, 2}, {5}}), (int[][])((Object[])new int[][]{{6}})}));
            RDD rdd = this.sc().parallelize(sequences, 2, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)))).cache();
            PrefixSpan prefixSpan = new PrefixSpan().setMinSupport(0.5).setMaxPatternLength(5);
            PrefixSpanModel model = prefixSpan.run(rdd, ClassTag$.MODULE$.Int());
            Tuple2[] expected = (Tuple2[])((Object[])new Tuple2[]{new Tuple2((Object)((Object[])new int[][]{{1}}), (Object)BoxesRunTime.boxToLong((long)3L)), new Tuple2((Object)((Object[])new int[][]{{2}}), (Object)BoxesRunTime.boxToLong((long)3L)), new Tuple2((Object)((Object[])new int[][]{{3}}), (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)((Object[])new int[][]{{1}, {3}}), (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)((Object[])new int[][]{{1, 2}}), (Object)BoxesRunTime.boxToLong((long)3L))});
            this.compareResults(expected, (PrefixSpan.FreqSequence[])model.freqSequences().collect());
        }, new Position("PrefixSpanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
        this.test("PrefixSpan String type, variable-size itemsets", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Map intToString = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 6).zip((GenIterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c", "d", "e", "f"})), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            Seq sequences = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new int[][][]{(int[][])((Object[])new int[][]{{1, 2}, {3}}), (int[][])((Object[])new int[][]{{1}, {3, 2}, {1, 2}}), (int[][])((Object[])new int[][]{{1, 2}, {5}}), (int[][])((Object[])new int[][]{{6}})}))).map((Function1 & Serializable & scala.Serializable)seq -> (String[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])seq)).map((Function1 & Serializable & scala.Serializable)itemSet -> (String[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(itemSet)).map((Function1)intToString, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))), Seq$.MODULE$.canBuildFrom());
            RDD rdd = this.sc().parallelize(sequences, 2, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(String.class)))).cache();
            PrefixSpan prefixSpan = new PrefixSpan().setMinSupport(0.5).setMaxPatternLength(5);
            PrefixSpanModel model = prefixSpan.run(rdd, ClassTag$.MODULE$.apply(String.class));
            Tuple2[] expected = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Tuple2[]{new Tuple2((Object)((Object[])new int[][]{{1}}), (Object)BoxesRunTime.boxToLong((long)3L)), new Tuple2((Object)((Object[])new int[][]{{2}}), (Object)BoxesRunTime.boxToLong((long)3L)), new Tuple2((Object)((Object[])new int[][]{{3}}), (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)((Object[])new int[][]{{1}, {3}}), (Object)BoxesRunTime.boxToLong((long)2L)), new Tuple2((Object)((Object[])new int[][]{{1, 2}}), (Object)BoxesRunTime.boxToLong((long)3L))})).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int[][] pattern = (int[][])tuple2._1();
                long count = tuple2._2$mcJ$sp();
                Tuple2 tuple22 = new Tuple2(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pattern)).map((Function1 & Serializable & scala.Serializable)itemSet -> (String[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(itemSet)).map((Function1)intToString, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))), (Object)BoxesRunTime.boxToLong((long)count));
                return tuple22;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            this.compareResults(expected, (PrefixSpan.FreqSequence[])model.freqSequences().collect());
        }, new Position("PrefixSpanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
        this.test("PrefixSpan pre-processing's cleaning test", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Map itemToInt1 = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(4), 5).zipWithIndex(IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            Seq sequences1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new int[][][]{(int[][])((Object[])new int[][]{{4}, {1}, {2}, {5}, {2}, {4}, {5}}), (int[][])((Object[])new int[][]{{6}, {7}, {8}})}));
            RDD rdd1 = this.sc().parallelize(sequences1, 2, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)))).cache();
            int[][] cleanedSequence1 = (int[][])PrefixSpan$.MODULE$.toDatabaseInternalRepr(rdd1, itemToInt1, ClassTag$.MODULE$.Int()).collect();
            int[][] expected1 = (int[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new int[][]{{0, 4, 0, 5, 0, 4, 0, 5, 0}})).map((Function1 & Serializable & scala.Serializable)x$1 -> (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(x$1)).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x -> x == 0 ? 0 : BoxesRunTime.unboxToInt((Object)itemToInt1.apply((Object)BoxesRunTime.boxToInteger((int)x))) + 1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))));
            this.compareInternalSequences(expected1, cleanedSequence1);
            Map itemToInt2 = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(4), 6).zipWithIndex(IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            Seq sequences2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new int[][][]{(int[][])((Object[])new int[][]{{4, 5}, {1, 6, 2}, {2}, {5}, {2}, {4}, {5, 6, 7}}), (int[][])((Object[])new int[][]{{8, 9}, {1, 2}})}));
            RDD rdd2 = this.sc().parallelize(sequences2, 2, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)))).cache();
            int[][] cleanedSequence2 = (int[][])PrefixSpan$.MODULE$.toDatabaseInternalRepr(rdd2, itemToInt2, ClassTag$.MODULE$.Int()).collect();
            int[][] expected2 = (int[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new int[][]{{0, 4, 5, 0, 6, 0, 5, 0, 4, 0, 5, 6, 0}})).map((Function1 & Serializable & scala.Serializable)x$2 -> (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(x$2)).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x -> x == 0 ? 0 : BoxesRunTime.unboxToInt((Object)itemToInt2.apply((Object)BoxesRunTime.boxToInteger((int)x))) + 1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))));
            this.compareInternalSequences(expected2, cleanedSequence2);
            Map itemToInt3 = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(10), 10).zipWithIndex(IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            Seq sequences3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new int[][][]{(int[][])((Object[])new int[][]{{4, 5}, {1, 6, 2}, {2}, {5}, {2}, {4}, {5, 6, 7}}), (int[][])((Object[])new int[][]{{8, 9}, {1, 2}})}));
            RDD rdd3 = this.sc().parallelize(sequences3, 2, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)))).cache();
            int[][] cleanedSequence3 = (int[][])PrefixSpan$.MODULE$.toDatabaseInternalRepr(rdd3, itemToInt3, ClassTag$.MODULE$.Int()).collect();
            int[][] expected3 = (int[][])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)));
            this.compareInternalSequences(expected3, cleanedSequence3);
        }, new Position("PrefixSpanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
        this.test("model save/load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            Seq sequences = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new int[][][]{(int[][])((Object[])new int[][]{{1, 2}, {3}}), (int[][])((Object[])new int[][]{{1}, {3, 2}, {1, 2}}), (int[][])((Object[])new int[][]{{1, 2}, {5}}), (int[][])((Object[])new int[][]{{6}})}));
            RDD rdd = this.sc().parallelize(sequences, 2, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)))).cache();
            PrefixSpan prefixSpan = new PrefixSpan().setMinSupport(0.5).setMaxPatternLength(5);
            PrefixSpanModel model = prefixSpan.run(rdd, ClassTag$.MODULE$.Int());
            File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            String path = tempDir.toURI().toString();
            try {
                model.save(this.sc(), path);
                PrefixSpanModel newModel = PrefixSpanModel$.MODULE$.load(this.sc(), path);
                Set originalSet = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.freqSequences().collect())).map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(x.sequence())).map((Function1 & Serializable & scala.Serializable)x$3 -> new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(x$3)).toSet(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Set.class))))).toSeq(), (Object)BoxesRunTime.boxToLong((long)x.freq())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toSet();
                Set newSet = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newModel.freqSequences().collect())).map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(x.sequence())).map((Function1 & Serializable & scala.Serializable)x$4 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(x$4)).toSet(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Set.class))))).toSeq(), (Object)BoxesRunTime.boxToLong((long)x.freq())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toSet();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(originalSet);
                Set $org_scalatest_assert_macro_right = newSet;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PrefixSpanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 430));
            }
            finally {
                Utils$.MODULE$.deleteRecursively(tempDir);
            }
            return assertion;
        }, new Position("PrefixSpanSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 404));
    }
}

