/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import breeze.linalg.DenseVector;
import breeze.linalg.SparseVector;
import breeze.storage.Zero;
import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]2AAC\u0006\u0001-!)1\u0004\u0001C\u00019!9q\u0004\u0001b\u0001\n\u0003\u0001\u0003B\u0002\u0016\u0001A\u0003%\u0011\u0005C\u0004,\u0001\t\u0007I\u0011\u0001\u0017\t\rA\u0002\u0001\u0015!\u0003.\u0011\u001d\t\u0004A1A\u0005\u0002IBa\u0001\u000e\u0001!\u0002\u0013\u0019\u0004bB\u001b\u0001\u0005\u0004%\t\u0001\t\u0005\u0007m\u0001\u0001\u000b\u0011B\u0011\u00037\t\u0013X-\u001a>f-\u0016\u001cGo\u001c:D_:4XM]:j_:\u001cV/\u001b;f\u0015\taQ\"\u0001\u0004mS:\fGn\u001a\u0006\u0003\u001d=\tQ!\u001c7mS\nT!\u0001E\t\u0002\u000bM\u0004\u0018M]6\u000b\u0005I\u0019\u0012AB1qC\u000eDWMC\u0001\u0015\u0003\ry'oZ\u0002\u0001'\t\u0001q\u0003\u0005\u0002\u001935\tq\"\u0003\u0002\u001b\u001f\ti1\u000b]1sW\u001a+hnU;ji\u0016\fa\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"A\u0006\u0002\u0007\u0005\u0014(/F\u0001\"!\r\u0011SeJ\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t)\u0011I\u001d:bsB\u0011!\u0005K\u0005\u0003S\r\u0012a\u0001R8vE2,\u0017\u0001B1se\u0002\n\u0011A\\\u000b\u0002[A\u0011!EL\u0005\u0003_\r\u00121!\u00138u\u0003\tq\u0007%A\u0004j]\u0012L7-Z:\u0016\u0003M\u00022AI\u0013.\u0003!Ig\u000eZ5dKN\u0004\u0013A\u0002<bYV,7/A\u0004wC2,Xm\u001d\u0011")
public class BreezeVectorConversionSuite
extends SparkFunSuite {
    private final double[] arr = new double[]{0.1, 0.2, 0.3, 0.4};
    private final int n;
    private final int[] indices = new int[]{0, 3, 5, 10, 13};
    private final double[] values = new double[]{0.1, 0.5, 0.3, -0.8, -1.0};

    public double[] arr() {
        return this.arr;
    }

    public int n() {
        return this.n;
    }

    public int[] indices() {
        return this.indices;
    }

    public double[] values() {
        return this.values;
    }

    public BreezeVectorConversionSuite() {
        this.n = 20;
        this.test("dense to breeze", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Vector vec = Vectors$.MODULE$.dense(this.arr());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(vec.asBreeze());
            DenseVector.mcD.sp $org_scalatest_assert_macro_right = new DenseVector.mcD.sp(this.arr());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BreezeVectorConversionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
        }, new Position("BreezeVectorConversionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
        this.test("sparse to breeze", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Vector vec = Vectors$.MODULE$.sparse(this.n(), this.indices(), this.values());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(vec.asBreeze());
            SparseVector.mcD.sp $org_scalatest_assert_macro_right = new SparseVector.mcD.sp(this.indices(), this.values(), this.n(), (Zero)Zero.DoubleZero$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BreezeVectorConversionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        }, new Position("BreezeVectorConversionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        this.test("dense breeze to vector", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            DenseVector.mcD.sp breeze = new DenseVector.mcD.sp(this.arr());
            DenseVector vec = (DenseVector)Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector)breeze);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec.size()));
            int $org_scalatest_assert_macro_right = this.arr().length;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BreezeVectorConversionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
            double[] $org_scalatest_assert_macro_left2 = vec.values();
            double[] $org_scalatest_assert_macro_right2 = this.arr();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "eq", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"should not copy data", Prettifier$.MODULE$.default(), new Position("BreezeVectorConversionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
        }, new Position("BreezeVectorConversionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        this.test("sparse breeze to vector", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparseVector.mcD.sp breeze = new SparseVector.mcD.sp(this.indices(), this.values(), this.n(), (Zero)Zero.DoubleZero$.MODULE$);
            SparseVector vec = (SparseVector)Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector)breeze);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec.size()));
            int $org_scalatest_assert_macro_right = this.n();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BreezeVectorConversionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
            int[] $org_scalatest_assert_macro_left2 = vec.indices();
            int[] $org_scalatest_assert_macro_right2 = this.indices();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "eq", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"should not copy data", Prettifier$.MODULE$.default(), new Position("BreezeVectorConversionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
            double[] $org_scalatest_assert_macro_left3 = vec.values();
            double[] $org_scalatest_assert_macro_right3 = this.values();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "eq", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"should not copy data", Prettifier$.MODULE$.default(), new Position("BreezeVectorConversionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        }, new Position("BreezeVectorConversionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
        this.test("sparse breeze with partially-used arrays to vector", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int activeSize = 3;
            SparseVector.mcD.sp breeze = new SparseVector.mcD.sp(this.indices(), this.values(), activeSize, this.n(), (Zero)Zero.DoubleZero$.MODULE$);
            SparseVector vec = (SparseVector)Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector)breeze);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec.size()));
            int $org_scalatest_assert_macro_right = this.n();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BreezeVectorConversionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(vec.indices());
            int[] $org_scalatest_assert_macro_right2 = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.indices())).slice(0, activeSize);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BreezeVectorConversionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(vec.values());
            double[] $org_scalatest_assert_macro_right3 = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.values())).slice(0, activeSize);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BreezeVectorConversionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        }, new Position("BreezeVectorConversionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
    }
}

