/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg.distributed;

import breeze.linalg.DenseVector;
import breeze.linalg.SparseVector;
import breeze.linalg.Vector;
import breeze.linalg.support.LiteralRow$;
import breeze.storage.Zero;
import java.io.File;
import java.io.Serializable;
import java.util.Random;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.DenseMatrix$;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.SparseMatrix;
import org.apache.spark.mllib.linalg.SparseMatrix$;
import org.apache.spark.mllib.linalg.distributed.BlockMatrix;
import org.apache.spark.mllib.linalg.distributed.CoordinateMatrix;
import org.apache.spark.mllib.linalg.distributed.GridPartitioner;
import org.apache.spark.mllib.linalg.distributed.GridPartitioner$;
import org.apache.spark.mllib.linalg.distributed.IndexedRow;
import org.apache.spark.mllib.linalg.distributed.IndexedRowMatrix;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001q3A!\u0005\n\u0001?!)!\u0006\u0001C\u0001W!9a\u0006\u0001b\u0001\n\u0003y\u0003B\u0002\u001c\u0001A\u0003%\u0001\u0007C\u00048\u0001\t\u0007I\u0011A\u0018\t\ra\u0002\u0001\u0015!\u00031\u0011\u001dI\u0004A1A\u0005\u0002=BaA\u000f\u0001!\u0002\u0013\u0001\u0004bB\u001e\u0001\u0005\u0004%\ta\f\u0005\u0007y\u0001\u0001\u000b\u0011\u0002\u0019\t\u000fu\u0002!\u0019!C\u0001_!1a\b\u0001Q\u0001\nAB\u0011b\u0010\u0001A\u0002\u0003\u0007I\u0011\u0001!\t\u0013\u0011\u0003\u0001\u0019!a\u0001\n\u0003)\u0005\"C&\u0001\u0001\u0004\u0005\t\u0015)\u0003B\u0011\u0015a\u0005\u0001\"\u0011N\u0011\u0015q\u0005\u0001\"\u0001P\u0005A\u0011En\\2l\u001b\u0006$(/\u001b=Tk&$XM\u0003\u0002\u0014)\u0005YA-[:ue&\u0014W\u000f^3e\u0015\t)b#\u0001\u0004mS:\fGn\u001a\u0006\u0003/a\tQ!\u001c7mS\nT!!\u0007\u000e\u0002\u000bM\u0004\u0018M]6\u000b\u0005ma\u0012AB1qC\u000eDWMC\u0001\u001e\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001\u0005\n\t\u0003C\tj\u0011\u0001G\u0005\u0003Ga\u0011Qb\u00159be.4UO\\*vSR,\u0007CA\u0013)\u001b\u00051#BA\u0014\u0017\u0003\u0011)H/\u001b7\n\u0005%2#!F'MY&\u0014G+Z:u'B\f'o[\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00031\u0002\"!\f\u0001\u000e\u0003I\t\u0011!\\\u000b\u0002aA\u0011\u0011\u0007N\u0007\u0002e)\t1'A\u0003tG\u0006d\u0017-\u0003\u00026e\t\u0019\u0011J\u001c;\u0002\u00055\u0004\u0013!\u00018\u0002\u00059\u0004\u0013A\u0003:poB+'\u000fU1si\u0006Y!o\\<QKJ\u0004\u0016M\u001d;!\u0003)\u0019w\u000e\u001c)feB\u000b'\u000f^\u0001\fG>d\u0007+\u001a:QCJ$\b%A\u0007ok6\u0004\u0016M\u001d;ji&|gn]\u0001\u000f]Vl\u0007+\u0019:uSRLwN\\:!\u000319'/\u001b3CCN,G-T1u+\u0005\t\u0005CA\u0017C\u0013\t\u0019%CA\u0006CY>\u001c7.T1ue&D\u0018\u0001E4sS\u0012\u0014\u0015m]3e\u001b\u0006$x\fJ3r)\t1\u0015\n\u0005\u00022\u000f&\u0011\u0001J\r\u0002\u0005+:LG\u000fC\u0004K\u001b\u0005\u0005\t\u0019A!\u0002\u0007a$\u0013'A\u0007he&$')Y:fI6\u000bG\u000fI\u0001\nE\u00164wN]3BY2$\u0012AR\u0001\ri\u0016\u001cH/T;mi&\u0004H.\u001f\u000b\u0006\rB\u0013FK\u0017\u0005\u0006#B\u0001\r!Q\u0001\u0002\u0003\")1\u000b\u0005a\u0001\u0003\u0006\t!\tC\u0003V!\u0001\u0007a+\u0001\bfqB,7\r^3e%\u0016\u001cX\u000f\u001c;\u0011\u0005]CV\"\u0001\u000b\n\u0005e#\"AB'biJL\u0007\u0010C\u0003\\!\u0001\u0007\u0001'A\bok6l\u0015\u000e\u001a#j[N\u0003H.\u001b;t\u0001")
public class BlockMatrixSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private final int m;
    private final int n;
    private final int rowPerPart;
    private final int colPerPart;
    private final int numPartitions;
    private BlockMatrix gridBasedMat;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public int m() {
        return this.m;
    }

    public int n() {
        return this.n;
    }

    public int rowPerPart() {
        return this.rowPerPart;
    }

    public int colPerPart() {
        return this.colPerPart;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public BlockMatrix gridBasedMat() {
        return this.gridBasedMat;
    }

    public void gridBasedMat_$eq(BlockMatrix x$1) {
        this.gridBasedMat = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
        Seq blocks = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Tuple2.mcII.sp(0, 0), (Object)new DenseMatrix(2, 2, new double[]{1.0, 0.0, 0.0, 2.0})), new Tuple2((Object)new Tuple2.mcII.sp(0, 1), (Object)new DenseMatrix(2, 2, new double[]{0.0, 1.0, 0.0, 0.0})), new Tuple2((Object)new Tuple2.mcII.sp(1, 0), (Object)new DenseMatrix(2, 2, new double[]{3.0, 0.0, 1.0, 1.0})), new Tuple2((Object)new Tuple2.mcII.sp(1, 1), (Object)new DenseMatrix(2, 2, new double[]{1.0, 2.0, 0.0, 1.0})), new Tuple2((Object)new Tuple2.mcII.sp(2, 1), (Object)new DenseMatrix(1, 2, new double[]{1.0, 5.0}))}));
        this.gridBasedMat_$eq(new BlockMatrix(this.sc().parallelize(blocks, this.numPartitions(), ClassTag$.MODULE$.apply(Tuple2.class)), this.rowPerPart(), this.colPerPart()));
    }

    public void testMultiply(BlockMatrix A, BlockMatrix B, Matrix expectedResult, int numMidDimSplits) {
        BlockMatrix C = A.multiply(B, numMidDimSplits);
        Matrix localC = C.toLocalMatrix();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)C.numRows()));
        long $org_scalatest_assert_macro_right = A.numRows();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)C.numCols()));
        long $org_scalatest_assert_macro_right2 = B.numCols();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(localC).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(expectedResult).absTol(1.0E-8)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(localC).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(expectedResult).absTol(1.0E-8))", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
    }

    private final void testImplicits$lzycompute$1() {
        BlockMatrixSuite blockMatrixSuite = this;
        synchronized (blockMatrixSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ Assertion $anonfun$new$4(BlockMatrixSuite $this, GridPartitioner part0$1, int i$1, int[][] expected0$1, Random random$1, int j) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)part0$1.getPartition((Object)new Tuple2.mcII.sp(i$1, j))));
        int $org_scalatest_assert_macro_right = expected0$1[i$1][j];
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)part0$1.getPartition((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)i$1), (Object)BoxesRunTime.boxToInteger((int)j), (Object)BoxesRunTime.boxToInteger((int)random$1.nextInt())))));
        int $org_scalatest_assert_macro_right2 = expected0$1[i$1][j];
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
    }

    public static final /* synthetic */ Assertion $anonfun$new$10(BlockMatrixSuite $this, GridPartitioner part1$1, int i$2, int[][] expected1$1, Random random$1, int j) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)part1$1.getPartition((Object)new Tuple2.mcII.sp(i$2, j))));
        int $org_scalatest_assert_macro_right = expected1$1[i$2][j];
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)part1$1.getPartition((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)i$2), (Object)BoxesRunTime.boxToInteger((int)j), (Object)BoxesRunTime.boxToInteger((int)random$1.nextInt())))));
        int $org_scalatest_assert_macro_right2 = expected1$1[i$2][j];
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
    }

    public static final /* synthetic */ Assertion $anonfun$new$12(BlockMatrixSuite $this, GridPartitioner part3$1, int i$3, int[][] expected3$1, Random random$1, int j) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)part3$1.getPartition((Object)new Tuple2.mcII.sp(i$3, j))));
        int $org_scalatest_assert_macro_right = expected3$1[i$3][j];
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)part3$1.getPartition((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)i$3), (Object)BoxesRunTime.boxToInteger((int)j), (Object)BoxesRunTime.boxToInteger((int)random$1.nextInt())))));
        int $org_scalatest_assert_macro_right2 = expected3$1[i$3][j];
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$22(int i) {
        return new Tuple2((Object)new Tuple2.mcII.sp(i / 2, i % 2), (Object)SparseMatrix$.MODULE$.speye(4));
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$23(int i) {
        return new Tuple2((Object)new Tuple2.mcII.sp(i / 2, i % 2), (Object)DenseMatrix$.MODULE$.eye(4));
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$27(int i) {
        return new Tuple2((Object)new Tuple2.mcII.sp(i / 2, i % 2), (Object)SparseMatrix$.MODULE$.speye(4));
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$28(int i) {
        return new Tuple2((Object)new Tuple2.mcII.sp(i / 2, i % 2), (Object)DenseMatrix$.MODULE$.eye(4));
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$32(Random rand$1, int i) {
        return new Tuple2((Object)new Tuple2.mcII.sp(i % 5, i / 5), (Object)DenseMatrix$.MODULE$.rand(6, 4, rand$1));
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$33(Random rand$1, int i) {
        return new Tuple2((Object)new Tuple2.mcII.sp(i % 4, i / 4), (Object)DenseMatrix$.MODULE$.rand(4, 4, rand$1));
    }

    public BlockMatrixSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.m = 5;
        this.n = 4;
        this.rowPerPart = 2;
        this.colPerPart = 2;
        this.numPartitions = 3;
        this.test("size", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)this.gridBasedMat().numRows()));
            int $org_scalatest_assert_macro_right = this.m();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)this.gridBasedMat().numCols()));
            int $org_scalatest_assert_macro_right2 = this.n();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        }, new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        this.test("grid partitioner", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Random random = new Random();
            GridPartitioner part0 = GridPartitioner$.MODULE$.apply(4, 7, 12);
            int[][] expected0 = (int[][])((Object[])new int[][]{{0, 0, 4, 4, 8, 8, 12}, {1, 1, 5, 5, 9, 9, 13}, {2, 2, 6, 6, 10, 10, 14}, {3, 3, 7, 7, 11, 11, 15}});
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 4).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 7).foreach((Function1 & Serializable & scala.Serializable)j -> BlockMatrixSuite.$anonfun$new$4(this, part0, i, expected0, random, BoxesRunTime.unboxToInt((Object)j))));
            this.intercept((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> part0.getPartition((Object)new Tuple2.mcII.sp(-1, 0)), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
            this.intercept((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> part0.getPartition((Object)new Tuple2.mcII.sp(4, 0)), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
            this.intercept((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> part0.getPartition((Object)new Tuple2.mcII.sp(0, -1)), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
            this.intercept((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> part0.getPartition((Object)new Tuple2.mcII.sp(0, 7)), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            GridPartitioner part1 = GridPartitioner$.MODULE$.apply(2, 2, 5);
            int[][] expected1 = (int[][])((Object[])new int[][]{{0, 2}, {1, 3}});
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach((Function1 & Serializable & scala.Serializable)j -> BlockMatrixSuite.$anonfun$new$10(this, part1, i, expected1, random, BoxesRunTime.unboxToInt((Object)j))));
            GridPartitioner part2 = GridPartitioner$.MODULE$.apply(2, 2, 5);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(part0);
            GridPartitioner $org_scalatest_assert_macro_right = part2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!==", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$bang$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(part1);
            GridPartitioner $org_scalatest_assert_macro_right2 = part2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            GridPartitioner part3 = new GridPartitioner(2, 3, 1, 2);
            int[][] expected3 = (int[][])((Object[])new int[][]{{0, 0, 2}, {1, 1, 3}});
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach((Function1 & Serializable & scala.Serializable)j -> BlockMatrixSuite.$anonfun$new$12(this, part3, i, expected3, random, BoxesRunTime.unboxToInt((Object)j))));
            GridPartitioner part4 = GridPartitioner$.MODULE$.apply(2, 3, 1, 2);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(part3);
            GridPartitioner $org_scalatest_assert_macro_right3 = part4;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> new GridPartitioner(2, 2, 0, 1), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> GridPartitioner$.MODULE$.apply(2, 2, 1, 0), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> GridPartitioner$.MODULE$.apply(2, 2, 0), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        }, new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        this.test("toCoordinateMatrix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            CoordinateMatrix coordMat = this.gridBasedMat().toCoordinateMatrix();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)coordMat.numRows()));
            int $org_scalatest_assert_macro_right = this.m();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)coordMat.numCols()));
            int $org_scalatest_assert_macro_right2 = this.n();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(coordMat.toBreeze());
            breeze.linalg.DenseMatrix $org_scalatest_assert_macro_right3 = this.gridBasedMat().toBreeze();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
        }, new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
        this.test("toIndexedRowMatrix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            DenseVector denseVector;
            Vector sparseVector;
            SparseMatrix matSparse;
            DenseMatrix matDense;
            block3: {
                block2: {
                    IndexedRowMatrix rowMat = this.gridBasedMat().toIndexedRowMatrix();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)rowMat.numRows()));
                    int $org_scalatest_assert_macro_right = this.m();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)rowMat.numCols()));
                    int $org_scalatest_assert_macro_right2 = this.n();
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(rowMat.toBreeze());
                    breeze.linalg.DenseMatrix $org_scalatest_assert_macro_right3 = this.gridBasedMat().toBreeze();
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
                    BlockMatrix bmat = rowMat.toBlockMatrix();
                    IndexedRowMatrix imat = bmat.toIndexedRowMatrix();
                    imat.rows().collect();
                    int rows = 1;
                    int cols = 10;
                    matDense = new DenseMatrix(rows, cols, new double[]{1.0, 1.0, 3.0, 2.0, 5.0, 6.0, 7.0, 1.0, 2.0, 3.0});
                    matSparse = new SparseMatrix(rows, cols, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, new int[]{0}, new double[]{1.0});
                    Seq vectors = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Tuple2.mcII.sp(0, 0), (Object)matDense), new Tuple2((Object)new Tuple2.mcII.sp(1, 0), (Object)matSparse)}));
                    SparkContext qual$1 = this.sc();
                    Seq x$1 = vectors;
                    int x$2 = qual$1.parallelize$default$2();
                    RDD rdd = qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class));
                    BlockMatrix B = new BlockMatrix(rdd, rows, cols);
                    IndexedRow[] C = (IndexedRow[])B.toIndexedRowMatrix().rows().collect();
                    Tuple2 tuple2 = new Tuple2((Object)C[0].vector().asBreeze(), (Object)C[1].vector().asBreeze());
                    if (tuple2 == null) break block2;
                    Vector denseVector2 = (Vector)tuple2._1();
                    sparseVector = (Vector)tuple2._2();
                    if (!(denseVector2 instanceof DenseVector)) break block2;
                    denseVector = (DenseVector)denseVector2;
                    if (sparseVector instanceof SparseVector) break block3;
                }
                throw new RuntimeException("IndexedRow returns vectors of unexpected type");
            }
            SparseVector sparseVector2 = (SparseVector)sparseVector;
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)denseVector.length()));
            int $org_scalatest_assert_macro_right = sparseVector2.length();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(matDense.toArray());
            double[] $org_scalatest_assert_macro_right4 = denseVector.toArray$mcD$sp(ClassTag$.MODULE$.Double());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(matSparse.toArray());
            double[] $org_scalatest_assert_macro_right5 = sparseVector2.toArray$mcD$sp(ClassTag$.MODULE$.Double());
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
            return assertion;
        }, new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        this.test("toBreeze and toLocalMatrix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            breeze.linalg.DenseMatrix expected = (breeze.linalg.DenseMatrix)breeze.linalg.DenseMatrix$.MODULE$.apply$mDc$sp((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)3.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)5.0))}), LiteralRow$.MODULE$.tuple4(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
            DenseMatrix dense = (DenseMatrix)Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix)expected);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.gridBasedMat().toLocalMatrix());
            DenseMatrix $org_scalatest_assert_macro_right = dense;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.gridBasedMat().toBreeze());
            breeze.linalg.DenseMatrix $org_scalatest_assert_macro_right2 = expected;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
        }, new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        this.test("add", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq blocks = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Tuple2.mcII.sp(0, 0), (Object)new DenseMatrix(2, 2, new double[]{1.0, 0.0, 0.0, 2.0})), new Tuple2((Object)new Tuple2.mcII.sp(0, 1), (Object)new DenseMatrix(2, 2, new double[]{0.0, 1.0, 0.0, 0.0})), new Tuple2((Object)new Tuple2.mcII.sp(1, 0), (Object)new DenseMatrix(2, 2, new double[]{3.0, 0.0, 1.0, 1.0})), new Tuple2((Object)new Tuple2.mcII.sp(1, 1), (Object)new DenseMatrix(2, 2, new double[]{1.0, 2.0, 0.0, 1.0})), new Tuple2((Object)new Tuple2.mcII.sp(2, 0), (Object)new DenseMatrix(1, 2, new double[]{1.0, 0.0})), new Tuple2((Object)new Tuple2.mcII.sp(2, 1), (Object)new DenseMatrix(1, 2, new double[]{1.0, 5.0}))}));
            RDD rdd = this.sc().parallelize(blocks, this.numPartitions(), ClassTag$.MODULE$.apply(Tuple2.class));
            BlockMatrix B = new BlockMatrix(rdd, this.rowPerPart(), this.colPerPart());
            breeze.linalg.DenseMatrix expected = (breeze.linalg.DenseMatrix)breeze.linalg.DenseMatrix$.MODULE$.apply$mDc$sp((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)4.0), (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)6.0), (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)BoxesRunTime.boxToDouble((double)4.0), (Object)BoxesRunTime.boxToDouble((double)2.0)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)BoxesRunTime.boxToDouble((double)10.0))}), LiteralRow$.MODULE$.tuple4(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
            BlockMatrix AplusB = this.gridBasedMat().add(B);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)AplusB.numRows()));
            int $org_scalatest_assert_macro_right = this.m();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)AplusB.numCols()));
            long $org_scalatest_assert_macro_right2 = B.numCols();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(AplusB.toBreeze());
            breeze.linalg.DenseMatrix $org_scalatest_assert_macro_right3 = expected;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
            BlockMatrix C = new BlockMatrix(rdd, this.rowPerPart(), this.colPerPart(), (long)this.m(), (long)(this.n() + 1));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> this.gridBasedMat().add(C), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
            Seq largerBlocks = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Tuple2.mcII.sp(0, 0), (Object)new DenseMatrix(4, 4, new double[16])), new Tuple2((Object)new Tuple2.mcII.sp(1, 0), (Object)new DenseMatrix(1, 4, new double[]{1.0, 0.0, 1.0, 5.0}))}));
            BlockMatrix C2 = new BlockMatrix(this.sc().parallelize(largerBlocks, this.numPartitions(), ClassTag$.MODULE$.apply(Tuple2.class)), 4, 4, (long)this.m(), (long)this.n());
            this.intercept((Function0 & Serializable & scala.Serializable)() -> this.gridBasedMat().add(C2), ClassTag$.MODULE$.apply(SparkException.class), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
            IndexedSeq sparseBlocks = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable & scala.Serializable)i -> BlockMatrixSuite.$anonfun$new$22(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            IndexedSeq denseBlocks = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable & scala.Serializable)i -> BlockMatrixSuite.$anonfun$new$23(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            BlockMatrix sparseBM = new BlockMatrix(this.sc().makeRDD((Seq)sparseBlocks, 4, ClassTag$.MODULE$.apply(Tuple2.class)), 4, 4, 8L, 8L);
            BlockMatrix denseBM = new BlockMatrix(this.sc().makeRDD((Seq)denseBlocks, 4, ClassTag$.MODULE$.apply(Tuple2.class)), 4, 4, 8L, 8L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(sparseBM.add(sparseBM).toBreeze());
            breeze.linalg.DenseMatrix $org_scalatest_assert_macro_right4 = sparseBM.add(denseBM).toBreeze();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
        }, new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        this.test("subtract", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq blocks = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Tuple2.mcII.sp(0, 0), (Object)new DenseMatrix(2, 2, new double[]{1.0, 0.0, 0.0, 2.0})), new Tuple2((Object)new Tuple2.mcII.sp(0, 1), (Object)new DenseMatrix(2, 2, new double[]{0.0, 1.0, 0.0, 0.0})), new Tuple2((Object)new Tuple2.mcII.sp(1, 0), (Object)new DenseMatrix(2, 2, new double[]{3.0, 0.0, 1.0, 1.0})), new Tuple2((Object)new Tuple2.mcII.sp(1, 1), (Object)new DenseMatrix(2, 2, new double[]{1.0, 2.0, 0.0, 1.0})), new Tuple2((Object)new Tuple2.mcII.sp(2, 0), (Object)new DenseMatrix(1, 2, new double[]{1.0, 0.0})), new Tuple2((Object)new Tuple2.mcII.sp(2, 1), (Object)new DenseMatrix(1, 2, new double[]{1.0, 5.0}))}));
            RDD rdd = this.sc().parallelize(blocks, this.numPartitions(), ClassTag$.MODULE$.apply(Tuple2.class));
            BlockMatrix B = new BlockMatrix(rdd, this.rowPerPart(), this.colPerPart());
            breeze.linalg.DenseMatrix expected = (breeze.linalg.DenseMatrix)breeze.linalg.DenseMatrix$.MODULE$.apply$mDc$sp((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)-1.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0))}), LiteralRow$.MODULE$.tuple4(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
            BlockMatrix AsubtractB = this.gridBasedMat().subtract(B);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)AsubtractB.numRows()));
            int $org_scalatest_assert_macro_right = this.m();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)AsubtractB.numCols()));
            long $org_scalatest_assert_macro_right2 = B.numCols();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(AsubtractB.toBreeze());
            breeze.linalg.DenseMatrix $org_scalatest_assert_macro_right3 = expected;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
            BlockMatrix C = new BlockMatrix(rdd, this.rowPerPart(), this.colPerPart(), (long)this.m(), (long)(this.n() + 1));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> this.gridBasedMat().subtract(C), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
            Seq largerBlocks = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Tuple2.mcII.sp(0, 0), (Object)new DenseMatrix(4, 4, new double[16])), new Tuple2((Object)new Tuple2.mcII.sp(1, 0), (Object)new DenseMatrix(1, 4, new double[]{1.0, 0.0, 1.0, 5.0}))}));
            BlockMatrix C2 = new BlockMatrix(this.sc().parallelize(largerBlocks, this.numPartitions(), ClassTag$.MODULE$.apply(Tuple2.class)), 4, 4, (long)this.m(), (long)this.n());
            this.intercept((Function0 & Serializable & scala.Serializable)() -> this.gridBasedMat().subtract(C2), ClassTag$.MODULE$.apply(SparkException.class), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
            IndexedSeq sparseBlocks = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable & scala.Serializable)i -> BlockMatrixSuite.$anonfun$new$27(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            IndexedSeq denseBlocks = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable & scala.Serializable)i -> BlockMatrixSuite.$anonfun$new$28(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            BlockMatrix sparseBM = new BlockMatrix(this.sc().makeRDD((Seq)sparseBlocks, 4, ClassTag$.MODULE$.apply(Tuple2.class)), 4, 4, 8L, 8L);
            BlockMatrix denseBM = new BlockMatrix(this.sc().makeRDD((Seq)denseBlocks, 4, ClassTag$.MODULE$.apply(Tuple2.class)), 4, 4, 8L, 8L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(sparseBM.subtract(sparseBM).toBreeze());
            breeze.linalg.DenseMatrix $org_scalatest_assert_macro_right4 = sparseBM.subtract(denseBM).toBreeze();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
        }, new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
        this.test("multiply", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq blocks = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Tuple2.mcII.sp(0, 0), (Object)new DenseMatrix(2, 2, new double[]{1.0, 0.0, 0.0, 1.0})), new Tuple2((Object)new Tuple2.mcII.sp(1, 1), (Object)new DenseMatrix(2, 2, new double[]{1.0, 0.0, 0.0, 1.0}))}));
            RDD rdd = this.sc().parallelize(blocks, 2, ClassTag$.MODULE$.apply(Tuple2.class));
            BlockMatrix B = new BlockMatrix(rdd, this.colPerPart(), this.rowPerPart());
            breeze.linalg.DenseMatrix expected = (breeze.linalg.DenseMatrix)breeze.linalg.DenseMatrix$.MODULE$.apply$mDc$sp((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)3.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)5.0))}), LiteralRow$.MODULE$.tuple4(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
            BlockMatrix AtimesB = this.gridBasedMat().multiply(B);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)AtimesB.numRows()));
            int $org_scalatest_assert_macro_right = this.m();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)AtimesB.numCols()));
            int $org_scalatest_assert_macro_right2 = this.n();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(AtimesB.toBreeze());
            breeze.linalg.DenseMatrix $org_scalatest_assert_macro_right3 = expected;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
            BlockMatrix C = new BlockMatrix(rdd, this.rowPerPart(), this.colPerPart(), (long)(this.m() + 1), (long)this.n());
            this.intercept((Function0 & Serializable & scala.Serializable)() -> this.gridBasedMat().multiply(C), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
            Seq largerBlocks = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Tuple2.mcII.sp(0, 0), (Object)DenseMatrix$.MODULE$.eye(4))}));
            BlockMatrix C2 = new BlockMatrix(this.sc().parallelize(largerBlocks, this.numPartitions(), ClassTag$.MODULE$.apply(Tuple2.class)), 4, 4);
            this.intercept((Function0 & Serializable & scala.Serializable)() -> this.gridBasedMat().multiply(C2), ClassTag$.MODULE$.apply(SparkException.class), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
            Random rand = new Random(42L);
            IndexedSeq largerAblocks = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).map((Function1 & Serializable & scala.Serializable)i -> BlockMatrixSuite.$anonfun$new$32(rand, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            IndexedSeq largerBblocks = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 16).map((Function1 & Serializable & scala.Serializable)i -> BlockMatrixSuite.$anonfun$new$33(rand, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            BlockMatrix largeA = new BlockMatrix(this.sc().parallelize((Seq)largerAblocks, 10, ClassTag$.MODULE$.apply(Tuple2.class)), 6, 4);
            BlockMatrix largeB = new BlockMatrix(this.sc().parallelize((Seq)largerBblocks, 8, ClassTag$.MODULE$.apply(Tuple2.class)), 4, 4);
            DenseMatrix result = largeA.toLocalMatrix().multiply((DenseMatrix)largeB.toLocalMatrix());
            this.testMultiply(largeA, largeB, (Matrix)result, 1);
            this.testMultiply(largeA, largeB, (Matrix)result, 2);
            this.testMultiply(largeA, largeB, (Matrix)result, 3);
            this.testMultiply(largeA, largeB, (Matrix)result, 4);
        }, new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
        this.test("simulate multiply", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq blocks = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Tuple2.mcII.sp(0, 0), (Object)new DenseMatrix(2, 2, new double[]{1.0, 0.0, 0.0, 1.0})), new Tuple2((Object)new Tuple2.mcII.sp(1, 1), (Object)new DenseMatrix(2, 2, new double[]{1.0, 0.0, 0.0, 1.0}))}));
            RDD rdd = this.sc().parallelize(blocks, 2, ClassTag$.MODULE$.apply(Tuple2.class));
            BlockMatrix B = new BlockMatrix(rdd, this.colPerPart(), this.rowPerPart());
            GridPartitioner resultPartitioner = GridPartitioner$.MODULE$.apply(this.gridBasedMat().numRowBlocks(), B.numColBlocks(), package$.MODULE$.max(this.numPartitions(), 2));
            Tuple2 tuple2 = this.gridBasedMat().simulateMultiply(B, resultPartitioner, 1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Map destinationsA = (Map)tuple2._1();
            Map destinationsB = (Map)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)destinationsA, (Object)destinationsB);
            Tuple2 tuple23 = tuple22;
            Map destinationsA2 = (Map)tuple23._1();
            Map destinationsB2 = (Map)tuple23._2();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(destinationsA2.apply((Object)new Tuple2.mcII.sp(0, 0)));
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 332));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(destinationsA2.apply((Object)new Tuple2.mcII.sp(0, 1)));
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(destinationsA2.apply((Object)new Tuple2.mcII.sp(1, 0)));
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(destinationsA2.apply((Object)new Tuple2.mcII.sp(1, 1)));
            Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 335));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(destinationsA2.apply((Object)new Tuple2.mcII.sp(2, 1)));
            Set $org_scalatest_assert_macro_right5 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3}));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(destinationsB2.apply((Object)new Tuple2.mcII.sp(0, 0)));
            Set $org_scalatest_assert_macro_right6 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(destinationsB2.apply((Object)new Tuple2.mcII.sp(1, 1)));
            Set $org_scalatest_assert_macro_right7 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338));
        }, new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
        this.test("validate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.gridBasedMat().validate();
            Seq blocks = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Tuple2.mcII.sp(0, 0), (Object)new DenseMatrix(2, 2, new double[]{1.0, 0.0, 0.0, 2.0})), new Tuple2((Object)new Tuple2.mcII.sp(0, 1), (Object)new DenseMatrix(2, 2, new double[]{0.0, 1.0, 0.0, 0.0})), new Tuple2((Object)new Tuple2.mcII.sp(1, 0), (Object)new DenseMatrix(2, 2, new double[]{3.0, 0.0, 1.0, 1.0})), new Tuple2((Object)new Tuple2.mcII.sp(1, 1), (Object)new DenseMatrix(2, 2, new double[]{1.0, 2.0, 0.0, 1.0})), new Tuple2((Object)new Tuple2.mcII.sp(2, 1), (Object)new DenseMatrix(1, 2, new double[]{1.0, 5.0}))}));
            RDD rdd = this.sc().parallelize(blocks, this.numPartitions(), ClassTag$.MODULE$.apply(Tuple2.class));
            BlockMatrix wrongRowPerParts = new BlockMatrix(rdd, this.rowPerPart() + 1, this.colPerPart());
            BlockMatrix wrongColPerParts = new BlockMatrix(rdd, this.rowPerPart(), this.colPerPart() + 1);
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> wrongRowPerParts.validate(), ClassTag$.MODULE$.apply(SparkException.class), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 354));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> wrongColPerParts.validate(), ClassTag$.MODULE$.apply(SparkException.class), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
            BlockMatrix wrongRowSize = new BlockMatrix(rdd, this.rowPerPart(), this.colPerPart(), 4L, 4L);
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> wrongRowSize.validate(), ClassTag$.MODULE$.apply(AssertionError.class), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362));
            BlockMatrix wrongColSize = new BlockMatrix(rdd, this.rowPerPart(), this.colPerPart(), 5L, 2L);
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> wrongColSize.validate(), ClassTag$.MODULE$.apply(AssertionError.class), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
            Seq duplicateBlocks = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Tuple2.mcII.sp(0, 0), (Object)new DenseMatrix(2, 2, new double[]{1.0, 0.0, 0.0, 2.0})), new Tuple2((Object)new Tuple2.mcII.sp(0, 0), (Object)new DenseMatrix(2, 2, new double[]{0.0, 1.0, 0.0, 0.0})), new Tuple2((Object)new Tuple2.mcII.sp(1, 1), (Object)new DenseMatrix(2, 2, new double[]{3.0, 0.0, 1.0, 1.0})), new Tuple2((Object)new Tuple2.mcII.sp(1, 1), (Object)new DenseMatrix(2, 2, new double[]{1.0, 2.0, 0.0, 1.0})), new Tuple2((Object)new Tuple2.mcII.sp(2, 1), (Object)new DenseMatrix(1, 2, new double[]{1.0, 5.0}))}));
            BlockMatrix dupMatrix = new BlockMatrix(this.sc().parallelize(duplicateBlocks, this.numPartitions(), ClassTag$.MODULE$.apply(Tuple2.class)), 2, 2);
            return (SparkException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> dupMatrix.validate(), ClassTag$.MODULE$.apply(SparkException.class), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 377));
        }, new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 341));
        this.test("transpose", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            breeze.linalg.DenseMatrix expected = (breeze.linalg.DenseMatrix)breeze.linalg.DenseMatrix$.MODULE$.apply$mDc$sp((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)3.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple5((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple5((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple5((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)5.0))}), LiteralRow$.MODULE$.tuple5(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
            BlockMatrix AT = this.gridBasedMat().transpose();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)AT.numRows()));
            long $org_scalatest_assert_macro_right = this.gridBasedMat().numCols();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 390));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)AT.numCols()));
            long $org_scalatest_assert_macro_right2 = this.gridBasedMat().numRows();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(AT.toBreeze());
            breeze.linalg.DenseMatrix $org_scalatest_assert_macro_right3 = expected;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 392));
            this.gridBasedMat().cache();
            BlockMatrix AT2 = this.gridBasedMat().transpose();
            AT2.cache();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(AT2.toBreeze());
            breeze.linalg.DenseMatrix $org_scalatest_assert_macro_right4 = AT.toBreeze();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 398));
            BlockMatrix A = AT2.transpose();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(A.toBreeze());
            breeze.linalg.DenseMatrix $org_scalatest_assert_macro_right5 = this.gridBasedMat().toBreeze();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400));
        }, new Position("BlockMatrixSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
    }
}

