/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.random;

import java.io.Serializable;
import org.apache.commons.math3.special.Gamma;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.random.ExponentialGenerator;
import org.apache.spark.mllib.random.GammaGenerator;
import org.apache.spark.mllib.random.LogNormalGenerator;
import org.apache.spark.mllib.random.PoissonGenerator;
import org.apache.spark.mllib.random.RandomDataGenerator;
import org.apache.spark.mllib.random.StandardNormalGenerator;
import org.apache.spark.mllib.random.UniformGenerator;
import org.apache.spark.mllib.random.WeibullGenerator;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.util.StatCounter;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r3Aa\u0002\u0005\u0001'!)\u0001\u0004\u0001C\u00013!)A\u0004\u0001C\u0001;!)A\u0006\u0001C\u0001[!9Q\u0007AI\u0001\n\u00031\u0004bB!\u0001#\u0003%\tA\u000e\u0005\b\u0005\u0002\t\n\u0011\"\u00017\u0005a\u0011\u0016M\u001c3p[\u0012\u000bG/Y$f]\u0016\u0014\u0018\r^8s'VLG/\u001a\u0006\u0003\u0013)\taA]1oI>l'BA\u0006\r\u0003\u0015iG\u000e\\5c\u0015\tia\"A\u0003ta\u0006\u00148N\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\f\u000e\u00031I!a\u0006\u0007\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\t!\u0004\u0005\u0002\u001c\u00015\t\u0001\"A\u0005ba&\u001c\u0005.Z2lgR\u0011a\u0004\n\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0005+:LG\u000fC\u0003&\u0005\u0001\u0007a%A\u0002hK:\u00042aG\u0014*\u0013\tA\u0003BA\nSC:$w.\u001c#bi\u0006<UM\\3sCR|'\u000f\u0005\u0002 U%\u00111\u0006\t\u0002\u0007\t>,(\r\\3\u0002%\u0011L7\u000f\u001e:jEV$\u0018n\u001c8DQ\u0016\u001c7n\u001d\u000b\u0006=9z\u0013g\r\u0005\u0006K\r\u0001\rA\n\u0005\ba\r\u0001\n\u00111\u0001*\u0003\u0011iW-\u00198\t\u000fI\u001a\u0001\u0013!a\u0001S\u000511\u000f\u001e3eKZDq\u0001N\u0002\u0011\u0002\u0003\u0007\u0011&A\u0004faNLGn\u001c8\u00029\u0011L7\u000f\u001e:jEV$\u0018n\u001c8DQ\u0016\u001c7n\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\tqG\u000b\u0002*q-\n\u0011\b\u0005\u0002;\u007f5\t1H\u0003\u0002={\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0003}\u0001\n!\"\u00198o_R\fG/[8o\u0013\t\u00015HA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fA\u0004Z5tiJL'-\u001e;j_:\u001c\u0005.Z2lg\u0012\"WMZ1vYR$3'\u0001\u000feSN$(/\u001b2vi&|gn\u00115fG.\u001cH\u0005Z3gCVdG\u000f\n\u001b")
public class RandomDataGeneratorSuite
extends SparkFunSuite {
    public void apiChecks(RandomDataGenerator<Object> gen) {
        gen.setSeed(42L);
        IndexedSeq array1 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1000).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToDouble((Object)gen.nextValue()), IndexedSeq$.MODULE$.canBuildFrom());
        gen.setSeed(42L);
        IndexedSeq array2 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1000).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$2 -> BoxesRunTime.unboxToDouble((Object)gen.nextValue()), IndexedSeq$.MODULE$.canBuildFrom());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(array1.equals((Object)array2), "array1.equals(array2)", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
        RandomDataGenerator gen2 = gen.copy();
        gen.setSeed(0L);
        IndexedSeq array3 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1000).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$3 -> BoxesRunTime.unboxToDouble((Object)gen.nextValue()), IndexedSeq$.MODULE$.canBuildFrom());
        gen2.setSeed(1L);
        IndexedSeq array4 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1000).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$4 -> BoxesRunTime.unboxToDouble((Object)gen2.nextValue()), IndexedSeq$.MODULE$.canBuildFrom());
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(array3.equals((Object)array4), "array3.equals(array4)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        gen.setSeed(0L);
        IndexedSeq array5 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1000).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$5 -> BoxesRunTime.unboxToDouble((Object)gen.nextValue()), IndexedSeq$.MODULE$.canBuildFrom());
        gen2.setSeed(0L);
        IndexedSeq array6 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1000).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$6 -> BoxesRunTime.unboxToDouble((Object)gen2.nextValue()), IndexedSeq$.MODULE$.canBuildFrom());
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(array5.equals((Object)array6), "array5.equals(array6)", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
    }

    public void distributionChecks(RandomDataGenerator<Object> gen, double mean, double stddev, double epsilon) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach((Function1 & Serializable & scala.Serializable)seed -> RandomDataGeneratorSuite.$anonfun$distributionChecks$1(this, gen, mean, epsilon, stddev, BoxesRunTime.unboxToInt((Object)seed)));
    }

    public double distributionChecks$default$2() {
        return 0.0;
    }

    public double distributionChecks$default$3() {
        return 1.0;
    }

    public double distributionChecks$default$4() {
        return 0.01;
    }

    public static final /* synthetic */ Assertion $anonfun$distributionChecks$1(RandomDataGeneratorSuite $this, RandomDataGenerator gen$2, double mean$1, double epsilon$1, double stddev$1, int seed) {
        gen$2.setSeed((long)seed);
        IndexedSeq sample = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100000).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$7 -> BoxesRunTime.unboxToDouble((Object)gen$2.nextValue()), IndexedSeq$.MODULE$.canBuildFrom());
        StatCounter stats = new StatCounter((TraversableOnce)sample);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(stats.mean()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(mean$1).absTol(epsilon$1)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(stats.mean).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(mean).absTol(epsilon))", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(stats.stdev()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(stddev$1).absTol(epsilon$1)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(stats.stdev).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(stddev).absTol(epsilon))", Prettifier$.MODULE$.default());
        return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
    }

    public static final /* synthetic */ void $anonfun$new$4(RandomDataGeneratorSuite $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double mean = tuple2._1$mcD$sp();
        double vari = tuple2._2$mcD$sp();
        double d = mean;
        double d2 = vari;
        LogNormalGenerator normal = new LogNormalGenerator(d, package$.MODULE$.sqrt(d2));
        $this.apiChecks((RandomDataGenerator<Object>)normal);
        double expectedMean = package$.MODULE$.exp(d + 0.5 * d2);
        double expectedStd = package$.MODULE$.sqrt(package$.MODULE$.expm1(d2) * package$.MODULE$.exp(2.0 * d + d2));
        double epsilon = 0.05 * expectedStd * expectedStd;
        $this.distributionChecks((RandomDataGenerator<Object>)normal, expectedMean, expectedStd, epsilon);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$10(RandomDataGeneratorSuite $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double shape = tuple2._1$mcD$sp();
        double scale = tuple2._2$mcD$sp();
        double d = shape;
        double d2 = scale;
        GammaGenerator gamma = new GammaGenerator(d, d2);
        $this.apiChecks((RandomDataGenerator<Object>)gamma);
        double expectedMean = d * d2;
        double expectedStd = package$.MODULE$.sqrt(d * d2 * d2);
        $this.distributionChecks((RandomDataGenerator<Object>)gamma, expectedMean, expectedStd, 0.1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$12(RandomDataGeneratorSuite $this, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double alpha = tuple2._1$mcD$sp();
        double beta = tuple2._2$mcD$sp();
        double d = alpha;
        double d2 = beta;
        WeibullGenerator weibull = new WeibullGenerator(d, d2);
        $this.apiChecks((RandomDataGenerator<Object>)weibull);
        double expectedMean = package$.MODULE$.exp(Gamma.logGamma((double)(1.0 + 1.0 / d))) * d2;
        double expectedVariance = package$.MODULE$.exp(Gamma.logGamma((double)(1.0 + (double)2 / d))) * d2 * d2 - expectedMean * expectedMean;
        double expectedStd = package$.MODULE$.sqrt(expectedVariance);
        $this.distributionChecks((RandomDataGenerator<Object>)weibull, expectedMean, expectedStd, 0.1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public RandomDataGeneratorSuite() {
        this.test("UniformGenerator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            UniformGenerator uniform = new UniformGenerator();
            this.apiChecks((RandomDataGenerator<Object>)uniform);
            this.distributionChecks((RandomDataGenerator<Object>)uniform, 0.5, 1.0 / package$.MODULE$.sqrt(12.0), this.distributionChecks$default$4());
        }, new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        this.test("StandardNormalGenerator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StandardNormalGenerator normal = new StandardNormalGenerator();
            this.apiChecks((RandomDataGenerator<Object>)normal);
            this.distributionChecks((RandomDataGenerator<Object>)normal, 0.0, 1.0, this.distributionChecks$default$4());
        }, new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        this.test("LogNormalGenerator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new .colon.colon((Object)new Tuple2.mcDD.sp(0.0, 1.0), (List)new .colon.colon((Object)new Tuple2.mcDD.sp(0.0, 2.0), (List)new .colon.colon((Object)new Tuple2.mcDD.sp(2.0, 1.0), (List)new .colon.colon((Object)new Tuple2.mcDD.sp(2.0, 2.0), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            RandomDataGeneratorSuite.$anonfun$new$4(this, x0$1);
            return BoxedUnit.UNIT;
        }), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        this.test("PoissonGenerator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 5.0, 100.0})).foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)mean -> {
            PoissonGenerator poisson = new PoissonGenerator(mean);
            this.apiChecks((RandomDataGenerator<Object>)poisson);
            this.distributionChecks((RandomDataGenerator<Object>)poisson, mean, package$.MODULE$.sqrt(mean), 0.1);
        }), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        this.test("ExponentialGenerator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 5.0, 10.0, 50.0, 100.0})).foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)mean -> {
            ExponentialGenerator exponential = new ExponentialGenerator(mean);
            this.apiChecks((RandomDataGenerator<Object>)exponential);
            double epsilon = 0.05 * mean * mean;
            this.distributionChecks((RandomDataGenerator<Object>)exponential, mean, mean, epsilon);
        }), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        this.test("GammaGenerator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new .colon.colon((Object)new Tuple2.mcDD.sp(1.0, 2.0), (List)new .colon.colon((Object)new Tuple2.mcDD.sp(2.0, 2.0), (List)new .colon.colon((Object)new Tuple2.mcDD.sp(3.0, 2.0), (List)new .colon.colon((Object)new Tuple2.mcDD.sp(5.0, 1.0), (List)new .colon.colon((Object)new Tuple2.mcDD.sp(9.0, 0.5), (List)Nil$.MODULE$))))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            RandomDataGeneratorSuite.$anonfun$new$10(this, x0$2);
            return BoxedUnit.UNIT;
        }), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
        this.test("WeibullGenerator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new .colon.colon((Object)new Tuple2.mcDD.sp(1.0, 2.0), (List)new .colon.colon((Object)new Tuple2.mcDD.sp(2.0, 3.0), (List)new .colon.colon((Object)new Tuple2.mcDD.sp(2.5, 3.5), (List)new .colon.colon((Object)new Tuple2.mcDD.sp(10.4, 2.222), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            RandomDataGeneratorSuite.$anonfun$new$12(this, x0$3);
            return BoxedUnit.UNIT;
        }), new Position("RandomDataGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
    }
}

