/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.SharedSparkSession;
import org.apache.spark.api.java.JavaDoubleRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.regression.IsotonicRegression;
import org.apache.spark.mllib.regression.IsotonicRegressionModel;
import org.junit.Assert;
import org.junit.Test;
import scala.Tuple3;

public class JavaIsotonicRegressionSuite
extends SharedSparkSession {
    private static List<Tuple3<Double, Double, Double>> generateIsotonicInput(double[] labels) {
        ArrayList<Tuple3<Double, Double, Double>> input = new ArrayList<Tuple3<Double, Double, Double>>(labels.length);
        for (int i = 1; i <= labels.length; ++i) {
            input.add((Tuple3<Double, Double, Double>)new Tuple3((Object)labels[i - 1], (Object)i, (Object)1.0));
        }
        return input;
    }

    private IsotonicRegressionModel runIsotonicRegression(double[] labels) {
        JavaRDD trainRDD = this.jsc.parallelize(JavaIsotonicRegressionSuite.generateIsotonicInput(labels), 2).cache();
        return new IsotonicRegression().run(trainRDD);
    }

    @Test
    public void testIsotonicRegressionJavaRDD() {
        IsotonicRegressionModel model = this.runIsotonicRegression(new double[]{1.0, 2.0, 3.0, 3.0, 1.0, 6.0, 7.0, 8.0, 11.0, 9.0, 10.0, 12.0});
        Assert.assertArrayEquals((double[])new double[]{1.0, 2.0, 2.3333333333333335, 2.3333333333333335, 6.0, 7.0, 8.0, 10.0, 10.0, 12.0}, (double[])model.predictions(), (double)1.0E-14);
    }

    @Test
    public void testIsotonicRegressionPredictionsJavaRDD() {
        IsotonicRegressionModel model = this.runIsotonicRegression(new double[]{1.0, 2.0, 3.0, 3.0, 1.0, 6.0, 7.0, 8.0, 11.0, 9.0, 10.0, 12.0});
        JavaDoubleRDD testRDD = this.jsc.parallelizeDoubles(Arrays.asList(0.0, 1.0, 9.5, 12.0, 13.0));
        List predictions = model.predict(testRDD).collect();
        Assert.assertEquals((double)1.0, (double)((Double)predictions.get(0)), (double)1.0E-14);
        Assert.assertEquals((double)1.0, (double)((Double)predictions.get(1)), (double)1.0E-14);
        Assert.assertEquals((double)10.0, (double)((Double)predictions.get(2)), (double)1.0E-14);
        Assert.assertEquals((double)12.0, (double)((Double)predictions.get(3)), (double)1.0E-14);
        Assert.assertEquals((double)12.0, (double)((Double)predictions.get(4)), (double)1.0E-14);
    }
}

