/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat;

import java.io.File;
import java.io.Serializable;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.stat.KernelDensity;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001u1AAA\u0002\u0001\u001d!)\u0011\u0004\u0001C\u00015\t\u00112*\u001a:oK2$UM\\:jif\u001cV/\u001b;f\u0015\t!Q!\u0001\u0003ti\u0006$(B\u0001\u0004\b\u0003\u0015iG\u000e\\5c\u0015\tA\u0011\"A\u0003ta\u0006\u00148N\u0003\u0002\u000b\u0017\u00051\u0011\r]1dQ\u0016T\u0011\u0001D\u0001\u0004_J<7\u0001A\n\u0004\u0001=\u0019\u0002C\u0001\t\u0012\u001b\u00059\u0011B\u0001\n\b\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011AcF\u0007\u0002+)\u0011a#B\u0001\u0005kRLG.\u0003\u0002\u0019+\t)R\n\u00147jER+7\u000f^*qCJ\\7i\u001c8uKb$\u0018A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0004\u0001")
public class KernelDensitySuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private final void testImplicits$lzycompute$1() {
        KernelDensitySuite kernelDensitySuite = this;
        synchronized (kernelDensitySuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public KernelDensitySuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("kernel density single sample", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkContext qual$1 = this.sc();
            WrappedArray x$1 = Predef$.MODULE$.wrapDoubleArray(new double[]{5.0});
            int x$2 = qual$1.parallelize$default$2();
            RDD rdd = qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.Double());
            double[] evaluationPoints = new double[]{5.0, 6.0};
            double[] densities = new KernelDensity().setSample(rdd).setBandwidth(3.0).estimate(evaluationPoints);
            NormalDistribution normal = new NormalDistribution(5.0, 3.0);
            double acceptableErr = 1.0E-6;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(densities[0]).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(normal.density(5.0)).absTol(acceptableErr)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(densities.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(normal.density(5.0)).absTol(acceptableErr))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KernelDensitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(densities[1]).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(normal.density(6.0)).absTol(acceptableErr)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(densities.apply(1)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(normal.density(6.0)).absTol(acceptableErr))", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KernelDensitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
        }, new Position("KernelDensitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 27));
        this.test("kernel density multiple samples", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkContext qual$2 = this.sc();
            WrappedArray x$3 = Predef$.MODULE$.wrapDoubleArray(new double[]{5.0, 10.0});
            int x$4 = qual$2.parallelize$default$2();
            RDD rdd = qual$2.parallelize((Seq)x$3, x$4, ClassTag$.MODULE$.Double());
            double[] evaluationPoints = new double[]{5.0, 6.0};
            double[] densities = new KernelDensity().setSample(rdd).setBandwidth(3.0).estimate(evaluationPoints);
            NormalDistribution normal1 = new NormalDistribution(5.0, 3.0);
            NormalDistribution normal2 = new NormalDistribution(10.0, 3.0);
            double acceptableErr = 1.0E-6;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(densities[0]).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals((normal1.density(5.0) + normal2.density(5.0)) / (double)2).absTol(acceptableErr)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(densities.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(normal1.density(5.0).+(normal2.density(5.0))./(2)).absTol(acceptableErr))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KernelDensitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(densities[1]).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals((normal1.density(6.0) + normal2.density(6.0)) / (double)2).absTol(acceptableErr)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(densities.apply(1)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(normal1.density(6.0).+(normal2.density(6.0))./(2)).absTol(acceptableErr))", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KernelDensitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        }, new Position("KernelDensitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
    }
}

