/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.tree.impl.DecisionTreeMetadata;
import org.apache.spark.ml.tree.impl.DecisionTreeMetadata$;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.DecisionTree$;
import org.apache.spark.mllib.tree.DecisionTreeSuite$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.FeatureType$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.configuration.Strategy$;
import org.apache.spark.mllib.tree.impurity.Entropy$;
import org.apache.spark.mllib.tree.impurity.Gini$;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.impurity.Variance$;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.DecisionTreeModel$;
import org.apache.spark.mllib.tree.model.InformationGainStats;
import org.apache.spark.mllib.tree.model.Node;
import org.apache.spark.mllib.tree.model.Split;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\f\u0019\u0001\rBQA\f\u0001\u0005\u0002=:QA\r\r\t\u0002M2Qa\u0006\r\t\u0002QBQAL\u0002\u0005\u0002UBQAN\u0002\u0005\u0002]BQAX\u0002\u0005\u0002}CQ\u0001Z\u0002\u0005\u0002\u0015DQ![\u0002\u0005\u0002\u0015DQA[\u0002\u0005\u0002\u0015DQa[\u0002\u0005\u0002\u0015DQ\u0001\\\u0002\u0005\u00025DQ!^\u0002\u0005\u0002\u0015DQA^\u0002\u0005\u0002\u0015DQa^\u0002\u0005\u0002\u0015DQ\u0001_\u0002\u0005\neDq!!\u0002\u0004\t\u0013\t9\u0001\u0003\u0005\u0002B\r!\t\u0001HA\"\u0011%\t9f\u0001b\u0001\n\u0013\tI\u0006\u0003\u0005\u0002^\r\u0001\u000b\u0011BA.\u0011!\tyf\u0001C\u00015\u0005\u0005\u0004bBA0\u0007\u0011%\u00111\u000e\u0005\n\u0003c\u001a\u0011\u0011!C\u0005\u0003g\u0012\u0011\u0003R3dSNLwN\u001c+sK\u0016\u001cV/\u001b;f\u0015\tI\"$\u0001\u0003ue\u0016,'BA\u000e\u001d\u0003\u0015iG\u000e\\5c\u0015\tib$A\u0003ta\u0006\u00148N\u0003\u0002 A\u00051\u0011\r]1dQ\u0016T\u0011!I\u0001\u0004_J<7\u0001A\n\u0004\u0001\u0011B\u0003CA\u0013'\u001b\u0005a\u0012BA\u0014\u001d\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011\u0011\u0006L\u0007\u0002U)\u00111FG\u0001\u0005kRLG.\u0003\u0002.U\t)R\n\u00147jER+7\u000f^*qCJ\\7i\u001c8uKb$\u0018A\u0002\u001fj]&$h\bF\u00011!\t\t\u0004!D\u0001\u0019\u0003E!UmY5tS>tGK]3f'VLG/\u001a\t\u0003c\r\u0019\"a\u0001\u0013\u0015\u0003M\n!C^1mS\u0012\fG/Z\"mCN\u001c\u0018NZ5feR!\u0001HP#Z!\tID(D\u0001;\u0015\u0005Y\u0014!B:dC2\f\u0017BA\u001f;\u0005\u0011)f.\u001b;\t\u000b}*\u0001\u0019\u0001!\u0002\u000b5|G-\u001a7\u0011\u0005\u0005\u001bU\"\u0001\"\u000b\u0005}B\u0012B\u0001#C\u0005E!UmY5tS>tGK]3f\u001b>$W\r\u001c\u0005\u0006\r\u0016\u0001\raR\u0001\u0006S:\u0004X\u000f\u001e\t\u0004\u0011B\u001bfBA%O\u001d\tQU*D\u0001L\u0015\ta%%\u0001\u0004=e>|GOP\u0005\u0002w%\u0011qJO\u0001\ba\u0006\u001c7.Y4f\u0013\t\t&KA\u0002TKFT!a\u0014\u001e\u0011\u0005Q;V\"A+\u000b\u0005YS\u0012A\u0003:fOJ,7o]5p]&\u0011\u0001,\u0016\u0002\r\u0019\u0006\u0014W\r\\3e!>Lg\u000e\u001e\u0005\u00065\u0016\u0001\raW\u0001\u0011e\u0016\fX/\u001b:fI\u0006\u001b7-\u001e:bGf\u0004\"!\u000f/\n\u0005uS$A\u0002#pk\ndW-A\twC2LG-\u0019;f%\u0016<'/Z:t_J$B\u0001\u000f1bE\")qH\u0002a\u0001\u0001\")aI\u0002a\u0001\u000f\")1M\u0002a\u00017\u0006Y!/Z9vSJ,G-T*F\u0003\u0019:WM\\3sCR,wJ\u001d3fe\u0016$G*\u00192fY\u0016$\u0007k\\5oiN<\u0016\u000e\u001e5MC\n,G\u000e\r\u000b\u0002MB\u0019\u0011hZ*\n\u0005!T$!B!se\u0006L\u0018AJ4f]\u0016\u0014\u0018\r^3Pe\u0012,'/\u001a3MC\n,G.\u001a3Q_&tGo],ji\"d\u0015MY3mc\u0005ar-\u001a8fe\u0006$Xm\u0014:eKJ,G\rT1cK2,G\rU8j]R\u001c\u0018!H4f]\u0016\u0014\u0018\r^3DCR,wm\u001c:jG\u0006dG)\u0019;b!>Lg\u000e^:\u0002O\u001d,g.\u001a:bi\u0016\u001c\u0015\r^3h_JL7-\u00197ECR\f\u0007k\\5oiN\f5OS1wC2K7\u000f\u001e\u000b\u0002]B\u0019qn]*\u000e\u0003AT!aK9\u000b\u0003I\fAA[1wC&\u0011A\u000f\u001d\u0002\u0005\u0019&\u001cH/\u0001\u0016hK:,'/\u0019;f\u0007\u0006$XmZ8sS\u000e\fG\u000eR1uCB{\u0017N\u001c;t\r>\u0014X*\u001e7uS\u000ed\u0017m]:\u0002S\u001d,g.\u001a:bi\u0016\u001cuN\u001c;j]V|Wo\u001d#bi\u0006\u0004v.\u001b8ug\u001a{'/T;mi&\u001cG.Y:t\u0003q:WM\\3sCR,7)\u0019;fO>\u0014\u0018nY1m\t\u0006$\u0018\rU8j]R\u001chi\u001c:Nk2$\u0018n\u00197bgN4uN](sI\u0016\u0014X\r\u001a$fCR,(/Z:\u0002\u001d\r\u0014X-\u0019;f\u0019\u0016\fgMT8eKR\u0011!0 \t\u0003\u0003nL!\u0001 \"\u0003\t9{G-\u001a\u0005\u0006}>\u0001\ra`\u0001\u0003S\u0012\u00042!OA\u0001\u0013\r\t\u0019A\u000f\u0002\u0004\u0013:$\u0018AE2sK\u0006$X-\u00138uKJt\u0017\r\u001c(pI\u0016$\u0012B_A\u0005\u0003\u0017\tI$!\u0010\t\u000by\u0004\u0002\u0019A@\t\u000f\u00055\u0001\u00031\u0001\u0002\u0010\u0005Ya-Z1ukJ,G+\u001f9f!\u0011\t\t\"a\r\u000f\t\u0005M\u0011Q\u0006\b\u0005\u0003+\tIC\u0004\u0003\u0002\u0018\u0005\u001db\u0002BA\r\u0003KqA!a\u0007\u0002$9!\u0011QDA\u0011\u001d\rQ\u0015qD\u0005\u0002C%\u0011q\u0004I\u0005\u0003;yI!a\u0007\u000f\n\u0005eQ\u0012bAA\u00161\u0005i1m\u001c8gS\u001e,(/\u0019;j_:LA!a\f\u00022\u0005Ya)Z1ukJ,G+\u001f9f\u0015\r\tY\u0003G\u0005\u0005\u0003k\t9DA\u0006GK\u0006$XO]3UsB,'\u0002BA\u0018\u0003cAa!a\u000f\u0011\u0001\u0004Q\u0018\u0001\u00027fMRDa!a\u0010\u0011\u0001\u0004Q\u0018!\u0002:jO\"$\u0018aC2sK\u0006$X-T8eK2$2\u0001QA#\u0011\u001d\t9%\u0005a\u0001\u0003\u0013\nA!\u00197h_B!\u00111JA)\u001d\u0011\t\u0019\"!\u0014\n\t\u0005=\u0013\u0011G\u0001\u0005\u00032<w.\u0003\u0003\u0002T\u0005U#\u0001B!mO>TA!a\u0014\u00022\u0005\u00192M]3bi\u0016$Wj\u001c3fY:{G-Z%egV\u0011\u00111\f\t\u0004s\u001d|\u0018\u0001F2sK\u0006$X\rZ'pI\u0016dgj\u001c3f\u0013\u0012\u001c\b%\u0001\u0006dQ\u0016\u001c7.R9vC2$R\u0001OA2\u0003OBa!!\u001a\u0015\u0001\u0004\u0001\u0015!A1\t\r\u0005%D\u00031\u0001A\u0003\u0005\u0011G#\u0002\u001d\u0002n\u0005=\u0004BBA3+\u0001\u0007!\u0010\u0003\u0004\u0002jU\u0001\rA_\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002vA!\u0011qOA?\u001b\t\tIHC\u0002\u0002|E\fA\u0001\\1oO&!\u0011qPA=\u0005\u0019y%M[3di\u0002")
public class DecisionTreeSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static LabeledPoint[] generateCategoricalDataPointsForMulticlassForOrderedFeatures() {
        return DecisionTreeSuite$.MODULE$.generateCategoricalDataPointsForMulticlassForOrderedFeatures();
    }

    public static LabeledPoint[] generateContinuousDataPointsForMulticlass() {
        return DecisionTreeSuite$.MODULE$.generateContinuousDataPointsForMulticlass();
    }

    public static LabeledPoint[] generateCategoricalDataPointsForMulticlass() {
        return DecisionTreeSuite$.MODULE$.generateCategoricalDataPointsForMulticlass();
    }

    public static java.util.List<LabeledPoint> generateCategoricalDataPointsAsJavaList() {
        return DecisionTreeSuite$.MODULE$.generateCategoricalDataPointsAsJavaList();
    }

    public static LabeledPoint[] generateCategoricalDataPoints() {
        return DecisionTreeSuite$.MODULE$.generateCategoricalDataPoints();
    }

    public static LabeledPoint[] generateOrderedLabeledPoints() {
        return DecisionTreeSuite$.MODULE$.generateOrderedLabeledPoints();
    }

    public static LabeledPoint[] generateOrderedLabeledPointsWithLabel1() {
        return DecisionTreeSuite$.MODULE$.generateOrderedLabeledPointsWithLabel1();
    }

    public static LabeledPoint[] generateOrderedLabeledPointsWithLabel0() {
        return DecisionTreeSuite$.MODULE$.generateOrderedLabeledPointsWithLabel0();
    }

    public static void validateRegressor(DecisionTreeModel decisionTreeModel, Seq<LabeledPoint> seq, double d) {
        DecisionTreeSuite$.MODULE$.validateRegressor(decisionTreeModel, seq, d);
    }

    public static void validateClassifier(DecisionTreeModel decisionTreeModel, Seq<LabeledPoint> seq, double d) {
        DecisionTreeSuite$.MODULE$.validateClassifier(decisionTreeModel, seq, d);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private final void testImplicits$lzycompute$1() {
        DecisionTreeSuite decisionTreeSuite = this;
        synchronized (decisionTreeSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ Assertion $anonfun$new$28(DecisionTreeSuite $this, double predict) {
        double $org_scalatest_assert_macro_left = predict;
        double $org_scalatest_assert_macro_right = 0.0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353));
    }

    public static final /* synthetic */ Assertion $anonfun$new$32(DecisionTreeSuite $this, double predict) {
        double $org_scalatest_assert_macro_left = predict;
        double $org_scalatest_assert_macro_right = 0.0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400));
    }

    public static final /* synthetic */ void $anonfun$new$36(DecisionTreeSuite $this, String path$1, File tempDir$1, Enumeration.Value algo) {
        DecisionTreeModel model = DecisionTreeSuite$.MODULE$.createModel(algo);
        try {
            model.save($this.sc(), path$1);
            DecisionTreeModel sameModel = DecisionTreeModel$.MODULE$.load($this.sc(), path$1);
            DecisionTreeSuite$.MODULE$.checkEqual(model, sameModel);
        }
        finally {
            Utils$.MODULE$.deleteRecursively(tempDir$1);
        }
    }

    public DecisionTreeSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("Binary classification stump with ordered categorical features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateCategoricalDataPoints();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
            int $org_scalatest_assert_macro_right = 1000;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
            SparkContext qual$1 = this.sc();
            WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$2 = qual$1.parallelize$default$2();
            RDD rdd = qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.apply(LabeledPoint.class));
            Enumeration.Value x$3 = Algo$.MODULE$.Classification();
            Gini$ x$4 = Gini$.MODULE$;
            int x$5 = 2;
            int x$6 = 2;
            int x$7 = 100;
            Map x$8 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)3))}));
            Enumeration.Value x$9 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$10 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$11 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$12 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$13 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$14 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$15 = Strategy$.MODULE$.$lessinit$greater$default$13();
            double x$16 = Strategy$.MODULE$.$lessinit$greater$default$14();
            boolean x$17 = Strategy$.MODULE$.$lessinit$greater$default$15();
            Strategy strategy = new Strategy(x$3, (Impurity)x$4, x$6, x$5, x$7, x$9, x$8, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17);
            Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
            Split split = (Split)rootNode.split().get();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(split.categories());
            List $org_scalatest_assert_macro_right2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(split.featureType());
            Enumeration.Value $org_scalatest_assert_macro_right3 = FeatureType$.MODULE$.Categorical();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
            InformationGainStats stats = (InformationGainStats)rootNode.stats().get();
            double $org_scalatest_assert_macro_left4 = stats.gain();
            int $org_scalatest_assert_macro_right4 = 0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 > (double)$org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)rootNode.predict().predict()));
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            double $org_scalatest_assert_macro_left6 = stats.impurity();
            double $org_scalatest_assert_macro_right6 = 0.2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left6), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 > $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        this.test("Regression stump with 3-ary (ordered) categorical features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateCategoricalDataPoints();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
            int $org_scalatest_assert_macro_right = 1000;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            SparkContext qual$2 = this.sc();
            WrappedArray x$18 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$19 = qual$2.parallelize$default$2();
            RDD rdd = qual$2.parallelize((Seq)x$18, x$19, ClassTag$.MODULE$.apply(LabeledPoint.class));
            Enumeration.Value x$20 = Algo$.MODULE$.Regression();
            Variance$ x$21 = Variance$.MODULE$;
            int x$22 = 2;
            int x$23 = 100;
            Map x$24 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)3))}));
            int x$25 = Strategy$.MODULE$.$lessinit$greater$default$4();
            Enumeration.Value x$26 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$27 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$28 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$29 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$30 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$31 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$32 = Strategy$.MODULE$.$lessinit$greater$default$13();
            double x$33 = Strategy$.MODULE$.$lessinit$greater$default$14();
            boolean x$34 = Strategy$.MODULE$.$lessinit$greater$default$15();
            Strategy strategy = new Strategy(x$20, (Impurity)x$21, x$22, x$25, x$23, x$26, x$24, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34);
            DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.asML().toInstance(), ClassTag$.MODULE$.apply(Instance.class)), strategy);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
            Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
            Split split = (Split)rootNode.split().get();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.categories().length()));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            List $org_scalatest_assert_macro_left3 = split.categories();
            double $org_scalatest_assert_macro_right3 = 1.0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.contains((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3)), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(split.featureType());
            Enumeration.Value $org_scalatest_assert_macro_right4 = FeatureType$.MODULE$.Categorical();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            InformationGainStats stats = (InformationGainStats)rootNode.stats().get();
            double $org_scalatest_assert_macro_left5 = stats.gain();
            int $org_scalatest_assert_macro_right5 = 0;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left5), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 > (double)$org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)rootNode.predict().predict()));
            double $org_scalatest_assert_macro_right6 = 0.6;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            double $org_scalatest_assert_macro_left7 = stats.impurity();
            double $org_scalatest_assert_macro_right7 = 0.2;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left7), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 > $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.test("Regression stump with binary (ordered) categorical features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateCategoricalDataPoints();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
            int $org_scalatest_assert_macro_right = 1000;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            SparkContext qual$3 = this.sc();
            WrappedArray x$35 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$36 = qual$3.parallelize$default$2();
            RDD rdd = qual$3.parallelize((Seq)x$35, x$36, ClassTag$.MODULE$.apply(LabeledPoint.class));
            Enumeration.Value x$37 = Algo$.MODULE$.Regression();
            Variance$ x$38 = Variance$.MODULE$;
            int x$39 = 2;
            int x$40 = 100;
            Map x$41 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)2))}));
            int x$42 = Strategy$.MODULE$.$lessinit$greater$default$4();
            Enumeration.Value x$43 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$44 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$45 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$46 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$47 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$48 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$49 = Strategy$.MODULE$.$lessinit$greater$default$13();
            double x$50 = Strategy$.MODULE$.$lessinit$greater$default$14();
            boolean x$51 = Strategy$.MODULE$.$lessinit$greater$default$15();
            Strategy strategy = new Strategy(x$37, (Impurity)x$38, x$39, x$42, x$40, x$43, x$41, x$44, x$45, x$46, x$47, x$48, x$49, x$50, x$51);
            DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.asML().toInstance(), ClassTag$.MODULE$.apply(Instance.class)), strategy);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            DecisionTreeModel model = DecisionTree$.MODULE$.train(rdd, strategy);
            DecisionTreeSuite$.MODULE$.validateRegressor(model, (Seq<LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 0.0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.numNodes()));
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.depth()));
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        this.test("Binary classification stump with fixed label 0 for Gini", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateOrderedLabeledPointsWithLabel0();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
            int $org_scalatest_assert_macro_right = 1000;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
            SparkContext qual$4 = this.sc();
            WrappedArray x$52 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$53 = qual$4.parallelize$default$2();
            RDD rdd = qual$4.parallelize((Seq)x$52, x$53, ClassTag$.MODULE$.apply(LabeledPoint.class));
            Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Gini$.MODULE$, 3, 2, 100, Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13(), Strategy$.MODULE$.$lessinit$greater$default$14(), Strategy$.MODULE$.$lessinit$greater$default$15());
            DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.asML().toInstance(), ClassTag$.MODULE$.apply(Instance.class)), strategy);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
            Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)rootNode.impurity()));
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
            Option $org_scalatest_assert_macro_left3 = rootNode.stats();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)rootNode.predict().predict()));
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        this.test("Binary classification stump with fixed label 1 for Gini", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateOrderedLabeledPointsWithLabel1();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
            int $org_scalatest_assert_macro_right = 1000;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
            SparkContext qual$5 = this.sc();
            WrappedArray x$54 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$55 = qual$5.parallelize$default$2();
            RDD rdd = qual$5.parallelize((Seq)x$54, x$55, ClassTag$.MODULE$.apply(LabeledPoint.class));
            Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Gini$.MODULE$, 3, 2, 100, Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13(), Strategy$.MODULE$.$lessinit$greater$default$14(), Strategy$.MODULE$.$lessinit$greater$default$15());
            DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.asML().toInstance(), ClassTag$.MODULE$.apply(Instance.class)), strategy);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
            Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)rootNode.impurity()));
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
            Option $org_scalatest_assert_macro_left3 = rootNode.stats();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)rootNode.predict().predict()));
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        this.test("Binary classification stump with fixed label 0 for Entropy", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateOrderedLabeledPointsWithLabel0();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
            int $org_scalatest_assert_macro_right = 1000;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
            SparkContext qual$6 = this.sc();
            WrappedArray x$56 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$57 = qual$6.parallelize$default$2();
            RDD rdd = qual$6.parallelize((Seq)x$56, x$57, ClassTag$.MODULE$.apply(LabeledPoint.class));
            Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Entropy$.MODULE$, 3, 2, 100, Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13(), Strategy$.MODULE$.$lessinit$greater$default$14(), Strategy$.MODULE$.$lessinit$greater$default$15());
            DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.asML().toInstance(), ClassTag$.MODULE$.apply(Instance.class)), strategy);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
            Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)rootNode.impurity()));
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
            Option $org_scalatest_assert_macro_left3 = rootNode.stats();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)rootNode.predict().predict()));
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
        this.test("Binary classification stump with fixed label 1 for Entropy", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateOrderedLabeledPointsWithLabel1();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
            int $org_scalatest_assert_macro_right = 1000;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
            SparkContext qual$7 = this.sc();
            WrappedArray x$58 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$59 = qual$7.parallelize$default$2();
            RDD rdd = qual$7.parallelize((Seq)x$58, x$59, ClassTag$.MODULE$.apply(LabeledPoint.class));
            Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Entropy$.MODULE$, 3, 2, 100, Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13(), Strategy$.MODULE$.$lessinit$greater$default$14(), Strategy$.MODULE$.$lessinit$greater$default$15());
            DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.asML().toInstance(), ClassTag$.MODULE$.apply(Instance.class)), strategy);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
            Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)rootNode.impurity()));
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
            Option $org_scalatest_assert_macro_left3 = rootNode.stats();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)rootNode.predict().predict()));
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
        this.test("Multiclass classification stump with 3-ary (unordered) categorical features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateCategoricalDataPointsForMulticlass();
            SparkContext qual$8 = this.sc();
            WrappedArray x$60 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$61 = qual$8.parallelize$default$2();
            RDD rdd = qual$8.parallelize((Seq)x$60, x$61, ClassTag$.MODULE$.apply(LabeledPoint.class));
            Enumeration.Value x$62 = Algo$.MODULE$.Classification();
            Gini$ x$63 = Gini$.MODULE$;
            int x$64 = 4;
            int x$65 = 3;
            Map x$66 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)3))}));
            int x$67 = Strategy$.MODULE$.$lessinit$greater$default$5();
            Enumeration.Value x$68 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$69 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$70 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$71 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$72 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$73 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$74 = Strategy$.MODULE$.$lessinit$greater$default$13();
            double x$75 = Strategy$.MODULE$.$lessinit$greater$default$14();
            boolean x$76 = Strategy$.MODULE$.$lessinit$greater$default$15();
            Strategy strategy = new Strategy(x$62, (Impurity)x$63, x$64, x$65, x$67, x$68, x$66, x$69, x$70, x$71, x$72, x$73, x$74, x$75, x$76);
            DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.asML().toInstance(), ClassTag$.MODULE$.apply(Instance.class)), strategy);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(strategy.isMulticlassClassification(), "strategy.isMulticlassClassification", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
            Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
            Split split = (Split)rootNode.split().get();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.feature()));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.categories().length()));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
            List $org_scalatest_assert_macro_left3 = split.categories();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3)), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(split.featureType());
            Enumeration.Value $org_scalatest_assert_macro_right4 = FeatureType$.MODULE$.Categorical();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
        this.test("Binary classification stump with 1 continuous feature, to check off-by-1 error", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LabeledPoint[] arr = (LabeledPoint[])((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(3.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])))});
            SparkContext qual$9 = this.sc();
            WrappedArray x$77 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$78 = qual$9.parallelize$default$2();
            RDD rdd = qual$9.parallelize((Seq)x$77, x$78, ClassTag$.MODULE$.apply(LabeledPoint.class));
            Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Gini$.MODULE$, 4, 2, Strategy$.MODULE$.$lessinit$greater$default$5(), Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13(), Strategy$.MODULE$.$lessinit$greater$default$14(), Strategy$.MODULE$.$lessinit$greater$default$15());
            DecisionTreeModel model = DecisionTree$.MODULE$.train(rdd, strategy);
            DecisionTreeSuite$.MODULE$.validateClassifier(model, (Seq<LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 1.0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.numNodes()));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.depth()));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
        this.test("Binary classification stump with 2 continuous features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LabeledPoint[] arr = (LabeledPoint[])((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 0.0)})))), new LabeledPoint(1.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 1.0)})))), new LabeledPoint(0.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 0.0)})))), new LabeledPoint(1.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 2.0)}))))});
            SparkContext qual$10 = this.sc();
            WrappedArray x$79 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$80 = qual$10.parallelize$default$2();
            RDD rdd = qual$10.parallelize((Seq)x$79, x$80, ClassTag$.MODULE$.apply(LabeledPoint.class));
            Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Gini$.MODULE$, 4, 2, Strategy$.MODULE$.$lessinit$greater$default$5(), Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13(), Strategy$.MODULE$.$lessinit$greater$default$14(), Strategy$.MODULE$.$lessinit$greater$default$15());
            DecisionTreeModel model = DecisionTree$.MODULE$.train(rdd, strategy);
            DecisionTreeSuite$.MODULE$.validateClassifier(model, (Seq<LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 1.0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.numNodes()));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.depth()));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Split)model.topNode().split().get()).feature()));
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
        this.test("Multiclass classification stump with unordered categorical features, with just enough bins", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int maxBins = 2 * ((int)package$.MODULE$.pow(2.0, 2.0) - 1);
            LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateCategoricalDataPointsForMulticlass();
            SparkContext qual$11 = this.sc();
            WrappedArray x$81 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$82 = qual$11.parallelize$default$2();
            RDD rdd = qual$11.parallelize((Seq)x$81, x$82, ClassTag$.MODULE$.apply(LabeledPoint.class));
            Enumeration.Value x$83 = Algo$.MODULE$.Classification();
            Gini$ x$84 = Gini$.MODULE$;
            int x$85 = 4;
            int x$86 = 3;
            int x$87 = maxBins;
            Map x$88 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)3))}));
            Enumeration.Value x$89 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$90 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$91 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$92 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$93 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$94 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$95 = Strategy$.MODULE$.$lessinit$greater$default$13();
            double x$96 = Strategy$.MODULE$.$lessinit$greater$default$14();
            boolean x$97 = Strategy$.MODULE$.$lessinit$greater$default$15();
            Strategy strategy = new Strategy(x$83, (Impurity)x$84, x$85, x$86, x$87, x$89, x$88, x$90, x$91, x$92, x$93, x$94, x$95, x$96, x$97);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(strategy.isMulticlassClassification(), "strategy.isMulticlassClassification", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
            DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.asML().toInstance(), ClassTag$.MODULE$.apply(Instance.class)), strategy);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
            DecisionTreeModel model = DecisionTree$.MODULE$.train(rdd, strategy);
            DecisionTreeSuite$.MODULE$.validateClassifier(model, (Seq<LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 1.0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.numNodes()));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.depth()));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
            Node rootNode = model.topNode();
            Split split = (Split)rootNode.split().get();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.feature()));
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.categories().length()));
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
            List $org_scalatest_assert_macro_left5 = split.categories();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5)), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(split.featureType());
            Enumeration.Value $org_scalatest_assert_macro_right6 = FeatureType$.MODULE$.Categorical();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
            InformationGainStats gain = (InformationGainStats)rootNode.stats().get();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)gain.leftImpurity()));
            int $org_scalatest_assert_macro_right7 = 0;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)gain.rightImpurity()));
            int $org_scalatest_assert_macro_right8 = 0;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
        this.test("Multiclass classification stump with continuous features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateContinuousDataPointsForMulticlass();
            SparkContext qual$12 = this.sc();
            WrappedArray x$98 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$99 = qual$12.parallelize$default$2();
            RDD rdd = qual$12.parallelize((Seq)x$98, x$99, ClassTag$.MODULE$.apply(LabeledPoint.class));
            Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Gini$.MODULE$, 4, 3, 100, Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13(), Strategy$.MODULE$.$lessinit$greater$default$14(), Strategy$.MODULE$.$lessinit$greater$default$15());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(strategy.isMulticlassClassification(), "strategy.isMulticlassClassification", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
            DecisionTreeModel model = DecisionTree$.MODULE$.train(rdd, strategy);
            DecisionTreeSuite$.MODULE$.validateClassifier(model, (Seq<LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 0.9);
            Node rootNode = model.topNode();
            Split split = (Split)rootNode.split().get();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.feature()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(split.featureType());
            Enumeration.Value $org_scalatest_assert_macro_right2 = FeatureType$.MODULE$.Continuous();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
            double $org_scalatest_assert_macro_left3 = split.threshold();
            int $org_scalatest_assert_macro_right3 = 1980;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 > (double)$org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280));
            double $org_scalatest_assert_macro_left4 = split.threshold();
            int $org_scalatest_assert_macro_right4 = 2020;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 < (double)$org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
        this.test("Multiclass classification stump with continuous + unordered categorical features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateContinuousDataPointsForMulticlass();
            SparkContext qual$13 = this.sc();
            WrappedArray x$100 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$101 = qual$13.parallelize$default$2();
            RDD rdd = qual$13.parallelize((Seq)x$100, x$101, ClassTag$.MODULE$.apply(LabeledPoint.class));
            Enumeration.Value x$102 = Algo$.MODULE$.Classification();
            Gini$ x$103 = Gini$.MODULE$;
            int x$104 = 4;
            int x$105 = 3;
            int x$106 = 100;
            Map x$107 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3))}));
            Enumeration.Value x$108 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$109 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$110 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$111 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$112 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$113 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$114 = Strategy$.MODULE$.$lessinit$greater$default$13();
            double x$115 = Strategy$.MODULE$.$lessinit$greater$default$14();
            boolean x$116 = Strategy$.MODULE$.$lessinit$greater$default$15();
            Strategy strategy = new Strategy(x$102, (Impurity)x$103, x$104, x$105, x$106, x$108, x$107, x$109, x$110, x$111, x$112, x$113, x$114, x$115, x$116);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(strategy.isMulticlassClassification(), "strategy.isMulticlassClassification", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
            DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.asML().toInstance(), ClassTag$.MODULE$.apply(Instance.class)), strategy);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
            DecisionTreeModel model = DecisionTree$.MODULE$.train(rdd, strategy);
            DecisionTreeSuite$.MODULE$.validateClassifier(model, (Seq<LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 0.9);
            Node rootNode = model.topNode();
            Split split = (Split)rootNode.split().get();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.feature()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(split.featureType());
            Enumeration.Value $org_scalatest_assert_macro_right2 = FeatureType$.MODULE$.Continuous();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301));
            double $org_scalatest_assert_macro_left3 = split.threshold();
            int $org_scalatest_assert_macro_right3 = 1980;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 > (double)$org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 302));
            double $org_scalatest_assert_macro_left4 = split.threshold();
            int $org_scalatest_assert_macro_right4 = 2020;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 < (double)$org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
        this.test("Multiclass classification stump with 10-ary (ordered) categorical features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateCategoricalDataPointsForMulticlassForOrderedFeatures();
            SparkContext qual$14 = this.sc();
            WrappedArray x$117 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$118 = qual$14.parallelize$default$2();
            RDD rdd = qual$14.parallelize((Seq)x$117, x$118, ClassTag$.MODULE$.apply(LabeledPoint.class));
            Enumeration.Value x$119 = Algo$.MODULE$.Classification();
            Gini$ x$120 = Gini$.MODULE$;
            int x$121 = 4;
            int x$122 = 3;
            int x$123 = 100;
            Map x$124 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)10))}));
            Enumeration.Value x$125 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$126 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$127 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$128 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$129 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$130 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$131 = Strategy$.MODULE$.$lessinit$greater$default$13();
            double x$132 = Strategy$.MODULE$.$lessinit$greater$default$14();
            boolean x$133 = Strategy$.MODULE$.$lessinit$greater$default$15();
            Strategy strategy = new Strategy(x$119, (Impurity)x$120, x$121, x$122, x$123, x$125, x$124, x$126, x$127, x$128, x$129, x$130, x$131, x$132, x$133);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(strategy.isMulticlassClassification(), "strategy.isMulticlassClassification", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312));
            DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.asML().toInstance(), ClassTag$.MODULE$.apply(Instance.class)), strategy);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 315));
            Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
            Split split = (Split)rootNode.split().get();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.feature()));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.categories().length()));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321));
            List $org_scalatest_assert_macro_left3 = split.categories();
            double $org_scalatest_assert_macro_right3 = 1.0;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.contains((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3)), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(split.featureType());
            Enumeration.Value $org_scalatest_assert_macro_right4 = FeatureType$.MODULE$.Categorical();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
        this.test("Multiclass classification tree with 10-ary (ordered) categorical features, with just enough bins", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateCategoricalDataPointsForMulticlassForOrderedFeatures();
            SparkContext qual$15 = this.sc();
            WrappedArray x$134 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$135 = qual$15.parallelize$default$2();
            RDD rdd = qual$15.parallelize((Seq)x$134, x$135, ClassTag$.MODULE$.apply(LabeledPoint.class));
            Enumeration.Value x$136 = Algo$.MODULE$.Classification();
            Gini$ x$137 = Gini$.MODULE$;
            int x$138 = 4;
            int x$139 = 3;
            int x$140 = 10;
            Map x$141 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)10))}));
            Enumeration.Value x$142 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$143 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$144 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$145 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$146 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$147 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$148 = Strategy$.MODULE$.$lessinit$greater$default$13();
            double x$149 = Strategy$.MODULE$.$lessinit$greater$default$14();
            boolean x$150 = Strategy$.MODULE$.$lessinit$greater$default$15();
            Strategy strategy = new Strategy(x$136, (Impurity)x$137, x$138, x$139, x$140, x$142, x$141, x$143, x$144, x$145, x$146, x$147, x$148, x$149, x$150);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(strategy.isMulticlassClassification(), "strategy.isMulticlassClassification", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
            DecisionTreeModel model = DecisionTree$.MODULE$.train(rdd, strategy);
            DecisionTreeSuite$.MODULE$.validateClassifier(model, (Seq<LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 0.6);
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327));
        this.test("split must satisfy min instances per node requirements", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LabeledPoint[] arr = (LabeledPoint[])((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 0.0)})))), new LabeledPoint(1.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 1.0)})))), new LabeledPoint(0.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0)}))))});
            SparkContext qual$16 = this.sc();
            WrappedArray x$151 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$152 = qual$16.parallelize$default$2();
            RDD rdd = qual$16.parallelize((Seq)x$151, x$152, ClassTag$.MODULE$.apply(LabeledPoint.class));
            Enumeration.Value x$153 = Algo$.MODULE$.Classification();
            Gini$ x$154 = Gini$.MODULE$;
            int x$155 = 2;
            int x$156 = 2;
            int x$157 = 2;
            int x$158 = Strategy$.MODULE$.$lessinit$greater$default$5();
            Enumeration.Value x$159 = Strategy$.MODULE$.$lessinit$greater$default$6();
            Map x$160 = Strategy$.MODULE$.$lessinit$greater$default$7();
            double x$161 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$162 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$163 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$164 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$165 = Strategy$.MODULE$.$lessinit$greater$default$13();
            double x$166 = Strategy$.MODULE$.$lessinit$greater$default$14();
            boolean x$167 = Strategy$.MODULE$.$lessinit$greater$default$15();
            Strategy strategy = new Strategy(x$153, (Impurity)x$154, x$155, x$156, x$158, x$159, x$160, x$157, x$161, x$162, x$163, x$164, x$165, x$166, x$167);
            DecisionTreeModel model = DecisionTree$.MODULE$.train(rdd, strategy);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(model.topNode().isLeaf(), "model.topNode.isLeaf", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349));
            double $org_scalatest_assert_macro_left = model.topNode().predict().predict();
            double $org_scalatest_assert_macro_right = 0.0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350));
            double[] predicts = (double[])rdd.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToDouble((double)model.predict(p.features())), ClassTag$.MODULE$.Double()).collect();
            new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(predicts)).foreach((Function1 & Serializable & scala.Serializable)predict -> DecisionTreeSuite.$anonfun$new$28(this, BoxesRunTime.unboxToDouble((Object)predict)));
            Node rootNode = model.topNode();
            Option $org_scalatest_assert_macro_left2 = rootNode.stats();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
        this.test("do not choose split that does not satisfy min instance per node requirements", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LabeledPoint[] arr = (LabeledPoint[])((Object[])new LabeledPoint[]{new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0})))});
            SparkContext qual$17 = this.sc();
            WrappedArray x$168 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$169 = qual$17.parallelize$default$2();
            RDD rdd = qual$17.parallelize((Seq)x$168, x$169, ClassTag$.MODULE$.apply(LabeledPoint.class));
            Enumeration.Value x$170 = Algo$.MODULE$.Classification();
            Gini$ x$171 = Gini$.MODULE$;
            int x$172 = 2;
            int x$173 = 2;
            Map x$174 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)2))}));
            int x$175 = 2;
            int x$176 = 2;
            Enumeration.Value x$177 = Strategy$.MODULE$.$lessinit$greater$default$6();
            double x$178 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$179 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$180 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$181 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$182 = Strategy$.MODULE$.$lessinit$greater$default$13();
            double x$183 = Strategy$.MODULE$.$lessinit$greater$default$14();
            boolean x$184 = Strategy$.MODULE$.$lessinit$greater$default$15();
            Strategy strategy = new Strategy(x$170, (Impurity)x$171, x$173, x$175, x$172, x$177, x$174, x$176, x$178, x$179, x$180, x$181, x$182, x$183, x$184);
            Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
            Split split = (Split)rootNode.split().get();
            InformationGainStats gainStats = (InformationGainStats)rootNode.stats().get();
            int $org_scalatest_assert_macro_left = split.feature();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 380));
            double $org_scalatest_assert_macro_left2 = gainStats.gain();
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 >= (double)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
            double $org_scalatest_assert_macro_left3 = gainStats.impurity();
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 >= (double)$org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362));
        this.test("split must satisfy min info gain requirements", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LabeledPoint[] arr = (LabeledPoint[])((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 0.0)})))), new LabeledPoint(1.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 1.0)})))), new LabeledPoint(0.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0)}))))});
            SparkContext qual$18 = this.sc();
            WrappedArray x$185 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$186 = qual$18.parallelize$default$2();
            RDD input = qual$18.parallelize((Seq)x$185, x$186, ClassTag$.MODULE$.apply(LabeledPoint.class));
            Enumeration.Value x$187 = Algo$.MODULE$.Classification();
            Gini$ x$188 = Gini$.MODULE$;
            int x$189 = 2;
            int x$190 = 2;
            double x$191 = 1.0;
            int x$192 = Strategy$.MODULE$.$lessinit$greater$default$5();
            Enumeration.Value x$193 = Strategy$.MODULE$.$lessinit$greater$default$6();
            Map x$194 = Strategy$.MODULE$.$lessinit$greater$default$7();
            int x$195 = Strategy$.MODULE$.$lessinit$greater$default$8();
            int x$196 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$197 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$198 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$199 = Strategy$.MODULE$.$lessinit$greater$default$13();
            double x$200 = Strategy$.MODULE$.$lessinit$greater$default$14();
            boolean x$201 = Strategy$.MODULE$.$lessinit$greater$default$15();
            Strategy strategy = new Strategy(x$187, (Impurity)x$188, x$189, x$190, x$192, x$193, x$194, x$195, x$191, x$196, x$197, x$198, x$199, x$200, x$201);
            DecisionTreeModel model = DecisionTree$.MODULE$.train(input, strategy);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(model.topNode().isLeaf(), "model.topNode.isLeaf", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 396));
            double $org_scalatest_assert_macro_left = model.topNode().predict().predict();
            double $org_scalatest_assert_macro_right = 0.0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 397));
            double[] predicts = (double[])input.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToDouble((double)model.predict(p.features())), ClassTag$.MODULE$.Double()).collect();
            new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(predicts)).foreach((Function1 & Serializable & scala.Serializable)predict -> DecisionTreeSuite.$anonfun$new$32(this, BoxesRunTime.unboxToDouble((Object)predict)));
            Option $org_scalatest_assert_macro_left2 = model.topNode().stats();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 404));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 385));
        this.test("Node.subtreeIterator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            DecisionTreeModel model = DecisionTreeSuite$.MODULE$.createModel(Algo$.MODULE$.Classification());
            int[] nodeIds = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])model.topNode().subtreeIterator().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.id())).toArray(ClassTag$.MODULE$.Int()))).sorted((Ordering)Ordering.Int$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(nodeIds);
            int[] $org_scalatest_assert_macro_right = DecisionTreeSuite$.MODULE$.org$apache$spark$mllib$tree$DecisionTreeSuite$$createdModelNodeIds();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 414));
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 411));
        this.test("model save/load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            String path = tempDir.toURI().toString();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Enumeration.Value[]{Algo$.MODULE$.Classification(), Algo$.MODULE$.Regression()})).foreach((Function1 & Serializable & scala.Serializable)algo -> {
                DecisionTreeSuite.$anonfun$new$36(this, path, tempDir, algo);
                return BoxedUnit.UNIT;
            });
        }, new Position("DecisionTreeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 417));
    }
}

