/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.DecisionTree$;
import org.apache.spark.mllib.tree.DecisionTreeSuite$;
import org.apache.spark.mllib.tree.EnsembleTestHelper$;
import org.apache.spark.mllib.tree.GradientBoostedTrees$;
import org.apache.spark.mllib.tree.GradientBoostedTreesSuite$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.configuration.Strategy$;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.impurity.Variance$;
import org.apache.spark.mllib.tree.loss.AbsoluteError$;
import org.apache.spark.mllib.tree.loss.LogLoss$;
import org.apache.spark.mllib.tree.loss.Loss;
import org.apache.spark.mllib.tree.loss.SquaredError$;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel$;
import org.apache.spark.mllib.tree.model.TreeEnsembleModel;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r4AAD\b\u00015!)1\u0006\u0001C\u0001Y\u001d1qf\u0004E\u0001'A2aAD\b\t\u0002M\t\u0004\"B\u0016\u0004\t\u0003Y\u0004b\u0002\u001f\u0004\u0005\u0004%\t!\u0010\u0005\u0007\u0015\u000e\u0001\u000b\u0011\u0002 \t\u000f-\u001b!\u0019!C\u0001\u0019\"1Ak\u0001Q\u0001\n5Cq!V\u0002C\u0002\u0013\u0005A\n\u0003\u0004W\u0007\u0001\u0006I!\u0014\u0005\b/\u000e\u0011\r\u0011\"\u0001M\u0011\u0019A6\u0001)A\u0005\u001b\"9\u0011lAA\u0001\n\u0013Q&!G$sC\u0012LWM\u001c;C_>\u001cH/\u001a3Ue\u0016,7oU;ji\u0016T!\u0001E\t\u0002\tQ\u0014X-\u001a\u0006\u0003%M\tQ!\u001c7mS\nT!\u0001F\u000b\u0002\u000bM\u0004\u0018M]6\u000b\u0005Y9\u0012AB1qC\u000eDWMC\u0001\u0019\u0003\ry'oZ\u0002\u0001'\u0011\u00011dH\u0013\u0011\u0005qiR\"A\n\n\u0005y\u0019\"!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002!G5\t\u0011E\u0003\u0002##\u0005!Q\u000f^5m\u0013\t!\u0013EA\u000bN\u00192L'\rV3tiN\u0003\u0018M]6D_:$X\r\u001f;\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!\u001a\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005):#a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035\u0002\"A\f\u0001\u000e\u0003=\t\u0011d\u0012:bI&,g\u000e\u001e\"p_N$X\r\u001a+sK\u0016\u001c8+^5uKB\u0011afA\n\u0004\u0007IB\u0004CA\u001a7\u001b\u0005!$\"A\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]\"$AB!osJ+g\r\u0005\u00024s%\u0011!\b\u000e\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0002a\u0005\u0001B/Z:u\u0007>l'-\u001b8bi&|gn]\u000b\u0002}A\u00191gP!\n\u0005\u0001#$!B!se\u0006L\b#B\u001aC\t\u001e;\u0015BA\"5\u0005\u0019!V\u000f\u001d7fgA\u00111'R\u0005\u0003\rR\u00121!\u00138u!\t\u0019\u0004*\u0003\u0002Ji\t1Ai\\;cY\u0016\f\u0011\u0003^3ti\u000e{WNY5oCRLwN\\:!\u0003\u0011!\u0017\r^1\u0016\u00035\u00032aM O!\ty%+D\u0001Q\u0015\t\t\u0016#\u0001\u0006sK\u001e\u0014Xm]:j_:L!a\u0015)\u0003\u00191\u000b'-\u001a7fIB{\u0017N\u001c;\u0002\u000b\u0011\fG/\u0019\u0011\u0002\u0013Q\u0014\u0018-\u001b8ECR\f\u0017A\u0003;sC&tG)\u0019;bA\u0005aa/\u00197jI\u0006$X\rR1uC\u0006ia/\u00197jI\u0006$X\rR1uC\u0002\n1B]3bIJ+7o\u001c7wKR\t1\f\u0005\u0002]C6\tQL\u0003\u0002_?\u0006!A.\u00198h\u0015\u0005\u0001\u0017\u0001\u00026bm\u0006L!AY/\u0003\r=\u0013'.Z2u\u0001")
public class GradientBoostedTreesSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static LabeledPoint[] validateData() {
        return GradientBoostedTreesSuite$.MODULE$.validateData();
    }

    public static LabeledPoint[] trainData() {
        return GradientBoostedTreesSuite$.MODULE$.trainData();
    }

    public static LabeledPoint[] data() {
        return GradientBoostedTreesSuite$.MODULE$.data();
    }

    public static Tuple3<Object, Object, Object>[] testCombinations() {
        return GradientBoostedTreesSuite$.MODULE$.testCombinations();
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private final void testImplicits$lzycompute$1() {
        GradientBoostedTreesSuite gradientBoostedTreesSuite = this;
        synchronized (gradientBoostedTreesSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$new$18(Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        DecisionTreeModel treeA = (DecisionTreeModel)tuple2._1();
        DecisionTreeModel treeB = (DecisionTreeModel)tuple2._2();
        DecisionTreeSuite$.MODULE$.checkEqual(treeA, treeB);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public GradientBoostedTreesSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("Regression with continuous features: SquaredError", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])GradientBoostedTreesSuite$.MODULE$.testCombinations())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            GradientBoostedTreesModel gbt;
            Strategy treeStrategy;
            RDD rdd;
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                int numIterations = BoxesRunTime.unboxToInt((Object)tuple3._1());
                double learningRate = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                double subsamplingRate = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                rdd = this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])GradientBoostedTreesSuite$.MODULE$.data()), 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Enumeration.Value x$1 = Algo$.MODULE$.Regression();
                Variance$ x$2 = Variance$.MODULE$;
                int x$3 = 2;
                Map x$4 = Predef$.MODULE$.Map().empty();
                double x$5 = subsamplingRate;
                int x$6 = Strategy$.MODULE$.$lessinit$greater$default$4();
                int x$7 = Strategy$.MODULE$.$lessinit$greater$default$5();
                Enumeration.Value x$8 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$9 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$10 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$11 = Strategy$.MODULE$.$lessinit$greater$default$10();
                boolean x$12 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$13 = Strategy$.MODULE$.$lessinit$greater$default$13();
                double x$14 = Strategy$.MODULE$.$lessinit$greater$default$14();
                boolean x$15 = Strategy$.MODULE$.$lessinit$greater$default$15();
                treeStrategy = new Strategy(x$1, (Impurity)x$2, x$3, x$6, x$7, x$8, x$4, x$9, x$10, x$11, x$5, x$12, x$13, x$14, x$15);
                BoostingStrategy boostingStrategy = new BoostingStrategy(treeStrategy, (Loss)SquaredError$.MODULE$, numIterations, learningRate, BoostingStrategy$.MODULE$.$lessinit$greater$default$5());
                gbt = GradientBoostedTrees$.MODULE$.train(rdd, boostingStrategy);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])gbt.trees())).size()));
                int $org_scalatest_assert_macro_right = numIterations;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GradientBoostedTreesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
                try {
                    EnsembleTestHelper$.MODULE$.validateRegressor((TreeEnsembleModel)gbt, (Seq<LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])GradientBoostedTreesSuite$.MODULE$.data()), 0.06, EnsembleTestHelper$.MODULE$.validateRegressor$default$4());
                }
                catch (AssertionError e) {
                    this.logError((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("FAILED for numIterations=").append(numIterations).append(", learningRate=").append(learningRate).append(",").append(" subsamplingRate=").append(subsamplingRate).toString());
                    throw e;
                }
            } else {
                throw new MatchError((Object)tuple3);
            }
            RDD remappedInput = rdd.map((Function1 & Serializable & scala.Serializable)x -> new LabeledPoint(x.label() * (double)2 - 1.0, x.features()), ClassTag$.MODULE$.apply(LabeledPoint.class));
            DecisionTreeModel dt = DecisionTree$.MODULE$.train(remappedInput, treeStrategy);
            String $org_scalatest_assert_macro_left = ((DecisionTreeModel)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])gbt.trees())).head()).toString();
            String $org_scalatest_assert_macro_right = dt.toString();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GradientBoostedTreesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            return assertion;
        }), new Position("GradientBoostedTreesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
        this.test("Regression with continuous features: Absolute Error", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])GradientBoostedTreesSuite$.MODULE$.testCombinations())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            GradientBoostedTreesModel gbt;
            Strategy treeStrategy;
            RDD rdd;
            Tuple3 tuple3 = x0$2;
            if (tuple3 != null) {
                int numIterations = BoxesRunTime.unboxToInt((Object)tuple3._1());
                double learningRate = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                double subsamplingRate = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                rdd = this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])GradientBoostedTreesSuite$.MODULE$.data()), 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Enumeration.Value x$16 = Algo$.MODULE$.Regression();
                Variance$ x$17 = Variance$.MODULE$;
                int x$18 = 2;
                Map x$19 = Predef$.MODULE$.Map().empty();
                double x$20 = subsamplingRate;
                int x$21 = Strategy$.MODULE$.$lessinit$greater$default$4();
                int x$22 = Strategy$.MODULE$.$lessinit$greater$default$5();
                Enumeration.Value x$23 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$24 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$25 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$26 = Strategy$.MODULE$.$lessinit$greater$default$10();
                boolean x$27 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$28 = Strategy$.MODULE$.$lessinit$greater$default$13();
                double x$29 = Strategy$.MODULE$.$lessinit$greater$default$14();
                boolean x$30 = Strategy$.MODULE$.$lessinit$greater$default$15();
                treeStrategy = new Strategy(x$16, (Impurity)x$17, x$18, x$21, x$22, x$23, x$19, x$24, x$25, x$26, x$20, x$27, x$28, x$29, x$30);
                BoostingStrategy boostingStrategy = new BoostingStrategy(treeStrategy, (Loss)AbsoluteError$.MODULE$, numIterations, learningRate, BoostingStrategy$.MODULE$.$lessinit$greater$default$5());
                gbt = GradientBoostedTrees$.MODULE$.train(rdd, boostingStrategy);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])gbt.trees())).size()));
                int $org_scalatest_assert_macro_right = numIterations;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GradientBoostedTreesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
                try {
                    EnsembleTestHelper$.MODULE$.validateRegressor((TreeEnsembleModel)gbt, (Seq<LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])GradientBoostedTreesSuite$.MODULE$.data()), 0.85, "mae");
                }
                catch (AssertionError e) {
                    this.logError((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("FAILED for numIterations=").append(numIterations).append(", learningRate=").append(learningRate).append(",").append(" subsamplingRate=").append(subsamplingRate).toString());
                    throw e;
                }
            } else {
                throw new MatchError((Object)tuple3);
            }
            RDD remappedInput = rdd.map((Function1 & Serializable & scala.Serializable)x -> new LabeledPoint(x.label() * (double)2 - 1.0, x.features()), ClassTag$.MODULE$.apply(LabeledPoint.class));
            DecisionTreeModel dt = DecisionTree$.MODULE$.train(remappedInput, treeStrategy);
            String $org_scalatest_assert_macro_left = ((DecisionTreeModel)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])gbt.trees())).head()).toString();
            String $org_scalatest_assert_macro_right = dt.toString();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GradientBoostedTreesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
            return assertion;
        }), new Position("GradientBoostedTreesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        this.test("Binary classification with continuous features: Log Loss", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])GradientBoostedTreesSuite$.MODULE$.testCombinations())).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            GradientBoostedTreesModel gbt;
            Strategy treeStrategy;
            RDD rdd;
            Tuple3 tuple3 = x0$3;
            if (tuple3 != null) {
                int numIterations = BoxesRunTime.unboxToInt((Object)tuple3._1());
                double learningRate = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                double subsamplingRate = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                rdd = this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])GradientBoostedTreesSuite$.MODULE$.data()), 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Enumeration.Value x$31 = Algo$.MODULE$.Classification();
                Variance$ x$32 = Variance$.MODULE$;
                int x$33 = 2;
                int x$34 = 2;
                Map x$35 = Predef$.MODULE$.Map().empty();
                double x$36 = subsamplingRate;
                int x$37 = Strategy$.MODULE$.$lessinit$greater$default$5();
                Enumeration.Value x$38 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$39 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$40 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$41 = Strategy$.MODULE$.$lessinit$greater$default$10();
                boolean x$42 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$43 = Strategy$.MODULE$.$lessinit$greater$default$13();
                double x$44 = Strategy$.MODULE$.$lessinit$greater$default$14();
                boolean x$45 = Strategy$.MODULE$.$lessinit$greater$default$15();
                treeStrategy = new Strategy(x$31, (Impurity)x$32, x$33, x$34, x$37, x$38, x$35, x$39, x$40, x$41, x$36, x$42, x$43, x$44, x$45);
                BoostingStrategy boostingStrategy = new BoostingStrategy(treeStrategy, (Loss)LogLoss$.MODULE$, numIterations, learningRate, BoostingStrategy$.MODULE$.$lessinit$greater$default$5());
                gbt = GradientBoostedTrees$.MODULE$.train(rdd, boostingStrategy);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])gbt.trees())).size()));
                int $org_scalatest_assert_macro_right = numIterations;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GradientBoostedTreesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
                try {
                    EnsembleTestHelper$.MODULE$.validateClassifier((TreeEnsembleModel)gbt, (Seq<LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])GradientBoostedTreesSuite$.MODULE$.data()), 0.9);
                }
                catch (AssertionError e) {
                    this.logError((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("FAILED for numIterations=").append(numIterations).append(", learningRate=").append(learningRate).append(",").append(" subsamplingRate=").append(subsamplingRate).toString());
                    throw e;
                }
            } else {
                throw new MatchError((Object)tuple3);
            }
            RDD remappedInput = rdd.map((Function1 & Serializable & scala.Serializable)x -> new LabeledPoint(x.label() * (double)2 - 1.0, x.features()), ClassTag$.MODULE$.apply(LabeledPoint.class));
            Strategy ensembleStrategy = treeStrategy.copy();
            ensembleStrategy.algo_$eq(Algo$.MODULE$.Regression());
            ensembleStrategy.impurity_$eq((Impurity)Variance$.MODULE$);
            DecisionTreeModel dt = DecisionTree$.MODULE$.train(remappedInput, ensembleStrategy);
            String $org_scalatest_assert_macro_left = ((DecisionTreeModel)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])gbt.trees())).head()).toString();
            String $org_scalatest_assert_macro_right = dt.toString();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GradientBoostedTreesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
            return assertion;
        }), new Position("GradientBoostedTreesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        this.test("SPARK-5496: BoostingStrategy.defaultParams should recognize Classification", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"classification", "Classification", "regression", "Regression"}))).foreach((Function1 & Serializable & scala.Serializable)algo -> BoostingStrategy$.MODULE$.defaultParams(algo)), new Position("GradientBoostedTreesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        this.test("model save/load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            String path = tempDir.toURI().toString();
            DecisionTreeModel[] trees = (DecisionTreeModel[])((TraversableOnce)package$.MODULE$.Range().apply(0, 3).map((Function1 & Serializable & scala.Serializable)x$1 -> DecisionTreeSuite$.MODULE$.createModel(Algo$.MODULE$.Regression()), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(DecisionTreeModel.class));
            double[] treeWeights = new double[]{0.1, 0.3, 1.1};
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Enumeration.Value[]{Algo$.MODULE$.Classification(), Algo$.MODULE$.Regression()})).foreach((Function1 & Serializable & scala.Serializable)algo -> {
                Assertion assertion;
                GradientBoostedTreesModel model = new GradientBoostedTreesModel(algo, trees, treeWeights);
                try {
                    model.save(this.sc(), path);
                    GradientBoostedTreesModel sameModel = GradientBoostedTreesModel$.MODULE$.load(this.sc(), path);
                    Enumeration.Value $org_scalatest_assert_macro_left = model.algo();
                    Enumeration.Value $org_scalatest_assert_macro_right = sameModel.algo();
                    Enumeration.Value value = $org_scalatest_assert_macro_left;
                    Enumeration.Value value2 = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(value != null ? !value.equals(value2) : value2 != null), Prettifier$.MODULE$.default());
                    this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GradientBoostedTreesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.trees())).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])sameModel.trees()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                        GradientBoostedTreesSuite.$anonfun$new$18(x0$4);
                        return BoxedUnit.UNIT;
                    });
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(model.treeWeights());
                    double[] $org_scalatest_assert_macro_right2 = sameModel.treeWeights();
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("GradientBoostedTreesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
                }
                finally {
                    Utils$.MODULE$.deleteRecursively(tempDir);
                }
                return assertion;
            });
        }, new Position("GradientBoostedTreesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        this.test("Checkpointing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            String path = tempDir.toURI().toString();
            this.sc().setCheckpointDir(path);
            RDD rdd = this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])GradientBoostedTreesSuite$.MODULE$.data()), 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
            Enumeration.Value x$46 = Algo$.MODULE$.Regression();
            Variance$ x$47 = Variance$.MODULE$;
            int x$48 = 2;
            Map x$49 = Predef$.MODULE$.Map().empty();
            int x$50 = 2;
            int x$51 = Strategy$.MODULE$.$lessinit$greater$default$4();
            int x$52 = Strategy$.MODULE$.$lessinit$greater$default$5();
            Enumeration.Value x$53 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$54 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$55 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$56 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$57 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$58 = Strategy$.MODULE$.$lessinit$greater$default$12();
            double x$59 = Strategy$.MODULE$.$lessinit$greater$default$14();
            boolean x$60 = Strategy$.MODULE$.$lessinit$greater$default$15();
            Strategy treeStrategy = new Strategy(x$46, (Impurity)x$47, x$48, x$51, x$52, x$53, x$49, x$54, x$55, x$56, x$57, x$58, x$50, x$59, x$60);
            BoostingStrategy boostingStrategy = new BoostingStrategy(treeStrategy, (Loss)SquaredError$.MODULE$, 5, 0.1, BoostingStrategy$.MODULE$.$lessinit$greater$default$5());
            GradientBoostedTreesModel gbt = GradientBoostedTrees$.MODULE$.train(rdd, boostingStrategy);
            this.sc().checkpointDir_$eq((Option)None$.MODULE$);
            Utils$.MODULE$.deleteRecursively(tempDir);
        }, new Position("GradientBoostedTreesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
    }
}

