/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.DecisionTree$;
import org.apache.spark.mllib.tree.DecisionTreeSuite$;
import org.apache.spark.mllib.tree.EnsembleTestHelper$;
import org.apache.spark.mllib.tree.RandomForest$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.configuration.Strategy$;
import org.apache.spark.mllib.tree.impurity.Gini$;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.impurity.Variance$;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.RandomForestModel;
import org.apache.spark.mllib.tree.model.RandomForestModel$;
import org.apache.spark.mllib.tree.model.TreeEnsembleModel;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001I2A\u0001B\u0003\u0001!!)1\u0004\u0001C\u00019!)q\u0004\u0001C\u0001A!)q\u0006\u0001C\u0001a\t\t\"+\u00198e_64uN]3tiN+\u0018\u000e^3\u000b\u0005\u00199\u0011\u0001\u0002;sK\u0016T!\u0001C\u0005\u0002\u000b5dG.\u001b2\u000b\u0005)Y\u0011!B:qCJ\\'B\u0001\u0007\u000e\u0003\u0019\t\u0007/Y2iK*\ta\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001#U\u0001\"AE\n\u000e\u0003%I!\u0001F\u0005\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t1\u0012$D\u0001\u0018\u0015\tAr!\u0001\u0003vi&d\u0017B\u0001\u000e\u0018\u0005UiE\n\\5c)\u0016\u001cHo\u00159be.\u001cuN\u001c;fqR\fa\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"A\u0003\u0002]\tLg.\u0019:z\u00072\f7o]5gS\u000e\fG/[8o)\u0016\u001cHoV5uQ\u000e{g\u000e^5ok>,8OR3biV\u0014Xm\u001d\u000b\u0003C\u001d\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012A!\u00168ji\")\u0001F\u0001a\u0001S\u0005A1\u000f\u001e:bi\u0016<\u0017\u0010\u0005\u0002+[5\t1F\u0003\u0002-\u000b\u0005i1m\u001c8gS\u001e,(/\u0019;j_:L!AL\u0016\u0003\u0011M#(/\u0019;fOf\fAE]3he\u0016\u001c8/[8o)\u0016\u001cHoV5uQ\u000e{g\u000e^5ok>,8OR3biV\u0014Xm\u001d\u000b\u0003CEBQ\u0001K\u0002A\u0002%\u0002")
public class RandomForestSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public void binaryClassificationTestWithContinuousFeatures(Strategy strategy) {
        LabeledPoint[] arr = EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(50, 1000);
        SparkContext qual$1 = this.sc();
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])arr);
        int x$2 = qual$1.parallelize$default$2();
        RDD rdd = qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.apply(LabeledPoint.class));
        int numTrees = 1;
        RandomForestModel rf = RandomForest$.MODULE$.trainClassifier(rdd, strategy, numTrees, "auto", 123);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)rf.trees().length));
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        DecisionTreeModel rfTree = rf.trees()[0];
        DecisionTreeModel dt = DecisionTree$.MODULE$.train(rdd, strategy);
        EnsembleTestHelper$.MODULE$.validateClassifier((TreeEnsembleModel)rf, (Seq<LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 0.9);
        DecisionTreeSuite$.MODULE$.validateClassifier(dt, (Seq<LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 0.9);
        String $org_scalatest_assert_macro_left2 = rfTree.toString();
        String $org_scalatest_assert_macro_right2 = dt.toString();
        String string = $org_scalatest_assert_macro_left2;
        String string2 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
    }

    public void regressionTestWithContinuousFeatures(Strategy strategy) {
        LabeledPoint[] arr = EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(50, 1000);
        SparkContext qual$1 = this.sc();
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])arr);
        int x$2 = qual$1.parallelize$default$2();
        RDD rdd = qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.apply(LabeledPoint.class));
        int numTrees = 1;
        RandomForestModel rf = RandomForest$.MODULE$.trainRegressor(rdd, strategy, numTrees, "auto", 123);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)rf.trees().length));
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        DecisionTreeModel rfTree = rf.trees()[0];
        DecisionTreeModel dt = DecisionTree$.MODULE$.train(rdd, strategy);
        EnsembleTestHelper$.MODULE$.validateRegressor((TreeEnsembleModel)rf, (Seq<LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 0.01, EnsembleTestHelper$.MODULE$.validateRegressor$default$4());
        DecisionTreeSuite$.MODULE$.validateRegressor(dt, (Seq<LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 0.01);
        String $org_scalatest_assert_macro_left2 = rfTree.toString();
        String $org_scalatest_assert_macro_right2 = dt.toString();
        String string = $org_scalatest_assert_macro_left2;
        String string2 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
    }

    private final void testImplicits$lzycompute$1() {
        RandomForestSuite randomForestSuite = this;
        synchronized (randomForestSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$new$10(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        DecisionTreeModel treeA = (DecisionTreeModel)tuple2._1();
        DecisionTreeModel treeB = (DecisionTreeModel)tuple2._2();
        DecisionTreeSuite$.MODULE$.checkEqual(treeA, treeB);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$8(RandomForestSuite $this, String path$1, File tempDir$1, Enumeration.Value algo) {
        DecisionTreeModel[] trees = (DecisionTreeModel[])((TraversableOnce)package$.MODULE$.Range().apply(0, 3).map((Function1 & Serializable & scala.Serializable)x$1 -> DecisionTreeSuite$.MODULE$.createModel(algo), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(DecisionTreeModel.class));
        RandomForestModel model = new RandomForestModel(algo, trees);
        try {
            model.save($this.sc(), path$1);
            RandomForestModel sameModel = RandomForestModel$.MODULE$.load($this.sc(), path$1);
            Enumeration.Value $org_scalatest_assert_macro_left = model.algo();
            Enumeration.Value $org_scalatest_assert_macro_right = sameModel.algo();
            Enumeration.Value value = $org_scalatest_assert_macro_left;
            Enumeration.Value value2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(value != null ? !value.equals(value2) : value2 != null), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.trees())).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])sameModel.trees()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                RandomForestSuite.$anonfun$new$10(x0$1);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            Utils$.MODULE$.deleteRecursively(tempDir$1);
        }
    }

    public RandomForestSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("Binary classification with continuous features: comparing DecisionTree vs. RandomForest(numTrees = 1)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Map categoricalFeaturesInfo = Predef$.MODULE$.Map().empty();
            Enumeration.Value x$1 = Algo$.MODULE$.Classification();
            Gini$ x$2 = Gini$.MODULE$;
            int x$3 = 2;
            int x$4 = 2;
            Map x$5 = categoricalFeaturesInfo;
            int x$6 = Strategy$.MODULE$.$lessinit$greater$default$5();
            Enumeration.Value x$7 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$8 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$9 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$10 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$11 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$12 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$13 = Strategy$.MODULE$.$lessinit$greater$default$13();
            double x$14 = Strategy$.MODULE$.$lessinit$greater$default$14();
            boolean x$15 = Strategy$.MODULE$.$lessinit$greater$default$15();
            Strategy strategy = new Strategy(x$1, (Impurity)x$2, x$3, x$4, x$6, x$7, x$5, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15);
            this.binaryClassificationTestWithContinuousFeatures(strategy);
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        this.test("Binary classification with continuous features and node Id cache : comparing DecisionTree vs. RandomForest(numTrees = 1)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Map categoricalFeaturesInfo = Predef$.MODULE$.Map().empty();
            Enumeration.Value x$16 = Algo$.MODULE$.Classification();
            Gini$ x$17 = Gini$.MODULE$;
            int x$18 = 2;
            int x$19 = 2;
            Map x$20 = categoricalFeaturesInfo;
            boolean x$21 = true;
            int x$22 = Strategy$.MODULE$.$lessinit$greater$default$5();
            Enumeration.Value x$23 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$24 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$25 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$26 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$27 = Strategy$.MODULE$.$lessinit$greater$default$11();
            int x$28 = Strategy$.MODULE$.$lessinit$greater$default$13();
            double x$29 = Strategy$.MODULE$.$lessinit$greater$default$14();
            boolean x$30 = Strategy$.MODULE$.$lessinit$greater$default$15();
            Strategy strategy = new Strategy(x$16, (Impurity)x$17, x$18, x$19, x$22, x$23, x$20, x$24, x$25, x$26, x$27, x$21, x$28, x$29, x$30);
            this.binaryClassificationTestWithContinuousFeatures(strategy);
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        this.test("Regression with continuous features: comparing DecisionTree vs. RandomForest(numTrees = 1)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Map categoricalFeaturesInfo = Predef$.MODULE$.Map().empty();
            Enumeration.Value x$31 = Algo$.MODULE$.Regression();
            Variance$ x$32 = Variance$.MODULE$;
            int x$33 = 2;
            int x$34 = 10;
            int x$35 = 2;
            Map x$36 = categoricalFeaturesInfo;
            Enumeration.Value x$37 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$38 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$39 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$40 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$41 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$42 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$43 = Strategy$.MODULE$.$lessinit$greater$default$13();
            double x$44 = Strategy$.MODULE$.$lessinit$greater$default$14();
            boolean x$45 = Strategy$.MODULE$.$lessinit$greater$default$15();
            Strategy strategy = new Strategy(x$31, (Impurity)x$32, x$33, x$35, x$34, x$37, x$36, x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$45);
            this.regressionTestWithContinuousFeatures(strategy);
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        this.test("Regression with continuous features and node Id cache : comparing DecisionTree vs. RandomForest(numTrees = 1)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Map categoricalFeaturesInfo = Predef$.MODULE$.Map().empty();
            Enumeration.Value x$46 = Algo$.MODULE$.Regression();
            Variance$ x$47 = Variance$.MODULE$;
            int x$48 = 2;
            int x$49 = 10;
            int x$50 = 2;
            Map x$51 = categoricalFeaturesInfo;
            boolean x$52 = true;
            Enumeration.Value x$53 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$54 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$55 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$56 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$57 = Strategy$.MODULE$.$lessinit$greater$default$11();
            int x$58 = Strategy$.MODULE$.$lessinit$greater$default$13();
            double x$59 = Strategy$.MODULE$.$lessinit$greater$default$14();
            boolean x$60 = Strategy$.MODULE$.$lessinit$greater$default$15();
            Strategy strategy = new Strategy(x$46, (Impurity)x$47, x$48, x$50, x$49, x$53, x$51, x$54, x$55, x$56, x$57, x$52, x$58, x$59, x$60);
            this.regressionTestWithContinuousFeatures(strategy);
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        this.test("alternating categorical and continuous features with multiclass labels to test indexing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LabeledPoint[] arr = new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 3.0, 1.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0, 1.0, 2.0}))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 6.0, 3.0}))), new LabeledPoint(2.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 1.0, 3.0, 2.0})))};
            Map categoricalFeaturesInfo = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)BoxesRunTime.boxToInteger((int)4))}));
            SparkContext qual$1 = this.sc();
            WrappedArray x$61 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$62 = qual$1.parallelize$default$2();
            RDD input = qual$1.parallelize((Seq)x$61, x$62, ClassTag$.MODULE$.apply(LabeledPoint.class));
            Enumeration.Value x$63 = Algo$.MODULE$.Classification();
            Gini$ x$64 = Gini$.MODULE$;
            int x$65 = 5;
            int x$66 = 3;
            Map x$67 = categoricalFeaturesInfo;
            int x$68 = Strategy$.MODULE$.$lessinit$greater$default$5();
            Enumeration.Value x$69 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$70 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$71 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$72 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$73 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$74 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$75 = Strategy$.MODULE$.$lessinit$greater$default$13();
            double x$76 = Strategy$.MODULE$.$lessinit$greater$default$14();
            boolean x$77 = Strategy$.MODULE$.$lessinit$greater$default$15();
            Strategy strategy = new Strategy(x$63, (Impurity)x$64, x$65, x$66, x$68, x$69, x$67, x$70, x$71, x$72, x$73, x$74, x$75, x$76, x$77);
            RandomForestModel model = RandomForest$.MODULE$.trainClassifier(input, strategy, 2, "sqrt", 12345);
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        this.test("subsampling rate in RandomForest", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LabeledPoint[] arr = EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(5, 20);
            SparkContext qual$2 = this.sc();
            WrappedArray x$78 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$79 = qual$2.parallelize$default$2();
            RDD rdd = qual$2.parallelize((Seq)x$78, x$79, ClassTag$.MODULE$.apply(LabeledPoint.class));
            Enumeration.Value x$80 = Algo$.MODULE$.Classification();
            Gini$ x$81 = Gini$.MODULE$;
            int x$82 = 2;
            int x$83 = 2;
            Map x$84 = Predef$.MODULE$.Map().empty();
            boolean x$85 = true;
            int x$86 = Strategy$.MODULE$.$lessinit$greater$default$5();
            Enumeration.Value x$87 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$88 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$89 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$90 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$91 = Strategy$.MODULE$.$lessinit$greater$default$11();
            int x$92 = Strategy$.MODULE$.$lessinit$greater$default$13();
            double x$93 = Strategy$.MODULE$.$lessinit$greater$default$14();
            boolean x$94 = Strategy$.MODULE$.$lessinit$greater$default$15();
            Strategy strategy = new Strategy(x$80, (Impurity)x$81, x$82, x$83, x$86, x$87, x$84, x$88, x$89, x$90, x$91, x$85, x$92, x$93, x$94);
            RandomForestModel rf1 = RandomForest$.MODULE$.trainClassifier(rdd, strategy, 3, "auto", 123);
            strategy.subsamplingRate_$eq(0.5);
            RandomForestModel rf2 = RandomForest$.MODULE$.trainClassifier(rdd, strategy, 3, "auto", 123);
            String $org_scalatest_assert_macro_left = rf1.toDebugString();
            String $org_scalatest_assert_macro_right = rf2.toDebugString();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, string == null ? string2 != null : !string.equals(string2), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        this.test("model save/load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            String path = tempDir.toURI().toString();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Enumeration.Value[]{Algo$.MODULE$.Classification(), Algo$.MODULE$.Regression()})).foreach((Function1 & Serializable & scala.Serializable)algo -> {
                RandomForestSuite.$anonfun$new$8(this, path, tempDir, algo);
                return BoxedUnit.UNIT;
            });
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
    }
}

