/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.Serializable;
import org.apache.spark.ml.classification.ClassificationModel;
import org.apache.spark.ml.classification.ClassifierParams;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel$;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.DoubleArrayParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.shared.HasProbabilityCol;
import org.apache.spark.ml.param.shared.HasThresholds;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed!\u0002\t\u0012\u0003\u0003a\u0002\"\u0002\u001d\u0001\t\u0003I\u0004\"\u0002\u001e\u0001\t\u0003Y\u0004\"B%\u0001\t\u0003Q\u0005\"\u0002*\u0001\t\u0003\u001a\u0006\"\u00020\u0001\t\u0003z\u0006\"B=\u0001\r#Q\bbBA\u0004\u0001\u0011E\u0011\u0011\u0002\u0005\b\u0003\u001b\u0001A\u0011KA\b\u0011\u001d\t\u0019\u0002\u0001C\u0001\u0003+Aq!!\f\u0001\t#\tyc\u0002\u0005\u00026EA\taEA\u001c\r\u001d\u0001\u0012\u0003#\u0001\u0014\u0003sAa\u0001\u000f\u0007\u0005\u0002\u0005\u001d\u0003bBA%\u0019\u0011\u0005\u00111\n\u0005\n\u0003;b\u0011\u0011!C\u0005\u0003?\u0012\u0001\u0005\u0015:pE\u0006\u0014\u0017\u000e\\5ti&\u001c7\t\\1tg&4\u0017nY1uS>tWj\u001c3fY*\u0011!cE\u0001\u000fG2\f7o]5gS\u000e\fG/[8o\u0015\t!R#\u0001\u0002nY*\u0011acF\u0001\u0006gB\f'o\u001b\u0006\u00031e\ta!\u00199bG\",'\"\u0001\u000e\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0007u!\u0013gE\u0002\u0001=U\u0002Ba\b\u0011#a5\t\u0011#\u0003\u0002\"#\t\u00192\t\\1tg&4\u0017nY1uS>tWj\u001c3fYB\u00111\u0005\n\u0007\u0001\t\u0015)\u0003A1\u0001'\u000511U-\u0019;ve\u0016\u001cH+\u001f9f#\t9S\u0006\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013FA\u0004O_RD\u0017N\\4\u0011\u0005!r\u0013BA\u0018*\u0005\r\te.\u001f\t\u0003GE\"QA\r\u0001C\u0002M\u0012\u0011!T\t\u0003OQ\u0002Ba\b\u0001#aA\u0011qDN\u0005\u0003oE\u0011Q\u0004\u0015:pE\u0006\u0014\u0017\u000e\\5ti&\u001c7\t\\1tg&4\u0017.\u001a:QCJ\fWn]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Q\n\u0011c]3u!J|'-\u00192jY&$\u0018pQ8m)\t\u0001D\bC\u0003>\u0005\u0001\u0007a(A\u0003wC2,X\r\u0005\u0002@\r:\u0011\u0001\t\u0012\t\u0003\u0003&j\u0011A\u0011\u0006\u0003\u0007n\ta\u0001\u0010:p_Rt\u0014BA#*\u0003\u0019\u0001&/\u001a3fM&\u0011q\t\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0015K\u0013!D:fiRC'/Z:i_2$7\u000f\u0006\u00021\u0017\")Qh\u0001a\u0001\u0019B\u0019\u0001&T(\n\u00059K#!B!se\u0006L\bC\u0001\u0015Q\u0013\t\t\u0016F\u0001\u0004E_V\u0014G.Z\u0001\u0010iJ\fgn\u001d4pe6\u001c6\r[3nCR\u0011A\u000b\u0018\t\u0003+jk\u0011A\u0016\u0006\u0003/b\u000bQ\u0001^=qKNT!!W\u000b\u0002\u0007M\fH.\u0003\u0002\\-\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000bu#\u0001\u0019\u0001+\u0002\rM\u001c\u0007.Z7b\u0003%!(/\u00198tM>\u0014X\u000e\u0006\u0002a_B\u0011\u0011\r\u001c\b\u0003E*t!aY5\u000f\u0005\u0011DgBA3h\u001d\t\te-C\u0001\u001b\u0013\tA\u0012$\u0003\u0002\u0017/%\u0011\u0011,F\u0005\u0003Wb\u000bq\u0001]1dW\u0006<W-\u0003\u0002n]\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0003WbCQ\u0001]\u0003A\u0002E\fq\u0001Z1uCN,G\u000f\r\u0002soB\u00191\u000f\u001e<\u000e\u0003aK!!\u001e-\u0003\u000f\u0011\u000bG/Y:fiB\u00111e\u001e\u0003\nq>\f\t\u0011!A\u0003\u0002\u0019\u00121a\u0018\u00132\u0003Y\u0011\u0018m\u001e\u001aqe>\u0014\u0017MY5mSRL\u0018J\u001c)mC\u000e,GcA>\u0002\u0004A\u0011Ap`\u0007\u0002{*\u0011apE\u0001\u0007Y&t\u0017\r\\4\n\u0007\u0005\u0005QP\u0001\u0004WK\u000e$xN\u001d\u0005\u0007\u0003\u000b1\u0001\u0019A>\u0002\u001bI\fw\u000f\u0015:fI&\u001cG/[8o\u0003=\u0011\u0018m\u001e\u001aqe>\u0014\u0017MY5mSRLHcA>\u0002\f!1\u0011QA\u0004A\u0002m\faB]1xeA\u0014X\rZ5di&|g\u000eF\u0002P\u0003#Aa!!\u0002\t\u0001\u0004Y\u0018A\u00059sK\u0012L7\r\u001e)s_\n\f'-\u001b7jif$2a_A\f\u0011\u0019\tI\"\u0003a\u0001E\u0005Aa-Z1ukJ,7\u000fK\u0003\n\u0003;\tI\u0003\u0005\u0003\u0002 \u0005\u0015RBAA\u0011\u0015\r\t\u0019#F\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0014\u0003C\u0011QaU5oG\u0016\f#!a\u000b\u0002\u000bMr\u0003G\f\u0019\u0002-A\u0014xNY1cS2LG/\u001f\u001aqe\u0016$\u0017n\u0019;j_:$2aTA\u0019\u0011\u0019\t\u0019D\u0003a\u0001w\u0006Y\u0001O]8cC\nLG.\u001b;z\u0003\u0001\u0002&o\u001c2bE&d\u0017n\u001d;jG\u000ec\u0017m]:jM&\u001c\u0017\r^5p]6{G-\u001a7\u0011\u0005}a1#\u0002\u0007\u0002<\u0005\u0005\u0003c\u0001\u0015\u0002>%\u0019\u0011qH\u0015\u0003\r\u0005s\u0017PU3g!\rA\u00131I\u0005\u0004\u0003\u000bJ#\u0001D*fe&\fG.\u001b>bE2,GCAA\u001c\u0003}qwN]7bY&TX\rV8Qe>\u0014\u0017MY5mSRLWm]%o!2\f7-\u001a\u000b\u0005\u0003\u001b\n\u0019\u0006E\u0002)\u0003\u001fJ1!!\u0015*\u0005\u0011)f.\u001b;\t\u000f\u0005Uc\u00021\u0001\u0002X\u0005\ta\u000fE\u0002}\u00033J1!a\u0017~\u0005-!UM\\:f-\u0016\u001cGo\u001c:\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003C\u0002B!a\u0019\u0002n5\u0011\u0011Q\r\u0006\u0005\u0003O\nI'\u0001\u0003mC:<'BAA6\u0003\u0011Q\u0017M^1\n\t\u0005=\u0014Q\r\u0002\u0007\u001f\nTWm\u0019;")
public abstract class ProbabilisticClassificationModel<FeaturesType, M extends ProbabilisticClassificationModel<FeaturesType, M>>
extends ClassificationModel<FeaturesType, M>
implements ProbabilisticClassifierParams {
    private final DoubleArrayParam thresholds;
    private final Param<String> probabilityCol;

    public static void normalizeToProbabilitiesInPlace(DenseVector denseVector) {
        ProbabilisticClassificationModel$.MODULE$.normalizeToProbabilitiesInPlace(denseVector);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$classification$ProbabilisticClassifierParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ProbabilisticClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public double[] getThresholds() {
        return HasThresholds.getThresholds$(this);
    }

    @Override
    public final String getProbabilityCol() {
        return HasProbabilityCol.getProbabilityCol$(this);
    }

    @Override
    public DoubleArrayParam thresholds() {
        return this.thresholds;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasThresholds$_setter_$thresholds_$eq(DoubleArrayParam x$1) {
        this.thresholds = x$1;
    }

    @Override
    public final Param<String> probabilityCol() {
        return this.probabilityCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasProbabilityCol$_setter_$probabilityCol_$eq(Param<String> x$1) {
        this.probabilityCol = x$1;
    }

    public M setProbabilityCol(String value) {
        return (M)((ProbabilisticClassificationModel)this.set(this.probabilityCol(), value));
    }

    public M setThresholds(double[] value) {
        Predef$.MODULE$.require(value.length == this.numClasses(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(115).append(this.getClass().getSimpleName()).append(".setThresholds() called with non-matching numClasses and thresholds.length.").append(" numClasses=").append(this.numClasses()).append(", but thresholds has length ").append(value.length).toString());
        return (M)((ProbabilisticClassificationModel)this.set(this.thresholds(), value));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StructType transformSchema(StructType schema) {
        void var2_2;
        block0: {
            StructType outputSchema = super.transformSchema(schema);
            if (!new StringOps(Predef$.MODULE$.augmentString(this.$(this.probabilityCol()))).nonEmpty()) break block0;
            outputSchema = SchemaUtils$.MODULE$.updateAttributeGroupSize(outputSchema, this.$(this.probabilityCol()), this.numClasses());
        }
        return var2_2;
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        Dataset outputData;
        block10: {
            StructType outputSchema = this.transformSchema(dataset.schema(), true);
            if (this.isDefined(this.thresholds())) {
                Predef$.MODULE$.require(this.$(this.thresholds()).length == this.numClasses(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(111).append(this.getClass().getSimpleName()).append(".transform() called with non-matching numClasses and thresholds.length.").append(" numClasses=").append(this.numClasses()).append(", but thresholds has length ").append(this.$(this.thresholds()).length).toString());
            }
            outputData = dataset;
            int numColsOutput = 0;
            if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.rawPredictionCol()))).nonEmpty()) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
                public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator1$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator1$1(ProbabilisticClassificationModel $outer) {
                    }
                }
                UserDefinedFunction predictRawUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> this.predictRaw(features), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator1$1(null)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Any());
                outputData = outputData.withColumn(this.getRawPredictionCol(), predictRawUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.getFeaturesCol())})), outputSchema.apply(this.$(this.rawPredictionCol())).metadata());
                ++numColsOutput;
            }
            if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.probabilityCol()))).nonEmpty()) {
                Column column;
                if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.rawPredictionCol()))).nonEmpty()) {
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
                    JavaUniverse $u2 = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
                    public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator2$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                        }

                        public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator2$1(ProbabilisticClassificationModel $outer) {
                        }
                    }
                    public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator3$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                        }

                        public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator3$1(ProbabilisticClassificationModel $outer) {
                        }
                    }
                    column = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)rawPrediction -> this.raw2probability((Vector)rawPrediction), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator2$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator3$1(null))).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.rawPredictionCol()))}));
                } else {
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
                    public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator4$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                        }

                        public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator4$1(ProbabilisticClassificationModel $outer) {
                        }
                    }
                    UserDefinedFunction probabilityUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> this.predictProbability(features), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator4$1(null)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Any());
                    column = probabilityUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}));
                }
                Column probCol = column;
                outputData = outputData.withColumn(this.$(this.probabilityCol()), probCol, outputSchema.apply(this.$(this.probabilityCol())).metadata());
                ++numColsOutput;
            }
            if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.predictionCol()))).nonEmpty()) {
                Column column;
                if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.rawPredictionCol()))).nonEmpty()) {
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
                    public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator5$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                        }

                        public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator5$1(ProbabilisticClassificationModel $outer) {
                        }
                    }
                    column = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)rawPrediction -> BoxesRunTime.boxToDouble((double)this.raw2prediction(rawPrediction)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator5$1(null))).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.rawPredictionCol()))}));
                } else if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.probabilityCol()))).nonEmpty()) {
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
                    public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator6$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                        }

                        public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator6$1(ProbabilisticClassificationModel $outer) {
                        }
                    }
                    column = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)probability -> BoxesRunTime.boxToDouble((double)this.probability2prediction(probability)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator6$1(null))).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.probabilityCol()))}));
                } else {
                    UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> BoxesRunTime.boxToDouble((double)this.predict(features)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Any());
                    column = predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}));
                }
                Column predCol = column;
                outputData = outputData.withColumn(this.$(this.predictionCol()), predCol, outputSchema.apply(this.$(this.predictionCol())).metadata());
                ++numColsOutput;
            }
            if (numColsOutput != false) break block10;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(95).append(this.uid()).append(": ProbabilisticClassificationModel.transform() does nothing").append(" because no output columns were set.").toString());
        }
        return outputData.toDF();
    }

    public abstract Vector raw2probabilityInPlace(Vector var1);

    public Vector raw2probability(Vector rawPrediction) {
        Vector probs = rawPrediction.copy();
        return this.raw2probabilityInPlace(probs);
    }

    @Override
    public double raw2prediction(Vector rawPrediction) {
        return !this.isDefined(this.thresholds()) ? (double)rawPrediction.argmax() : this.probability2prediction(this.raw2probability(rawPrediction));
    }

    public Vector predictProbability(FeaturesType features) {
        Vector rawPreds = this.predictRaw(features);
        return this.raw2probabilityInPlace(rawPreds);
    }

    public double probability2prediction(Vector probability) {
        double d;
        if (!this.isDefined(this.thresholds())) {
            d = probability.argmax();
        } else {
            double[] thresholds = this.getThresholds();
            int argMax = 0;
            double max = Double.NEGATIVE_INFINITY;
            int probabilitySize = probability.size();
            for (int i = 0; i < probabilitySize; ++i) {
                double scaled = probability.apply(i) / thresholds[i];
                if (!(scaled > max)) continue;
                max = scaled;
                argMax = i;
            }
            d = argMax;
        }
        return d;
    }

    public ProbabilisticClassificationModel() {
        HasProbabilityCol.$init$(this);
        HasThresholds.$init$(this);
        ProbabilisticClassifierParams.$init$(this);
    }
}

