/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel$;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams;
import org.apache.spark.ml.classification.RandomForestClassificationModel$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.tree.DecisionTreeParams;
import org.apache.spark.ml.tree.EnsembleModelReadWrite$;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.RandomForestClassifierParams;
import org.apache.spark.ml.tree.RandomForestParams;
import org.apache.spark.ml.tree.TreeClassifierParams;
import org.apache.spark.ml.tree.TreeEnsembleClassifierParams;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.ml.tree.TreeEnsembleModel$;
import org.apache.spark.ml.tree.TreeEnsembleParams;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.RandomForestModel;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t-f\u0001\u0002\u0016,\u0001YB\u0001B\u0017\u0001\u0003\u0006\u0004%\te\u0017\u0005\ta\u0002\u0011\t\u0011)A\u00059\"A!\u000f\u0001BC\u0002\u0013%1\u000f\u0003\u0005x\u0001\t\u0005\t\u0015!\u0003u\u0011!A\bA!b\u0001\n\u0003J\b\"CA\u0001\u0001\t\u0005\t\u0015!\u0003{\u0011%\t)\u0001\u0001BC\u0002\u0013\u0005\u0013\u0010C\u0005\u0002\n\u0001\u0011\t\u0011)A\u0005u\"A\u0011Q\u0002\u0001\u0005\u00025\ny\u0001\u0003\u0005\u0002\u000e\u0001!\t!LA\u0010\u0011\u0019\t\u0019\u0003\u0001C!g\"Q\u0011q\u0006\u0001\t\u0006\u0004%I!!\r\t\u000f\u0005m\u0002\u0001\"\u0011\u00022!9\u0011q\b\u0001\u0005B\u0005\u0005\u0003bBA-\u0001\u0011\u0005\u00131\f\u0005\b\u0003?\u0003A\u0011IAQ\u0011\u001d\ti\u000b\u0001C)\u0003_Cq!!.\u0001\t\u0003\n9\fC\u0004\u0002L\u0002!\t%!4\t\u0015\u0005E\u0007\u0001#b\u0001\n\u0003\t\u0019\u000e\u0003\u0005\u0002X\u0002!\t!LAm\u0011\u001d\ti\u000f\u0001C!\u0003_<q!a@,\u0011\u0003\u0011\tA\u0002\u0004+W!\u0005!1\u0001\u0005\b\u0003\u001bAB\u0011\u0001B\t\u0011\u001d\u0011\u0019\u0002\u0007C!\u0005+AqAa\b\u0019\t\u0003\u0012\tCB\u0004\u0003*a\u0001\u0001Da\u000b\t\u0013\t5BD!A!\u0002\u0013\t\u0005bBA\u00079\u0011\u0005!q\u0006\u0005\b\u0005oaB\u0011\u000bB\u001d\r\u0019\u0011\u0019\u0005\u0007\u0003\u0003F!9\u0011Q\u0002\u0011\u0005\u0002\t\u001d\u0003\"\u0003B&A\t\u0007I\u0011\u0002B'\u0011!\u0011i\u0006\tQ\u0001\n\t=\u0003\"\u0003B0A\t\u0007I\u0011\u0002B'\u0011!\u0011\t\u0007\tQ\u0001\n\t=\u0003b\u0002B\u0010A\u0011\u0005#1\r\u0005\t\u0005OBB\u0011A\u0017\u0003j!Q!q\u0011\r\u0012\u0002\u0013\u0005QF!#\t\u0013\tu\u0005$!A\u0005\n\t}%a\b*b]\u0012|WNR8sKN$8\t\\1tg&4\u0017nY1uS>tWj\u001c3fY*\u0011A&L\u0001\u000fG2\f7o]5gS\u000e\fG/[8o\u0015\tqs&\u0001\u0002nY*\u0011\u0001'M\u0001\u0006gB\f'o\u001b\u0006\u0003eM\na!\u00199bG\",'\"\u0001\u001b\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u00019$\t\u0013(U!\u0011A\u0014hO!\u000e\u0003-J!AO\u0016\u0003AA\u0013xNY1cS2L7\u000f^5d\u00072\f7o]5gS\u000e\fG/[8o\u001b>$W\r\u001c\t\u0003y}j\u0011!\u0010\u0006\u0003}5\na\u0001\\5oC2<\u0017B\u0001!>\u0005\u00191Vm\u0019;peB\u0011\u0001\b\u0001\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000b6\nA\u0001\u001e:fK&\u0011q\t\u0012\u0002\u001d%\u0006tGm\\7G_J,7\u000f^\"mCN\u001c\u0018NZ5feB\u000b'/Y7t!\r\u0019\u0015jS\u0005\u0003\u0015\u0012\u0013\u0011\u0003\u0016:fK\u0016s7/Z7cY\u0016lu\u000eZ3m!\tAD*\u0003\u0002NW\tyB)Z2jg&|g\u000e\u0016:fK\u000ec\u0017m]:jM&\u001c\u0017\r^5p]6{G-\u001a7\u0011\u0005=\u0013V\"\u0001)\u000b\u0005Ek\u0013\u0001B;uS2L!a\u0015)\u0003\u00155cuK]5uC\ndW\r\u0005\u0002V16\taKC\u0001X\u0003\u0015\u00198-\u00197b\u0013\tIfK\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0002vS\u0012,\u0012\u0001\u0018\t\u0003;\u0012t!A\u00182\u0011\u0005}3V\"\u00011\u000b\u0005\u0005,\u0014A\u0002\u001fs_>$h(\u0003\u0002d-\u00061\u0001K]3eK\u001aL!!\u001a4\u0003\rM#(/\u001b8h\u0015\t\u0019g\u000bK\u0002\u0002Q:\u0004\"!\u001b7\u000e\u0003)T!a[\u0018\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002nU\n)1+\u001b8dK\u0006\nq.A\u00032]Ur\u0003'\u0001\u0003vS\u0012\u0004\u0003f\u0001\u0002i]\u00061q\f\u001e:fKN,\u0012\u0001\u001e\t\u0004+V\\\u0015B\u0001<W\u0005\u0015\t%O]1z\u0003\u001dyFO]3fg\u0002\n1B\\;n\r\u0016\fG/\u001e:fgV\t!\u0010\u0005\u0002Vw&\u0011AP\u0016\u0002\u0004\u0013:$\bfA\u0003i}\u0006\nq0A\u00032]Yr\u0003'\u0001\u0007ok64U-\u0019;ve\u0016\u001c\b\u0005K\u0002\u0007Qz\f!B\\;n\u00072\f7o]3tQ\r9\u0001N\\\u0001\f]Vl7\t\\1tg\u0016\u001c\b\u0005K\u0002\tQ:\fa\u0001P5oSRtD#C!\u0002\u0012\u0005U\u0011qCA\u000e\u0011\u0015Q\u0016\u00021\u0001]Q\u0011\t\t\u0002\u001b8\t\u000bIL\u0001\u0019\u0001;\t\u000baL\u0001\u0019\u0001>)\t\u0005]\u0001N \u0005\u0007\u0003\u000bI\u0001\u0019\u0001>)\t\u0005m\u0001N\u001c\u000b\b\u0003\u0006\u0005\u0012QEA\u0014\u0011\u0019\t\u0019C\u0003a\u0001i\u0006)AO]3fg\")\u0001P\u0003a\u0001u\"1\u0011Q\u0001\u0006A\u0002iDCa\u00035\u0002,\u0005\u0012\u0011QF\u0001\u0006c9\"d\u0006M\u0001\r?R\u0014X-Z,fS\u001eDGo]\u000b\u0003\u0003g\u0001B!V;\u00026A\u0019Q+a\u000e\n\u0007\u0005ebK\u0001\u0004E_V\u0014G.Z\u0001\fiJ,WmV3jO\"$8\u000f\u000b\u0003\u000eQ\u0006-\u0012a\u0004;sC:\u001chm\u001c:n'\u000eDW-\\1\u0015\t\u0005\r\u00131\u000b\t\u0005\u0003\u000b\ny%\u0004\u0002\u0002H)!\u0011\u0011JA&\u0003\u0015!\u0018\u0010]3t\u0015\r\tieL\u0001\u0004gFd\u0017\u0002BA)\u0003\u000f\u0012!b\u0015;sk\u000e$H+\u001f9f\u0011\u001d\t)F\u0004a\u0001\u0003\u0007\naa]2iK6\f\u0007\u0006\u0002\bi\u0003W\t\u0011\u0002\u001e:b]N4wN]7\u0015\t\u0005u\u00131\u0010\t\u0005\u0003?\n)H\u0004\u0003\u0002b\u0005Ed\u0002BA2\u0003_rA!!\u001a\u0002n9!\u0011qMA6\u001d\ry\u0016\u0011N\u0005\u0002i%\u0011!gM\u0005\u0003aEJ1!!\u00140\u0013\u0011\t\u0019(a\u0013\u0002\u000fA\f7m[1hK&!\u0011qOA=\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0003\u0002t\u0005-\u0003bBA?\u001f\u0001\u0007\u0011qP\u0001\bI\u0006$\u0018m]3ua\u0011\t\t)!$\u0011\r\u0005\r\u0015QQAE\u001b\t\tY%\u0003\u0003\u0002\b\u0006-#a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u0003\u0017\u000bi\t\u0004\u0001\u0005\u0019\u0005=\u00151PA\u0001\u0002\u0003\u0015\t!!%\u0003\u0007}##'\u0005\u0003\u0002\u0014\u0006e\u0005cA+\u0002\u0016&\u0019\u0011q\u0013,\u0003\u000f9{G\u000f[5oOB\u0019Q+a'\n\u0007\u0005ueKA\u0002B]f\f!\u0002\u001d:fI&\u001cGOU1x)\rY\u00141\u0015\u0005\u0007\u0003K\u0003\u0002\u0019A\u001e\u0002\u0011\u0019,\u0017\r^;sKNDC\u0001\u00055\u0002*\u0006\u0012\u00111V\u0001\u0006g9\u0002d\u0006M\u0001\u0017e\u0006<(\u0007\u001d:pE\u0006\u0014\u0017\u000e\\5us&s\u0007\u000b\\1dKR\u00191(!-\t\r\u0005M\u0016\u00031\u0001<\u00035\u0011\u0018m\u001e)sK\u0012L7\r^5p]\u0006!1m\u001c9z)\r\t\u0015\u0011\u0018\u0005\b\u0003w\u0013\u0002\u0019AA_\u0003\u0015)\u0007\u0010\u001e:b!\u0011\ty,!2\u000e\u0005\u0005\u0005'bAAb[\u0005)\u0001/\u0019:b[&!\u0011qYAa\u0005!\u0001\u0016M]1n\u001b\u0006\u0004\b\u0006\u0002\ni\u0003W\t\u0001\u0002^8TiJLgn\u001a\u000b\u00029\"\"1\u0003[A\u0016\u0003I1W-\u0019;ve\u0016LU\u000e]8si\u0006t7-Z:\u0016\u0003mB3\u0001\u00065o\u0003\u0015!xn\u00147e+\t\tY\u000e\u0005\u0003\u0002^\u0006%XBAAp\u0015\u0011\t\t/a9\u0002\u000b5|G-\u001a7\u000b\u0007\u0015\u000b)OC\u0002\u0002h>\nQ!\u001c7mS\nLA!a;\u0002`\n\t\"+\u00198e_64uN]3ti6{G-\u001a7\u0002\u000b]\u0014\u0018\u000e^3\u0016\u0005\u0005E\bcA(\u0002t&\u0019\u0011Q\u001f)\u0003\u00115cuK]5uKJDCA\u00065\u0002z\u0006\u0012\u00111`\u0001\u0006e9\u0002d\u0006\r\u0015\u0005\u0001!\fY#A\u0010SC:$w.\u001c$pe\u0016\u001cHo\u00117bgNLg-[2bi&|g.T8eK2\u0004\"\u0001\u000f\r\u0014\ra\u0011)Aa\u0003U!\r)&qA\u0005\u0004\u0005\u00131&AB!osJ+g\r\u0005\u0003P\u0005\u001b\t\u0015b\u0001B\b!\nQQ\n\u0014*fC\u0012\f'\r\\3\u0015\u0005\t\u0005\u0011\u0001\u0002:fC\u0012,\"Aa\u0006\u0011\t=\u0013I\"Q\u0005\u0004\u00057\u0001&\u0001C'M%\u0016\fG-\u001a:)\tiA\u0017\u0011`\u0001\u0005Y>\fG\rF\u0002B\u0005GAaA!\n\u001c\u0001\u0004a\u0016\u0001\u00029bi\"DCa\u00075\u0002z\n)#+\u00198e_64uN]3ti\u000ec\u0017m]:jM&\u001c\u0017\r^5p]6{G-\u001a7Xe&$XM]\n\u00049\u0005E\u0018\u0001C5ogR\fgnY3\u0015\t\tE\"Q\u0007\t\u0004\u0005gaR\"\u0001\r\t\r\t5b\u00041\u0001B\u0003!\u0019\u0018M^3J[BdG\u0003\u0002B\u001e\u0005\u0003\u00022!\u0016B\u001f\u0013\r\u0011yD\u0016\u0002\u0005+:LG\u000f\u0003\u0004\u0003&}\u0001\r\u0001\u0018\u0002&%\u0006tGm\\7G_J,7\u000f^\"mCN\u001c\u0018NZ5dCRLwN\\'pI\u0016d'+Z1eKJ\u001c2\u0001\tB\f)\t\u0011I\u0005E\u0002\u00034\u0001\n\u0011b\u00197bgNt\u0015-\\3\u0016\u0005\t=\u0003\u0003\u0002B)\u00057j!Aa\u0015\u000b\t\tU#qK\u0001\u0005Y\u0006twM\u0003\u0002\u0003Z\u0005!!.\u0019<b\u0013\r)'1K\u0001\u000bG2\f7o\u001d(b[\u0016\u0004\u0013!\u0004;sK\u0016\u001cE.Y:t\u001d\u0006lW-\u0001\bue\u0016,7\t\\1tg:\u000bW.\u001a\u0011\u0015\u0007\u0005\u0013)\u0007\u0003\u0004\u0003&\u0019\u0002\r\u0001X\u0001\bMJ|Wn\u00147e)-\t%1\u000eB8\u0005s\u0012\u0019I!\"\t\u000f\t5t\u00051\u0001\u0002\\\u0006Aq\u000e\u001c3N_\u0012,G\u000eC\u0004\u0003r\u001d\u0002\rAa\u001d\u0002\rA\f'/\u001a8u!\rA$QO\u0005\u0004\u0005oZ#A\u0006*b]\u0012|WNR8sKN$8\t\\1tg&4\u0017.\u001a:\t\u000f\tmt\u00051\u0001\u0003~\u0005\u00192-\u0019;fO>\u0014\u0018nY1m\r\u0016\fG/\u001e:fgB)QLa {u&\u0019!\u0011\u00114\u0003\u00075\u000b\u0007\u000f\u0003\u0004\u0002\u0006\u001d\u0002\rA\u001f\u0005\bq\u001e\u0002\n\u00111\u0001{\u0003E1'o\\7PY\u0012$C-\u001a4bk2$H%N\u000b\u0003\u0005\u0017S3A\u001fBGW\t\u0011y\t\u0005\u0003\u0003\u0012\neUB\u0001BJ\u0015\u0011\u0011)Ja&\u0002\u0013Ut7\r[3dW\u0016$'BA6W\u0013\u0011\u0011YJa%\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0006sK\u0006$'+Z:pYZ,GC\u0001BQ!\u0011\u0011\tFa)\n\t\t\u0015&1\u000b\u0002\u0007\u001f\nTWm\u0019;)\taA\u0017\u0011 \u0015\u0005/!\fI\u0010")
public class RandomForestClassificationModel
extends ProbabilisticClassificationModel<Vector, RandomForestClassificationModel>
implements RandomForestClassifierParams,
TreeEnsembleModel<DecisionTreeClassificationModel>,
MLWritable {
    private double[] _treeWeights;
    private Vector featureImportances;
    private final String uid;
    private final DecisionTreeClassificationModel[] _trees;
    private final int numFeatures;
    private final int numClasses;
    private int totalNumNodes;
    private final Param<String> impurity;
    private final IntParam numTrees;
    private final BooleanParam bootstrap;
    private final DoubleParam subsamplingRate;
    private final Param<String> featureSubsetStrategy;
    private final Param<String> leafCol;
    private final IntParam maxDepth;
    private final IntParam maxBins;
    private final IntParam minInstancesPerNode;
    private final DoubleParam minWeightFractionPerNode;
    private final DoubleParam minInfoGain;
    private final IntParam maxMemoryInMB;
    private final BooleanParam cacheNodeIds;
    private final Param<String> weightCol;
    private final LongParam seed;
    private final IntParam checkpointInterval;
    private volatile byte bitmap$0;

    public static RandomForestClassificationModel load(String string) {
        return RandomForestClassificationModel$.MODULE$.load(string);
    }

    public static MLReader<RandomForestClassificationModel> read() {
        return RandomForestClassificationModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public Vector javaTreeWeights() {
        return TreeEnsembleModel.javaTreeWeights$(this);
    }

    @Override
    public String toDebugString() {
        return TreeEnsembleModel.toDebugString$(this);
    }

    @Override
    public Vector predictLeaf(Vector features) {
        return TreeEnsembleModel.predictLeaf$(this, features);
    }

    @Override
    public StructField getLeafField(String leafCol) {
        return TreeEnsembleModel.getLeafField$(this, leafCol);
    }

    @Override
    public final String getImpurity() {
        return TreeClassifierParams.getImpurity$(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return TreeClassifierParams.getOldImpurity$(this);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$tree$TreeEnsembleClassifierParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ProbabilisticClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return TreeEnsembleClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final int getNumTrees() {
        return RandomForestParams.getNumTrees$(this);
    }

    @Override
    public final boolean getBootstrap() {
        return RandomForestParams.getBootstrap$(this);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$TreeEnsembleParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final double getSubsamplingRate() {
        return TreeEnsembleParams.getSubsamplingRate$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final String getFeatureSubsetStrategy() {
        return TreeEnsembleParams.getFeatureSubsetStrategy$(this);
    }

    @Override
    public final DecisionTreeParams setLeafCol(String value) {
        return DecisionTreeParams.setLeafCol$(this, value);
    }

    @Override
    public final String getLeafCol() {
        return DecisionTreeParams.getLeafCol$(this);
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams.getMaxDepth$(this);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams.getMaxBins$(this);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams.getMinInstancesPerNode$(this);
    }

    @Override
    public final double getMinWeightFractionPerNode() {
        return DecisionTreeParams.getMinWeightFractionPerNode$(this);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams.getMinInfoGain$(this);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams.getMaxMemoryInMB$(this);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams.getCacheNodeIds$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval.getCheckpointInterval$(this);
    }

    private int totalNumNodes$lzycompute() {
        RandomForestClassificationModel randomForestClassificationModel = this;
        synchronized (randomForestClassificationModel) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.totalNumNodes = TreeEnsembleModel.totalNumNodes$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.totalNumNodes;
    }

    @Override
    public int totalNumNodes() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.totalNumNodes$lzycompute() : this.totalNumNodes;
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeClassifierParams$_setter_$impurity_$eq(Param<String> x$1) {
        this.impurity = x$1;
    }

    @Override
    public final IntParam numTrees() {
        return this.numTrees;
    }

    @Override
    public final BooleanParam bootstrap() {
        return this.bootstrap;
    }

    @Override
    public final void org$apache$spark$ml$tree$RandomForestParams$_setter_$numTrees_$eq(IntParam x$1) {
        this.numTrees = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$RandomForestParams$_setter_$bootstrap_$eq(BooleanParam x$1) {
        this.bootstrap = x$1;
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public final Param<String> featureSubsetStrategy() {
        return this.featureSubsetStrategy;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$featureSubsetStrategy_$eq(Param<String> x$1) {
        this.featureSubsetStrategy = x$1;
    }

    @Override
    public final Param<String> leafCol() {
        return this.leafCol;
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minWeightFractionPerNode() {
        return this.minWeightFractionPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$leafCol_$eq(Param<String> x$1) {
        this.leafCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minWeightFractionPerNode_$eq(DoubleParam x$1) {
        this.minWeightFractionPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    private DecisionTreeClassificationModel[] _trees() {
        return this._trees;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    public DecisionTreeClassificationModel[] trees() {
        return this._trees();
    }

    private double[] _treeWeights$lzycompute() {
        RandomForestClassificationModel randomForestClassificationModel = this;
        synchronized (randomForestClassificationModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this._treeWeights = (double[])Array$.MODULE$.fill(this._trees().length, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0, ClassTag$.MODULE$.Double());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this._treeWeights;
    }

    private double[] _treeWeights() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this._treeWeights$lzycompute() : this._treeWeights;
    }

    @Override
    public double[] treeWeights() {
        return this._treeWeights();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StructType transformSchema(StructType schema) {
        void var2_2;
        block0: {
            StructType outputSchema = super.transformSchema(schema);
            if (!new StringOps(Predef$.MODULE$.augmentString(this.$(this.leafCol()))).nonEmpty()) break block0;
            outputSchema = SchemaUtils$.MODULE$.updateField(outputSchema, this.getLeafField(this.$(this.leafCol())), SchemaUtils$.MODULE$.updateField$default$3());
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        Dataset dataset2;
        StructType outputSchema = this.transformSchema(dataset.schema(), true);
        Dataset<Row> outputData = super.transform(dataset);
        if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.leafCol()))).nonEmpty()) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(RandomForestClassificationModel.class.getClassLoader());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(RandomForestClassificationModel.class.getClassLoader());
            public final class Org_apache_spark_ml_classification_RandomForestClassificationModel$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_classification_RandomForestClassificationModel$$typecreator1$1(RandomForestClassificationModel $outer) {
                }
            }
            public final class Org_apache_spark_ml_classification_RandomForestClassificationModel$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_classification_RandomForestClassificationModel$$typecreator2$1(RandomForestClassificationModel $outer) {
                }
            }
            UserDefinedFunction leafUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> this.predictLeaf((Vector)features), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_RandomForestClassificationModel$$typecreator1$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_classification_RandomForestClassificationModel$$typecreator2$1(null)));
            dataset2 = outputData.withColumn(this.$(this.leafCol()), leafUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})), outputSchema.apply(this.$(this.leafCol())).metadata());
        } else {
            void var3_3;
            dataset2 = var3_3;
        }
        return dataset2;
    }

    @Override
    public Vector predictRaw(Vector features) {
        double[] votes = (double[])Array$.MODULE$.ofDim(this.numClasses(), ClassTag$.MODULE$.Double());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this._trees())).view().foreach((Function1 & Serializable & scala.Serializable)tree -> {
            RandomForestClassificationModel.$anonfun$predictRaw$1(this, features, votes, tree);
            return BoxedUnit.UNIT;
        });
        return Vectors$.MODULE$.dense(votes);
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        Vector vector = rawPrediction;
        if (!(vector instanceof DenseVector)) {
            if (vector instanceof SparseVector) {
                throw new RuntimeException("Unexpected error in RandomForestClassificationModel: raw2probabilityInPlace encountered SparseVector");
            }
            throw new MatchError((Object)vector);
        }
        DenseVector denseVector = (DenseVector)vector;
        ProbabilisticClassificationModel$.MODULE$.normalizeToProbabilitiesInPlace(denseVector);
        DenseVector denseVector2 = denseVector;
        return denseVector2;
    }

    @Override
    public RandomForestClassificationModel copy(ParamMap extra) {
        return (RandomForestClassificationModel)((Model)this.copyValues(new RandomForestClassificationModel(this.uid(), this._trees(), this.numFeatures(), this.numClasses()), extra)).setParent(this.parent());
    }

    @Override
    public String toString() {
        return new StringBuilder(75).append("RandomForestClassificationModel: uid=").append(this.uid()).append(", numTrees=").append(this.getNumTrees()).append(", numClasses=").append(this.numClasses()).append(", ").append("numFeatures=").append(this.numFeatures()).toString();
    }

    private Vector featureImportances$lzycompute() {
        RandomForestClassificationModel randomForestClassificationModel = this;
        synchronized (randomForestClassificationModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.featureImportances = TreeEnsembleModel$.MODULE$.featureImportances(this.trees(), this.numFeatures(), TreeEnsembleModel$.MODULE$.featureImportances$default$3());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.featureImportances;
    }

    public Vector featureImportances() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.featureImportances$lzycompute() : this.featureImportances;
    }

    public RandomForestModel toOld() {
        return new RandomForestModel(Algo$.MODULE$.Classification(), (DecisionTreeModel[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this._trees())).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toOld(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeModel.class))));
    }

    @Override
    public MLWriter write() {
        return new RandomForestClassificationModelWriter(this);
    }

    public static final /* synthetic */ void $anonfun$predictRaw$1(RandomForestClassificationModel $this, Vector features$1, double[] votes$1, DecisionTreeClassificationModel tree) {
        double[] classCounts = tree.rootNode().predictImpl(features$1).impurityStats().stats();
        double total = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(classCounts)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        if (total != 0.0) {
            for (int i = 0; i < $this.numClasses(); ++i) {
                int n = i;
                votes$1[n] = votes$1[n] + classCounts[i] / total;
            }
        }
    }

    public RandomForestClassificationModel(String uid, DecisionTreeClassificationModel[] _trees, int numFeatures, int numClasses) {
        this.uid = uid;
        this._trees = _trees;
        this.numFeatures = numFeatures;
        this.numClasses = numClasses;
        HasCheckpointInterval.$init$(this);
        HasSeed.$init$(this);
        HasWeightCol.$init$(this);
        DecisionTreeParams.$init$(this);
        TreeEnsembleParams.$init$(this);
        RandomForestParams.$init$(this);
        TreeEnsembleClassifierParams.$init$(this);
        TreeClassifierParams.$init$(this);
        TreeEnsembleModel.$init$(this);
        MLWritable.$init$(this);
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])_trees)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "RandomForestClassificationModel requires at least 1 tree.");
    }

    public RandomForestClassificationModel(DecisionTreeClassificationModel[] trees, int numFeatures, int numClasses) {
        this(Identifiable$.MODULE$.randomUID("rfc"), trees, numFeatures, numClasses);
    }

    public static class RandomForestClassificationModelReader
    extends MLReader<RandomForestClassificationModel> {
        private final String className = RandomForestClassificationModel.class.getName();
        private final String treeClassName = DecisionTreeClassificationModel.class.getName();

        private String className() {
            return this.className;
        }

        private String treeClassName() {
            return this.treeClassName;
        }

        @Override
        public RandomForestClassificationModel load(String path) {
            DefaultParamsReader.Metadata metadata;
            Tuple2[] treesData;
            DefaultFormats$ format;
            block3: {
                Tuple3<DefaultParamsReader.Metadata, Tuple2<DefaultParamsReader.Metadata, Node>[], double[]> tuple3;
                block2: {
                    format = DefaultFormats$.MODULE$;
                    tuple3 = EnsembleModelReadWrite$.MODULE$.loadImpl(path, this.sparkSession(), this.className(), this.treeClassName());
                    if (tuple3 == null) break block2;
                    DefaultParamsReader.Metadata metadata2 = (DefaultParamsReader.Metadata)tuple3._1();
                    treesData = (Tuple2[])tuple3._2();
                    if (metadata2 == null) break block2;
                    metadata = metadata2;
                    if (treesData != null) break block3;
                }
                throw new MatchError(tuple3);
            }
            Tuple2[] tuple2Array = treesData;
            Tuple2 tuple2 = new Tuple2((Object)metadata, (Object)tuple2Array);
            Tuple2 tuple22 = tuple2;
            DefaultParamsReader.Metadata metadata3 = (DefaultParamsReader.Metadata)tuple22._1();
            Tuple2[] treesData2 = (Tuple2[])tuple22._2();
            int numFeatures = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash("numFeatures")).extract((Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            int numClasses = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash("numClasses")).extract((Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            int numTrees = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash("numTrees")).extract((Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            DecisionTreeClassificationModel[] trees = (DecisionTreeClassificationModel[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])treesData2)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                DefaultParamsReader.Metadata treeMetadata = (DefaultParamsReader.Metadata)tuple2._1();
                Node root = (Node)tuple2._2();
                DecisionTreeClassificationModel tree = new DecisionTreeClassificationModel(treeMetadata.uid(), root, numFeatures, numClasses);
                treeMetadata.getAndSetParams(tree, treeMetadata.getAndSetParams$default$2());
                DecisionTreeClassificationModel decisionTreeClassificationModel = tree;
                return decisionTreeClassificationModel;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeClassificationModel.class)));
            Predef$.MODULE$.require(numTrees == trees.length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(88).append("RandomForestClassificationModel.load expected ").append(numTrees).append(" trees based on metadata but found ").append(trees.length).append(" trees.").toString());
            RandomForestClassificationModel model = new RandomForestClassificationModel(metadata3.uid(), trees, numFeatures, numClasses);
            metadata3.getAndSetParams(model, metadata3.getAndSetParams$default$2());
            return model;
        }
    }

    public static class RandomForestClassificationModelWriter
    extends MLWriter {
        private final RandomForestClassificationModel instance;

        @Override
        public void saveImpl(String path) {
            JsonAST.JObject extraMetadata = JsonDSL$.MODULE$.map2jvalue((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numFeatures"), (Object)BoxesRunTime.boxToInteger((int)this.instance.numFeatures())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numClasses"), (Object)BoxesRunTime.boxToInteger((int)this.instance.numClasses())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numTrees"), (Object)BoxesRunTime.boxToInteger((int)this.instance.getNumTrees()))})), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)));
            EnsembleModelReadWrite$.MODULE$.saveImpl(this.instance, path, this.sparkSession(), extraMetadata);
        }

        public RandomForestClassificationModelWriter(RandomForestClassificationModel instance) {
            this.instance = instance;
        }
    }
}

