/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.SeqView;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.IndexedSeqView$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r4Aa\u0002\u0005\u0001'!Aa\u0004\u0001BC\u0002\u0013\u0005s\u0004\u0003\u00056\u0001\t\u0005\t\u0015!\u0003!\u0011!9\u0004A!b\u0001\n\u0003A\u0004\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B\u001d\t\u000b\u0001\u0003A\u0011A!\t\u000b!\u0003A\u0011A%\u0003)M#(/Z1nS:<7*T3b]Nlu\u000eZ3m\u0015\tI!\"\u0001\u0006dYV\u001cH/\u001a:j]\u001eT!a\u0003\u0007\u0002\u000b5dG.\u001b2\u000b\u00055q\u0011!B:qCJ\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001aE\u0002\u0001)a\u0001\"!\u0006\f\u000e\u0003!I!a\u0006\u0005\u0003\u0017-kU-\u00198t\u001b>$W\r\u001c\t\u00033qi\u0011A\u0007\u0006\u000371\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003;i\u0011q\u0001T8hO&tw-\u0001\bdYV\u001cH/\u001a:DK:$XM]:\u0016\u0003\u0001\u00022!\t\u0013'\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#!B!se\u0006L\bCA\u0014+\u001b\u0005A#BA\u0015\u000b\u0003\u0019a\u0017N\\1mO&\u00111\u0006\u000b\u0002\u0007-\u0016\u001cGo\u001c:)\u0007\u0005i3\u0007\u0005\u0002/c5\tqF\u0003\u00021\u0019\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Iz#!B*j]\u000e,\u0017%\u0001\u001b\u0002\u000bEr#G\f\u0019\u0002\u001f\rdWo\u001d;fe\u000e+g\u000e^3sg\u0002B3AA\u00174\u00039\u0019G.^:uKJ<V-[4iiN,\u0012!\u000f\t\u0004C\u0011R\u0004CA\u0011<\u0013\ta$E\u0001\u0004E_V\u0014G.\u001a\u0015\u0004\u00075\u001a\u0014aD2mkN$XM],fS\u001eDGo\u001d\u0011)\u0007\u0011i3'\u0001\u0004=S:LGO\u0010\u000b\u0004\u0005\u000e+\u0005CA\u000b\u0001\u0011\u0015qR\u00011\u0001!Q\r\u0019Uf\r\u0005\u0006o\u0015\u0001\r!\u000f\u0015\u0004\u000b6\u001a\u0004fA\u0003.g\u00051Q\u000f\u001d3bi\u0016$BA\u0011&S)\")1J\u0002a\u0001\u0019\u0006!A-\u0019;b!\ri\u0005KJ\u0007\u0002\u001d*\u0011q\nD\u0001\u0004e\u0012$\u0017BA)O\u0005\r\u0011F\t\u0012\u0005\u0006'\u001a\u0001\rAO\u0001\fI\u0016\u001c\u0017-\u001f$bGR|'\u000fC\u0003V\r\u0001\u0007a+\u0001\u0005uS6,WK\\5u!\t9fL\u0004\u0002Y9B\u0011\u0011LI\u0007\u00025*\u00111LE\u0001\u0007yI|w\u000e\u001e \n\u0005u\u0013\u0013A\u0002)sK\u0012,g-\u0003\u0002`A\n11\u000b\u001e:j]\u001eT!!\u0018\u0012)\u0007\u0019i3\u0007K\u0002\u0001[M\u0002")
public class StreamingKMeansModel
extends KMeansModel
implements Logging {
    private final Vector[] clusterCenters;
    private final double[] clusterWeights;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public Vector[] clusterCenters() {
        return this.clusterCenters;
    }

    public double[] clusterWeights() {
        return this.clusterWeights;
    }

    public StreamingKMeansModel update(RDD<Vector> data, double decayFactor, String timeUnit) {
        double d;
        RDD closest = data.map((Function1 & Serializable & scala.Serializable)point -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)this.predict((Vector)point)), (Object)new Tuple2(point, (Object)BoxesRunTime.boxToLong((long)1L))), ClassTag$.MODULE$.apply(Tuple2.class));
        Function2 & Serializable & scala.Serializable mergeContribs = (Function2 & Serializable & scala.Serializable)(p1, p2) -> {
            BLAS$.MODULE$.axpy(1.0, (Vector)p2._1(), (Vector)p1._1());
            return new Tuple2(p1._1(), (Object)BoxesRunTime.boxToLong((long)(p1._2$mcJ$sp() + p2._2$mcJ$sp())));
        };
        int dim = this.clusterCenters()[0].size();
        Tuple2[] pointStats = (Tuple2[])RDD$.MODULE$.rddToPairRDDFunctions(closest, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).aggregateByKey((Object)new Tuple2((Object)Vectors$.MODULE$.zeros(dim), (Object)BoxesRunTime.boxToLong((long)0L)), (Function2)mergeContribs, (Function2)mergeContribs, ClassTag$.MODULE$.apply(Tuple2.class)).collect();
        String string = timeUnit;
        if ("batches".equals(string)) {
            d = decayFactor;
        } else if ("points".equals(string)) {
            long numNewPoints = BoxesRunTime.unboxToLong((Object)((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pointStats)).view().map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToLong((long)StreamingKMeansModel.$anonfun$update$3(x0$1)), IndexedSeqView$.MODULE$.arrCanBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            d = package$.MODULE$.pow(decayFactor, (double)numNewPoints);
        } else {
            throw new MatchError((Object)string);
        }
        double discount = d;
        BLAS$.MODULE$.scal(discount, Vectors$.MODULE$.dense(this.clusterWeights()));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pointStats)).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            StreamingKMeansModel.$anonfun$update$4(this, x0$2);
            return BoxedUnit.UNIT;
        });
        SeqView weightsWithIndex = (SeqView)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.clusterWeights())).view().zipWithIndex(IndexedSeqView$.MODULE$.arrCanBuildFrom());
        Tuple2 tuple2 = (Tuple2)weightsWithIndex.maxBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)x$1._1$mcD$sp()), (Ordering)Ordering.Double$.MODULE$);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double maxWeight = tuple2._1$mcD$sp();
        int largest = tuple2._2$mcI$sp();
        Tuple2.mcDI.sp sp2 = new Tuple2.mcDI.sp(maxWeight, largest);
        Tuple2.mcDI.sp sp3 = sp2;
        double maxWeight2 = sp3._1$mcD$sp();
        int largest2 = sp3._2$mcI$sp();
        Tuple2 tuple22 = (Tuple2)weightsWithIndex.minBy((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToDouble((double)x$3._1$mcD$sp()), (Ordering)Ordering.Double$.MODULE$);
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        double minWeight = tuple22._1$mcD$sp();
        int smallest = tuple22._2$mcI$sp();
        Tuple2.mcDI.sp sp4 = new Tuple2.mcDI.sp(minWeight, smallest);
        Tuple2.mcDI.sp sp5 = sp4;
        double minWeight2 = sp5._1$mcD$sp();
        int smallest2 = sp5._2$mcI$sp();
        if (minWeight2 < 1.0E-8 * maxWeight2) {
            double weight;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Cluster ").append(smallest2).append(" is dying. Split the largest cluster ").append(largest2).append(" into two.").toString());
            this.clusterWeights()[largest2] = weight = (maxWeight2 + minWeight2) / 2.0;
            this.clusterWeights()[smallest2] = weight;
            Vector largestClusterCenter = this.clusterCenters()[largest2];
            Vector smallestClusterCenter = this.clusterCenters()[smallest2];
            for (int j = 0; j < dim; ++j) {
                double x = largestClusterCenter.apply(j);
                double p = 1.0E-14 * package$.MODULE$.max(package$.MODULE$.abs(x), 1.0);
                largestClusterCenter.asBreeze().update$mcID$sp(j, x + p);
                smallestClusterCenter.asBreeze().update$mcID$sp(j, x - p);
            }
        }
        return new StreamingKMeansModel(this.clusterCenters(), this.clusterWeights());
    }

    public static final /* synthetic */ long $anonfun$update$3(Tuple2 x0$1) {
        long n;
        Tuple2 tuple2;
        Tuple2 tuple22 = x0$1;
        if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
            throw new MatchError((Object)tuple22);
        }
        long l = n = tuple2._2$mcJ$sp();
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$update$4(StreamingKMeansModel $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        int label = tuple2._1$mcI$sp();
        Tuple2 tuple22 = (Tuple2)tuple2._2();
        if (tuple22 == null) throw new MatchError((Object)tuple2);
        Vector sum = (Vector)tuple22._1();
        long count = tuple22._2$mcJ$sp();
        Vector centroid = $this.clusterCenters()[label];
        double updatedWeight = $this.clusterWeights()[label] + (double)count;
        double lambda = (double)count / package$.MODULE$.max(updatedWeight, 1.0E-16);
        $this.clusterWeights()[label] = updatedWeight;
        BLAS$.MODULE$.scal(1.0 - lambda, centroid);
        BLAS$.MODULE$.axpy(lambda / (double)count, sum, centroid);
        int n = $this.clusterCenters()[label].size();
        switch (n) {
            default: 
        }
        String display = n > 100 ? new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(centroid.toArray())).take(100))).mkString("[", ",", "...") : new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(centroid.toArray())).mkString("[", ",", "]");
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Cluster ").append(label).append(" updated with weight ").append(updatedWeight).append(" and centroid: ").append(display).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public StreamingKMeansModel(Vector[] clusterCenters, double[] clusterWeights) {
        this.clusterCenters = clusterCenters;
        this.clusterWeights = clusterWeights;
        super(clusterCenters);
        Logging.$init$((Logging)this);
    }
}

