/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import breeze.storage.Zero;
import java.io.Serializable;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.feature.IDFModel;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.DenseVector$;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.SparseVector$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Tuple3;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001B\r\u001b\u0001\u0015B\u0001\u0002\f\u0001\u0003\u0006\u0004%\t!\f\u0005\tu\u0001\u0011\t\u0011)A\u0005]!)A\b\u0001C\u0001{!)A\b\u0001C\u0001\u0007\")q\t\u0001C\u0001\u0011\")q\t\u0001C\u00017\u001e)qM\u0007E\u0005Q\u001a)\u0011D\u0007E\u0005S\")A\b\u0003C\u0001U\u001a!1\u000e\u0003\u0001m\u0011!a#B!b\u0001\n\u0003i\u0003\u0002\u0003\u001e\u000b\u0005\u0003\u0005\u000b\u0011\u0002\u0018\t\u000bqRA\u0011\u00019\t\u000fQT\u0001\u0019!C\u0005k\"9\u0011P\u0003a\u0001\n\u0013Q\bbBA\u0001\u0015\u0001\u0006KA\u001e\u0005\f\u0003\u0007Q\u0001\u0019!a\u0001\n\u0013\t)\u0001C\u0006\u0002\u0016)\u0001\r\u00111A\u0005\n\u0005]\u0001bCA\u000e\u0015\u0001\u0007\t\u0011)Q\u0005\u0003\u000fAa\u0001\u0010\u0006\u0005\u0002\u0005u\u0001bBA\u0010\u0015\u0011\u0005\u0011\u0011\u0005\u0005\b\u0003SQA\u0011AA\u0016\u0011\u001d\t\tD\u0003C\u0005\u0003gAq!a\u000f\u000b\t\u0003\tiDA\u0002J\t\u001aS!a\u0007\u000f\u0002\u000f\u0019,\u0017\r^;sK*\u0011QDH\u0001\u0006[2d\u0017N\u0019\u0006\u0003?\u0001\nQa\u001d9be.T!!\t\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0013aA8sO\u000e\u00011C\u0001\u0001'!\t9#&D\u0001)\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016)\u0005\u0019\te.\u001f*fM\u0006QQ.\u001b8E_\u000e4%/Z9\u0016\u00039\u0002\"aJ\u0018\n\u0005AB#aA%oi\"\u001a\u0011A\r\u001d\u0011\u0005M2T\"\u0001\u001b\u000b\u0005Ur\u0012AC1o]>$\u0018\r^5p]&\u0011q\u0007\u000e\u0002\u0006'&t7-Z\u0011\u0002s\u0005)\u0011G\f\u001a/a\u0005YQ.\u001b8E_\u000e4%/Z9!Q\r\u0011!\u0007O\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005y\u0002\u0005CA \u0001\u001b\u0005Q\u0002\"\u0002\u0017\u0004\u0001\u0004q\u0003f\u0001!3q!\u001a1A\r\u001d\u0015\u0003yB3\u0001\u0002\u001aFC\u00051\u0015!B\u0019/c9\u0002\u0014a\u00014jiR\u0011\u0011\n\u0014\t\u0003\u007f)K!a\u0013\u000e\u0003\u0011%#e)T8eK2DQ!T\u0003A\u00029\u000bq\u0001Z1uCN,G\u000fE\u0002P%Rk\u0011\u0001\u0015\u0006\u0003#z\t1A\u001d3e\u0013\t\u0019\u0006KA\u0002S\t\u0012\u0003\"!\u0016-\u000e\u0003YS!a\u0016\u000f\u0002\r1Lg.\u00197h\u0013\tIfK\u0001\u0004WK\u000e$xN\u001d\u0015\u0004\u000bI*ECA%]\u0011\u0015ie\u00011\u0001^!\rq6\rV\u0007\u0002?*\u0011\u0001-Y\u0001\u0005U\u00064\u0018M\u0003\u0002c=\u0005\u0019\u0011\r]5\n\u0005\u0011|&a\u0002&bm\u0006\u0014F\t\u0012\u0015\u0004\rI*\u0005f\u0001\u00013\u000b\u0006\u0019\u0011\n\u0012$\u0011\u0005}B1C\u0001\u0005')\u0005A'a\u0007#pGVlWM\u001c;Ge\u0016\fX/\u001a8ds\u0006;wM]3hCR|'oE\u0002\u000bM5\u0004\"a\n8\n\u0005=D#\u0001D*fe&\fG.\u001b>bE2,GCA9t!\t\u0011(\"D\u0001\t\u0011\u0015aS\u00021\u0001/\u0003\u0005iW#\u0001<\u0011\u0005\u001d:\u0018B\u0001=)\u0005\u0011auN\\4\u0002\u000b5|F%Z9\u0015\u0005mt\bCA\u0014}\u0013\ti\bF\u0001\u0003V]&$\bbB@\u0010\u0003\u0003\u0005\rA^\u0001\u0004q\u0012\n\u0014AA7!\u0003\t!g-\u0006\u0002\u0002\bA)\u0011\u0011BA\tm6\u0011\u00111\u0002\u0006\u0004/\u00065!BAA\b\u0003\u0019\u0011'/Z3{K&!\u00111CA\u0006\u0005-!UM\\:f-\u0016\u001cGo\u001c:\u0002\r\u00114w\fJ3r)\rY\u0018\u0011\u0004\u0005\t\u007fJ\t\t\u00111\u0001\u0002\b\u0005\u0019AM\u001a\u0011\u0015\u0003E\f1!\u00193e)\u0011\t\u0019#!\n\u000e\u0003)Aa!a\n\u0016\u0001\u0004!\u0016a\u00013pG\u0006)Q.\u001a:hKR!\u00111EA\u0017\u0011\u0019\tyC\u0006a\u0001c\u0006)q\u000e\u001e5fe\u00069\u0011n]#naRLXCAA\u001b!\r9\u0013qG\u0005\u0004\u0003sA#a\u0002\"p_2,\u0017M\\\u0001\u0004S\u00124GCAA !\u001d9\u0013\u0011\t+\u0002FYL1!a\u0011)\u0005\u0019!V\u000f\u001d7fgA!q%a\u0012w\u0013\r\tI\u0005\u000b\u0002\u0006\u0003J\u0014\u0018-\u001f")
public class IDF {
    private final int minDocFreq;

    public int minDocFreq() {
        return this.minDocFreq;
    }

    public IDFModel fit(RDD<Vector> dataset) {
        Vector vector;
        long numDocs;
        long[] docFreq;
        block3: {
            Tuple3<Vector, long[], Object> tuple3;
            block2: {
                int x$4;
                Function2 & Serializable & scala.Serializable x$3;
                Function2 & Serializable & scala.Serializable x$2;
                DocumentFrequencyAggregator x$1 = new DocumentFrequencyAggregator(this.minDocFreq());
                tuple3 = ((DocumentFrequencyAggregator)dataset.treeAggregate((Object)x$1, (Function2)(x$2 = (Function2 & Serializable & scala.Serializable)(df, v) -> df.add((Vector)v)), (Function2)(x$3 = (Function2 & Serializable & scala.Serializable)(df1, df2) -> df1.merge((DocumentFrequencyAggregator)df2)), x$4 = dataset.treeAggregate$default$4((Object)x$1), ClassTag$.MODULE$.apply(DocumentFrequencyAggregator.class))).idf();
                if (tuple3 == null) break block2;
                Vector idf = (Vector)tuple3._1();
                docFreq = (long[])tuple3._2();
                numDocs = BoxesRunTime.unboxToLong((Object)tuple3._3());
                if (idf == null) break block2;
                vector = idf;
                if (docFreq != null) break block3;
            }
            throw new MatchError(tuple3);
        }
        long[] lArray = docFreq;
        long l = numDocs;
        Tuple3 tuple3 = new Tuple3((Object)vector, (Object)lArray, (Object)BoxesRunTime.boxToLong((long)l));
        Tuple3 tuple32 = tuple3;
        Vector idf = (Vector)tuple32._1();
        long[] docFreq2 = (long[])tuple32._2();
        long numDocs2 = BoxesRunTime.unboxToLong((Object)tuple32._3());
        return new IDFModel(idf, docFreq2, numDocs2);
    }

    public IDFModel fit(JavaRDD<Vector> dataset) {
        return this.fit((RDD<Vector>)dataset.rdd());
    }

    public IDF(int minDocFreq) {
        this.minDocFreq = minDocFreq;
    }

    public IDF() {
        this(0);
    }

    public static class DocumentFrequencyAggregator
    implements scala.Serializable {
        private final int minDocFreq;
        private long m;
        private breeze.linalg.DenseVector<Object> df;

        public int minDocFreq() {
            return this.minDocFreq;
        }

        private long m() {
            return this.m;
        }

        private void m_$eq(long x$1) {
            this.m = x$1;
        }

        private breeze.linalg.DenseVector<Object> df() {
            return this.df;
        }

        private void df_$eq(breeze.linalg.DenseVector<Object> x$1) {
            this.df = x$1;
        }

        public DocumentFrequencyAggregator add(Vector doc) {
            DenseVector denseVector;
            Option<double[]> option;
            SparseVector sparseVector;
            Option<Tuple3<Object, int[], double[]>> option2;
            Vector vector;
            if (this.isEmpty()) {
                this.df_$eq((breeze.linalg.DenseVector<Object>)breeze.linalg.DenseVector$.MODULE$.zeros$mJc$sp(doc.size(), ClassTag$.MODULE$.Long(), (Zero)Zero.LongZero$.MODULE$));
            }
            if ((vector = doc) instanceof SparseVector && !(option2 = SparseVector$.MODULE$.unapply(sparseVector = (SparseVector)vector)).isEmpty()) {
                int[] indices = (int[])((Tuple3)option2.get())._2();
                double[] values = (double[])((Tuple3)option2.get())._3();
                int nnz = indices.length;
                for (int k = 0; k < nnz; ++k) {
                    if (!(values[k] > 0.0)) continue;
                    breeze.linalg.DenseVector<Object> denseVector2 = this.df();
                    int n = indices[k];
                    denseVector2.update$mcJ$sp(n, denseVector2.apply$mcJ$sp(n) + 1L);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (vector instanceof DenseVector && !(option = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector)).isEmpty()) {
                double[] values = (double[])option.get();
                int n = values.length;
                for (int j = 0; j < n; ++j) {
                    if (!(values[j] > 0.0)) continue;
                    breeze.linalg.DenseVector<Object> denseVector3 = this.df();
                    int n2 = j;
                    denseVector3.update$mcJ$sp(n2, denseVector3.apply$mcJ$sp(n2) + 1L);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new UnsupportedOperationException(new StringBuilder(53).append("Only sparse and dense vectors are supported but got ").append(vector.getClass()).append(".").toString());
            }
            this.m_$eq(this.m() + 1L);
            return this;
        }

        public DocumentFrequencyAggregator merge(DocumentFrequencyAggregator other) {
            Object object;
            if (!other.isEmpty()) {
                this.m_$eq(this.m() + other.m());
                if (this.df() == null) {
                    this.df_$eq((breeze.linalg.DenseVector<Object>)other.df().copy$mcJ$sp());
                    object = BoxedUnit.UNIT;
                } else {
                    object = this.df().$plus$eq(other.df(), breeze.linalg.DenseVector$.MODULE$.dv_dv_UpdateOp_Long_OpAdd());
                }
            } else {
                object = BoxedUnit.UNIT;
            }
            return this;
        }

        private boolean isEmpty() {
            return this.m() == 0L;
        }

        public Tuple3<Vector, long[], Object> idf() {
            if (this.isEmpty()) {
                throw new IllegalStateException("Haven't seen any document yet.");
            }
            int n = this.df().length();
            double[] inv = new double[n];
            long[] dfv = new long[n];
            for (int j = 0; j < n; ++j) {
                if (this.df().apply$mcJ$sp(j) < (long)this.minDocFreq()) continue;
                inv[j] = package$.MODULE$.log(((double)this.m() + 1.0) / ((double)this.df().apply$mcJ$sp(j) + 1.0));
                dfv[j] = this.df().apply$mcJ$sp(j);
            }
            return new Tuple3((Object)Vectors$.MODULE$.dense(inv), (Object)dfv, (Object)BoxesRunTime.boxToLong((long)this.m()));
        }

        public DocumentFrequencyAggregator(int minDocFreq) {
            this.minDocFreq = minDocFreq;
            this.m = 0L;
        }

        public DocumentFrequencyAggregator() {
            this(0);
        }
    }
}

