/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.storage.Zero;
import com.github.fommil.netlib.ARPACK;
import java.io.Serializable;
import java.util.Arrays;
import org.netlib.util.doubleW;
import org.netlib.util.intW;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class EigenValueDecomposition$ {
    public static EigenValueDecomposition$ MODULE$;

    static {
        new EigenValueDecomposition$();
    }

    public Tuple2<DenseVector<Object>, DenseMatrix<Object>> symmetricEigs(Function1<DenseVector<Object>, DenseVector<Object>> mul, int n, int k, double tol, int maxIterations) {
        Predef$.MODULE$.require(n > k, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("Number of required eigenvalues ").append(k).append(" must be smaller than matrix dimension ").append(n).toString());
        ARPACK arpack = ARPACK.getInstance();
        doubleW tolW = new doubleW(tol);
        intW nev = new intW(k);
        int ncv = package$.MODULE$.min(2 * k, n);
        String bmat = "I";
        String which = "LM";
        int[] iparam = new int[11];
        iparam[0] = 1;
        iparam[2] = maxIterations;
        iparam[6] = 1;
        Predef$.MODULE$.require((long)n * (long)ncv <= Integer.MAX_VALUE && (long)ncv * ((long)ncv + 8L) <= Integer.MAX_VALUE, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("k = ").append(k).append(" and/or n = ").append(n).append(" are too large to compute an eigendecomposition").toString());
        intW ido = new intW(0);
        intW info = new intW(0);
        double[] resid = new double[n];
        double[] v = new double[n * ncv];
        double[] workd = new double[n * 3];
        double[] workl = new double[ncv * (ncv + 8)];
        int[] ipntr = new int[11];
        arpack.dsaupd(ido, bmat, n, which, nev.val, tolW, resid, ncv, v, n, iparam, ipntr, workd, workl, workl.length, info);
        DenseVector w = DenseVector$.MODULE$.apply$mDc$sp(workd);
        while (ido.val != 99) {
            if (ido.val != -1 && ido.val != 1) {
                throw new IllegalStateException(new StringBuilder(91).append("ARPACK returns ido = ").append(ido.val).append(" This flag is not compatible with Mode 1: A*x = lambda*x, A symmetric.").toString());
            }
            int inputOffset = ipntr[0] - 1;
            int outputOffset = ipntr[1] - 1;
            DenseVector x = w.slice$mcD$sp(inputOffset, inputOffset + n, w.slice$default$3());
            DenseVector y = w.slice$mcD$sp(outputOffset, outputOffset + n, w.slice$default$3());
            y.$colon$eq(mul.apply((Object)x), DenseVector$.MODULE$.dv_dv_UpdateOp_Double_OpSet());
            arpack.dsaupd(ido, bmat, n, which, nev.val, tolW, resid, ncv, v, n, iparam, ipntr, workd, workl, workl.length, info);
        }
        if (info.val != 0) {
            int n2 = info.val;
            switch (n2) {
                case 1: {
                    throw new IllegalStateException(new StringBuilder(105).append("ARPACK returns non-zero info = ").append(info.val).append(" Maximum number of iterations taken. (Refer ARPACK user guide for details)").toString());
                }
                case 3: {
                    throw new IllegalStateException(new StringBuilder(118).append("ARPACK returns non-zero info = ").append(info.val).append(" No shifts could be applied. Try to increase NCV. ").append("(Refer ARPACK user guide for details)").toString());
                }
            }
            throw new IllegalStateException(new StringBuilder(81).append("ARPACK returns non-zero info = ").append(info.val).append(" Please refer ARPACK user guide for error message.").toString());
        }
        double[] d = new double[nev.val];
        boolean[] select = new boolean[ncv];
        double[] z = Arrays.copyOfRange(v, 0, nev.val * n);
        arpack.dseupd(true, "A", select, d, z, n, 0.0, bmat, n, which, nev, tol, resid, ncv, v, n, iparam, ipntr, workd, workl, workl.length, info);
        int computed = iparam[4];
        Tuple2[] eigenPairs = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(Arrays.copyOfRange(d, 0, computed))).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)r -> new Tuple2((Object)BoxesRunTime.boxToDouble((double)r._1$mcD$sp()), (Object)Arrays.copyOfRange(z, r._2$mcI$sp() * n, r._2$mcI$sp() * n + n)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        Tuple2[] sortedEigenPairs = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])eigenPairs)).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)EigenValueDecomposition$.$anonfun$symmetricEigs$4(x$1)), (Ordering)Ordering.Double$.MODULE$);
        DenseMatrix sortedU = DenseMatrix$.MODULE$.zeros$mDc$sp(n, computed, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sortedEigenPairs)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)r -> {
            EigenValueDecomposition$.$anonfun$symmetricEigs$5(n, sortedU, r);
            return BoxedUnit.UNIT;
        });
        return new Tuple2((Object)DenseVector$.MODULE$.apply(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sortedEigenPairs)).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble((double)x$2._1$mcD$sp()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), (Object)sortedU);
    }

    public static final /* synthetic */ double $anonfun$symmetricEigs$4(Tuple2 x$1) {
        return -x$1._1$mcD$sp();
    }

    public static final /* synthetic */ void $anonfun$symmetricEigs$5(int n$1, DenseMatrix sortedU$1, Tuple2 r) {
        int b = r._2$mcI$sp() * n$1;
        for (int i = 0; i < n$1; ++i) {
            sortedU$1.data$mcD$sp()[b + i] = ((double[])((Tuple2)r._1())._2())[i];
        }
    }

    private EigenValueDecomposition$() {
        MODULE$ = this;
    }
}

