/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat.distribution;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Matrix;
import breeze.linalg.Tensor$;
import breeze.linalg.Transpose$;
import breeze.linalg.Vector$;
import breeze.linalg.diag$;
import breeze.linalg.eigSym;
import breeze.linalg.eigSym$;
import breeze.linalg.max$;
import breeze.storage.Zero;
import java.io.Serializable;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.MLUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001y4A\u0001E\t\u0001=!A\u0001\u0006\u0001BC\u0002\u0013\u0005\u0011\u0006\u0003\u0005:\u0001\t\u0005\t\u0015!\u0003+\u0011!Y\u0004A!b\u0001\n\u0003a\u0004\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u000b\r\u0003A\u0011\u0001#\t\u00111\u0003\u0001R1A\u0005\n5Caa\u0011\u0001\u0005\u0002Ua\u0006B\u00032\u0001!\u0003E9\u0019)C\u0005G\"Aq\r\u0001EC\u0002\u0013%\u0001\u000e\u0003\u0005k\u0001!\u0015\r\u0011\"\u0003l\u0011\u0015i\u0007\u0001\"\u0001o\u0011\u0015\u0011\b\u0001\"\u0001t\u0011\u0019i\u0007\u0001\"\u0001\u0016m\"1!\u000f\u0001C\u0001+iDQ\u0001 \u0001\u0005\n\r\u0014A#T;mi&4\u0018M]5bi\u0016<\u0015-^:tS\u0006t'B\u0001\n\u0014\u00031!\u0017n\u001d;sS\n,H/[8o\u0015\t!R#\u0001\u0003ti\u0006$(B\u0001\f\u0018\u0003\u0015iG\u000e\\5c\u0015\tA\u0012$A\u0003ta\u0006\u00148N\u0003\u0002\u001b7\u00051\u0011\r]1dQ\u0016T\u0011\u0001H\u0001\u0004_J<7\u0001A\n\u0004\u0001})\u0003C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#AB!osJ+g\r\u0005\u0002!M%\u0011q%\t\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0003[V,\u0012A\u000b\t\u0003W9j\u0011\u0001\f\u0006\u0003[U\ta\u0001\\5oC2<\u0017BA\u0018-\u0005\u00191Vm\u0019;pe\"\u001a\u0011!M\u001c\u0011\u0005I*T\"A\u001a\u000b\u0005Q:\u0012AC1o]>$\u0018\r^5p]&\u0011ag\r\u0002\u0006'&t7-Z\u0011\u0002q\u0005)\u0011GL\u001a/a\u0005\u0019Q.\u001e\u0011)\u0007\t\tt'A\u0003tS\u001el\u0017-F\u0001>!\tYc(\u0003\u0002@Y\t1Q*\u0019;sSbD3aA\u00198\u0003\u0019\u0019\u0018nZ7bA!\u001aA!M\u001c\u0002\rqJg.\u001b;?)\r)u)\u0013\t\u0003\r\u0002i\u0011!\u0005\u0005\u0006Q\u0015\u0001\rA\u000b\u0015\u0004\u000fF:\u0004\"B\u001e\u0006\u0001\u0004i\u0004fA%2o!\u001aQ!M\u001c\u0002\u0011\t\u0014X-\u001a>f\u001bV,\u0012A\u0014\t\u0004\u001fN+V\"\u0001)\u000b\u00055\n&\"\u0001*\u0002\r\t\u0014X-\u001a>f\u0013\t!\u0006KA\u0006EK:\u001cXMV3di>\u0014\bC\u0001\u0011W\u0013\t9\u0016E\u0001\u0004E_V\u0014G.\u001a\u0015\u0003\re\u0003\"\u0001\t.\n\u0005m\u000b#!\u0003;sC:\u001c\u0018.\u001a8u)\r)UL\u0018\u0005\u0006Q\u001d\u0001\rA\u0014\u0005\u0006w\u001d\u0001\ra\u0018\t\u0004\u001f\u0002,\u0016BA1Q\u0005-!UM\\:f\u001b\u0006$(/\u001b=\u0002\u0007a$\u0013'F\u0001e!\u0011\u0001SmX+\n\u0005\u0019\f#A\u0002+va2,''\u0001\u0007s_>$8+[4nC&sg/F\u0001`Q\tI\u0011,A\u0001v+\u0005)\u0006F\u0001\u0006Z\u0003\r\u0001HM\u001a\u000b\u0003+>DQ\u0001]\u0006A\u0002)\n\u0011\u0001\u001f\u0015\u0004\u0017E:\u0014A\u00027pOB$g\r\u0006\u0002Vi\")\u0001\u000f\u0004a\u0001U!\u001aA\"M\u001c\u0015\u0005U;\b\"\u00029\u000e\u0001\u0004A\bcA(z+&\u0011q\u0006\u0015\u000b\u0003+nDQ\u0001\u001d\bA\u0002a\fAdY1mGVd\u0017\r^3D_Z\f'/[1oG\u0016\u001cuN\\:uC:$8\u000fK\u0002\u0001c]\u0002")
public class MultivariateGaussian
implements scala.Serializable {
    private transient DenseVector<Object> breezeMu;
    private Tuple2<DenseMatrix<Object>, Object> x$1;
    private transient DenseMatrix<Object> rootSigmaInv;
    private transient double u;
    private final Vector mu;
    private final org.apache.spark.mllib.linalg.Matrix sigma;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public Vector mu() {
        return this.mu;
    }

    public org.apache.spark.mllib.linalg.Matrix sigma() {
        return this.sigma;
    }

    private DenseVector<Object> breezeMu$lzycompute() {
        MultivariateGaussian multivariateGaussian = this;
        synchronized (multivariateGaussian) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.breezeMu = this.mu().asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.breezeMu;
    }

    private DenseVector<Object> breezeMu() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.breezeMu$lzycompute() : this.breezeMu;
    }

    private Tuple2<DenseMatrix<Object>, Object> x$1$lzycompute() {
        block5: {
            MultivariateGaussian multivariateGaussian = this;
            synchronized (multivariateGaussian) {
                double u;
                DenseMatrix rootSigmaInv;
                block7: {
                    Tuple2<DenseMatrix<Object>, Object> tuple2;
                    block6: {
                        if (this.bitmap$0) break block5;
                        tuple2 = this.calculateCovarianceConstants();
                        if (tuple2 == null) break block6;
                        rootSigmaInv = (DenseMatrix)tuple2._1();
                        u = tuple2._2$mcD$sp();
                        if (rootSigmaInv != null) break block7;
                    }
                    throw new MatchError(tuple2);
                }
                DenseMatrix denseMatrix = rootSigmaInv;
                double d = u;
                Tuple2 tuple2 = new Tuple2((Object)denseMatrix, (Object)BoxesRunTime.boxToDouble((double)d));
                this.x$1 = tuple2;
                this.bitmap$0 = true;
            }
        }
        return this.x$1;
    }

    private /* synthetic */ Tuple2 x$1() {
        return !this.bitmap$0 ? this.x$1$lzycompute() : this.x$1;
    }

    private DenseMatrix<Object> rootSigmaInv$lzycompute() {
        MultivariateGaussian multivariateGaussian = this;
        synchronized (multivariateGaussian) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.rootSigmaInv = (DenseMatrix)this.x$1()._1();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.rootSigmaInv;
    }

    private DenseMatrix<Object> rootSigmaInv() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.rootSigmaInv$lzycompute() : this.rootSigmaInv;
    }

    private double u$lzycompute() {
        MultivariateGaussian multivariateGaussian = this;
        synchronized (multivariateGaussian) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.u = this.x$1()._2$mcD$sp();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.u;
    }

    private double u() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.u$lzycompute() : this.u;
    }

    public double pdf(Vector x) {
        return this.pdf(x.asBreeze());
    }

    public double logpdf(Vector x) {
        return this.logpdf(x.asBreeze());
    }

    public double pdf(breeze.linalg.Vector<Object> x) {
        return package$.MODULE$.exp(this.logpdf(x));
    }

    public double logpdf(breeze.linalg.Vector<Object> x) {
        breeze.linalg.Vector delta = (breeze.linalg.Vector)x.$minus(this.breezeMu(), Vector$.MODULE$.castOps(Predef$.MODULE$.$conforms(), Predef$.MODULE$.$conforms(), (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpSub()));
        DenseVector v = (DenseVector)this.rootSigmaInv().$times((Object)delta, (UFunc.UImpl2)DenseMatrix$.MODULE$.op_DM_V_Double());
        return this.u() + BoxesRunTime.unboxToDouble((Object)((ImmutableNumericOps)v.t(Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.$conforms()))).$times((Object)v, Transpose$.MODULE$.transTimesNormalFromDot((UFunc.UImpl2)DenseVector.canDotD$.MODULE$))) * -0.5;
    }

    private Tuple2<DenseMatrix<Object>, Object> calculateCovarianceConstants() {
        Tuple2 tuple2;
        eigSym.EigSym eigSym2 = (eigSym.EigSym)eigSym$.MODULE$.apply((Object)this.sigma().asBreeze().toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$), (UFunc.UImpl)eigSym.EigSym_DM_Impl$.MODULE$);
        if (eigSym2 == null) {
            throw new MatchError((Object)eigSym2);
        }
        DenseVector d = (DenseVector)eigSym2.eigenvalues();
        DenseMatrix u = (DenseMatrix)eigSym2.eigenvectors();
        Tuple2 tuple22 = new Tuple2((Object)d, (Object)u);
        Tuple2 tuple23 = tuple22;
        DenseVector d2 = (DenseVector)tuple23._1();
        DenseMatrix u2 = (DenseMatrix)tuple23._2();
        double tol = MLUtils$.MODULE$.EPSILON() * BoxesRunTime.unboxToDouble((Object)max$.MODULE$.apply((Object)d2, max$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()))) * (double)d2.length();
        try {
            double logPseudoDetSigma = BoxesRunTime.unboxToDouble((Object)d2.activeValuesIterator().filter((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$3 -> x$3 > tol).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.log(x)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            DenseMatrix pinvS = (DenseMatrix)diag$.MODULE$.apply((Object)new DenseVector.mcD.sp(((DenseVector)d2.map$mcD$sp((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)v -> v > tol ? package$.MODULE$.sqrt(1.0 / v) : 0.0, DenseVector$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double()))).toArray$mcD$sp(ClassTag$.MODULE$.Double())), diag$.MODULE$.diagDVDMImpl(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$));
            tuple2 = new Tuple2(pinvS.$times(u2.t(DenseMatrix$.MODULE$.canTranspose()), (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DMD_eq_DMD()), (Object)BoxesRunTime.boxToDouble((double)(-0.5 * ((double)this.mu().size() * package$.MODULE$.log(Math.PI * 2) + logPseudoDetSigma))));
        }
        catch (UnsupportedOperationException uex) {
            throw new IllegalArgumentException("Covariance matrix has no non-zero singular values");
        }
        return tuple2;
    }

    public MultivariateGaussian(Vector mu, org.apache.spark.mllib.linalg.Matrix sigma) {
        this.mu = mu;
        this.sigma = sigma;
        Predef$.MODULE$.require(sigma.numCols() == sigma.numRows(), (Function0 & Serializable & scala.Serializable)() -> "Covariance matrix must be square");
        Predef$.MODULE$.require(mu.size() == sigma.numCols(), (Function0 & Serializable & scala.Serializable)() -> "Mean vector length must match covariance matrix size");
    }

    public MultivariateGaussian(DenseVector<Object> mu, DenseMatrix<Object> sigma) {
        this(Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)mu), Matrices$.MODULE$.fromBreeze((Matrix<Object>)sigma));
    }
}

