/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat.test;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.stat.test.BinarySample;
import org.apache.spark.mllib.stat.test.StreamingTestMethod;
import org.apache.spark.mllib.stat.test.StreamingTestMethod$;
import org.apache.spark.mllib.stat.test.StreamingTestResult;
import org.apache.spark.mllib.stat.test.WelchTTest$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaDStream$;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStream$;
import org.apache.spark.util.StatCounter;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001B\n\u0015\u0001\u0005BQ!\r\u0001\u0005\u0002IBqA\u0010\u0001A\u0002\u0013%q\bC\u0004D\u0001\u0001\u0007I\u0011\u0002#\t\r)\u0003\u0001\u0015)\u0003A\u0011\u001dY\u0005\u00011A\u0005\n}Bq\u0001\u0014\u0001A\u0002\u0013%Q\n\u0003\u0004P\u0001\u0001\u0006K\u0001\u0011\u0005\b!\u0002\u0001\r\u0011\"\u0003R\u0011\u001d)\u0006\u00011A\u0005\nYCa\u0001\u0017\u0001!B\u0013\u0011\u0006\"B-\u0001\t\u0003Q\u0006\"\u00020\u0001\t\u0003y\u0006\"\u00022\u0001\t\u0003\u0019\u0007\"\u0002:\u0001\t\u0003\u0019\bB\u0002:\u0001\t\u0003\ti\u0001\u0003\u0005\u0002&\u0001!\tAFA\u0014\u0011!\tY\u0003\u0001C\u0001-\u00055\u0002\u0002CA&\u0001\u0011\u0005a#!\u0014\u0003\u001bM#(/Z1nS:<G+Z:u\u0015\t)b#\u0001\u0003uKN$(BA\f\u0019\u0003\u0011\u0019H/\u0019;\u000b\u0005eQ\u0012!B7mY&\u0014'BA\u000e\u001d\u0003\u0015\u0019\b/\u0019:l\u0015\tib$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002?\u0005\u0019qN]4\u0004\u0001M!\u0001A\t\u0015/!\t\u0019c%D\u0001%\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0005\u0019\te.\u001f*fMB\u0011\u0011\u0006L\u0007\u0002U)\u00111FG\u0001\tS:$XM\u001d8bY&\u0011QF\u000b\u0002\b\u0019><w-\u001b8h!\t\u0019s&\u0003\u00021I\ta1+\u001a:jC2L'0\u00192mK\u00061A(\u001b8jiz\"\u0012a\r\t\u0003i\u0001i\u0011\u0001\u0006\u0015\u0004\u0003Yb\u0004CA\u001c;\u001b\u0005A$BA\u001d\u001b\u0003)\tgN\\8uCRLwN\\\u0005\u0003wa\u0012QaU5oG\u0016\f\u0013!P\u0001\u0006c92d\u0006M\u0001\fa\u0016\f7-\u001a)fe&|G-F\u0001A!\t\u0019\u0013)\u0003\u0002CI\t\u0019\u0011J\u001c;\u0002\u001fA,\u0017mY3QKJLw\u000eZ0%KF$\"!\u0012%\u0011\u0005\r2\u0015BA$%\u0005\u0011)f.\u001b;\t\u000f%\u001b\u0011\u0011!a\u0001\u0001\u0006\u0019\u0001\u0010J\u0019\u0002\u0019A,\u0017mY3QKJLw\u000e\u001a\u0011\u0002\u0015]Lg\u000eZ8x'&TX-\u0001\bxS:$wn^*ju\u0016|F%Z9\u0015\u0005\u0015s\u0005bB%\u0007\u0003\u0003\u0005\r\u0001Q\u0001\fo&tGm\\<TSj,\u0007%\u0001\u0006uKN$X*\u001a;i_\u0012,\u0012A\u0015\t\u0003iMK!\u0001\u0016\u000b\u0003'M#(/Z1nS:<G+Z:u\u001b\u0016$\bn\u001c3\u0002\u001dQ,7\u000f^'fi\"|Gm\u0018\u0013fcR\u0011Qi\u0016\u0005\b\u0013&\t\t\u00111\u0001S\u0003-!Xm\u001d;NKRDw\u000e\u001a\u0011\u0002\u001dM,G\u000fU3bG\u0016\u0004VM]5pIR\u00111\fX\u0007\u0002\u0001!)ah\u0003a\u0001\u0001\"\u001a1B\u000e\u001f\u0002\u001bM,GoV5oI><8+\u001b>f)\tY\u0006\rC\u0003L\u0019\u0001\u0007\u0001\tK\u0002\rmq\nQb]3u)\u0016\u001cH/T3uQ>$GCA.e\u0011\u0015)W\u00021\u0001g\u0003\u0019iW\r\u001e5pIB\u0011qM\u001c\b\u0003Q2\u0004\"!\u001b\u0013\u000e\u0003)T!a\u001b\u0011\u0002\rq\u0012xn\u001c;?\u0013\tiG%\u0001\u0004Qe\u0016$WMZ\u0005\u0003_B\u0014aa\u0015;sS:<'BA7%Q\ria\u0007P\u0001\u000fe\u0016<\u0017n\u001d;feN#(/Z1n)\t!x\u0010E\u0002vurl\u0011A\u001e\u0006\u0003ob\fq\u0001Z:ue\u0016\fWN\u0003\u0002z5\u0005I1\u000f\u001e:fC6LgnZ\u0005\u0003wZ\u0014q\u0001R*ue\u0016\fW\u000e\u0005\u00025{&\u0011a\u0010\u0006\u0002\u0014'R\u0014X-Y7j]\u001e$Vm\u001d;SKN,H\u000e\u001e\u0005\b\u0003\u0003q\u0001\u0019AA\u0002\u0003\u0011!\u0017\r^1\u0011\tUT\u0018Q\u0001\t\u0004i\u0005\u001d\u0011bAA\u0005)\ta!)\u001b8bef\u001c\u0016-\u001c9mK\"\u001aaB\u000e\u001f\u0015\t\u0005=\u0011q\u0004\t\u0006\u0003#\tY\u0002`\u0007\u0003\u0003'QA!!\u0006\u0002\u0018\u0005!!.\u0019<b\u0015\r\tI\u0002_\u0001\u0004CBL\u0017\u0002BA\u000f\u0003'\u00111BS1wC\u0012\u001bFO]3b[\"9\u0011\u0011A\bA\u0002\u0005\u0005\u0002CBA\t\u00037\t)\u0001K\u0002\u0010mq\nq\u0002\u001a:paB+\u0017mY3QKJLw\u000e\u001a\u000b\u0005\u0003\u0007\tI\u0003C\u0004\u0002\u0002A\u0001\r!a\u0001\u0002/M,X.\\1sSj,')_&fs\u0006sGmV5oI><H\u0003BA\u0018\u0003\u0013\u0002B!\u001e>\u00022A91%a\r\u00028\u0005u\u0012bAA\u001bI\t1A+\u001e9mKJ\u00022aIA\u001d\u0013\r\tY\u0004\n\u0002\b\u0005>|G.Z1o!\u0011\ty$!\u0012\u000e\u0005\u0005\u0005#bAA\"5\u0005!Q\u000f^5m\u0013\u0011\t9%!\u0011\u0003\u0017M#\u0018\r^\"pk:$XM\u001d\u0005\b\u0003\u0003\t\u0002\u0019AA\u0002\u00035\u0001\u0018-\u001b:Tk6l\u0017M]5fgR!\u0011qJA*!\u0011)(0!\u0015\u0011\u000f\r\n\u0019$!\u0010\u0002>!9\u0011Q\u000b\nA\u0002\u0005=\u0012AD:v[6\f'/\u001b>fI\u0012\u000bG/\u0019\u0015\u0004\u0001Yb\u0004")
public class StreamingTest
implements Logging,
scala.Serializable {
    private int peacePeriod;
    private int windowSize;
    private StreamingTestMethod testMethod;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int peacePeriod() {
        return this.peacePeriod;
    }

    private void peacePeriod_$eq(int x$1) {
        this.peacePeriod = x$1;
    }

    private int windowSize() {
        return this.windowSize;
    }

    private void windowSize_$eq(int x$1) {
        this.windowSize = x$1;
    }

    private StreamingTestMethod testMethod() {
        return this.testMethod;
    }

    private void testMethod_$eq(StreamingTestMethod x$1) {
        this.testMethod = x$1;
    }

    public StreamingTest setPeacePeriod(int peacePeriod) {
        this.peacePeriod_$eq(peacePeriod);
        return this;
    }

    public StreamingTest setWindowSize(int windowSize) {
        this.windowSize_$eq(windowSize);
        return this;
    }

    public StreamingTest setTestMethod(String method) {
        this.testMethod_$eq(StreamingTestMethod$.MODULE$.getTestMethodFromName(method));
        return this;
    }

    public DStream<StreamingTestResult> registerStream(DStream<BinarySample> data) {
        DStream<BinarySample> dataAfterPeacePeriod = this.dropPeacePeriod(data);
        DStream<Tuple2<Object, StatCounter>> summarizedData = this.summarizeByKeyAndWindow(dataAfterPeacePeriod);
        DStream<Tuple2<StatCounter, StatCounter>> pairedSummaries = this.pairSummaries(summarizedData);
        return this.testMethod().doTest(pairedSummaries);
    }

    public JavaDStream<StreamingTestResult> registerStream(JavaDStream<BinarySample> data) {
        return JavaDStream$.MODULE$.fromDStream(this.registerStream((DStream<BinarySample>)data.dstream()), ClassTag$.MODULE$.apply(StreamingTestResult.class));
    }

    public DStream<BinarySample> dropPeacePeriod(DStream<BinarySample> data) {
        return data.transform((Function2 & Serializable & scala.Serializable)(rdd, time) -> {
            RDD rDD;
            if (time.milliseconds() > data.slideDuration().milliseconds() * (long)this.peacePeriod()) {
                rDD = rdd;
            } else {
                SparkContext qual$1 = data.context().sparkContext();
                Seq x$1 = (Seq)Seq$.MODULE$.empty();
                int x$2 = qual$1.parallelize$default$2();
                rDD = qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(BinarySample.class));
            }
            return rDD;
        }, ClassTag$.MODULE$.apply(BinarySample.class));
    }

    public DStream<Tuple2<Object, StatCounter>> summarizeByKeyAndWindow(DStream<BinarySample> data) {
        DStream dStream;
        DStream categoryValuePair = data.map((Function1 & Serializable & scala.Serializable)sample -> new Tuple2.mcZD.sp(sample.isExperiment(), sample.value()), ClassTag$.MODULE$.apply(Tuple2.class));
        if (this.windowSize() == 0) {
            dStream = DStream$.MODULE$.toPairDStreamFunctions(categoryValuePair, ClassTag$.MODULE$.Boolean(), ClassTag$.MODULE$.Double(), (Ordering)Ordering.Boolean$.MODULE$).updateStateByKey((Function2 & Serializable & scala.Serializable)(newValues, oldSummary) -> {
                StatCounter newSummary = (StatCounter)oldSummary.getOrElse((Function0 & Serializable & scala.Serializable)() -> new StatCounter());
                newSummary.merge((TraversableOnce)newValues);
                return new Some((Object)newSummary);
            }, ClassTag$.MODULE$.apply(StatCounter.class));
        } else {
            Duration windowDuration = data.slideDuration().$times(this.windowSize());
            dStream = DStream$.MODULE$.toPairDStreamFunctions(DStream$.MODULE$.toPairDStreamFunctions(categoryValuePair, ClassTag$.MODULE$.Boolean(), ClassTag$.MODULE$.Double(), (Ordering)Ordering.Boolean$.MODULE$).groupByKeyAndWindow(windowDuration), ClassTag$.MODULE$.Boolean(), ClassTag$.MODULE$.apply(Iterable.class), (Ordering)Ordering.Boolean$.MODULE$).mapValues((Function1 & Serializable & scala.Serializable)values -> {
                void var1_1;
                StatCounter summary = new StatCounter();
                values.foreach((Function1 & Serializable & scala.Serializable)value -> summary.merge(BoxesRunTime.unboxToDouble((Object)value)));
                return var1_1;
            }, ClassTag$.MODULE$.apply(StatCounter.class));
        }
        return dStream;
    }

    public DStream<Tuple2<StatCounter, StatCounter>> pairSummaries(DStream<Tuple2<Object, StatCounter>> summarizedData) {
        return DStream$.MODULE$.toPairDStreamFunctions(summarizedData.map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), x._2()), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(StatCounter.class), (Ordering)Ordering.Int$.MODULE$).groupByKey().map((Function1 & Serializable & scala.Serializable)x -> new Tuple2(((IterableLike)x._2()).head(), ((TraversableLike)x._2()).last()), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public StreamingTest() {
        Logging.$init$((Logging)this);
        this.peacePeriod = 0;
        this.windowSize = 0;
        this.testMethod = WelchTTest$.MODULE$;
    }
}

