/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree.impurity;

import org.apache.spark.mllib.tree.impurity.GiniCalculator;
import org.apache.spark.mllib.tree.impurity.ImpurityAggregator;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t3Q!\u0002\u0004\u0001\u0019IA\u0001\"\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\u0006E\u0001!\ta\t\u0005\u0006M\u0001!\ta\n\u0005\u0006w\u0001!\t\u0001\u0010\u0002\u000f\u000f&t\u0017.Q4he\u0016<\u0017\r^8s\u0015\t9\u0001\"\u0001\u0005j[B,(/\u001b;z\u0015\tI!\"\u0001\u0003ue\u0016,'BA\u0006\r\u0003\u0015iG\u000e\\5c\u0015\tia\"A\u0003ta\u0006\u00148N\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7c\u0001\u0001\u0014/A\u0011A#F\u0007\u0002\r%\u0011aC\u0002\u0002\u0013\u00136\u0004XO]5us\u0006;wM]3hCR|'\u000f\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0006ok6\u001cE.Y:tKN\u001c\u0001\u0001\u0005\u0002\u0019A%\u0011\u0011%\u0007\u0002\u0004\u0013:$\u0018A\u0002\u001fj]&$h\b\u0006\u0002%KA\u0011A\u0003\u0001\u0005\u0006;\t\u0001\raH\u0001\u0007kB$\u0017\r^3\u0015\r!Z3'N\u001c:!\tA\u0012&\u0003\u0002+3\t!QK\\5u\u0011\u0015a3\u00011\u0001.\u0003!\tG\u000e\\*uCR\u001c\bc\u0001\r/a%\u0011q&\u0007\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00031EJ!AM\r\u0003\r\u0011{WO\u00197f\u0011\u0015!4\u00011\u0001 \u0003\u0019ygMZ:fi\")ag\u0001a\u0001a\u0005)A.\u00192fY\")\u0001h\u0001a\u0001?\u0005Qa.^7TC6\u0004H.Z:\t\u000bi\u001a\u0001\u0019\u0001\u0019\u0002\u0019M\fW\u000e\u001d7f/\u0016Lw\r\u001b;\u0002\u001b\u001d,GoQ1mGVd\u0017\r^8s)\ri\u0004)\u0011\t\u0003)yJ!a\u0010\u0004\u0003\u001d\u001dKg.[\"bY\u000e,H.\u0019;pe\")A\u0006\u0002a\u0001[!)A\u0007\u0002a\u0001?\u0001")
public class GiniAggregator
extends ImpurityAggregator {
    private final int numClasses;

    @Override
    public void update(double[] allStats, int offset, double label, int numSamples, double sampleWeight) {
        if (label >= (double)this.numClasses) {
            throw new IllegalArgumentException(new StringBuilder(65).append("GiniAggregator given label ").append(label).append(" but requires label < numClasses (= ").append(this.numClasses).append(").").toString());
        }
        if (label < 0.0) {
            throw new IllegalArgumentException(new StringBuilder(65).append("GiniAggregator given label ").append(label).append("but requires label to be non-negative.").toString());
        }
        int n = offset + (int)label;
        allStats[n] = allStats[n] + (double)numSamples * sampleWeight;
        int n2 = offset + this.statsSize() - 1;
        allStats[n2] = allStats[n2] + (double)numSamples;
    }

    @Override
    public GiniCalculator getCalculator(double[] allStats, int offset) {
        return new GiniCalculator((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(allStats)).view(offset, offset + this.statsSize() - 1).toArray(ClassTag$.MODULE$.Double()), (long)allStats[offset + this.statsSize() - 1]);
    }

    public GiniAggregator(int numClasses) {
        this.numClasses = numClasses;
        super(numClasses + 1);
    }
}

