/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.network.TestUtils;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportClientFactory;
import org.apache.spark.network.server.NoOpRpcHandler;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.TransportServer;
import org.apache.spark.network.util.ConfigProvider;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.network.util.MapConfigProvider;
import org.apache.spark.network.util.TransportConf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TransportClientFactorySuite {
    private TransportConf conf;
    private TransportContext context;
    private TransportServer server1;
    private TransportServer server2;

    @Before
    public void setUp() {
        this.conf = new TransportConf("shuffle", (ConfigProvider)MapConfigProvider.EMPTY);
        NoOpRpcHandler rpcHandler = new NoOpRpcHandler();
        this.context = new TransportContext(this.conf, (RpcHandler)rpcHandler);
        this.server1 = this.context.createServer();
        this.server2 = this.context.createServer();
    }

    @After
    public void tearDown() {
        JavaUtils.closeQuietly((Closeable)this.server1);
        JavaUtils.closeQuietly((Closeable)this.server2);
        JavaUtils.closeQuietly((Closeable)this.context);
    }

    private void testClientReuse(int maxConnections, boolean concurrent) throws IOException, InterruptedException {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("spark.shuffle.io.numConnectionsPerPeer", Integer.toString(maxConnections));
        TransportConf conf = new TransportConf("shuffle", (ConfigProvider)new MapConfigProvider(configMap));
        NoOpRpcHandler rpcHandler = new NoOpRpcHandler();
        try (TransportContext context = new TransportContext(conf, (RpcHandler)rpcHandler);){
            TransportClientFactory factory = context.createClientFactory();
            Set<TransportClient> clients = Collections.synchronizedSet(new HashSet());
            AtomicInteger failed = new AtomicInteger();
            Thread[] attempts = new Thread[maxConnections * 10];
            for (int i = 0; i < attempts.length; ++i) {
                attempts[i] = new Thread(() -> {
                    try {
                        TransportClient client = factory.createClient(TestUtils.getLocalHost(), this.server1.getPort());
                        Assert.assertTrue((boolean)client.isActive());
                        clients.add(client);
                    }
                    catch (IOException e) {
                        failed.incrementAndGet();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                });
                if (concurrent) {
                    attempts[i].start();
                    continue;
                }
                attempts[i].run();
            }
            for (Thread attempt : attempts) {
                attempt.join();
            }
            Assert.assertEquals((long)0L, (long)failed.get());
            Assert.assertTrue((clients.size() <= maxConnections ? 1 : 0) != 0);
            for (TransportClient client : clients) {
                client.close();
            }
            factory.close();
        }
    }

    @Test
    public void reuseClientsUpToConfigVariable() throws Exception {
        this.testClientReuse(1, false);
        this.testClientReuse(2, false);
        this.testClientReuse(3, false);
        this.testClientReuse(4, false);
    }

    @Test
    public void reuseClientsUpToConfigVariableConcurrent() throws Exception {
        this.testClientReuse(1, true);
        this.testClientReuse(2, true);
        this.testClientReuse(3, true);
        this.testClientReuse(4, true);
    }

    @Test
    public void returnDifferentClientsForDifferentServers() throws IOException, InterruptedException {
        TransportClientFactory factory = this.context.createClientFactory();
        TransportClient c1 = factory.createClient(TestUtils.getLocalHost(), this.server1.getPort());
        TransportClient c2 = factory.createClient(TestUtils.getLocalHost(), this.server2.getPort());
        Assert.assertTrue((boolean)c1.isActive());
        Assert.assertTrue((boolean)c2.isActive());
        Assert.assertNotSame((Object)c1, (Object)c2);
        factory.close();
    }

    @Test
    public void neverReturnInactiveClients() throws IOException, InterruptedException {
        TransportClientFactory factory = this.context.createClientFactory();
        TransportClient c1 = factory.createClient(TestUtils.getLocalHost(), this.server1.getPort());
        c1.close();
        long start = System.currentTimeMillis();
        while (c1.isActive() && System.currentTimeMillis() - start < 3000L) {
            Thread.sleep(10L);
        }
        Assert.assertFalse((boolean)c1.isActive());
        TransportClient c2 = factory.createClient(TestUtils.getLocalHost(), this.server1.getPort());
        Assert.assertNotSame((Object)c1, (Object)c2);
        Assert.assertTrue((boolean)c2.isActive());
        factory.close();
    }

    @Test
    public void closeBlockClientsWithFactory() throws IOException, InterruptedException {
        TransportClientFactory factory = this.context.createClientFactory();
        TransportClient c1 = factory.createClient(TestUtils.getLocalHost(), this.server1.getPort());
        TransportClient c2 = factory.createClient(TestUtils.getLocalHost(), this.server2.getPort());
        Assert.assertTrue((boolean)c1.isActive());
        Assert.assertTrue((boolean)c2.isActive());
        factory.close();
        Assert.assertFalse((boolean)c1.isActive());
        Assert.assertFalse((boolean)c2.isActive());
    }

    @Test
    public void closeIdleConnectionForRequestTimeOut() throws IOException, InterruptedException {
        TransportConf conf = new TransportConf("shuffle", new ConfigProvider(){

            public String get(String name) {
                if ("spark.shuffle.io.connectionTimeout".equals(name)) {
                    return "1s";
                }
                String value = System.getProperty(name);
                if (value == null) {
                    throw new NoSuchElementException(name);
                }
                return value;
            }

            public Iterable<Map.Entry<String, String>> getAll() {
                throw new UnsupportedOperationException();
            }
        });
        try (TransportContext context = new TransportContext(conf, (RpcHandler)new NoOpRpcHandler(), true);
             TransportClientFactory factory = context.createClientFactory();){
            TransportClient c1 = factory.createClient(TestUtils.getLocalHost(), this.server1.getPort());
            Assert.assertTrue((boolean)c1.isActive());
            long expiredTime = System.currentTimeMillis() + 10000L;
            while (c1.isActive() && System.currentTimeMillis() < expiredTime) {
                Thread.sleep(10L);
            }
            Assert.assertFalse((boolean)c1.isActive());
        }
    }

    @Test(expected=IOException.class)
    public void closeFactoryBeforeCreateClient() throws IOException, InterruptedException {
        TransportClientFactory factory = this.context.createClientFactory();
        factory.close();
        factory.createClient(TestUtils.getLocalHost(), this.server1.getPort());
    }
}

