/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.crypto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.embedded.EmbeddedChannel;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.crypto.stream.CryptoInputStream;
import org.apache.commons.crypto.stream.CryptoOutputStream;
import org.apache.spark.network.crypto.TransportCipher;
import org.apache.spark.network.util.ConfigProvider;
import org.apache.spark.network.util.MapConfigProvider;
import org.apache.spark.network.util.TransportConf;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TransportCipherSuite {
    @Test
    public void testBufferNotLeaksOnInternalError() throws IOException {
        String algorithm = "TestAlgorithm";
        TransportConf conf = new TransportConf("Test", (ConfigProvider)MapConfigProvider.EMPTY);
        TransportCipher cipher = new TransportCipher(conf.cryptoConf(), conf.cipherTransformation(), new SecretKeySpec(new byte[256], algorithm), new byte[0], new byte[0]){

            CryptoOutputStream createOutputStream(WritableByteChannel ch) {
                return null;
            }

            CryptoInputStream createInputStream(ReadableByteChannel ch) throws IOException {
                CryptoInputStream mockInputStream = (CryptoInputStream)Mockito.mock(CryptoInputStream.class);
                Mockito.when((Object)mockInputStream.read((byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenThrow(new Throwable[]{new InternalError()});
                return mockInputStream;
            }
        };
        EmbeddedChannel channel = new EmbeddedChannel();
        cipher.addToChannel((Channel)channel);
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2});
        ByteBuf buffer2 = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2});
        try {
            channel.writeInbound(new Object[]{buffer});
            Assert.fail((String)"Should have raised InternalError");
        }
        catch (InternalError expected) {
            Assert.assertEquals((long)0L, (long)buffer.refCnt());
        }
        try {
            channel.writeInbound(new Object[]{buffer2});
            Assert.fail((String)"Should have raised an exception");
        }
        catch (Throwable expected) {
            Assert.assertThat((Object)expected, (Matcher)CoreMatchers.instanceOf(IOException.class));
            Assert.assertEquals((long)0L, (long)buffer2.refCnt());
        }
        Assert.assertFalse((boolean)channel.finish());
    }
}

