/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.SystemUtils;
import org.apache.spark.network.util.JavaUtils;
import org.sparkproject.guava.annotations.VisibleForTesting;

public class ExecutorDiskUtils {
    private static final Pattern MULTIPLE_SEPARATORS = SystemUtils.IS_OS_WINDOWS ? Pattern.compile("[/\\\\]+") : Pattern.compile("/{2,}");

    public static File getFile(String[] localDirs, int subDirsPerLocalDir, String filename) {
        int hash = JavaUtils.nonNegativeHash((Object)filename);
        String localDir = localDirs[hash % localDirs.length];
        int subDirId = hash / localDirs.length % subDirsPerLocalDir;
        return new File(ExecutorDiskUtils.createNormalizedInternedPathname(localDir, String.format("%02x", subDirId), filename));
    }

    @VisibleForTesting
    static String createNormalizedInternedPathname(String dir1, String dir2, String fname) {
        String pathname = dir1 + File.separator + dir2 + File.separator + fname;
        Matcher m = MULTIPLE_SEPARATORS.matcher(pathname);
        if ((pathname = m.replaceAll(Matcher.quoteReplacement(File.separator))).length() > 1 && pathname.charAt(pathname.length() - 1) == File.separatorChar) {
            pathname = pathname.substring(0, pathname.length() - 1);
        }
        return pathname.intern();
    }
}

