/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.Network$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.streaming.MicroBatchStream;
import org.apache.spark.sql.connector.read.streaming.Offset;
import org.apache.spark.sql.connector.read.streaming.ReadAllAvailable;
import org.apache.spark.sql.connector.read.streaming.ReadLimit;
import org.apache.spark.sql.connector.read.streaming.ReadMaxRows;
import org.apache.spark.sql.connector.read.streaming.SupportsAdmissionControl;
import org.apache.spark.sql.kafka010.EarliestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.JsonUtils$;
import org.apache.spark.sql.kafka010.KafkaBatchInputPartition;
import org.apache.spark.sql.kafka010.KafkaBatchReaderFactory$;
import org.apache.spark.sql.kafka010.KafkaOffsetRange;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit;
import org.apache.spark.sql.kafka010.KafkaOffsetReader;
import org.apache.spark.sql.kafka010.KafkaSourceInitialOffsetWriter;
import org.apache.spark.sql.kafka010.KafkaSourceOffset;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.sql.kafka010.LatestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.SpecificOffsetRangeLimit;
import org.apache.spark.sql.kafka010.SpecificTimestampRangeLimit;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.UninterruptibleThread;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005]f!\u0002\u0011\"\u0001\u0005Z\u0003\"C$\u0001\u0005\u000b\u0007I\u0011A\u0011I\u0011!q\u0005A!A!\u0002\u0013I\u0005\u0002C(\u0001\u0005\u0003\u0005\u000b\u0011\u0002)\t\u0011\r\u0004!\u0011!Q\u0001\n\u0011D\u0001\"\u001b\u0001\u0003\u0002\u0003\u0006IA\u0016\u0005\tU\u0002\u0011\t\u0011)A\u0005W\"Aa\u000e\u0001B\u0001B\u0003%q\u000eC\u0003t\u0001\u0011\u0005A\u000f\u0003\u0005}\u0001\t\u0007I\u0011A\u0011~\u0011\u001d\t\u0019\u0001\u0001Q\u0001\nyD!\"!\u0002\u0001\u0005\u0004%\t!IA\u0004\u0011!\ty\u0001\u0001Q\u0001\n\u0005%\u0001\"CA\t\u0001\t\u0007I\u0011BA\n\u0011\u001d\t)\u0002\u0001Q\u0001\n=D1\"a\u0006\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u001a!Y\u0011\u0011\u0005\u0001A\u0002\u0003\u0007I\u0011BA\u0012\u0011-\ty\u0003\u0001a\u0001\u0002\u0003\u0006K!a\u0007\t\u000f\u0005E\u0002\u0001\"\u0011\u00024!9\u00111\b\u0001\u0005B\u0005u\u0002bBA#\u0001\u0011\u0005\u00131\u0007\u0005\b\u0003\u000b\u0002A\u0011IA$\u0011\u001d\t\t\u0006\u0001C!\u0003'Bq!!\u001b\u0001\t\u0003\nY\u0007C\u0004\u0002t\u0001!\t%!\u001e\t\u000f\u0005m\u0004\u0001\"\u0011\u0002~!9\u0011\u0011\u0011\u0001\u0005B\u0005\r\u0005bBAC\u0001\u0011\u0005\u0013q\u0011\u0005\b\u0003\u0013\u0003A\u0011BAF\u0011\u001d\tY\n\u0001C\u0005\u0003;Cq!a+\u0001\t\u0013\ti\u000b\u0003\b\u00024\u0002\u0001\n1!A\u0001\n\u0013\ti$!.\u0003+-\u000bgm[1NS\u000e\u0014xNQ1uG\"\u001cFO]3b[*\u0011!eI\u0001\tW\u000647.\u0019\u00192a)\u0011A%J\u0001\u0004gFd'B\u0001\u0014(\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0013&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002U\u0005\u0019qN]4\u0014\u000b\u0001aCGP!\u0011\u00055\u0012T\"\u0001\u0018\u000b\u0005=\u0002\u0014\u0001\u00027b]\u001eT\u0011!M\u0001\u0005U\u00064\u0018-\u0003\u00024]\t1qJ\u00196fGR\u0004\"!\u000e\u001f\u000e\u0003YR!a\u000e\u001d\u0002\u0013M$(/Z1nS:<'BA\u001d;\u0003\u0011\u0011X-\u00193\u000b\u0005m\u001a\u0013!C2p]:,7\r^8s\u0013\tidG\u0001\rTkB\u0004xN\u001d;t\u0003\u0012l\u0017n]:j_:\u001cuN\u001c;s_2\u0004\"!N \n\u0005\u00013$\u0001E'jGJ|')\u0019;dQN#(/Z1n!\t\u0011U)D\u0001D\u0015\t!U%\u0001\u0005j]R,'O\\1m\u0013\t15IA\u0004M_\u001e<\u0017N\\4\u0002#-\fgm[1PM\u001a\u001cX\r\u001e*fC\u0012,'/F\u0001J!\tQ5*D\u0001\"\u0013\ta\u0015EA\tLC\u001a\\\u0017m\u00144gg\u0016$(+Z1eKJ\u001c\u0001!\u0001\nlC\u001a\\\u0017m\u00144gg\u0016$(+Z1eKJ\u0004\u0013aE3yK\u000e,Ho\u001c:LC\u001a\\\u0017\rU1sC6\u001c\b\u0003B)U-2j\u0011A\u0015\u0006\u0003'B\nA!\u001e;jY&\u0011QK\u0015\u0002\u0004\u001b\u0006\u0004\bCA,a\u001d\tAf\f\u0005\u0002Z96\t!L\u0003\u0002\\\u001b\u00061AH]8pizR\u0011!X\u0001\u0006g\u000e\fG.Y\u0005\u0003?r\u000ba\u0001\u0015:fI\u00164\u0017BA1c\u0005\u0019\u0019FO]5oO*\u0011q\fX\u0001\b_B$\u0018n\u001c8t!\t)w-D\u0001g\u0015\t\u00196%\u0003\u0002iM\nA2)Y:f\u0013:\u001cXM\\:ji&4Xm\u0015;sS:<W*\u00199\u0002\u00195,G/\u00193bi\u0006\u0004\u0016\r\u001e5\u0002\u001fM$\u0018M\u001d;j]\u001e|eMZ:fiN\u0004\"A\u00137\n\u00055\f#!F&bM.\fwJ\u001a4tKR\u0014\u0016M\\4f\u0019&l\u0017\u000e^\u0001\u000fM\u0006LGn\u00148ECR\fGj\\:t!\t\u0001\u0018/D\u0001]\u0013\t\u0011HLA\u0004C_>dW-\u00198\u0002\rqJg.\u001b;?)\u001d)ho\u001e=zun\u0004\"A\u0013\u0001\t\u000b\u001dC\u0001\u0019A%\t\u000b=C\u0001\u0019\u0001)\t\u000b\rD\u0001\u0019\u00013\t\u000b%D\u0001\u0019\u0001,\t\u000b)D\u0001\u0019A6\t\u000b9D\u0001\u0019A8\u0002\u001bA|G\u000e\u001c+j[\u0016|W\u000f^'t+\u0005q\bC\u00019\u0000\u0013\r\t\t\u0001\u0018\u0002\u0005\u0019>tw-\u0001\bq_2dG+[7f_V$Xj\u001d\u0011\u0002)5\f\u0007p\u00144gg\u0016$8\u000fU3s)JLwmZ3s+\t\tI\u0001\u0005\u0003q\u0003\u0017q\u0018bAA\u00079\n1q\n\u001d;j_:\fQ#\\1y\u001f\u001a47/\u001a;t!\u0016\u0014HK]5hO\u0016\u0014\b%\u0001\bj]\u000edW\u000fZ3IK\u0006$WM]:\u0016\u0003=\fq\"\u001b8dYV$W\rS3bI\u0016\u00148\u000fI\u0001\u0014K:$\u0007+\u0019:uSRLwN\\(gMN,Go]\u000b\u0003\u00037\u00012ASA\u000f\u0013\r\ty\"\t\u0002\u0012\u0017\u000647.Y*pkJ\u001cWm\u00144gg\u0016$\u0018aF3oIB\u000b'\u000f^5uS>twJ\u001a4tKR\u001cx\fJ3r)\u0011\t)#a\u000b\u0011\u0007A\f9#C\u0002\u0002*q\u0013A!\u00168ji\"I\u0011Q\u0006\t\u0002\u0002\u0003\u0007\u00111D\u0001\u0004q\u0012\n\u0014\u0001F3oIB\u000b'\u000f^5uS>twJ\u001a4tKR\u001c\b%A\u0007j]&$\u0018.\u00197PM\u001a\u001cX\r\u001e\u000b\u0003\u0003k\u00012!NA\u001c\u0013\r\tID\u000e\u0002\u0007\u001f\u001a47/\u001a;\u0002'\u001d,G\u000fR3gCVdGOU3bI2KW.\u001b;\u0015\u0005\u0005}\u0002cA\u001b\u0002B%\u0019\u00111\t\u001c\u0003\u0013I+\u0017\r\u001a'j[&$\u0018\u0001\u00047bi\u0016\u001cHo\u00144gg\u0016$HCBA\u001b\u0003\u0013\ni\u0005C\u0004\u0002LU\u0001\r!!\u000e\u0002\u000bM$\u0018M\u001d;\t\u000f\u0005=S\u00031\u0001\u0002@\u0005I!/Z1e\u0019&l\u0017\u000e^\u0001\u0014a2\fg.\u00138qkR\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0007\u0003+\n\u0019'!\u001a\u0011\u000bA\f9&a\u0017\n\u0007\u0005eCLA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002^\u0005}S\"\u0001\u001d\n\u0007\u0005\u0005\u0004H\u0001\bJ]B,H\u000fU1si&$\u0018n\u001c8\t\u000f\u0005-c\u00031\u0001\u00026!9\u0011q\r\fA\u0002\u0005U\u0012aA3oI\u0006\u00192M]3bi\u0016\u0014V-\u00193fe\u001a\u000b7\r^8ssR\u0011\u0011Q\u000e\t\u0005\u0003;\ny'C\u0002\u0002ra\u0012a\u0003U1si&$\u0018n\u001c8SK\u0006$WM\u001d$bGR|'/_\u0001\u0012I\u0016\u001cXM]5bY&TXm\u00144gg\u0016$H\u0003BA\u001b\u0003oBa!!\u001f\u0019\u0001\u00041\u0016\u0001\u00026t_:\faaY8n[&$H\u0003BA\u0013\u0003\u007fBq!a\u001a\u001a\u0001\u0004\t)$\u0001\u0003ti>\u0004HCAA\u0013\u0003!!xn\u0015;sS:<G#\u0001,\u0002E\u001d,Go\u0014:De\u0016\fG/Z%oSRL\u0017\r\u001c)beRLG/[8o\u001f\u001a47/\u001a;t)\t\ti\t\u0005\u0003\u0002\u0010\u0006Ueb\u0001&\u0002\u0012&\u0019\u00111S\u0011\u0002\u000fA\f7m[1hK&!\u0011qSAM\u0005I\u0001\u0016M\u001d;ji&|gn\u00144gg\u0016$X*\u00199\u000b\u0007\u0005M\u0015%A\u0005sCR,G*[7jiRA\u0011QRAP\u0003G\u000b9\u000b\u0003\u0004\u0002\"v\u0001\rA`\u0001\u0006Y&l\u0017\u000e\u001e\u0005\b\u0003Kk\u0002\u0019AAG\u0003\u00111'o\\7\t\u000f\u0005%V\u00041\u0001\u0002\u000e\u0006)QO\u001c;jY\u0006q!/\u001a9peR$\u0015\r^1M_N\u001cH\u0003BA\u0013\u0003_Ca!!-\u001f\u0001\u00041\u0016aB7fgN\fw-Z\u0001\u001agV\u0004XM\u001d\u0013hKR$UMZ1vYR\u0014V-\u00193MS6LG/C\u0002\u0002<q\u0002")
public class KafkaMicroBatchStream
implements SupportsAdmissionControl,
MicroBatchStream,
Logging {
    private final KafkaOffsetReader kafkaOffsetReader;
    private final Map<String, Object> executorKafkaParams;
    private final String metadataPath;
    private final KafkaOffsetRangeLimit startingOffsets;
    private final boolean failOnDataLoss;
    private final long pollTimeoutMs;
    private final Option<Object> maxOffsetsPerTrigger;
    private final boolean includeHeaders;
    private KafkaSourceOffset endPartitionOffsets;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private /* synthetic */ ReadLimit super$getDefaultReadLimit() {
        return super.getDefaultReadLimit();
    }

    public KafkaOffsetReader kafkaOffsetReader() {
        return this.kafkaOffsetReader;
    }

    public long pollTimeoutMs() {
        return this.pollTimeoutMs;
    }

    public Option<Object> maxOffsetsPerTrigger() {
        return this.maxOffsetsPerTrigger;
    }

    private boolean includeHeaders() {
        return this.includeHeaders;
    }

    private KafkaSourceOffset endPartitionOffsets() {
        return this.endPartitionOffsets;
    }

    private void endPartitionOffsets_$eq(KafkaSourceOffset x$1) {
        this.endPartitionOffsets = x$1;
    }

    public Offset initialOffset() {
        return new KafkaSourceOffset(this.getOrCreateInitialPartitionOffsets());
    }

    public ReadLimit getDefaultReadLimit() {
        return (ReadLimit)this.maxOffsetsPerTrigger().map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaMicroBatchStream.$anonfun$getDefaultReadLimit$1(BoxesRunTime.unboxToLong((Object)x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.super$getDefaultReadLimit());
    }

    public Offset latestOffset() {
        throw new UnsupportedOperationException("latestOffset(Offset, ReadLimit) should be called instead of this method");
    }

    public Offset latestOffset(Offset start, ReadLimit readLimit) {
        scala.collection.immutable.Map<TopicPartition, Object> map;
        scala.collection.immutable.Map<TopicPartition, Object> startPartitionOffsets = ((KafkaSourceOffset)start).partitionToOffsets();
        scala.collection.immutable.Map<TopicPartition, Object> latestPartitionOffsets = this.kafkaOffsetReader().fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)new Some(startPartitionOffsets));
        ReadLimit readLimit2 = readLimit;
        if (readLimit2 instanceof ReadMaxRows) {
            ReadMaxRows readMaxRows = (ReadMaxRows)readLimit2;
            map = this.rateLimit(readMaxRows.maxRows(), startPartitionOffsets, latestPartitionOffsets);
        } else if (readLimit2 instanceof ReadAllAvailable) {
            map = latestPartitionOffsets;
        } else {
            throw new MatchError((Object)readLimit2);
        }
        this.endPartitionOffsets_$eq(new KafkaSourceOffset(map));
        return this.endPartitionOffsets();
    }

    public InputPartition[] planInputPartitions(Offset start, Offset end) {
        scala.collection.immutable.Map<TopicPartition, Object> startPartitionOffsets = ((KafkaSourceOffset)start).partitionToOffsets();
        scala.collection.immutable.Map<TopicPartition, Object> endPartitionOffsets = ((KafkaSourceOffset)end).partitionToOffsets();
        Seq<KafkaOffsetRange> offsetRanges = this.kafkaOffsetReader().getOffsetRangesFromResolvedOffsets(startPartitionOffsets, endPartitionOffsets, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)message -> {
            this.reportDataLoss(message);
            return BoxedUnit.UNIT;
        });
        return (InputPartition[])((TraversableOnce)offsetRanges.map((Function1 & Serializable & scala.Serializable)range -> new KafkaBatchInputPartition((KafkaOffsetRange)range, $this.executorKafkaParams, this.pollTimeoutMs(), $this.failOnDataLoss, this.includeHeaders()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(InputPartition.class));
    }

    public PartitionReaderFactory createReaderFactory() {
        return KafkaBatchReaderFactory$.MODULE$;
    }

    public Offset deserializeOffset(String json) {
        return new KafkaSourceOffset(JsonUtils$.MODULE$.partitionOffsets(json));
    }

    public void commit(Offset end) {
    }

    public void stop() {
        this.kafkaOffsetReader().close();
    }

    public String toString() {
        return new StringBuilder(9).append("KafkaV2[").append(this.kafkaOffsetReader()).append("]").toString();
    }

    private scala.collection.immutable.Map<TopicPartition, Object> getOrCreateInitialPartitionOffsets() {
        Predef$.MODULE$.assert(Thread.currentThread() instanceof UninterruptibleThread);
        Predef$.MODULE$.assert(SparkSession$.MODULE$.getActiveSession().nonEmpty());
        KafkaSourceInitialOffsetWriter metadataLog = new KafkaSourceInitialOffsetWriter((SparkSession)SparkSession$.MODULE$.getActiveSession().get(), this.metadataPath);
        return ((KafkaSourceOffset)((Object)metadataLog.get(0L).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            void var3_8;
            KafkaSourceOffset kafkaSourceOffset;
            KafkaOffsetRangeLimit kafkaOffsetRangeLimit = $this.startingOffsets;
            if (EarliestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
                kafkaSourceOffset = new KafkaSourceOffset(this.kafkaOffsetReader().fetchEarliestOffsets());
            } else if (LatestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
                kafkaSourceOffset = new KafkaSourceOffset(this.kafkaOffsetReader().fetchLatestOffsets((Option<scala.collection.immutable.Map<TopicPartition, Object>>)None$.MODULE$));
            } else if (kafkaOffsetRangeLimit instanceof SpecificOffsetRangeLimit) {
                SpecificOffsetRangeLimit specificOffsetRangeLimit = (SpecificOffsetRangeLimit)kafkaOffsetRangeLimit;
                scala.collection.immutable.Map<TopicPartition, Object> p = specificOffsetRangeLimit.partitionOffsets();
                kafkaSourceOffset = this.kafkaOffsetReader().fetchSpecificOffsets(p, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)message -> {
                    this.reportDataLoss(message);
                    return BoxedUnit.UNIT;
                });
            } else if (kafkaOffsetRangeLimit instanceof SpecificTimestampRangeLimit) {
                SpecificTimestampRangeLimit specificTimestampRangeLimit = (SpecificTimestampRangeLimit)kafkaOffsetRangeLimit;
                scala.collection.immutable.Map<TopicPartition, Object> p = specificTimestampRangeLimit.topicTimestamps();
                kafkaSourceOffset = this.kafkaOffsetReader().fetchSpecificTimestampBasedOffsets(p, true);
            } else {
                throw new MatchError((Object)kafkaOffsetRangeLimit);
            }
            KafkaSourceOffset offsets = kafkaSourceOffset;
            metadataLog.add(0L, (Object)offsets);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Initial offsets: ").append((Object)offsets).toString());
            return var3_8;
        }))).partitionToOffsets();
    }

    private scala.collection.immutable.Map<TopicPartition, Object> rateLimit(long limit, scala.collection.immutable.Map<TopicPartition, Object> from, scala.collection.immutable.Map<TopicPartition, Object> until) {
        scala.collection.immutable.Map<TopicPartition, Object> fromNew = this.kafkaOffsetReader().fetchEarliestOffsets((Seq<TopicPartition>)until.keySet().diff((GenSet)from.keySet()).toSeq());
        scala.collection.immutable.Map sizes = (scala.collection.immutable.Map)until.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long end = tuple2._2$mcJ$sp();
            Iterable iterable = Option$.MODULE$.option2Iterable(from.get((Object)tp).orElse((Function0 & Serializable & scala.Serializable)() -> fromNew.get((Object)tp)).flatMap((Function1 & Serializable & scala.Serializable)begin -> KafkaMicroBatchStream.$anonfun$rateLimit$3(this, end, tp, BoxesRunTime.unboxToLong((Object)begin))));
            return iterable;
        }, Map$.MODULE$.canBuildFrom());
        double total = BoxesRunTime.unboxToLong((Object)sizes.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        return total < 1.0 ? until : (scala.collection.immutable.Map)until.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long end = tuple2._2$mcJ$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), sizes.get((Object)tp).map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)size -> {
                long begin = BoxesRunTime.unboxToLong((Object)from.getOrElse((Object)tp, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)fromNew.apply((Object)tp))));
                double prorate = (double)limit * ((double)size / total);
                long prorateLong = (long)(prorate < 1.0 ? Math.ceil(prorate) : Math.floor(prorate));
                long off = prorateLong > Long.MAX_VALUE - begin ? Long.MAX_VALUE : begin + prorateLong;
                return Math.min(end, off);
            }).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> end));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
    }

    private void reportDataLoss(String message) {
        if (this.failOnDataLoss) {
            throw new IllegalStateException(new StringBuilder(2).append(message).append(". ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_TRUE()).toString());
        }
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(2).append(message).append(". ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_FALSE()).toString());
    }

    public static final /* synthetic */ long $anonfun$maxOffsetsPerTrigger$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toLong();
    }

    public static final /* synthetic */ ReadLimit $anonfun$getDefaultReadLimit$1(long x$1) {
        return ReadLimit.maxRows((long)x$1);
    }

    public static final /* synthetic */ Option $anonfun$rateLimit$3(KafkaMicroBatchStream $this, long end$1, TopicPartition tp$1, long begin) {
        long size = end$1 - begin;
        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("rateLimit ").append(tp$1).append(" size is ").append(size).toString());
        return size > 0L ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp$1), (Object)BoxesRunTime.boxToLong((long)size))) : None$.MODULE$;
    }

    public KafkaMicroBatchStream(KafkaOffsetReader kafkaOffsetReader, Map<String, Object> executorKafkaParams, CaseInsensitiveStringMap options, String metadataPath, KafkaOffsetRangeLimit startingOffsets, boolean failOnDataLoss) {
        this.kafkaOffsetReader = kafkaOffsetReader;
        this.executorKafkaParams = executorKafkaParams;
        this.metadataPath = metadataPath;
        this.startingOffsets = startingOffsets;
        this.failOnDataLoss = failOnDataLoss;
        Logging.$init$((Logging)this);
        this.pollTimeoutMs = options.getLong(KafkaSourceProvider$.MODULE$.CONSUMER_POLL_TIMEOUT(), BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Network$.MODULE$.NETWORK_TIMEOUT())) * 1000L);
        this.maxOffsetsPerTrigger = Option$.MODULE$.apply((Object)options.get((Object)KafkaSourceProvider$.MODULE$.MAX_OFFSET_PER_TRIGGER())).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)KafkaMicroBatchStream.$anonfun$maxOffsetsPerTrigger$1(x$1)));
        this.includeHeaders = options.getBoolean(KafkaSourceProvider$.MODULE$.INCLUDE_HEADERS(), false);
    }
}

