/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.ExecutorCacheTaskLocation;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.kafka010.ConsumerStrategy;
import org.apache.spark.sql.kafka010.EarliestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.KafkaOffsetRange;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeCalculator;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.KafkaSourceOffset;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.sql.kafka010.LatestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.SpecificOffsetRangeLimit;
import org.apache.spark.sql.kafka010.SpecificTimestampRangeLimit;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.UninterruptibleThread;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t5g!\u0002\u001a4\u0001Mj\u0004\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u0011A\u0003!Q1A\u0005\u0002EC\u0001b\u001b\u0001\u0003\u0002\u0003\u0006IA\u0015\u0005\tY\u0002\u0011\t\u0011)A\u0005[\"AA\u000f\u0001B\u0001B\u0003%!\fC\u0003v\u0001\u0011\u0005a\u000fC\u0004}\u0001\t\u0007I\u0011A?\t\u000f\u0005%\u0001\u0001)A\u0005}\"I\u00111\u0002\u0001C\u0002\u0013\u0005\u0011Q\u0002\u0005\t\u00033\u0001\u0001\u0015!\u0003\u0002\u0010!I\u00111\u0004\u0001A\u0002\u0013%\u0011Q\u0004\u0005\n\u0003?\u0001\u0001\u0019!C\u0005\u0003CAq!!\f\u0001A\u0003&!\fC\u0005\u00020\u0001\u0001\r\u0011\"\u0003\u00022!I\u0011\u0011\b\u0001A\u0002\u0013%\u00111\b\u0005\t\u0003\u007f\u0001\u0001\u0015)\u0003\u00024!I\u0011\u0011\t\u0001A\u0002\u0013E\u00111\t\u0005\n\u0003K\u0002\u0001\u0019!C\t\u0003OB\u0001\"a\u001b\u0001A\u0003&\u0011Q\t\u0005\b\u0003\u0017\u0002A\u0011CA\"\u0011)\t)\b\u0001b\u0001\n\u0003\u0019\u0014\u0011\u0007\u0005\t\u0003o\u0002\u0001\u0015!\u0003\u00024!I\u0011\u0011\u0010\u0001C\u0002\u0013%\u00111\u0010\u0005\t\u0003\u0007\u0003\u0001\u0015!\u0003\u0002~!I\u0011Q\u0011\u0001C\u0002\u0013%\u0011q\u0011\u0005\t\u0003\u001f\u0003\u0001\u0015!\u0003\u0002\n\"Q\u0011\u0011\u0013\u0001C\u0002\u0013\u00051'a%\t\u0011\u0005m\u0005\u0001)A\u0005\u0003+Cq!!(\u0001\t\u0013\ty\nC\u0004\u0002,\u0002!I!!,\t\u000f\u0005=\u0006\u0001\"\u0011\u0002.\"9\u0011\u0011\u0017\u0001\u0005\u0002\u0005M\u0006bBA[\u0001\u0011\u0005\u0011q\u0017\u0005\b\u0003\u0017\u0004A\u0011AAg\u0011\u001d\t\t\u000f\u0001C\u0001\u0003GDq!!?\u0001\t\u0003\tY\u0010C\u0004\u0003\u0006\u0001!IAa\u0002\t\u000f\t}\u0001\u0001\"\u0001\u0003\"!9!1\u0005\u0001\u0005\u0002\t\u0015\u0002b\u0002B\u0010\u0001\u0011\u0005!1\b\u0005\b\u0005#\u0002A\u0011\u0001B*\u0011\u001d\u0011)\u0007\u0001C\u0005\u0005OBqAa\u001b\u0001\t\u0003\u0011i\u0007C\u0004\u0003z\u0001!IAa\u001f\t\u0013\t\u0015\u0005!%A\u0005\n\t\u001d\u0005b\u0002BO\u0001\u0011%!q\u0014\u0005\b\u0005\u0003\u0004A\u0011\u0002Bb\u0011\u001d\u0011I\r\u0001C\u0005\u0003gCqAa3\u0001\t\u0013\t\u0019LA\tLC\u001a\\\u0017m\u00144gg\u0016$(+Z1eKJT!\u0001N\u001b\u0002\u0011-\fgm[11cAR!AN\u001c\u0002\u0007M\fHN\u0003\u00029s\u0005)1\u000f]1sW*\u0011!hO\u0001\u0007CB\f7\r[3\u000b\u0003q\n1a\u001c:h'\r\u0001a\b\u0012\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0002\u0003\u0006)1oY1mC&\u00111\t\u0011\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001d;\u0014\u0001C5oi\u0016\u0014h.\u00197\n\u0005%3%a\u0002'pO\u001eLgnZ\u0001\u0011G>t7/^7feN#(/\u0019;fOf\u001c\u0001\u0001\u0005\u0002N\u001d6\t1'\u0003\u0002Pg\t\u00012i\u001c8tk6,'o\u0015;sCR,w-_\u0001\u0012IJLg/\u001a:LC\u001a\\\u0017\rU1sC6\u001cX#\u0001*\u0011\tMC&,Z\u0007\u0002)*\u0011QKV\u0001\u0005kRLGNC\u0001X\u0003\u0011Q\u0017M^1\n\u0005e#&aA'baB\u00111L\u0019\b\u00039\u0002\u0004\"!\u0018!\u000e\u0003yS!aX&\u0002\rq\u0012xn\u001c;?\u0013\t\t\u0007)\u0001\u0004Qe\u0016$WMZ\u0005\u0003G\u0012\u0014aa\u0015;sS:<'BA1A!\t1\u0017.D\u0001h\u0015\tAg+\u0001\u0003mC:<\u0017B\u00016h\u0005\u0019y%M[3di\u0006\u0011BM]5wKJ\\\u0015MZ6b!\u0006\u0014\u0018-\\:!\u00035\u0011X-\u00193fe>\u0003H/[8ogB\u0019aN\u001d.\u000e\u0003=T!!\u00169\u000b\u0005E,\u0014\u0001C2bi\u0006d\u0017p\u001d;\n\u0005M|'AE\"bg\u0016Len]3og&$\u0018N^3NCB\f1\u0003\u001a:jm\u0016\u0014xI]8va&#\u0007K]3gSb\fa\u0001P5oSRtD#B<ysj\\\bCA'\u0001\u0011\u0015Qe\u00011\u0001M\u0011\u0015\u0001f\u00011\u0001S\u0011\u0015ag\u00011\u0001n\u0011\u0015!h\u00011\u0001[\u0003EY\u0017MZ6b%\u0016\fG-\u001a:UQJ,\u0017\rZ\u000b\u0002}B\u0019q0!\u0002\u000e\u0005\u0005\u0005!bAA\u0002)\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005\u001d\u0011\u0011\u0001\u0002\u0010\u000bb,7-\u001e;peN+'O^5dK\u0006\u00112.\u00194lCJ+\u0017\rZ3s)\"\u0014X-\u00193!\u0003-)\u00070Z2D_:$X\r\u001f;\u0016\u0005\u0005=\u0001\u0003BA\t\u0003+i!!a\u0005\u000b\u0007\u0005\r\u0001)\u0003\u0003\u0002\u0018\u0005M!aH#yK\u000e,H/[8o\u0007>tG/\u001a=u\u000bb,7-\u001e;peN+'O^5dK\u0006aQ\r_3d\u0007>tG/\u001a=uA\u00059qM]8va&#W#\u0001.\u0002\u0017\u001d\u0014x.\u001e9JI~#S-\u001d\u000b\u0005\u0003G\tI\u0003E\u0002@\u0003KI1!a\nA\u0005\u0011)f.\u001b;\t\u0011\u0005-B\"!AA\u0002i\u000b1\u0001\u001f\u00132\u0003!9'o\\;q\u0013\u0012\u0004\u0013A\u00028fqRLE-\u0006\u0002\u00024A\u0019q(!\u000e\n\u0007\u0005]\u0002IA\u0002J]R\f!B\\3yi&#w\fJ3r)\u0011\t\u0019#!\u0010\t\u0013\u0005-r\"!AA\u0002\u0005M\u0012a\u00028fqRLE\rI\u0001\n?\u000e|gn];nKJ,\"!!\u0012\u0011\u0011\u0005\u001d\u0013QKA-\u00033j!!!\u0013\u000b\t\u0005-\u0013QJ\u0001\tG>t7/^7fe*!\u0011qJA)\u0003\u001d\u0019G.[3oiNT1!a\u0015:\u0003\u0015Y\u0017MZ6b\u0013\u0011\t9&!\u0013\u0003\u0011\r{gn];nKJ\u0004RaPA.\u0003?J1!!\u0018A\u0005\u0015\t%O]1z!\ry\u0014\u0011M\u0005\u0004\u0003G\u0002%\u0001\u0002\"zi\u0016\fQbX2p]N,X.\u001a:`I\u0015\fH\u0003BA\u0012\u0003SB\u0011\"a\u000b\u0013\u0003\u0003\u0005\r!!\u0012\u0002\u0015}\u001bwN\\:v[\u0016\u0014\b\u0005K\u0002\u0014\u0003_\u00022aPA9\u0013\r\t\u0019\b\u0011\u0002\tm>d\u0017\r^5mK\u00061R.\u0019=PM\u001a\u001cX\r\u001e$fi\u000eD\u0017\t\u001e;f[B$8/A\fnCb|eMZ:fi\u001a+Go\u00195BiR,W\u000e\u001d;tA\u0005iQ.\u001b8QCJ$\u0018\u000e^5p]N,\"!! \u0011\u000b}\ny(a\r\n\u0007\u0005\u0005\u0005I\u0001\u0004PaRLwN\\\u0001\u000f[&t\u0007+\u0019:uSRLwN\\:!\u0003=\u0011\u0018M\\4f\u0007\u0006d7-\u001e7bi>\u0014XCAAE!\ri\u00151R\u0005\u0004\u0003\u001b\u001b$AG&bM.\fwJ\u001a4tKR\u0014\u0016M\\4f\u0007\u0006d7-\u001e7bi>\u0014\u0018\u0001\u0005:b]\u001e,7)\u00197dk2\fGo\u001c:!\u0003qygMZ:fi\u001a+Go\u00195BiR,W\u000e\u001d;J]R,'O^1m\u001bN,\"!!&\u0011\u0007}\n9*C\u0002\u0002\u001a\u0002\u0013A\u0001T8oO\u0006irN\u001a4tKR4U\r^2i\u0003R$X-\u001c9u\u0013:$XM\u001d<bY6\u001b\b%\u0001\u000ftQ>,H\u000e\u001a#jmZLX\u000b\u001d'be\u001e,\u0007+\u0019:uSRLwN\\:\u0015\t\u0005\u0005\u0016q\u0015\t\u0004\u007f\u0005\r\u0016bAAS\u0001\n9!i\\8mK\u0006t\u0007bBAU;\u0001\u0007\u00111G\u0001\u0013]VlGk\u001c9jGB\u000b'\u000f^5uS>t7/A\u0006oKb$xI]8va&#G#\u0001.\u0002\u0011Q|7\u000b\u001e:j]\u001e\fQa\u00197pg\u0016$\"!a\t\u0002)\u0019,Go\u00195U_BL7\rU1si&$\u0018n\u001c8t)\t\tI\fE\u0003\\\u0003w\u000by,C\u0002\u0002>\u0012\u00141aU3u!\u0011\t\t-a2\u000e\u0005\u0005\r'\u0002BAc\u0003#\naaY8n[>t\u0017\u0002BAe\u0003\u0007\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\u000bgKR\u001c\u0007\u000eU1si&$\u0018n\u001c8PM\u001a\u001cX\r^:\u0015\r\u0005=\u00171[Ao!\u001dY\u0016\u0011[A`\u0003+K!!\u00173\t\u000f\u0005U'\u00051\u0001\u0002X\u0006\u0001rN\u001a4tKR\u0014\u0016M\\4f\u0019&l\u0017\u000e\u001e\t\u0004\u001b\u0006e\u0017bAAng\t)2*\u00194lC>3gm]3u%\u0006tw-\u001a'j[&$\bbBApE\u0001\u0007\u0011\u0011U\u0001\u0012SN\u001cF/\u0019:uS:<wJ\u001a4tKR\u001c\u0018\u0001\u00064fi\u000eD7\u000b]3dS\u001aL7m\u00144gg\u0016$8\u000f\u0006\u0004\u0002f\u0006-\u0018q\u001e\t\u0004\u001b\u0006\u001d\u0018bAAug\t\t2*\u00194lCN{WO]2f\u001f\u001a47/\u001a;\t\u000f\u000558\u00051\u0001\u0002P\u0006\u0001\u0002/\u0019:uSRLwN\\(gMN,Go\u001d\u0005\b\u0003c\u001c\u0003\u0019AAz\u00039\u0011X\r]8si\u0012\u000bG/\u0019'pgN\u0004baPA{5\u0006\r\u0012bAA|\u0001\nIa)\u001e8di&|g.M\u0001#M\u0016$8\r[*qK\u000eLg-[2US6,7\u000f^1na\n\u000b7/\u001a3PM\u001a\u001cX\r^:\u0015\r\u0005\u0015\u0018Q B\u0001\u0011\u001d\ty\u0010\na\u0001\u0003\u001f\f1\u0003]1si&$\u0018n\u001c8US6,7\u000f^1naNDqAa\u0001%\u0001\u0004\t\t+A\fgC&d7o\u00148O_6\u000bGo\u00195j]\u001e|eMZ:fi\u0006)b-\u001a;dQN\u0003XmY5gS\u000e|eMZ:fiN\u0004D\u0003CAs\u0005\u0013\u0011\u0019B!\u0007\t\u000f\t-Q\u00051\u0001\u0003\u000e\u0005\u0001cM\\!tg\u0016\u0014H\u000fU1sC6,G/\u001a:t/&$\b\u000eU1si&$\u0018n\u001c8t!\u001dy\u0014Q\u001fB\b\u0003G\u0001Ra\u0015B\t\u0003\u007fK1!!0U\u0011\u001d\u0011)\"\na\u0001\u0005/\t!D\u001a8SKR\u0014\u0018.\u001a<f!\u0006\u0014H/\u001b;j_:|eMZ:fiN\u0004raPA{\u0005\u001f\ty\rC\u0004\u0003\u001c\u0015\u0002\rA!\b\u0002-\u0019t\u0017i]:feR4U\r^2iK\u0012|eMZ:fiN\u0004raPA{\u0003\u001f\f\u0019#\u0001\u000bgKR\u001c\u0007.R1sY&,7\u000f^(gMN,Go\u001d\u000b\u0003\u0003\u001f\f!CZ3uG\"d\u0015\r^3ti>3gm]3ugR!!q\u0005B\u001b!\u0011\u0011ICa\f\u000f\u00075\u0013Y#C\u0002\u0003.M\nq\u0001]1dW\u0006<W-\u0003\u0003\u00032\tM\"A\u0005)beRLG/[8o\u001f\u001a47/\u001a;NCBT1A!\f4\u0011\u001d\u00119d\na\u0001\u0005s\tAb\u001b8po:|eMZ:fiN\u0004RaPA@\u0005O!B!a4\u0003>!9!q\b\u0015A\u0002\t\u0005\u0013!\u00048foB\u000b'\u000f^5uS>t7\u000f\u0005\u0004\u0003D\t-\u0013q\u0018\b\u0005\u0005\u000b\u0012IED\u0002^\u0005\u000fJ\u0011!Q\u0005\u0004\u0005[\u0001\u0015\u0002\u0002B'\u0005\u001f\u00121aU3r\u0015\r\u0011i\u0003Q\u0001%O\u0016$xJ\u001a4tKR\u0014\u0016M\\4fg\u001a\u0013x.\\+oe\u0016\u001cx\u000e\u001c<fI>3gm]3ugR1!Q\u000bB/\u0005C\u0002bAa\u0011\u0003L\t]\u0003cA'\u0003Z%\u0019!1L\u001a\u0003!-\u000bgm[1PM\u001a\u001cX\r\u001e*b]\u001e,\u0007b\u0002B0S\u0001\u0007\u0011q[\u0001\u0010gR\f'\u000f^5oO>3gm]3ug\"9!1M\u0015A\u0002\u0005]\u0017!D3oI&twm\u00144gg\u0016$8/A\u000bhKR\u001cvN\u001d;fI\u0016CXmY;u_Jd\u0015n\u001d;\u0015\u0005\t%\u0004\u0003B \u0002\\i\u000b!eZ3u\u001f\u001a47/\u001a;SC:<Wm\u001d$s_6\u0014Vm]8mm\u0016$wJ\u001a4tKR\u001cH\u0003\u0003B+\u0005_\u0012\u0019Ha\u001e\t\u000f\tE4\u00061\u0001\u0003(\u0005!bM]8n!\u0006\u0014H/\u001b;j_:|eMZ:fiNDqA!\u001e,\u0001\u0004\u00119#A\u000bv]RLG\u000eU1si&$\u0018n\u001c8PM\u001a\u001cX\r^:\t\u000f\u0005E8\u00061\u0001\u0002t\u0006a\u0002/\u0019:uSRLwN\\:BgNLwM\\3e)>\u001cuN\\:v[\u0016\u0014HCBAh\u0005{\u0012\t\tC\u0004\u0003\u00001\u0002\rAa\u0006\u0002\t\t|G-\u001f\u0005\n\u0005\u0007c\u0003\u0013!a\u0001\u0003C\u000baCZ3uG\"LgnZ#be2LWm\u001d;PM\u001a\u001cX\r^\u0001'a\u0006\u0014H/\u001b;j_:\u001c\u0018i]:jO:,G\rV8D_:\u001cX/\\3sI\u0011,g-Y;mi\u0012\u0012TC\u0001BEU\u0011\t\tKa#,\u0005\t5\u0005\u0003\u0002BH\u00053k!A!%\u000b\t\tM%QS\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa&A\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00057\u0013\tJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!C];o+:Lg\u000e^3seV\u0004H/\u001b2msV!!\u0011\u0015BT)\u0011\u0011\u0019K!/\u0011\t\t\u0015&q\u0015\u0007\u0001\t\u001d\u0011IK\fb\u0001\u0005W\u0013\u0011\u0001V\t\u0005\u0005[\u0013\u0019\fE\u0002@\u0005_K1A!-A\u0005\u001dqu\u000e\u001e5j]\u001e\u00042a\u0010B[\u0013\r\u00119\f\u0011\u0002\u0004\u0003:L\b\u0002\u0003B@]\u0011\u0005\rAa/\u0011\u000b}\u0012iLa)\n\u0007\t}\u0006I\u0001\u0005=Eft\u0017-\\3?\u0003m9\u0018\u000e\u001e5SKR\u0014\u0018.Z:XSRDw.\u001e;J]R,'O];qiR!\u0011q\u001aBc\u0011!\u0011yh\fCA\u0002\t\u001d\u0007#B \u0003>\u0006=\u0017\u0001D:u_B\u001cuN\\:v[\u0016\u0014\u0018!\u0004:fg\u0016$8i\u001c8tk6,'\u000f")
public class KafkaOffsetReader
implements Logging {
    private final ConsumerStrategy consumerStrategy;
    private final java.util.Map<String, Object> driverKafkaParams;
    private final String driverGroupIdPrefix;
    private final ExecutorService kafkaReaderThread;
    private final ExecutionContextExecutorService execContext;
    private String groupId;
    private int nextId;
    private volatile Consumer<byte[], byte[]> _consumer;
    private final int maxOffsetFetchAttempts;
    private final Option<Object> minPartitions;
    private final KafkaOffsetRangeCalculator rangeCalculator;
    private final long offsetFetchAttemptIntervalMs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public java.util.Map<String, Object> driverKafkaParams() {
        return this.driverKafkaParams;
    }

    public ExecutorService kafkaReaderThread() {
        return this.kafkaReaderThread;
    }

    public ExecutionContextExecutorService execContext() {
        return this.execContext;
    }

    private String groupId() {
        return this.groupId;
    }

    private void groupId_$eq(String x$1) {
        this.groupId = x$1;
    }

    private int nextId() {
        return this.nextId;
    }

    private void nextId_$eq(int x$1) {
        this.nextId = x$1;
    }

    public Consumer<byte[], byte[]> _consumer() {
        return this._consumer;
    }

    public void _consumer_$eq(Consumer<byte[], byte[]> x$1) {
        this._consumer = x$1;
    }

    public synchronized Consumer<byte[], byte[]> consumer() {
        block0: {
            Predef$.MODULE$.assert(Thread.currentThread() instanceof UninterruptibleThread);
            if (this._consumer() != null) break block0;
            HashMap<String, Object> newKafkaParams = new HashMap<String, Object>(this.driverKafkaParams());
            Object object = this.driverKafkaParams().get("group.id") == null ? newKafkaParams.put("group.id", this.nextGroupId()) : BoxedUnit.UNIT;
            this._consumer_$eq(this.consumerStrategy.createConsumer(newKafkaParams));
        }
        return this._consumer();
    }

    public int maxOffsetFetchAttempts() {
        return this.maxOffsetFetchAttempts;
    }

    private Option<Object> minPartitions() {
        return this.minPartitions;
    }

    private KafkaOffsetRangeCalculator rangeCalculator() {
        return this.rangeCalculator;
    }

    public long offsetFetchAttemptIntervalMs() {
        return this.offsetFetchAttemptIntervalMs;
    }

    private boolean shouldDivvyUpLargePartitions(int numTopicPartitions) {
        return BoxesRunTime.unboxToBoolean((Object)this.minPartitions().map((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> x$2 > numTopicPartitions).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
    }

    private String nextGroupId() {
        this.groupId_$eq(new StringBuilder(1).append(this.driverGroupIdPrefix).append("-").append(this.nextId()).toString());
        this.nextId_$eq(this.nextId() + 1);
        return this.groupId();
    }

    public String toString() {
        return this.consumerStrategy.toString();
    }

    public void close() {
        Object object = this._consumer() != null ? this.runUninterruptibly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.stopConsumer()) : BoxedUnit.UNIT;
        this.kafkaReaderThread().shutdown();
    }

    public scala.collection.immutable.Set<TopicPartition> fetchTopicPartitions() {
        return (scala.collection.immutable.Set)this.runUninterruptibly((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.assert(Thread.currentThread() instanceof UninterruptibleThread);
            this.consumer().poll(0L);
            Set partitions = this.consumer().assignment();
            this.consumer().pause((Collection)partitions);
            return ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala()).toSet();
        });
    }

    public scala.collection.immutable.Map<TopicPartition, Object> fetchPartitionOffsets(KafkaOffsetRangeLimit offsetRangeLimit, boolean isStartingOffsets) {
        scala.collection.immutable.Map<TopicPartition, Object> map;
        scala.collection.immutable.Set<TopicPartition> partitions = this.fetchTopicPartitions();
        KafkaOffsetRangeLimit kafkaOffsetRangeLimit = offsetRangeLimit;
        if (EarliestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
            map = ((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                TopicPartition topicPartition = x0$1;
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)KafkaOffsetRangeLimit$.MODULE$.EARLIEST()));
                return tuple2;
            }, scala.collection.immutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        } else if (LatestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
            map = ((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                TopicPartition topicPartition = x0$2;
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)KafkaOffsetRangeLimit$.MODULE$.LATEST()));
                return tuple2;
            }, scala.collection.immutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        } else if (kafkaOffsetRangeLimit instanceof SpecificOffsetRangeLimit) {
            SpecificOffsetRangeLimit specificOffsetRangeLimit = (SpecificOffsetRangeLimit)kafkaOffsetRangeLimit;
            scala.collection.immutable.Map<TopicPartition, Object> partitionOffsets = specificOffsetRangeLimit.partitionOffsets();
            map = this.validateTopicPartitions$1(partitions, partitionOffsets);
        } else if (kafkaOffsetRangeLimit instanceof SpecificTimestampRangeLimit) {
            SpecificTimestampRangeLimit specificTimestampRangeLimit = (SpecificTimestampRangeLimit)kafkaOffsetRangeLimit;
            scala.collection.immutable.Map<TopicPartition, Object> partitionTimestamps = specificTimestampRangeLimit.topicTimestamps();
            map = this.fetchSpecificTimestampBasedOffsets(partitionTimestamps, isStartingOffsets).partitionToOffsets();
        } else {
            throw new MatchError((Object)kafkaOffsetRangeLimit);
        }
        return map;
    }

    public KafkaSourceOffset fetchSpecificOffsets(scala.collection.immutable.Map<TopicPartition, Object> partitionOffsets, Function1<String, BoxedUnit> reportDataLoss) {
        Function1 & Serializable & scala.Serializable fnAssertParametersWithPartitions = (Function1 & Serializable & scala.Serializable)partitions -> {
            KafkaOffsetReader.$anonfun$fetchSpecificOffsets$1(this, partitionOffsets, partitions);
            return BoxedUnit.UNIT;
        };
        Function1 & Serializable & scala.Serializable fnRetrievePartitionOffsets = (Function1 & Serializable & scala.Serializable)x$3 -> partitionOffsets;
        Function1 & Serializable & scala.Serializable fnAssertFetchedOffsets = (Function1 & Serializable & scala.Serializable)fetched -> {
            partitionOffsets.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                KafkaOffsetReader.$anonfun$fetchSpecificOffsets$6(fetched, reportDataLoss$1, x0$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        };
        return this.fetchSpecificOffsets0((Function1<Set<TopicPartition>, BoxedUnit>)fnAssertParametersWithPartitions, (Function1<Set<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Object>>)fnRetrievePartitionOffsets, (Function1<scala.collection.immutable.Map<TopicPartition, Object>, BoxedUnit>)fnAssertFetchedOffsets);
    }

    public KafkaSourceOffset fetchSpecificTimestampBasedOffsets(scala.collection.immutable.Map<TopicPartition, Object> partitionTimestamps, boolean failsOnNoMatchingOffset) {
        Function1 & Serializable & scala.Serializable fnAssertParametersWithPartitions = (Function1 & Serializable & scala.Serializable)partitions -> {
            KafkaOffsetReader.$anonfun$fetchSpecificTimestampBasedOffsets$1(this, partitionTimestamps, partitions);
            return BoxedUnit.UNIT;
        };
        Function1 & Serializable & scala.Serializable fnRetrievePartitionOffsets = (Function1 & Serializable & scala.Serializable)x$4 -> {
            java.util.Map converted = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionTimestamps.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                long timestamp = tuple2._2$mcJ$sp();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)timestamp);
                return tuple22;
            }, scala.collection.immutable.Map$.MODULE$.canBuildFrom())).asJava();
            java.util.Map offsetForTime = this.consumer().offsetsForTimes(converted);
            return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(offsetForTime).asScala()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                OffsetAndTimestamp offsetAndTimestamp;
                TopicPartition tp;
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    tp = (TopicPartition)tuple2._1();
                    offsetAndTimestamp = (OffsetAndTimestamp)tuple2._2();
                    if (failsOnNoMatchingOffset) {
                        Predef$.MODULE$.assert(offsetAndTimestamp != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("No offset matched from request of ").append("topic-partition ").append(tp).append(" and timestamp ").append(partitionTimestamps.apply((Object)tp)).append(".").toString());
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                Tuple2 tuple22 = offsetAndTimestamp == null ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)KafkaOffsetRangeLimit$.MODULE$.LATEST())) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)offsetAndTimestamp.offset()));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        };
        Function1 & Serializable & scala.Serializable fnAssertFetchedOffsets = (Function1 & Serializable & scala.Serializable)x$5 -> {
            KafkaOffsetReader.$anonfun$fetchSpecificTimestampBasedOffsets$8(x$5);
            return BoxedUnit.UNIT;
        };
        return this.fetchSpecificOffsets0((Function1<Set<TopicPartition>, BoxedUnit>)fnAssertParametersWithPartitions, (Function1<Set<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Object>>)fnRetrievePartitionOffsets, (Function1<scala.collection.immutable.Map<TopicPartition, Object>, BoxedUnit>)fnAssertFetchedOffsets);
    }

    private KafkaSourceOffset fetchSpecificOffsets0(Function1<Set<TopicPartition>, BoxedUnit> fnAssertParametersWithPartitions, Function1<Set<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Object>> fnRetrievePartitionOffsets, Function1<scala.collection.immutable.Map<TopicPartition, Object>, BoxedUnit> fnAssertFetchedOffsets) {
        scala.collection.immutable.Map<TopicPartition, Object> fetched = this.partitionsAssignedToConsumer((Function1<Set<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Object>>)(Function1 & Serializable & scala.Serializable)partitions -> {
            fnAssertParametersWithPartitions.apply(partitions);
            scala.collection.immutable.Map partitionOffsets = (scala.collection.immutable.Map)fnRetrievePartitionOffsets.apply(partitions);
            partitionOffsets.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                KafkaOffsetReader.$anonfun$fetchSpecificOffsets0$2(this, x0$1);
                return BoxedUnit.UNIT;
            });
            return (scala.collection.immutable.Map)partitionOffsets.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)this.consumer().position(tp)));
                return tuple22;
            }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        }, this.partitionsAssignedToConsumer$default$2());
        fnAssertFetchedOffsets.apply(fetched);
        return new KafkaSourceOffset(fetched);
    }

    public scala.collection.immutable.Map<TopicPartition, Object> fetchEarliestOffsets() {
        return this.partitionsAssignedToConsumer((Function1<Set<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Object>>)(Function1 & Serializable & scala.Serializable)partitions -> {
            void var2_2;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Seeking to the beginning");
            this.consumer().seekToBeginning((Collection)partitions);
            scala.collection.immutable.Map partitionOffsets = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala()).map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p), (Object)BoxesRunTime.boxToLong((long)this.consumer().position(p))), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Got earliest offsets for partition : ").append(partitionOffsets).toString());
            return var2_2;
        }, true);
    }

    public scala.collection.immutable.Map<TopicPartition, Object> fetchLatestOffsets(Option<scala.collection.immutable.Map<TopicPartition, Object>> knownOffsets) {
        return this.partitionsAssignedToConsumer((Function1<Set<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Object>>)(Function1 & Serializable & scala.Serializable)partitions -> {
            scala.collection.immutable.Map map;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Seeking to the end.");
            if (knownOffsets.isEmpty()) {
                this.consumer().seekToEnd((Collection)partitions);
                map = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala()).map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p), (Object)BoxesRunTime.boxToLong((long)this.consumer().position(p))), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            } else {
                ObjectRef partitionOffsets = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
                ObjectRef incorrectOffsets = ObjectRef.create((Object)Nil$.MODULE$);
                int attempt = 0;
                do {
                    this.consumer().seekToEnd((Collection)partitions);
                    partitionOffsets.elem = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala()).map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p), (Object)BoxesRunTime.boxToLong((long)this.consumer().position(p))), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    ++attempt;
                    incorrectOffsets.elem = KafkaOffsetReader.findIncorrectOffsets$1(partitionOffsets, knownOffsets);
                    if (!((Seq)incorrectOffsets.elem).nonEmpty()) continue;
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(89).append("Found incorrect offsets in some partitions ").append("(partition, previous offset, fetched offset): ").append((Seq)incorrectOffsets$2.elem).toString());
                    if (attempt >= this.maxOffsetFetchAttempts()) continue;
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Retrying to fetch latest offsets because of incorrect offsets");
                    Thread.sleep(this.offsetFetchAttemptIntervalMs());
                } while (((Seq)incorrectOffsets.elem).nonEmpty() && attempt < this.maxOffsetFetchAttempts());
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Got latest offsets for partition : ").append((scala.collection.immutable.Map)partitionOffsets$4.elem).toString());
                map = (scala.collection.immutable.Map)partitionOffsets.elem;
            }
            return map;
        }, this.partitionsAssignedToConsumer$default$2());
    }

    public scala.collection.immutable.Map<TopicPartition, Object> fetchEarliestOffsets(Seq<TopicPartition> newPartitions) {
        return newPartitions.isEmpty() ? Predef$.MODULE$.Map().empty() : this.partitionsAssignedToConsumer((Function1<Set<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Object>>)(Function1 & Serializable & scala.Serializable)partitions -> {
            void var3_3;
            this.consumer().seekToBeginning((Collection)partitions);
            scala.collection.immutable.Map partitionOffsets = ((TraversableOnce)((TraversableLike)newPartitions.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)partitions.contains(p)))).map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p), (Object)BoxesRunTime.boxToLong((long)this.consumer().position(p))), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Got earliest offsets for new partitions: ").append(partitionOffsets).toString());
            return var3_3;
        }, true);
    }

    public Seq<KafkaOffsetRange> getOffsetRangesFromUnresolvedOffsets(KafkaOffsetRangeLimit startingOffsets, KafkaOffsetRangeLimit endingOffsets) {
        Seq seq;
        scala.collection.immutable.Map<TopicPartition, Object> fromPartitionOffsets = this.fetchPartitionOffsets(startingOffsets, true);
        scala.collection.immutable.Map<TopicPartition, Object> untilPartitionOffsets = this.fetchPartitionOffsets(endingOffsets, false);
        scala.collection.immutable.Set set = fromPartitionOffsets.keySet();
        scala.collection.immutable.Set set2 = untilPartitionOffsets.keySet();
        if (set == null ? set2 != null : !set.equals(set2)) {
            Ordering topicOrdering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)t -> t.topic(), (Ordering)Ordering.String$.MODULE$);
            String fromTopics = ((TraversableOnce)fromPartitionOffsets.keySet().toList().sorted(topicOrdering)).mkString(",");
            String untilTopics = ((TraversableOnce)untilPartitionOffsets.keySet().toList().sorted(topicOrdering)).mkString(",");
            throw new IllegalStateException(new StringBuilder(84).append("different topic partitions ").append("for starting offsets topics[").append(fromTopics).append("] and ").append("ending offsets topics[").append(untilTopics).append("]").toString());
        }
        Seq offsetRangesBase = ((SetLike)untilPartitionOffsets.keySet().map((Function1 & Serializable & scala.Serializable)tp -> {
            long fromOffset = BoxesRunTime.unboxToLong((Object)fromPartitionOffsets.get(tp).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException(new StringBuilder(27).append(tp).append(" doesn't have a from offset").toString());
            }));
            long untilOffset = BoxesRunTime.unboxToLong((Object)untilPartitionOffsets.apply(tp));
            return new KafkaOffsetRange((TopicPartition)tp, fromOffset, untilOffset, (Option<String>)None$.MODULE$);
        }, scala.collection.immutable.Set$.MODULE$.canBuildFrom())).toSeq();
        if (this.shouldDivvyUpLargePartitions(offsetRangesBase.size())) {
            scala.collection.immutable.Map fromOffsetsMap = ((TraversableOnce)offsetRangesBase.map((Function1 & Serializable & scala.Serializable)range -> new Tuple2((Object)range.topicPartition(), (Object)BoxesRunTime.boxToLong((long)range.fromOffset())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            scala.collection.immutable.Map untilOffsetsMap = ((TraversableOnce)offsetRangesBase.map((Function1 & Serializable & scala.Serializable)range -> new Tuple2((Object)range.topicPartition(), (Object)BoxesRunTime.boxToLong((long)range.untilOffset())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            scala.collection.immutable.Map<TopicPartition, Object> resolvedFromOffsets = this.fetchSpecificOffsets((scala.collection.immutable.Map<TopicPartition, Object>)fromOffsetsMap, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$7 -> {
                KafkaOffsetReader.$anonfun$getOffsetRangesFromUnresolvedOffsets$6(x$7);
                return BoxedUnit.UNIT;
            }).partitionToOffsets();
            scala.collection.immutable.Map<TopicPartition, Object> resolvedUntilOffsets = this.fetchSpecificOffsets((scala.collection.immutable.Map<TopicPartition, Object>)untilOffsetsMap, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$8 -> {
                KafkaOffsetReader.$anonfun$getOffsetRangesFromUnresolvedOffsets$7(x$8);
                return BoxedUnit.UNIT;
            }).partitionToOffsets();
            Seq ranges = (Seq)((TraversableLike)offsetRangesBase.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.topicPartition(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)tp -> new KafkaOffsetRange((TopicPartition)tp, BoxesRunTime.unboxToLong((Object)resolvedFromOffsets.apply(tp)), BoxesRunTime.unboxToLong((Object)resolvedUntilOffsets.apply(tp)), (Option<String>)None$.MODULE$), Seq$.MODULE$.canBuildFrom());
            scala.collection.immutable.Map divvied = this.rangeCalculator().getRanges((Seq<KafkaOffsetRange>)ranges, this.rangeCalculator().getRanges$default$2()).groupBy((Function1 & Serializable & scala.Serializable)x$10 -> x$10.topicPartition());
            seq = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)divvied.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Seq seq;
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    Seq splitOffsetRanges = (Seq)tuple2._2();
                    if (splitOffsetRanges.length() == 1) {
                        seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{new KafkaOffsetRange(tp, BoxesRunTime.unboxToLong((Object)fromOffsetsMap.apply((Object)tp)), BoxesRunTime.unboxToLong((Object)untilOffsetsMap.apply((Object)tp)), (Option<String>)None$.MODULE$)}));
                    } else {
                        KafkaOffsetRange qual$1 = (KafkaOffsetRange)splitOffsetRanges.head();
                        long x$1 = BoxesRunTime.unboxToLong((Object)fromOffsetsMap.apply((Object)tp));
                        TopicPartition x$2 = qual$1.copy$default$1();
                        long x$3 = qual$1.copy$default$3();
                        Option<String> x$4 = qual$1.copy$default$4();
                        KafkaOffsetRange first = qual$1.copy(x$2, x$1, x$3, x$4);
                        KafkaOffsetRange qual$2 = (KafkaOffsetRange)splitOffsetRanges.last();
                        long x$5 = BoxesRunTime.unboxToLong((Object)untilOffsetsMap.apply((Object)tp));
                        TopicPartition x$6 = qual$2.copy$default$1();
                        long x$7 = qual$2.copy$default$2();
                        Option<String> x$8 = qual$2.copy$default$4();
                        KafkaOffsetRange end = qual$2.copy(x$6, x$7, x$5, x$8);
                        seq = (Seq)((SeqLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaOffsetRange[]{first}))).$plus$plus((GenTraversableOnce)((IterableLike)splitOffsetRanges.drop(1)).dropRight(1), Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)end, Seq$.MODULE$.canBuildFrom());
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                Seq seq2 = seq;
                return seq2;
            }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(KafkaOffsetRange.class)))).toSeq();
        } else {
            seq = offsetRangesBase;
        }
        return seq;
    }

    private String[] getSortedExecutorList() {
        BlockManager bm = SparkEnv$.MODULE$.get().blockManager();
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])bm.master().getPeers(bm.blockManagerId()).toArray(ClassTag$.MODULE$.apply(BlockManagerId.class)))).map((Function1 & Serializable & scala.Serializable)x -> new ExecutorCacheTaskLocation(x.host(), x.executorId()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ExecutorCacheTaskLocation.class))))).sortWith((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)KafkaOffsetReader.compare$1(a, b))))).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    public Seq<KafkaOffsetRange> getOffsetRangesFromResolvedOffsets(scala.collection.immutable.Map<TopicPartition, Object> fromPartitionOffsets, scala.collection.immutable.Map<TopicPartition, Object> untilPartitionOffsets, Function1<String, BoxedUnit> reportDataLoss) {
        Object object;
        Object object2;
        scala.collection.immutable.Set newPartitions = (scala.collection.immutable.Set)untilPartitionOffsets.keySet().diff((GenSet)fromPartitionOffsets.keySet());
        scala.collection.immutable.Map<TopicPartition, Object> newPartitionInitialOffsets = this.fetchEarliestOffsets((Seq<TopicPartition>)newPartitions.toSeq());
        scala.collection.immutable.Set set = newPartitionInitialOffsets.keySet();
        scala.collection.immutable.Set set2 = newPartitions;
        if (set == null ? set2 != null : !set.equals(set2)) {
            scala.collection.immutable.Set deletedPartitions = (scala.collection.immutable.Set)newPartitions.diff((GenSet)newPartitionInitialOffsets.keySet());
            object2 = reportDataLoss.apply((Object)new StringBuilder(64).append("Cannot find earliest offsets of ").append(deletedPartitions).append(". Some data may have been missed").toString());
        } else {
            object2 = BoxedUnit.UNIT;
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Partitions added: ").append(newPartitionInitialOffsets).toString());
        ((IterableLike)newPartitionInitialOffsets.filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)KafkaOffsetReader.$anonfun$getOffsetRangesFromResolvedOffsets$2(x$12)))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            KafkaOffsetReader.$anonfun$getOffsetRangesFromResolvedOffsets$3(reportDataLoss, x0$1);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Set deletedPartitions = (scala.collection.immutable.Set)fromPartitionOffsets.keySet().diff((GenSet)untilPartitionOffsets.keySet());
        if (deletedPartitions.nonEmpty()) {
            String message = this.driverKafkaParams().containsKey("group.id") ? new StringBuilder(11).append(deletedPartitions).append(" are gone. ").append(KafkaSourceProvider$.MODULE$.CUSTOM_GROUP_ID_ERROR_MESSAGE()).toString() : new StringBuilder(42).append(deletedPartitions).append(" are gone. Some data may have been missed.").toString();
            object = reportDataLoss.apply((Object)message);
        } else {
            object = BoxedUnit.UNIT;
        }
        Seq topicPartitions = ((SetLike)untilPartitionOffsets.keySet().filter((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)KafkaOffsetReader.$anonfun$getOffsetRangesFromResolvedOffsets$4(newPartitionInitialOffsets, fromPartitionOffsets, tp)))).toSeq();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("TopicPartitions: ").append(topicPartitions.mkString(", ")).toString());
        scala.collection.immutable.Map fromOffsets = fromPartitionOffsets.$plus$plus(newPartitionInitialOffsets);
        scala.collection.immutable.Map<TopicPartition, Object> untilOffsets = untilPartitionOffsets;
        Seq ranges = (Seq)topicPartitions.map((Function1 & Serializable & scala.Serializable)tp -> {
            long fromOffset = BoxesRunTime.unboxToLong((Object)fromOffsets.apply(tp));
            long untilOffset = BoxesRunTime.unboxToLong((Object)untilOffsets.apply(tp));
            Object object = untilOffset < fromOffset ? reportDataLoss.apply((Object)new StringBuilder(73).append("Partition ").append(tp).append("'s offset was changed from ").append(fromOffset).append(" to ").append(untilOffset).append(", some data may have been missed").toString()) : BoxedUnit.UNIT;
            return new KafkaOffsetRange((TopicPartition)tp, fromOffset, untilOffset, (Option<String>)None$.MODULE$);
        }, Seq$.MODULE$.canBuildFrom());
        return this.rangeCalculator().getRanges((Seq<KafkaOffsetRange>)ranges, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])this.getSortedExecutorList()));
    }

    private scala.collection.immutable.Map<TopicPartition, Object> partitionsAssignedToConsumer(Function1<Set<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Object>> body, boolean fetchingEarliestOffset) {
        return (scala.collection.immutable.Map)this.runUninterruptibly((Function0 & Serializable & scala.Serializable)() -> this.withRetriesWithoutInterrupt((Function0<scala.collection.immutable.Map<TopicPartition, Object>>)(Function0 & Serializable & scala.Serializable)() -> {
            this.consumer().poll(0L);
            Set partitions = this.consumer().assignment();
            if (!fetchingEarliestOffset) {
                ((IterableLike)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala()).map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p), (Object)BoxesRunTime.boxToLong((long)this.consumer().position(p))), Set$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
                    KafkaOffsetReader.$anonfun$partitionsAssignedToConsumer$4(x$13);
                    return BoxedUnit.UNIT;
                });
            }
            this.consumer().pause((Collection)partitions);
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Partitions assigned to consumer: ").append(partitions).append(".").toString());
            return (scala.collection.immutable.Map)body.apply((Object)partitions);
        }));
    }

    private boolean partitionsAssignedToConsumer$default$2() {
        return false;
    }

    private <T> T runUninterruptibly(Function0<T> body) {
        Object object;
        if (!(Thread.currentThread() instanceof UninterruptibleThread)) {
            Future future = Future$.MODULE$.apply(body, (ExecutionContext)this.execContext());
            object = ThreadUtils$.MODULE$.awaitResult((Awaitable)future, (Duration)Duration$.MODULE$.Inf());
        } else {
            object = body.apply();
        }
        return (T)object;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> withRetriesWithoutInterrupt(Function0<scala.collection.immutable.Map<TopicPartition, Object>> body) {
        scala.collection.immutable.Map map;
        Predef$.MODULE$.assert(Thread.currentThread() instanceof UninterruptibleThread);
        KafkaOffsetReader kafkaOffsetReader = this;
        synchronized (kafkaOffsetReader) {
            ObjectRef result = ObjectRef.create((Object)None$.MODULE$);
            IntRef attempt = IntRef.create((int)1);
            ObjectRef lastException = ObjectRef.create(null);
            while (((Option)result.elem).isEmpty() && attempt.elem <= this.maxOffsetFetchAttempts() && !Thread.currentThread().isInterrupted()) {
                Thread thread = Thread.currentThread();
                if (thread instanceof UninterruptibleThread) {
                    UninterruptibleThread uninterruptibleThread = (UninterruptibleThread)thread;
                    BoxedUnit boxedUnit = (BoxedUnit)uninterruptibleThread.runUninterruptibly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        try {
                            result$1.elem = new Some(body.apply());
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            Option option = NonFatal$.MODULE$.unapply(throwable2);
                            if (!option.isEmpty()) {
                                Throwable e = (Throwable)option.get();
                                lastException$1.elem = e;
                                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Error in attempt ").append(attempt$1.elem).append(" getting Kafka offsets: ").toString(), e);
                                ++attempt$1.elem;
                                Thread.sleep(this.offsetFetchAttemptIntervalMs());
                                this.resetConsumer();
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            throw throwable;
                        }
                    });
                    continue;
                }
                throw new IllegalStateException("Kafka APIs must be executed on a o.a.spark.util.UninterruptibleThread");
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (((Option)result.elem).isEmpty()) {
                Predef$.MODULE$.assert(attempt.elem > this.maxOffsetFetchAttempts());
                Predef$.MODULE$.assert((Throwable)lastException.elem != null);
                throw (Throwable)lastException.elem;
            }
            map = (scala.collection.immutable.Map)((Option)result.elem).get();
        }
        return map;
    }

    private synchronized void stopConsumer() {
        block0: {
            Predef$.MODULE$.assert(Thread.currentThread() instanceof UninterruptibleThread);
            if (this._consumer() == null) break block0;
            this._consumer().close();
        }
    }

    private synchronized void resetConsumer() {
        this.stopConsumer();
        this._consumer_$eq(null);
    }

    public static final /* synthetic */ int $anonfun$minPartitions$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
    }

    private final scala.collection.immutable.Map validateTopicPartitions$1(scala.collection.immutable.Set partitions, scala.collection.immutable.Map partitionOffsets) {
        scala.collection.immutable.Set set = partitions;
        scala.collection.immutable.Set set2 = partitionOffsets.keySet();
        Predef$.MODULE$.assert(!(set != null ? !set.equals(set2) : set2 != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(142).append("If startingOffsets contains specific offsets, you must specify all TopicPartitions.\nUse -1 for latest, -2 for earliest.\n").append("Specified: ").append(partitionOffsets.keySet()).append(" Assigned: ").append(partitions).toString());
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Partitions assigned to consumer: ").append(partitions).append(". Seeking to ").append(partitionOffsets).toString());
        return partitionOffsets;
    }

    public static final /* synthetic */ void $anonfun$fetchSpecificOffsets$1(KafkaOffsetReader $this, scala.collection.immutable.Map partitionOffsets$2, Set partitions) {
        Object object = JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala();
        scala.collection.immutable.Set set = partitionOffsets$2.keySet();
        Predef$.MODULE$.assert(!(object != null ? !object.equals(set) : set != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(161).append("If startingOffsets contains specific offsets, you must specify all TopicPartitions.\nUse -1 for latest, -2 for earliest, if you don't care.\n").append("Specified: ").append(partitionOffsets$2.keySet()).append(" Assigned: ").append(JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala()).toString());
        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Partitions assigned to consumer: ").append(partitions).append(". Seeking to ").append(partitionOffsets$2).toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$fetchSpecificOffsets$6(scala.collection.immutable.Map fetched$1, Function1 reportDataLoss$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            long off = tuple2._2$mcJ$sp();
            if (off != KafkaOffsetRangeLimit$.MODULE$.LATEST() && off != KafkaOffsetRangeLimit$.MODULE$.EARLIEST()) {
                BoxedUnit boxedUnit = BoxesRunTime.unboxToLong((Object)fetched$1.apply((Object)tp)) != off ? (BoxedUnit)reportDataLoss$1.apply((Object)new StringBuilder(48).append("startingOffsets for ").append(tp).append(" was ").append(off).append(" but consumer reset to ").append(fetched$1.apply((Object)tp)).toString()) : BoxedUnit.UNIT;
                return;
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$fetchSpecificTimestampBasedOffsets$1(KafkaOffsetReader $this, scala.collection.immutable.Map partitionTimestamps$1, Set partitions) {
        Object object = JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala();
        scala.collection.immutable.Set set = partitionTimestamps$1.keySet();
        Predef$.MODULE$.assert(!(object != null ? !object.equals(set) : set != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(115).append("If starting/endingOffsetsByTimestamp contains specific offsets, you must specify all ").append("topics. Specified: ").append(partitionTimestamps$1.keySet()).append(" Assigned: ").append(JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala()).toString());
        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Partitions assigned to consumer: ").append(partitions).append(". Seeking to ").append(partitionTimestamps$1).toString());
    }

    public static final /* synthetic */ void $anonfun$fetchSpecificTimestampBasedOffsets$8(scala.collection.immutable.Map x$5) {
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$fetchSpecificOffsets0$2(KafkaOffsetReader $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            long l = tuple2._2$mcJ$sp();
            if (KafkaOffsetRangeLimit$.MODULE$.LATEST() == l) {
                $this.consumer().seekToEnd(Arrays.asList((Object[])new TopicPartition[]{tp}));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            long l = tuple2._2$mcJ$sp();
            if (KafkaOffsetRangeLimit$.MODULE$.EARLIEST() == l) {
                $this.consumer().seekToBeginning(Arrays.asList((Object[])new TopicPartition[]{tp}));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        TopicPartition tp = (TopicPartition)tuple2._1();
        long off = tuple2._2$mcJ$sp();
        $this.consumer().seek(tp, off);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$fetchLatestOffsets$6(long offset$1, TopicPartition tp$2, ObjectRef incorrectOffsets$1, long knownOffset) {
        BoxedUnit boxedUnit;
        if (knownOffset > offset$1) {
            Tuple3 incorrectOffset = new Tuple3((Object)tp$2, (Object)BoxesRunTime.boxToLong((long)knownOffset), (Object)BoxesRunTime.boxToLong((long)offset$1));
            boxedUnit = ((ArrayBuffer)incorrectOffsets$1.elem).$plus$eq((Object)incorrectOffset);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$fetchLatestOffsets$5(TopicPartition tp$2, long offset$1, ObjectRef incorrectOffsets$1, scala.collection.immutable.Map x$6) {
        x$6.get((Object)tp$2).foreach((Function1 & Serializable & scala.Serializable)knownOffset -> KafkaOffsetReader.$anonfun$fetchLatestOffsets$6(offset$1, tp$2, incorrectOffsets$1, BoxesRunTime.unboxToLong((Object)knownOffset)));
    }

    public static final /* synthetic */ void $anonfun$fetchLatestOffsets$4(Option knownOffsets$1, ObjectRef incorrectOffsets$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        long offset = tuple2._2$mcJ$sp();
        knownOffsets$1.foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            KafkaOffsetReader.$anonfun$fetchLatestOffsets$5(tp, offset, incorrectOffsets$1, x$6);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final Seq findIncorrectOffsets$1(ObjectRef partitionOffsets$4, Option knownOffsets$1) {
        ObjectRef incorrectOffsets = ObjectRef.create((Object)((ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)));
        ((scala.collection.immutable.Map)partitionOffsets$4.elem).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            KafkaOffsetReader.$anonfun$fetchLatestOffsets$4(knownOffsets$1, incorrectOffsets, x0$1);
            return BoxedUnit.UNIT;
        });
        return (ArrayBuffer)incorrectOffsets.elem;
    }

    public static final /* synthetic */ void $anonfun$getOffsetRangesFromUnresolvedOffsets$6(String x$7) {
    }

    public static final /* synthetic */ void $anonfun$getOffsetRangesFromUnresolvedOffsets$7(String x$8) {
    }

    private static final boolean compare$1(ExecutorCacheTaskLocation a, ExecutorCacheTaskLocation b) {
        String string = a.host();
        String string2 = b.host();
        return !(string != null ? !string.equals(string2) : string2 != null) ? new StringOps(Predef$.MODULE$.augmentString(a.executorId())).$greater((Object)b.executorId()) : new StringOps(Predef$.MODULE$.augmentString(a.host())).$greater((Object)b.host());
    }

    public static final /* synthetic */ boolean $anonfun$getOffsetRangesFromResolvedOffsets$2(Tuple2 x$12) {
        return x$12._2$mcJ$sp() != 0L;
    }

    public static final /* synthetic */ void $anonfun$getOffsetRangesFromResolvedOffsets$3(Function1 reportDataLoss$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition p = (TopicPartition)tuple2._1();
        long o = tuple2._2$mcJ$sp();
        BoxedUnit boxedUnit = (BoxedUnit)reportDataLoss$2.apply((Object)new StringBuilder(74).append("Added partition ").append(p).append(" starts from ").append(o).append(" instead of 0. Some data may have been missed").toString());
    }

    public static final /* synthetic */ boolean $anonfun$getOffsetRangesFromResolvedOffsets$4(scala.collection.immutable.Map newPartitionInitialOffsets$1, scala.collection.immutable.Map fromPartitionOffsets$2, TopicPartition tp) {
        return newPartitionInitialOffsets$1.contains((Object)tp) || fromPartitionOffsets$2.contains((Object)tp);
    }

    public static final /* synthetic */ void $anonfun$partitionsAssignedToConsumer$4(Tuple2 x$13) {
    }

    public KafkaOffsetReader(ConsumerStrategy consumerStrategy, java.util.Map<String, Object> driverKafkaParams, CaseInsensitiveMap<String> readerOptions, String driverGroupIdPrefix) {
        this.consumerStrategy = consumerStrategy;
        this.driverKafkaParams = driverKafkaParams;
        this.driverGroupIdPrefix = driverGroupIdPrefix;
        Logging.$init$((Logging)this);
        this.kafkaReaderThread = Executors.newSingleThreadExecutor(r -> {
            void var1_1;
            UninterruptibleThread t = new UninterruptibleThread(null, r){
                private final Runnable r$1;

                public void run() {
                    this.r$1.run();
                }
                {
                    this.r$1 = r$1;
                    super("Kafka Offset Reader");
                }
            };
            t.setDaemon(true);
            return var1_1;
        });
        this.execContext = ExecutionContext$.MODULE$.fromExecutorService(this.kafkaReaderThread());
        this.groupId = null;
        this.nextId = 0;
        this._consumer = null;
        this.maxOffsetFetchAttempts = new StringOps(Predef$.MODULE$.augmentString((String)readerOptions.getOrElse((Object)KafkaSourceProvider$.MODULE$.FETCH_OFFSET_NUM_RETRY(), (Function0 & Serializable & scala.Serializable)() -> "3"))).toInt();
        this.minPartitions = readerOptions.get(KafkaSourceProvider$.MODULE$.MIN_PARTITIONS_OPTION_KEY()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)KafkaOffsetReader.$anonfun$minPartitions$1(x$1)));
        this.rangeCalculator = new KafkaOffsetRangeCalculator(this.minPartitions());
        this.offsetFetchAttemptIntervalMs = new StringOps(Predef$.MODULE$.augmentString((String)readerOptions.getOrElse((Object)KafkaSourceProvider$.MODULE$.FETCH_OFFSET_RETRY_INTERVAL_MS(), (Function0 & Serializable & scala.Serializable)() -> "1000"))).toLong();
    }
}

