/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010.consumer;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetOutOfRangeException;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.kafka010.KafkaTokenUtil$;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.sql.kafka010.consumer.FetchedData;
import org.apache.spark.sql.kafka010.consumer.FetchedDataPool;
import org.apache.spark.sql.kafka010.consumer.FetchedRecord;
import org.apache.spark.sql.kafka010.consumer.InternalKafkaConsumer;
import org.apache.spark.sql.kafka010.consumer.InternalKafkaConsumerPool;
import org.apache.spark.sql.kafka010.consumer.KafkaDataConsumer$;
import org.apache.spark.util.UninterruptibleThread;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\r}f!\u00021b\u0001\rl\u0007\u0002\u0003>\u0001\u0005\u0003\u0005\u000b\u0011\u0002?\t\u0015\u0005%\u0001A!A!\u0002\u0013\tY\u0001\u0003\u0006\u0002>\u0001\u0011\t\u0011)A\u0005\u0003\u007fA!\"a\u0012\u0001\u0005\u0003\u0005\u000b\u0011BA%\u0011\u001d\ty\u0005\u0001C\u0001\u0003#B!\"!\u0018\u0001\u0001\u0004%\t!YA0\u0011)\ti\u0007\u0001a\u0001\n\u0003\t\u0017q\u000e\u0005\t\u0003w\u0002\u0001\u0015)\u0003\u0002b!I\u0011Q\u0011\u0001A\u0002\u0013%\u0011q\u0011\u0005\n\u0003#\u0003\u0001\u0019!C\u0005\u0003'C\u0001\"a&\u0001A\u0003&\u0011\u0011\u0012\u0005\n\u00037\u0003!\u0019!C\u0005\u0003;C\u0001\"a(\u0001A\u0003%\u00111\u0004\u0005\n\u0003C\u0003!\u0019!C\u0005\u0003GC\u0001ba\u0002\u0001A\u0003%\u0011Q\u0015\u0005\n\u0007\u0013\u0001!\u0019!C\u0005\u0007\u0017A\u0001ba\u0005\u0001A\u0003%1Q\u0002\u0005\b\u0007+\u0001A\u0011AB\f\u0011\u001d\u0019\t\u0005\u0001C\u0001\u0007\u0007Bqaa\u0012\u0001\t\u0003\u0019I\u0005C\u0004\u0004L\u0001!Ia!\u0013\t\u000f\r5\u0003\u0001\"\u0003\u0004J!91q\n\u0001\u0005\n\rE\u0003bBB-\u0001\u0011%11\f\u0005\b\u0007W\u0002A\u0011BB7\u0011!\u00199\b\u0001C\u0001G\u000ee\u0004bBB>\u0001\u0011%1\u0011\n\u0005\b\u0007{\u0002A\u0011BB@\u0011\u001d\u0019\u0019\t\u0001C\u0005\u0007\u000bCqa!$\u0001\t\u0013\u0019y\tC\u0005\u0004\u001e\u0002\t\n\u0011\"\u0003\u0004\u0004!91q\u0014\u0001\u0005\n\r\u0005v\u0001CAUC\"\u00051-a+\u0007\u000f\u0001\f\u0007\u0012A2\u0002.\"9\u0011q\n\u0012\u0005\u0002\u0005=\u0006\"CAYE\t\u0007I\u0011AAZ\u0011!\tYL\tQ\u0001\n\u0005UfABA_E\u0001\u000by\f\u0003\u0006\u0002N\u001a\u0012)\u001a!C\u0001\u0003gC!\"a4'\u0005#\u0005\u000b\u0011BA[\u0011)\t\tN\nBK\u0002\u0013\u0005\u00111\u0017\u0005\u000b\u0003'4#\u0011#Q\u0001\n\u0005U\u0006bBA(M\u0011\u0005\u0011Q\u001b\u0005\n\u0003?4\u0013\u0011!C\u0001\u0003CD\u0011\"a:'#\u0003%\t!!;\t\u0013\u0005}h%%A\u0005\u0002\u0005%\b\"\u0003B\u0001M\u0005\u0005I\u0011\tB\u0002\u0011%\u0011IAJA\u0001\n\u0003\u0011Y\u0001C\u0005\u0003\u0014\u0019\n\t\u0011\"\u0001\u0003\u0016!I!q\u0004\u0014\u0002\u0002\u0013\u0005#\u0011\u0005\u0005\n\u0005_1\u0013\u0011!C\u0001\u0005cA\u0011Ba\u000f'\u0003\u0003%\tE!\u0010\t\u0013\t}b%!A\u0005B\t\u0005\u0003\"\u0003B\"M\u0005\u0005I\u0011\tB#\u000f%\u0011IEIA\u0001\u0012\u0003\u0011YEB\u0005\u0002>\n\n\t\u0011#\u0001\u0003N!9\u0011q\n\u001d\u0005\u0002\tm\u0003\"\u0003B q\u0005\u0005IQ\tB!\u0011%\u0011i\u0006OA\u0001\n\u0003\u0013y\u0006C\u0005\u0003fa\n\t\u0011\"!\u0003h!I!Q\u000f\u001d\u0002\u0002\u0013%!q\u000f\u0004\u0007\u0005s\u0012\u0003Ia\u001f\t\u0015\u0005meH!f\u0001\n\u0003\ti\n\u0003\u0006\u0002 z\u0012\t\u0012)A\u0005\u00037A\u0011B\u001f \u0003\u0016\u0004%\tA! \t\u0013\t}dH!E!\u0002\u0013a\bbBA(}\u0011\u0005!\u0011\u0011\u0005\b\u0003\u001frD\u0011\u0001BE\u0011%\tyNPA\u0001\n\u0003\u0011y\tC\u0005\u0002hz\n\n\u0011\"\u0001\u0003\u0016\"I\u0011q  \u0012\u0002\u0013\u0005!\u0011\u0014\u0005\n\u0005\u0003q\u0014\u0011!C!\u0005\u0007A\u0011B!\u0003?\u0003\u0003%\tAa\u0003\t\u0013\tMa(!A\u0005\u0002\tu\u0005\"\u0003B\u0010}\u0005\u0005I\u0011\tB\u0011\u0011%\u0011yCPA\u0001\n\u0003\u0011\t\u000bC\u0005\u0003<y\n\t\u0011\"\u0011\u0003>!I!q\b \u0002\u0002\u0013\u0005#\u0011\t\u0005\n\u0005\u0007r\u0014\u0011!C!\u0005K;\u0011B!+#\u0003\u0003E\tAa+\u0007\u0013\te$%!A\t\u0002\t5\u0006bBA(#\u0012\u0005!\u0011\u0017\u0005\n\u0005\u007f\t\u0016\u0011!C#\u0005\u0003B\u0011B!\u0018R\u0003\u0003%\tIa-\t\u0013\t\u0015\u0014+!A\u0005\u0002\ne\u0006\"\u0003B;#\u0006\u0005I\u0011\u0002B<\u0011%\u0011\tM\tb\u0001\n\u0013\u0011\u0019\r\u0003\u0005\u0003N\n\u0002\u000b\u0011\u0002Bc\u0011%\tiD\tb\u0001\n\u0013\u0011y\r\u0003\u0005\u0003R\n\u0002\u000b\u0011BA \u0011%\t9E\tb\u0001\n\u0013\u0011\u0019\u000e\u0003\u0005\u0003V\n\u0002\u000b\u0011BA%\u0011\u001d\u00119N\tC\u0001\u00053DqAa8#\t\u0013\u0011\t\u000fC\u0005\u0004\u0002\t\n\n\u0011\"\u0003\u0004\u0004\t\t2*\u00194lC\u0012\u000bG/Y\"p]N,X.\u001a:\u000b\u0005\t\u001c\u0017\u0001C2p]N,X.\u001a:\u000b\u0005\u0011,\u0017\u0001C6bM.\f\u0007'\r\u0019\u000b\u0005\u0019<\u0017aA:rY*\u0011\u0001.[\u0001\u0006gB\f'o\u001b\u0006\u0003U.\fa!\u00199bG\",'\"\u00017\u0002\u0007=\u0014xmE\u0002\u0001]R\u0004\"a\u001c:\u000e\u0003AT\u0011!]\u0001\u0006g\u000e\fG.Y\u0005\u0003gB\u0014a!\u00118z%\u00164\u0007CA;y\u001b\u00051(BA<h\u0003!Ig\u000e^3s]\u0006d\u0017BA=w\u0005\u001daunZ4j]\u001e\fa\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u0001\u0001\u0011\u0007u\f)!D\u0001\u007f\u0015\ry\u0018\u0011A\u0001\u0007G>lWn\u001c8\u000b\u0007\u0005\r\u0011.A\u0003lC\u001a\\\u0017-C\u0002\u0002\by\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\u0006lC\u001a\\\u0017\rU1sC6\u001c\b\u0003CA\u0007\u0003/\tY\"!\r\u000e\u0005\u0005=!\u0002BA\t\u0003'\tA!\u001e;jY*\u0011\u0011QC\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001a\u0005=!aA'baB!\u0011QDA\u0016\u001d\u0011\ty\"a\n\u0011\u0007\u0005\u0005\u0002/\u0004\u0002\u0002$)\u0019\u0011QE>\u0002\rq\u0012xn\u001c;?\u0013\r\tI\u0003]\u0001\u0007!J,G-\u001a4\n\t\u00055\u0012q\u0006\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005%\u0002\u000f\u0005\u0003\u00024\u0005eRBAA\u001b\u0015\u0011\t9$a\u0005\u0002\t1\fgnZ\u0005\u0005\u0003w\t)D\u0001\u0004PE*,7\r^\u0001\rG>t7/^7feB{w\u000e\u001c\t\u0005\u0003\u0003\n\u0019%D\u0001b\u0013\r\t)%\u0019\u0002\u001a\u0013:$XM\u001d8bY.\u000bgm[1D_:\u001cX/\\3s!>|G.A\bgKR\u001c\u0007.\u001a3ECR\f\u0007k\\8m!\u0011\t\t%a\u0013\n\u0007\u00055\u0013MA\bGKR\u001c\u0007.\u001a3ECR\f\u0007k\\8m\u0003\u0019a\u0014N\\5u}QQ\u00111KA+\u0003/\nI&a\u0017\u0011\u0007\u0005\u0005\u0003\u0001C\u0003{\u000b\u0001\u0007A\u0010C\u0004\u0002\n\u0015\u0001\r!a\u0003\t\u000f\u0005uR\u00011\u0001\u0002@!9\u0011qI\u0003A\u0002\u0005%\u0013!C0d_:\u001cX/\\3s+\t\t\t\u0007E\u0003p\u0003G\n9'C\u0002\u0002fA\u0014aa\u00149uS>t\u0007\u0003BA!\u0003SJ1!a\u001bb\u0005UIe\u000e^3s]\u0006d7*\u00194lC\u000e{gn];nKJ\fQbX2p]N,X.\u001a:`I\u0015\fH\u0003BA9\u0003o\u00022a\\A:\u0013\r\t)\b\u001d\u0002\u0005+:LG\u000fC\u0005\u0002z\u001d\t\t\u00111\u0001\u0002b\u0005\u0019\u0001\u0010J\u0019\u0002\u0015}\u001bwN\\:v[\u0016\u0014\b\u0005K\u0002\t\u0003\u007f\u00022a\\AA\u0013\r\t\u0019\t\u001d\u0002\tm>d\u0017\r^5mK\u0006aqLZ3uG\",G\rR1uCV\u0011\u0011\u0011\u0012\t\u0006_\u0006\r\u00141\u0012\t\u0005\u0003\u0003\ni)C\u0002\u0002\u0010\u0006\u00141BR3uG\",G\rR1uC\u0006\u0001rLZ3uG\",G\rR1uC~#S-\u001d\u000b\u0005\u0003c\n)\nC\u0005\u0002z)\t\t\u00111\u0001\u0002\n\u0006iqLZ3uG\",G\rR1uC\u0002B3aCA@\u0003\u001d9'o\\;q\u0013\u0012,\"!a\u0007\u0002\u0011\u001d\u0014x.\u001e9JI\u0002\n\u0001bY1dQ\u0016\\U-_\u000b\u0003\u0003K\u00032!a*?\u001d\r\t\t%I\u0001\u0012\u0017\u000647.\u0019#bi\u0006\u001cuN\\:v[\u0016\u0014\bcAA!EM\u0019!E\u001c;\u0015\u0005\u0005-\u0016AD+O\u0017:{uKT0P\r\u001a\u001bV\tV\u000b\u0003\u0003k\u00032a\\A\\\u0013\r\tI\f\u001d\u0002\u0005\u0019>tw-A\bV\u001d.suj\u0016(`\u001f\u001a35+\u0012+!\u0005Q\te/Y5mC\ndWm\u00144gg\u0016$(+\u00198hKN1aE\\Aa\u0003\u000f\u00042a\\Ab\u0013\r\t)\r\u001d\u0002\b!J|G-^2u!\ry\u0017\u0011Z\u0005\u0004\u0003\u0017\u0004(\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001C3be2LWm\u001d;\u0002\u0013\u0015\f'\u000f\\5fgR\u0004\u0013A\u00027bi\u0016\u001cH/A\u0004mCR,7\u000f\u001e\u0011\u0015\r\u0005]\u00171\\Ao!\r\tINJ\u0007\u0002E!9\u0011QZ\u0016A\u0002\u0005U\u0006bBAiW\u0001\u0007\u0011QW\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u0002X\u0006\r\u0018Q\u001d\u0005\n\u0003\u001bd\u0003\u0013!a\u0001\u0003kC\u0011\"!5-!\u0003\u0005\r!!.\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u001e\u0016\u0005\u0003k\u000bio\u000b\u0002\u0002pB!\u0011\u0011_A~\u001b\t\t\u0019P\u0003\u0003\u0002v\u0006]\u0018!C;oG\",7m[3e\u0015\r\tI\u0010]\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u007f\u0003g\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B\u0003!\u0011\t\u0019Da\u0002\n\t\u00055\u0012QG\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0005\u001b\u00012a\u001cB\b\u0013\r\u0011\t\u0002\u001d\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005/\u0011i\u0002E\u0002p\u00053I1Aa\u0007q\u0005\r\te.\u001f\u0005\n\u0003s\n\u0014\u0011!a\u0001\u0005\u001b\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005G\u0001bA!\n\u0003,\t]QB\u0001B\u0014\u0015\r\u0011I\u0003]\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u0017\u0005O\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!1\u0007B\u001d!\ry'QG\u0005\u0004\u0005o\u0001(a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003s\u001a\u0014\u0011!a\u0001\u0005/\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0005\u001b\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005\u000b\ta!Z9vC2\u001cH\u0003\u0002B\u001a\u0005\u000fB\u0011\"!\u001f7\u0003\u0003\u0005\rAa\u0006\u0002)\u00053\u0018-\u001b7bE2,wJ\u001a4tKR\u0014\u0016M\\4f!\r\tI\u000eO\n\u0006q\t=\u0013q\u0019\t\u000b\u0005#\u00129&!.\u00026\u0006]WB\u0001B*\u0015\r\u0011)\u0006]\u0001\beVtG/[7f\u0013\u0011\u0011IFa\u0015\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0003L\u0005)\u0011\r\u001d9msR1\u0011q\u001bB1\u0005GBq!!4<\u0001\u0004\t)\fC\u0004\u0002Rn\u0002\r!!.\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\u000eB9!\u0015y\u00171\rB6!\u001dy'QNA[\u0003kK1Aa\u001cq\u0005\u0019!V\u000f\u001d7fe!I!1\u000f\u001f\u0002\u0002\u0003\u0007\u0011q[\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!\r\u0003\u0011\r\u000b7\r[3LKf\u001cbA\u00108\u0002B\u0006\u001dW#\u0001?\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0002\"bAa!\u0003\u0006\n\u001d\u0005cAAm}!9\u00111T\"A\u0002\u0005m\u0001\"\u0002>D\u0001\u0004aHC\u0002BB\u0005\u0017\u0013i\tC\u0003{\t\u0002\u0007A\u0010C\u0004\u0002\n\u0011\u0003\r!a\u0003\u0015\r\t\r%\u0011\u0013BJ\u0011%\tY*\u0012I\u0001\u0002\u0004\tY\u0002C\u0004{\u000bB\u0005\t\u0019\u0001?\u0016\u0005\t]%\u0006BA\u000e\u0003[,\"Aa'+\u0007q\fi\u000f\u0006\u0003\u0003\u0018\t}\u0005\"CA=\u0015\u0006\u0005\t\u0019\u0001B\u0007)\u0011\u0011\u0019Da)\t\u0013\u0005eD*!AA\u0002\t]A\u0003\u0002B\u001a\u0005OC\u0011\"!\u001fP\u0003\u0003\u0005\rAa\u0006\u0002\u0011\r\u000b7\r[3LKf\u00042!!7R'\u0015\t&qVAd!%\u0011\tFa\u0016\u0002\u001cq\u0014\u0019\t\u0006\u0002\u0003,R1!1\u0011B[\u0005oCq!a'U\u0001\u0004\tY\u0002C\u0003{)\u0002\u0007A\u0010\u0006\u0003\u0003<\n}\u0006#B8\u0002d\tu\u0006CB8\u0003n\u0005mA\u0010C\u0005\u0003tU\u000b\t\u00111\u0001\u0003\u0004\u0006I1\u000f]1sW\u000e{gNZ\u000b\u0003\u0005\u000b\u0004BAa2\u0003J6\tq-C\u0002\u0003L\u001e\u0014\u0011b\u00159be.\u001cuN\u001c4\u0002\u0015M\u0004\u0018M]6D_:4\u0007%\u0006\u0002\u0002@\u0005i1m\u001c8tk6,'\u000fU8pY\u0002*\"!!\u0013\u0002!\u0019,Go\u00195fI\u0012\u000bG/\u0019)p_2\u0004\u0013aB1dcVL'/\u001a\u000b\u0007\u0003'\u0012YN!8\t\u000bil\u0006\u0019\u0001?\t\u000f\u0005%Q\f1\u0001\u0002\f\u0005y!/\u001a9peR$\u0015\r^1M_N\u001c\b\u0007\u0006\u0005\u0002r\t\r(q\u001dBv\u0011\u001d\u0011)O\u0018a\u0001\u0005g\taBZ1jY>sG)\u0019;b\u0019>\u001c8\u000fC\u0004\u0003jz\u0003\r!a\u0007\u0002\u0019\u0019Lg.\u00197NKN\u001c\u0018mZ3\t\u0013\t5h\f%AA\u0002\t=\u0018!B2bkN,\u0007\u0003\u0002By\u0005wtAAa=\u0003x:!\u0011\u0011\u0005B{\u0013\u0005\t\u0018b\u0001B}a\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B\u007f\u0005\u007f\u0014\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\te\b/A\rsKB|'\u000f\u001e#bi\u0006dun]:1I\u0011,g-Y;mi\u0012\u001aTCAB\u0003U\u0011\u0011y/!<\u0002\u0013\r\f7\r[3LKf\u0004\u0013!\u00044fi\u000eDW\r\u001a*fG>\u0014H-\u0006\u0002\u0004\u000eA!\u0011\u0011IB\b\u0013\r\u0019\t\"\u0019\u0002\u000e\r\u0016$8\r[3e%\u0016\u001cwN\u001d3\u0002\u001d\u0019,Go\u00195fIJ+7m\u001c:eA\u0005\u0019q-\u001a;\u0015\u0015\re11GB\u001c\u0007w\u0019y\u0004\u0005\u0005\u0004\u001c\r\r2qEB\u0014\u001b\t\u0019iBC\u0002c\u0007?QAa!\t\u0002\u0002\u000591\r\\5f]R\u001c\u0018\u0002BB\u0013\u0007;\u0011abQ8ogVlWM\u001d*fG>\u0014H\rE\u0003p\u0007S\u0019i#C\u0002\u0004,A\u0014Q!\u0011:sCf\u00042a\\B\u0018\u0013\r\u0019\t\u0004\u001d\u0002\u0005\u0005f$X\rC\u0004\u00046I\u0001\r!!.\u0002\r=4gm]3u\u0011\u001d\u0019ID\u0005a\u0001\u0003k\u000b1\"\u001e8uS2|eMZ:fi\"91Q\b\nA\u0002\u0005U\u0016!\u00049pY2$\u0016.\\3pkRl5\u000fC\u0004\u0003fJ\u0001\rAa\r\u0002/\u001d,G/\u0011<bS2\f'\r\\3PM\u001a\u001cX\r\u001e*b]\u001e,GCAB#!\r\t9KJ\u0001\be\u0016dW-Y:f)\t\t\t(A\bsK2,\u0017m]3D_:\u001cX/\\3s\u0003I\u0011X\r\\3bg\u00164U\r^2iK\u0012$\u0015\r^1\u0002C\u001d,G/R1sY&,7\u000f^!wC&d\u0017M\u00197f\u001f\u001a47/\u001a;CKR<X-\u001a8\u0015\u0011\u0005U61KB+\u0007/BaAY\fA\u0002\u0005\u001d\u0004bBB\u001b/\u0001\u0007\u0011Q\u0017\u0005\b\u0007s9\u0002\u0019AA[\u0003-1W\r^2i%\u0016\u001cwN\u001d3\u0015\u001d\r51QLB0\u0007G\u001a)ga\u001a\u0004j!1!\r\u0007a\u0001\u0003OBqa!\u0019\u0019\u0001\u0004\tY)A\u0006gKR\u001c\u0007.\u001a3ECR\f\u0007bBB\u001b1\u0001\u0007\u0011Q\u0017\u0005\b\u0007sA\u0002\u0019AA[\u0011\u001d\u0019i\u0004\u0007a\u0001\u0003kCqA!:\u0019\u0001\u0004\u0011\u0019$A\u0005gKR\u001c\u0007\u000eR1uCRQ\u0011\u0011OB8\u0007c\u001a\u0019h!\u001e\t\r\tL\u0002\u0019AA4\u0011\u001d\u0019\t'\u0007a\u0001\u0003\u0017Cqa!\u000e\u001a\u0001\u0004\t)\fC\u0004\u0004>e\u0001\r!!.\u0002+\u001d,Go\u0014:SKR\u0014\u0018.\u001a<f\u0007>t7/^7feR\u0011\u0011qM\u0001\u0011e\u0016$(/[3wK\u000e{gn];nKJ\f\u0001dZ3u\u001fJ\u0014V\r\u001e:jKZ,g)\u001a;dQ\u0016$G)\u0019;b)\u0011\tYi!!\t\u000f\rUB\u00041\u0001\u00026\u0006\t\u0012\r\u001a3ji&|g.\u00197NKN\u001c\u0018mZ3\u0015\u0011\u0005m1qQBE\u0007\u0017CQA_\u000fA\u0002qDq!a'\u001e\u0001\u0004\tY\u0002C\u0004\u0003fv\u0001\rAa\r\u0002\u001dI,\u0007o\u001c:u\t\u0006$\u0018\rT8tgRa\u0011\u0011OBI\u0007'\u001b)ja&\u0004\u001c\")!P\ba\u0001y\"9\u00111\u0014\u0010A\u0002\u0005m\u0001b\u0002Bs=\u0001\u0007!1\u0007\u0005\b\u00073s\u0002\u0019AA\u000e\u0003\u001diWm]:bO\u0016D\u0011B!<\u001f!\u0003\u0005\rAa<\u00021I,\u0007o\u001c:u\t\u0006$\u0018\rT8tg\u0012\"WMZ1vYR$S'\u0001\u000fsk:,f.\u001b8uKJ\u0014X\u000f\u001d;jE2L\u0018J\u001a)pgNL'\r\\3\u0016\t\r\r6\u0011\u0016\u000b\u0005\u0007K\u001b)\f\u0005\u0003\u0004(\u000e%F\u0002\u0001\u0003\b\u0007W\u0003#\u0019ABW\u0005\u0005!\u0016\u0003BBX\u0005/\u00012a\\BY\u0013\r\u0019\u0019\f\u001d\u0002\b\u001d>$\b.\u001b8h\u0011!\u00199\f\tCA\u0002\re\u0016\u0001\u00022pIf\u0004Ra\\B^\u0007KK1a!0q\u0005!a$-\u001f8b[\u0016t\u0004")
public class KafkaDataConsumer
implements Logging {
    private final TopicPartition topicPartition;
    private final Map<String, Object> kafkaParams;
    private final InternalKafkaConsumerPool consumerPool;
    private final FetchedDataPool fetchedDataPool;
    private volatile Option<InternalKafkaConsumer> _consumer;
    private volatile Option<FetchedData> _fetchedData;
    private final String groupId;
    private final CacheKey cacheKey;
    private final FetchedRecord fetchedRecord;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static KafkaDataConsumer acquire(TopicPartition topicPartition, Map<String, Object> map) {
        return KafkaDataConsumer$.MODULE$.acquire(topicPartition, map);
    }

    public static long UNKNOWN_OFFSET() {
        return KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Option<InternalKafkaConsumer> _consumer() {
        return this._consumer;
    }

    public void _consumer_$eq(Option<InternalKafkaConsumer> x$1) {
        this._consumer = x$1;
    }

    private Option<FetchedData> _fetchedData() {
        return this._fetchedData;
    }

    private void _fetchedData_$eq(Option<FetchedData> x$1) {
        this._fetchedData = x$1;
    }

    private String groupId() {
        return this.groupId;
    }

    private CacheKey cacheKey() {
        return this.cacheKey;
    }

    private FetchedRecord fetchedRecord() {
        return this.fetchedRecord;
    }

    public ConsumerRecord<byte[], byte[]> get(long offset, long untilOffset, long pollTimeoutMs, boolean failOnDataLoss) {
        return (ConsumerRecord)this.runUninterruptiblyIfPossible((Function0 & Serializable & scala.Serializable)() -> {
            ConsumerRecord<byte[], byte[]> consumerRecord;
            Predef$.MODULE$.require(offset < untilOffset, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("offset must always be less than untilOffset [offset: ").append(offset).append(", untilOffset: ").append(untilOffset).append("]").toString());
            InternalKafkaConsumer consumer = this.getOrRetrieveConsumer();
            FetchedData fetchedData = this.getOrRetrieveFetchedData(offset);
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Get ").append(this.groupId()).append(" ").append($this.topicPartition).append(" nextOffset ").append(fetchedData.nextOffsetInFetchedData()).append(" ").append("requested $offset").toString());
            LongRef toFetchOffset = LongRef.create((long)offset);
            FetchedRecord fetchedRecord = null;
            boolean isFetchComplete = false;
            while (toFetchOffset.elem != KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET() && !isFetchComplete) {
                try {
                    fetchedRecord = this.fetchRecord(consumer, fetchedData, toFetchOffset.elem, untilOffset, pollTimeoutMs, failOnDataLoss);
                    if (fetchedRecord.record() != null) {
                        isFetchComplete = true;
                        continue;
                    }
                    toFetchOffset.elem = fetchedRecord.nextOffsetToFetch();
                    if (toFetchOffset.elem >= untilOffset) {
                        fetchedData.reset();
                        toFetchOffset.elem = KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET();
                        continue;
                    }
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Skipped offsets [").append(offset).append(", ").append(toFetchOffset$1.elem).append("]").toString());
                }
                catch (OffsetOutOfRangeException e) {
                    this.releaseConsumer();
                    fetchedData.reset();
                    this.reportDataLoss($this.topicPartition, this.groupId(), failOnDataLoss, new StringBuilder(20).append("Cannot fetch offset ").append(toFetchOffset.elem).toString(), e);
                    toFetchOffset.elem = this.getEarliestAvailableOffsetBetween(consumer, toFetchOffset.elem, untilOffset);
                }
            }
            if (isFetchComplete) {
                consumerRecord = fetchedRecord.record();
            } else {
                fetchedData.reset();
                consumerRecord = null;
            }
            return consumerRecord;
        });
    }

    public AvailableOffsetRange getAvailableOffsetRange() {
        return (AvailableOffsetRange)this.runUninterruptiblyIfPossible((Function0 & Serializable & scala.Serializable)() -> {
            InternalKafkaConsumer consumer = this.getOrRetrieveConsumer();
            return consumer.getAvailableOffsetRange();
        });
    }

    public void release() {
        this.releaseConsumer();
        this.releaseFetchedData();
    }

    private void releaseConsumer() {
        block0: {
            if (!this._consumer().isDefined()) break block0;
            this.consumerPool.returnObject((InternalKafkaConsumer)this._consumer().get());
            this._consumer_$eq((Option<InternalKafkaConsumer>)None$.MODULE$);
        }
    }

    private void releaseFetchedData() {
        block0: {
            if (!this._fetchedData().isDefined()) break block0;
            this.fetchedDataPool.release(this.cacheKey(), (FetchedData)this._fetchedData().get());
            this._fetchedData_$eq((Option<FetchedData>)None$.MODULE$);
        }
    }

    private long getEarliestAvailableOffsetBetween(InternalKafkaConsumer consumer, long offset, long untilOffset) {
        long l;
        AvailableOffsetRange range = consumer.getAvailableOffsetRange();
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Some data may be lost. Recovering from the earliest offset: ").append(range.earliest()).toString());
        TopicPartition topicPartition = consumer.topicPartition();
        String groupId = consumer.groupId();
        if (offset >= range.latest() || range.earliest() >= untilOffset) {
            String warningMessage = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(143).append("\n         |The current available offset range is ").append(range).append(".\n         | Offset ").append(offset).append(" is out of range, and records in [").append(offset).append(", ").append(untilOffset).append(") will be\n         | skipped ").append(this.additionalMessage(topicPartition, groupId, false)).append("\n        ").toString())).stripMargin();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> warningMessage);
            l = KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET();
        } else if (offset >= range.earliest()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Found a disappeared offset ").append(offset).append(". Some data may be lost ").append(this.additionalMessage(topicPartition, groupId, false)).toString());
            l = offset;
        } else {
            String warningMessage = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(143).append("\n         |The current available offset range is ").append(range).append(".\n         | Offset ").append(offset).append(" is out of range, and records in [").append(offset).append(", ").append(range.earliest()).append(") will be\n         | skipped ").append(this.additionalMessage(topicPartition, groupId, false)).append("\n        ").toString())).stripMargin();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> warningMessage);
            l = range.earliest();
        }
        return l;
    }

    private FetchedRecord fetchRecord(InternalKafkaConsumer consumer, FetchedData fetchedData, long offset, long untilOffset, long pollTimeoutMs, boolean failOnDataLoss) {
        FetchedRecord fetchedRecord;
        if (offset != fetchedData.nextOffsetInFetchedData()) {
            this.fetchData(consumer, fetchedData, offset, pollTimeoutMs);
        } else if (!fetchedData.hasNext()) {
            if (offset < fetchedData.offsetAfterPoll()) {
                long nextOffsetToFetch = fetchedData.offsetAfterPoll();
                fetchedData.reset();
                return this.fetchedRecord().withRecord(null, nextOffsetToFetch);
            }
            this.fetchData(consumer, fetchedData, offset, pollTimeoutMs);
        }
        if (!fetchedData.hasNext()) {
            Predef$.MODULE$.assert(offset <= fetchedData.offsetAfterPoll(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("seek to ").append(offset).append(" and poll but the offset was reset to ").append(fetchedData.offsetAfterPoll()).toString());
            fetchedRecord = this.fetchedRecord().withRecord(null, fetchedData.offsetAfterPoll());
        } else {
            ConsumerRecord<byte[], byte[]> record = fetchedData.next();
            if (record.offset() > offset) {
                AvailableOffsetRange range = consumer.getAvailableOffsetRange();
                if (range.earliest() <= offset) {
                    fetchedData.previous();
                    return this.fetchedRecord().withRecord(null, record.offset());
                }
                if (failOnDataLoss) {
                    this.reportDataLoss(consumer.topicPartition(), consumer.groupId(), true, new StringBuilder(28).append("Cannot fetch records in [").append(offset).append(", ").append(record.offset()).append(")").toString(), this.reportDataLoss$default$5());
                    throw new IllegalStateException("reportDataLoss didn't throw an exception when 'failOnDataLoss' is true");
                }
                if (record.offset() >= untilOffset) {
                    this.reportDataLoss(consumer.topicPartition(), consumer.groupId(), false, new StringBuilder(28).append("Skip missing records in [").append(offset).append(", ").append(untilOffset).append(")").toString(), this.reportDataLoss$default$5());
                    fetchedRecord = this.fetchedRecord().withRecord(null, untilOffset);
                } else {
                    this.reportDataLoss(consumer.topicPartition(), consumer.groupId(), false, new StringBuilder(28).append("Skip missing records in [").append(offset).append(", ").append(record.offset()).append(")").toString(), this.reportDataLoss$default$5());
                    fetchedRecord = this.fetchedRecord().withRecord(record, fetchedData.nextOffsetInFetchedData());
                }
            } else {
                if (record.offset() < offset) {
                    throw new IllegalStateException(new StringBuilder(51).append("Tried to fetch ").append(offset).append(" but the returned record offset was ").append(record.offset()).toString());
                }
                fetchedRecord = this.fetchedRecord().withRecord(record, fetchedData.nextOffsetInFetchedData());
            }
        }
        return fetchedRecord;
    }

    private void fetchData(InternalKafkaConsumer consumer, FetchedData fetchedData, long offset, long pollTimeoutMs) {
        Tuple2<List<ConsumerRecord<byte[], byte[]>>, Object> tuple2 = consumer.fetch(offset, pollTimeoutMs);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List records = (List)tuple2._1();
        long offsetAfterPoll = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2((Object)records, (Object)BoxesRunTime.boxToLong((long)offsetAfterPoll));
        Tuple2 tuple23 = tuple22;
        List records2 = (List)tuple23._1();
        long offsetAfterPoll2 = tuple23._2$mcJ$sp();
        fetchedData.withNewPoll(records2.listIterator(), offsetAfterPoll2);
    }

    public InternalKafkaConsumer getOrRetrieveConsumer() {
        block1: {
            if (!this._consumer().isDefined()) {
                this.retrieveConsumer();
            }
            Predef$.MODULE$.require(this._consumer().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Consumer must be defined");
            if (!KafkaTokenUtil$.MODULE$.needTokenUpdate(SparkEnv$.MODULE$.get().conf(), ((InternalKafkaConsumer)this._consumer().get()).kafkaParamsWithSecurity(), ((InternalKafkaConsumer)this._consumer().get()).clusterConfig())) break block1;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cached consumer uses an old delegation token, invalidating.");
            this.releaseConsumer();
            this.consumerPool.invalidateKey(this.cacheKey());
            this.fetchedDataPool.invalidate(this.cacheKey());
            this.retrieveConsumer();
        }
        return (InternalKafkaConsumer)this._consumer().get();
    }

    private void retrieveConsumer() {
        this._consumer_$eq((Option<InternalKafkaConsumer>)Option$.MODULE$.apply((Object)this.consumerPool.borrowObject(this.cacheKey(), this.kafkaParams)));
        Predef$.MODULE$.require(this._consumer().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "borrowing consumer from pool must always succeed.");
    }

    private FetchedData getOrRetrieveFetchedData(long offset) {
        FetchedData fetchedData;
        Option<FetchedData> option = this._fetchedData();
        if (None$.MODULE$.equals(option)) {
            this._fetchedData_$eq((Option<FetchedData>)Option$.MODULE$.apply((Object)this.fetchedDataPool.acquire(this.cacheKey(), offset)));
            Predef$.MODULE$.require(this._fetchedData().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "acquiring fetched data from cache must always succeed.");
            fetchedData = (FetchedData)this._fetchedData().get();
        } else if (option instanceof Some) {
            FetchedData fetchedData2;
            Some some = (Some)option;
            fetchedData = fetchedData2 = (FetchedData)some.value();
        } else {
            throw new MatchError(option);
        }
        return fetchedData;
    }

    private String additionalMessage(TopicPartition topicPartition, String groupId, boolean failOnDataLoss) {
        return failOnDataLoss ? new StringBuilder(31).append("(GroupId: ").append(groupId).append(", TopicPartition: ").append(topicPartition).append("). ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_TRUE()).toString() : new StringBuilder(31).append("(GroupId: ").append(groupId).append(", TopicPartition: ").append(topicPartition).append("). ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_FALSE()).toString();
    }

    private void reportDataLoss(TopicPartition topicPartition, String groupId, boolean failOnDataLoss, String message, Throwable cause) {
        String finalMessage = new StringBuilder(1).append(message).append(" ").append(this.additionalMessage(topicPartition, groupId, failOnDataLoss)).toString();
        KafkaDataConsumer$.MODULE$.org$apache$spark$sql$kafka010$consumer$KafkaDataConsumer$$reportDataLoss0(failOnDataLoss, finalMessage, cause);
    }

    private Throwable reportDataLoss$default$5() {
        return null;
    }

    private <T> T runUninterruptiblyIfPossible(Function0<T> body) {
        Object object;
        Thread thread = Thread.currentThread();
        if (thread instanceof UninterruptibleThread) {
            UninterruptibleThread uninterruptibleThread = (UninterruptibleThread)thread;
            object = uninterruptibleThread.runUninterruptibly(body);
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "KafkaDataConsumer is not running in UninterruptibleThread. It may hang when KafkaDataConsumer's methods are interrupted because of KAFKA-1894");
            object = body.apply();
        }
        return (T)object;
    }

    public KafkaDataConsumer(TopicPartition topicPartition, Map<String, Object> kafkaParams, InternalKafkaConsumerPool consumerPool, FetchedDataPool fetchedDataPool) {
        this.topicPartition = topicPartition;
        this.kafkaParams = kafkaParams;
        this.consumerPool = consumerPool;
        this.fetchedDataPool = fetchedDataPool;
        Logging.$init$((Logging)this);
        this._consumer = None$.MODULE$;
        this._fetchedData = None$.MODULE$;
        this.groupId = (String)kafkaParams.get("group.id");
        this.cacheKey = new CacheKey(this.groupId(), topicPartition);
        this.fetchedRecord = new FetchedRecord(null, KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET());
    }

    public static class AvailableOffsetRange
    implements Product,
    scala.Serializable {
        private final long earliest;
        private final long latest;

        public long earliest() {
            return this.earliest;
        }

        public long latest() {
            return this.latest;
        }

        public AvailableOffsetRange copy(long earliest, long latest) {
            return new AvailableOffsetRange(earliest, latest);
        }

        public long copy$default$1() {
            return this.earliest();
        }

        public long copy$default$2() {
            return this.latest();
        }

        public String productPrefix() {
            return "AvailableOffsetRange";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Long l;
            int n = x$1;
            switch (n) {
                case 0: {
                    l = BoxesRunTime.boxToLong((long)this.earliest());
                    break;
                }
                case 1: {
                    l = BoxesRunTime.boxToLong((long)this.latest());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return l;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof AvailableOffsetRange;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.earliest()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.latest()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof AvailableOffsetRange)) return false;
            boolean bl = true;
            if (!bl) return false;
            AvailableOffsetRange availableOffsetRange = (AvailableOffsetRange)x$1;
            if (this.earliest() != availableOffsetRange.earliest()) return false;
            if (this.latest() != availableOffsetRange.latest()) return false;
            if (!availableOffsetRange.canEqual(this)) return false;
            return true;
        }

        public AvailableOffsetRange(long earliest, long latest) {
            this.earliest = earliest;
            this.latest = latest;
            Product.$init$((Product)this);
        }
    }

    public static class CacheKey
    implements Product,
    scala.Serializable {
        private final String groupId;
        private final TopicPartition topicPartition;

        public String groupId() {
            return this.groupId;
        }

        public TopicPartition topicPartition() {
            return this.topicPartition;
        }

        public CacheKey copy(String groupId, TopicPartition topicPartition) {
            return new CacheKey(groupId, topicPartition);
        }

        public String copy$default$1() {
            return this.groupId();
        }

        public TopicPartition copy$default$2() {
            return this.topicPartition();
        }

        public String productPrefix() {
            return "CacheKey";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = this.groupId();
                    break;
                }
                case 1: {
                    string = this.topicPartition();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return string;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CacheKey;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CacheKey)) return false;
            boolean bl = true;
            if (!bl) return false;
            CacheKey cacheKey = (CacheKey)x$1;
            String string = this.groupId();
            String string2 = cacheKey.groupId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            TopicPartition topicPartition = this.topicPartition();
            TopicPartition topicPartition2 = cacheKey.topicPartition();
            if (topicPartition == null) {
                if (topicPartition2 != null) {
                    return false;
                }
            } else if (!topicPartition.equals(topicPartition2)) return false;
            if (!cacheKey.canEqual(this)) return false;
            return true;
        }

        public CacheKey(String groupId, TopicPartition topicPartition) {
            this.groupId = groupId;
            this.topicPartition = topicPartition;
            Product.$init$((Product)this);
        }

        public CacheKey(TopicPartition topicPartition, Map<String, Object> kafkaParams) {
            this((String)kafkaParams.get("group.id"), topicPartition);
        }
    }
}

