/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.adaptive;

import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.planning.ExtractEquiJoinKeys$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.SparkStrategy;
import org.apache.spark.sql.execution.adaptive.BroadcastQueryStageExec;
import org.apache.spark.sql.execution.adaptive.LogicalQueryStage;
import org.apache.spark.sql.execution.joins.BroadcastHashJoinExec;
import org.apache.spark.sql.execution.joins.BroadcastNestedLoopJoinExec;
import org.apache.spark.sql.execution.joins.package;
import org.apache.spark.sql.execution.joins.package$BuildLeft$;
import org.apache.spark.sql.execution.joins.package$BuildRight$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple7;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;

public final class LogicalQueryStageStrategy$
extends SparkStrategy
implements PredicateHelper {
    public static LogicalQueryStageStrategy$ MODULE$;

    static {
        new LogicalQueryStageStrategy$();
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression replaceAlias(Expression condition, AttributeMap<Expression> aliases) {
        return PredicateHelper.replaceAlias$((PredicateHelper)this, (Expression)condition, aliases);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    private boolean isBroadcastStage(LogicalPlan plan) {
        LogicalQueryStage logicalQueryStage;
        LogicalPlan logicalPlan2 = plan;
        boolean bl = logicalPlan2 instanceof LogicalQueryStage && (logicalQueryStage = (LogicalQueryStage)logicalPlan2).physicalPlan() instanceof BroadcastQueryStageExec;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Seq<SparkPlan> apply(LogicalPlan plan) {
        boolean bl = false;
        Join join2 = null;
        LogicalPlan logicalPlan2 = plan;
        if (logicalPlan2 instanceof Join) {
            bl = true;
            join2 = (Join)logicalPlan2;
            Option option = ExtractEquiJoinKeys$.MODULE$.unapply(join2);
            if (!option.isEmpty()) {
                JoinType joinType = (JoinType)((Tuple7)option.get())._1();
                Seq leftKeys = (Seq)((Tuple7)option.get())._2();
                Seq rightKeys = (Seq)((Tuple7)option.get())._3();
                Option condition = (Option)((Tuple7)option.get())._4();
                LogicalPlan left = (LogicalPlan)((Tuple7)option.get())._5();
                LogicalPlan right = (LogicalPlan)((Tuple7)option.get())._6();
                if (this.isBroadcastStage(left) || this.isBroadcastStage(right)) {
                    package.BuildSide buildSide = this.isBroadcastStage(left) ? package$BuildLeft$.MODULE$ : package$BuildRight$.MODULE$;
                    return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BroadcastHashJoinExec[]{new BroadcastHashJoinExec((Seq<Expression>)leftKeys, (Seq<Expression>)rightKeys, joinType, buildSide, (Option<Expression>)condition, this.planLater(left), this.planLater(right))}));
                }
            }
        }
        if (bl) {
            LogicalPlan left = join2.left();
            LogicalPlan right = join2.right();
            JoinType joinType = join2.joinType();
            Option condition = join2.condition();
            if (this.isBroadcastStage(left) || this.isBroadcastStage(right)) {
                package.BuildSide buildSide = this.isBroadcastStage(left) ? package$BuildLeft$.MODULE$ : package$BuildRight$.MODULE$;
                BroadcastNestedLoopJoinExec broadcastNestedLoopJoinExec = new BroadcastNestedLoopJoinExec(this.planLater(left), this.planLater(right), buildSide, joinType, (Option<Expression>)condition);
                return Nil$.MODULE$.$colon$colon((Object)broadcastNestedLoopJoinExec);
            }
        }
        if (!(logicalPlan2 instanceof LogicalQueryStage)) return Nil$.MODULE$;
        LogicalQueryStage logicalQueryStage = (LogicalQueryStage)logicalPlan2;
        SparkPlan sparkPlan = logicalQueryStage.physicalPlan();
        return Nil$.MODULE$.$colon$colon((Object)sparkPlan);
    }

    private LogicalQueryStageStrategy$() {
        MODULE$ = this;
        PredicateHelper.$init$((PredicateHelper)this);
    }
}

