/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.text;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.util.CompressionCodecs$;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.text.TextOptions;
import org.apache.spark.sql.execution.datasources.text.TextOutputWriter;
import org.apache.spark.sql.execution.datasources.v2.FileWriteBuilder;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001}4A\u0001C\u0005\u00015!Aq\u0004\u0001B\u0001B\u0003%\u0001\u0005\u0003\u00057\u0001\t\u0005\t\u0015!\u0003/\u0011!9\u0004A!A!\u0002\u0013A\u0004\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\t\u000b9\u0003A\u0011A(\t\u000bY\u0003A\u0011B,\t\u000b\u0001\u0004A\u0011I1\u0003!Q+\u0007\u0010^,sSR,')^5mI\u0016\u0014(B\u0001\u0006\f\u0003\u0011!X\r\u001f;\u000b\u00051i\u0011A\u0001<3\u0015\tqq\"A\u0006eCR\f7o\\;sG\u0016\u001c(B\u0001\t\u0012\u0003%)\u00070Z2vi&|gN\u0003\u0002\u0013'\u0005\u00191/\u001d7\u000b\u0005Q)\u0012!B:qCJ\\'B\u0001\f\u0018\u0003\u0019\t\u0007/Y2iK*\t\u0001$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u00017A\u0011A$H\u0007\u0002\u0017%\u0011ad\u0003\u0002\u0011\r&dWm\u0016:ji\u0016\u0014U/\u001b7eKJ\fQ\u0001]1uQN\u00042!I\u0016/\u001d\t\u0011\u0003F\u0004\u0002$M5\tAE\u0003\u0002&3\u00051AH]8pizJ\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S)\nq\u0001]1dW\u0006<WMC\u0001(\u0013\taSFA\u0002TKFT!!\u000b\u0016\u0011\u0005=\u001adB\u0001\u00192!\t\u0019#&\u0003\u00023U\u00051\u0001K]3eK\u001aL!\u0001N\u001b\u0003\rM#(/\u001b8h\u0015\t\u0011$&\u0001\u0006g_Jl\u0017\r\u001e(b[\u0016\f\u0001c];qa>\u0014Ho\u001d#bi\u0006$\u0016\u0010]3\u0011\teRDHQ\u0007\u0002U%\u00111H\u000b\u0002\n\rVt7\r^5p]F\u0002\"!\u0010!\u000e\u0003yR!aP\t\u0002\u000bQL\b/Z:\n\u0005\u0005s$\u0001\u0003#bi\u0006$\u0016\u0010]3\u0011\u0005e\u001a\u0015B\u0001#+\u0005\u001d\u0011un\u001c7fC:\fA!\u001b8g_B\u0011q\tT\u0007\u0002\u0011*\u0011\u0011JS\u0001\u0006oJLG/\u001a\u0006\u0003\u0017F\t\u0011bY8o]\u0016\u001cGo\u001c:\n\u00055C%\u0001\u0005'pO&\u001c\u0017\r\\,sSR,\u0017J\u001c4p\u0003\u0019a\u0014N\\5u}Q)\u0001KU*U+B\u0011\u0011\u000bA\u0007\u0002\u0013!)q$\u0002a\u0001A!)a'\u0002a\u0001]!)q'\u0002a\u0001q!)Q)\u0002a\u0001\r\u0006aa/\u001a:jMf\u001c6\r[3nCR\u0011\u0001l\u0017\t\u0003seK!A\u0017\u0016\u0003\tUs\u0017\u000e\u001e\u0005\u00069\u001a\u0001\r!X\u0001\u0007g\u000eDW-\\1\u0011\u0005ur\u0016BA0?\u0005)\u0019FO];diRK\b/Z\u0001\raJ,\u0007/\u0019:f/JLG/\u001a\u000b\u0006E\u001at\u00070 \t\u0003G\u0012l\u0011!D\u0005\u0003K6\u00111cT;uaV$xK]5uKJ4\u0015m\u0019;pefDQaZ\u0004A\u0002!\fqa]9m\u0007>tg\r\u0005\u0002jY6\t!N\u0003\u0002l#\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002nU\n91+\u0015'D_:4\u0007\"B8\b\u0001\u0004\u0001\u0018a\u00016pEB\u0011\u0011O^\u0007\u0002e*\u00111\u000f^\u0001\n[\u0006\u0004(/\u001a3vG\u0016T!!^\u000b\u0002\r!\fGm\\8q\u0013\t9(OA\u0002K_\nDQ!_\u0004A\u0002i\fqa\u001c9uS>t7\u000f\u0005\u00030w:r\u0013B\u0001?6\u0005\ri\u0015\r\u001d\u0005\u0006}\u001e\u0001\r!X\u0001\u000bI\u0006$\u0018mU2iK6\f\u0007")
public class TextWriteBuilder
extends FileWriteBuilder {
    private void verifySchema(StructType schema) {
        if (schema.size() != 1) {
            throw new AnalysisException(new StringBuilder(70).append("Text data source supports only a single column, and you have ").append(schema.size()).append(" columns.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    @Override
    public OutputWriterFactory prepareWrite(SQLConf sqlConf, Job job, Map<String, String> options, StructType dataSchema) {
        this.verifySchema(dataSchema);
        TextOptions textOptions = new TextOptions(options);
        Configuration conf = job.getConfiguration();
        textOptions.compressionCodec().foreach((Function1 & Serializable & scala.Serializable)codec -> {
            CompressionCodecs$.MODULE$.setCodecConfiguration(conf, codec);
            return BoxedUnit.UNIT;
        });
        return new OutputWriterFactory(null, textOptions){
            private final TextOptions textOptions$1;

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new TextOutputWriter(path, dataSchema, this.textOptions$1.lineSeparatorInWrite(), context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder(4).append(".txt").append(CodecStreams$.MODULE$.getCompressionExtension((JobContext)context)).toString();
            }
            {
                this.textOptions$1 = textOptions$1;
            }
        };
    }

    public TextWriteBuilder(Seq<String> paths, String formatName, Function1<DataType, Object> supportsDataType, LogicalWriteInfo info) {
        super(paths, formatName, supportsDataType, info);
    }
}

