/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.streaming.CompactibleFileStreamLog$;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog;
import org.apache.spark.util.SizeEstimator$;
import org.apache.spark.util.Utils$;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.Serialization$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayOps;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t%c!\u0002\u0016,\u0003\u0003A\u0004\u0002C(\u0001\u0005\u0003\u0005\u000b\u0011\u0002)\t\u0011M\u0003!\u0011!Q\u0001\nQC\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006I!\u0017\u0005\tI\u0002\u0011\u0019\u0011)A\u0006K\")1\u000e\u0001C\u0001Y\"91\u000f\u0001b\u0001\n\u0017!\bbBA\u000e\u0001\u0001\u0006I!\u001e\u0005\n\u0003;\u0001!\u0019!C\u0006\u0003?A\u0001\"a\n\u0001A\u0003%\u0011\u0011\u0005\u0005\n\u0003S\u0001!\u0019!C\t\u0003WAq!!\f\u0001A\u0003%\u0001\u000bC\u0004\u00020\u00011\t\"!\r\t\u000f\u0005e\u0002A\"\u0005\u0002<!9\u00111\t\u0001\u0007\u0012\u0005-\u0002BCA#\u0001!\u0015\r\u0011\"\u0006\u0002,!9\u0011q\t\u0001\u0007\u0002\u0005%\u0003bBA1\u0001\u0011\u0005\u00131\r\u0005\b\u0003s\u0002A\u0011IA>\u0011\u001d\ty\b\u0001C!\u0003\u0003Cq!!\"\u0001\t\u0003\n9\tC\u0004\u0002(\u0002!\t%!+\t\u000f\u0005U\u0006\u0001\"\u0011\u00028\"9\u0011Q\u0018\u0001\u0005B\u0005}\u0006bBAc\u0001\u0011%\u0011q\u0019\u0005\b\u0003\u001b\u0004A\u0011AAh\u0011\u001d\t\t\u000e\u0001C\u0005\u0003'Da\"!7\u0001!\u0003\r\t\u0011!C\u0005\u00037\f)\u000f\u0003\b\u0002j\u0002\u0001\n1!A\u0001\n\u0013\tY/a=\b\u000f\u0005U8\u0006#\u0001\u0002x\u001a1!f\u000bE\u0001\u0003sDaa\u001b\u0010\u0005\u0002\u0005m\b\"CA\u007f=\t\u0007I\u0011AA\u0000\u0011!\u0011YA\bQ\u0001\n\t\u0005\u0001\"\u0003B\u0007=\t\u0007I\u0011AA\u0016\u0011\u001d\u0011yA\bQ\u0001\nACqA!\u0005\u001f\t\u0003\u0011\u0019\u0002C\u0004\u0003\u001ay!\tAa\u0007\t\u000f\t\u0005b\u0004\"\u0001\u0003$!9!Q\u0006\u0010\u0005\u0002\t=\u0002b\u0002B\u001b=\u0011\u0005!q\u0007\u0005\b\u0005{qB\u0011\u0001B \u0005a\u0019u.\u001c9bGRL'\r\\3GS2,7\u000b\u001e:fC6dun\u001a\u0006\u0003Y5\n\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u00059z\u0013!C3yK\u000e,H/[8o\u0015\t\u0001\u0014'A\u0002tc2T!AM\u001a\u0002\u000bM\u0004\u0018M]6\u000b\u0005Q*\u0014AB1qC\u000eDWMC\u00017\u0003\ry'oZ\u0002\u0001+\tIdi\u0005\u0002\u0001uA\u00191\b\u0010 \u000e\u0003-J!!P\u0016\u0003\u001f!#eiU'fi\u0006$\u0017\r^1M_\u001e\u00042a\u0010\"E\u001b\u0005\u0001%\"A!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0003%!B!se\u0006L\bCA#G\u0019\u0001!Qa\u0012\u0001C\u0002!\u0013\u0011\u0001V\t\u0003\u00132\u0003\"a\u0010&\n\u0005-\u0003%a\u0002(pi\"Lgn\u001a\t\u0003\u007f5K!A\u0014!\u0003\r\u0005s\u0017PU3g\u0003IiW\r^1eCR\fGj\\4WKJ\u001c\u0018n\u001c8\u0011\u0005}\n\u0016B\u0001*A\u0005\rIe\u000e^\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003+Zk\u0011aL\u0005\u0003/>\u0012Ab\u00159be.\u001cVm]:j_:\fA\u0001]1uQB\u0011!,\u0019\b\u00037~\u0003\"\u0001\u0018!\u000e\u0003uS!AX\u001c\u0002\rq\u0012xn\u001c;?\u0013\t\u0001\u0007)\u0001\u0004Qe\u0016$WMZ\u0005\u0003E\u000e\u0014aa\u0015;sS:<'B\u00011A\u0003))g/\u001b3f]\u000e,G%\r\t\u0004M&$U\"A4\u000b\u0005!\u0004\u0015a\u0002:fM2,7\r^\u0005\u0003U\u001e\u0014\u0001b\u00117bgN$\u0016mZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\t5\u0004\u0018O\u001d\u000b\u0003]>\u00042a\u000f\u0001E\u0011\u0015!W\u0001q\u0001f\u0011\u0015yU\u00011\u0001Q\u0011\u0015\u0019V\u00011\u0001U\u0011\u0015AV\u00011\u0001Z\u0003\u001d1wN]7biN,\u0012!\u001e\n\u0004m2kh\u0001B<\u0001\u0001U\u0014A\u0002\u0010:fM&tW-\\3oizJ!a]=\n\u0005i\\(!D*fe&\fG.\u001b>bi&|gN\u0003\u0002}k\u00051!n]8oiM\u0004\"A`@\u000e\u0003mL1!!\u0001|\u0005\u001d1uN]7biND\u0011\"!\u0002w\u0005\u0004%\t!a\u0002\u0002\u0015\u0011\fG/\u001a$pe6\fG/\u0006\u0002\u0002\nA\u0019a0a\u0003\n\u0007\u000551P\u0001\u0006ECR,gi\u001c:nCRD\u0011\"!\u0005w\u0005\u0004%\t!a\u0005\u0002\u0013QL\b/\u001a%j]R\u001cXCAA\u000b!\rq\u0018qC\u0005\u0004\u00033Y(!\u0003+za\u0016D\u0015N\u001c;t\u0003!1wN]7biN\u0004\u0013\u0001C7b]&4Wm\u001d;\u0016\u0005\u0005\u0005\u0002\u0003\u00024\u0002$\u0011K1!!\nh\u0005!i\u0015M\\5gKN$\u0018!C7b]&4Wm\u001d;!\u0003Ii\u0017N\u001c\"bi\u000eDWm\u001d+p%\u0016$\u0018-\u001b8\u0016\u0003A\u000b1#\\5o\u0005\u0006$8\r[3t)>\u0014V\r^1j]\u0002\n!CZ5mK\u000ecW-\u00198va\u0012+G.Y=NgV\u0011\u00111\u0007\t\u0004\u007f\u0005U\u0012bAA\u001c\u0001\n!Aj\u001c8h\u0003QI7\u000fR3mKRLgnZ#ya&\u0014X\r\u001a'pOV\u0011\u0011Q\b\t\u0004\u007f\u0005}\u0012bAA!\u0001\n9!i\\8mK\u0006t\u0017A\u00063fM\u0006,H\u000e^\"p[B\f7\r^%oi\u0016\u0014h/\u00197\u0002\u001f\r|W\u000e]1di&sG/\u001a:wC2\f1bY8na\u0006\u001cG\u000fT8hgR!\u00111JA/!\u0015\ti%a\u0016E\u001d\u0011\ty%a\u0015\u000f\u0007q\u000b\t&C\u0001B\u0013\r\t)\u0006Q\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI&a\u0017\u0003\u0007M+\u0017OC\u0002\u0002V\u0001Cq!a\u0018\u0011\u0001\u0004\tY%\u0001\u0003m_\u001e\u001c\u0018!\u00042bi\u000eD\u0017\n\u001a+p!\u0006$\b\u000e\u0006\u0003\u0002f\u0005U\u0004\u0003BA4\u0003cj!!!\u001b\u000b\t\u0005-\u0014QN\u0001\u0003MNT1!a\u001c4\u0003\u0019A\u0017\rZ8pa&!\u00111OA5\u0005\u0011\u0001\u0016\r\u001e5\t\u000f\u0005]\u0014\u00031\u0001\u00024\u00059!-\u0019;dQ&#\u0017!\u00049bi\"$vNQ1uG\"LE\r\u0006\u0003\u00024\u0005u\u0004B\u0002-\u0013\u0001\u0004\t)'A\u0006jg\n\u000bGo\u00195GS2,G\u0003BA\u001f\u0003\u0007Ca\u0001W\nA\u0002\u0005\u0015\u0014!C:fe&\fG.\u001b>f)\u0019\tI)a$\u0002\u0014B\u0019q(a#\n\u0007\u00055\u0005I\u0001\u0003V]&$\bBBAI)\u0001\u0007a(A\u0004m_\u001e$\u0015\r^1\t\u000f\u0005UE\u00031\u0001\u0002\u0018\u0006\u0019q.\u001e;\u0011\t\u0005e\u00151U\u0007\u0003\u00037SA!!(\u0002 \u0006\u0011\u0011n\u001c\u0006\u0003\u0003C\u000bAA[1wC&!\u0011QUAN\u00051yU\u000f\u001e9viN#(/Z1n\u0003-!Wm]3sS\u0006d\u0017N_3\u0015\u0007y\nY\u000bC\u0004\u0002.V\u0001\r!a,\u0002\u0005%t\u0007\u0003BAM\u0003cKA!a-\u0002\u001c\nY\u0011J\u001c9viN#(/Z1n\u0003\r\tG\r\u001a\u000b\u0007\u0003{\tI,a/\t\u000f\u0005]d\u00031\u0001\u00024!1\u0011q\f\fA\u0002y\nQ\u0001];sO\u0016$B!!#\u0002B\"9\u00111Y\fA\u0002\u0005M\u0012\u0001\u0005;ie\u0016\u001c\bn\u001c7e\u0005\u0006$8\r[%e\u0003\u001d\u0019w.\u001c9bGR$b!!\u0010\u0002J\u0006-\u0007bBA<1\u0001\u0007\u00111\u0007\u0005\u0007\u0003?B\u0002\u0019\u0001 \u0002\u0011\u0005dGNR5mKN$\u0012AP\u0001\u0011I\u0016dW\r^3FqBL'/\u001a3M_\u001e$B!!#\u0002V\"9\u0011q\u001b\u000eA\u0002\u0005M\u0012AD2veJ,g\u000e\u001e\"bi\u000eD\u0017\nZ\u0001\ngV\u0004XM\u001d\u0013hKR$B!!8\u0002dB!q(a8?\u0013\r\t\t\u000f\u0011\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005]4\u00041\u0001\u00024%\u0019\u0011q\u001d\u001f\u0002\u0007\u001d,G/A\u0005tkB,'\u000fJ1eIR1\u0011QHAw\u0003_Dq!a\u001e\u001d\u0001\u0004\t\u0019\u0004\u0003\u0004\u0002rr\u0001\rAP\u0001\t[\u0016$\u0018\rZ1uC&\u0019\u0011Q\u0017\u001f\u00021\r{W\u000e]1di&\u0014G.\u001a$jY\u0016\u001cFO]3b[2{w\r\u0005\u0002<=M\u0011a\u0004\u0014\u000b\u0003\u0003o\f1cQ(N!\u0006\u001bEk\u0018$J\u0019\u0016{6+\u0016$G\u0013b+\"A!\u0001\u0011\t\t\r!\u0011B\u0007\u0003\u0005\u000bQAAa\u0002\u0002 \u0006!A.\u00198h\u0013\r\u0011'QA\u0001\u0015\u0007>k\u0005+Q\"U?\u001aKE*R0T+\u001a3\u0015\n\u0017\u0011\u0002C\r{U\nU!D)~c\u0015\tV#O\u0007f{v+\u0011*O?RC%+R*I\u001f2#u,T*\u0002E\r{U\nU!D)~c\u0015\tV#O\u0007f{v+\u0011*O?RC%+R*I\u001f2#u,T*!\u0003Y9W\r\u001e\"bi\u000eD\u0017\n\u001a$s_64\u0015\u000e\\3OC6,G\u0003BA\u001a\u0005+AaAa\u0006%\u0001\u0004I\u0016\u0001\u00034jY\u0016t\u0015-\\3\u0002#%\u001c8i\\7qC\u000e$\u0018n\u001c8CCR\u001c\u0007\u000e\u0006\u0004\u0002>\tu!q\u0004\u0005\b\u0003o*\u0003\u0019AA\u001a\u0011\u0019\t)%\na\u0001!\u0006!s-\u001a;WC2LGMQ1uG\",7OQ3g_J,7i\\7qC\u000e$\u0018n\u001c8CCR\u001c\u0007\u000e\u0006\u0004\u0003&\t\u001d\"1\u0006\t\u0007\u0003\u001b\n9&a\r\t\u000f\t%b\u00051\u0001\u00024\u0005\t2m\\7qC\u000e$\u0018n\u001c8CCR\u001c\u0007.\u00133\t\r\u0005\u0015c\u00051\u0001Q\u0003I9W\r^!mYZ\u000bG.\u001b3CCR\u001c\u0007.Z:\u0015\r\t\u0015\"\u0011\u0007B\u001a\u0011\u001d\t9h\na\u0001\u0003gAq!!\u0012(\u0001\u0004\t\u0019$A\u000boKb$8i\\7qC\u000e$\u0018n\u001c8CCR\u001c\u0007.\u00133\u0015\r\u0005M\"\u0011\bB\u001e\u0011\u001d\t9\b\u000ba\u0001\u0003gAq!!\u0012)\u0001\u0004\t\u0019$A\u000beKJLg/Z\"p[B\f7\r^%oi\u0016\u0014h/\u00197\u0015\u000bA\u0013\tE!\u0012\t\r\t\r\u0013\u00061\u0001Q\u0003=!WMZ1vYRLe\u000e^3sm\u0006d\u0007B\u0002B$S\u0001\u0007\u0001+\u0001\u000bmCR,7\u000f^\"p[B\f7\r\u001e\"bi\u000eD\u0017\n\u001a")
public abstract class CompactibleFileStreamLog<T>
extends HDFSMetadataLog<T[]> {
    private int compactInterval;
    private final int metadataLogVersion;
    private final Formats formats;
    private final Manifest<T> manifest;
    private final int minBatchesToRetain;
    private volatile boolean bitmap$0;

    public static int deriveCompactInterval(int n, int n2) {
        return CompactibleFileStreamLog$.MODULE$.deriveCompactInterval(n, n2);
    }

    public static long nextCompactionBatchId(long l, long l2) {
        return CompactibleFileStreamLog$.MODULE$.nextCompactionBatchId(l, l2);
    }

    public static Seq<Object> getAllValidBatches(long l, long l2) {
        return CompactibleFileStreamLog$.MODULE$.getAllValidBatches(l, l2);
    }

    public static Seq<Object> getValidBatchesBeforeCompactionBatch(long l, int n) {
        return CompactibleFileStreamLog$.MODULE$.getValidBatchesBeforeCompactionBatch(l, n);
    }

    public static boolean isCompactionBatch(long l, int n) {
        return CompactibleFileStreamLog$.MODULE$.isCompactionBatch(l, n);
    }

    public static long getBatchIdFromFileName(String string) {
        return CompactibleFileStreamLog$.MODULE$.getBatchIdFromFileName(string);
    }

    public static int COMPACT_LATENCY_WARN_THRESHOLD_MS() {
        return CompactibleFileStreamLog$.MODULE$.COMPACT_LATENCY_WARN_THRESHOLD_MS();
    }

    public static String COMPACT_FILE_SUFFIX() {
        return CompactibleFileStreamLog$.MODULE$.COMPACT_FILE_SUFFIX();
    }

    private /* synthetic */ Option super$get(long batchId) {
        return super.get(batchId);
    }

    private /* synthetic */ boolean super$add(long batchId, Object[] metadata) {
        return super.add(batchId, metadata);
    }

    private Formats formats() {
        return this.formats;
    }

    private Manifest<T> manifest() {
        return this.manifest;
    }

    public int minBatchesToRetain() {
        return this.minBatchesToRetain;
    }

    public abstract long fileCleanupDelayMs();

    public abstract boolean isDeletingExpiredLog();

    public abstract int defaultCompactInterval();

    private int compactInterval$lzycompute() {
        CompactibleFileStreamLog compactibleFileStreamLog = this;
        synchronized (compactibleFileStreamLog) {
            if (!this.bitmap$0) {
                long[] compactibleBatchIds = (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter()))).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)CompactibleFileStreamLog.$anonfun$compactInterval$1(f))))).map((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sorted(Ordering.Long$.MODULE$.reverse());
                IntRef interval = IntRef.create((int)this.defaultCompactInterval());
                if (compactibleBatchIds.length >= 2) {
                    long latestCompactBatchId = compactibleBatchIds[0];
                    long previousCompactBatchId = compactibleBatchIds[1];
                    interval.elem = (int)(latestCompactBatchId - previousCompactBatchId);
                } else if (compactibleBatchIds.length == 1) {
                    interval.elem = CompactibleFileStreamLog$.MODULE$.deriveCompactInterval(this.defaultCompactInterval(), (int)compactibleBatchIds[0]);
                }
                Predef$.MODULE$.assert(interval.elem > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("intervalValue = ").append(interval$1.elem).append(" not positive value.").toString());
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Set the compact interval to ").append(interval$1.elem).append(" ").append("[defaultCompactInterval: ").append(this.defaultCompactInterval()).append("]").toString());
                this.compactInterval = interval.elem;
                this.bitmap$0 = true;
            }
        }
        return this.compactInterval;
    }

    public final int compactInterval() {
        return !this.bitmap$0 ? this.compactInterval$lzycompute() : this.compactInterval;
    }

    public abstract Seq<T> compactLogs(Seq<T> var1);

    @Override
    public Path batchIdToPath(long batchId) {
        return CompactibleFileStreamLog$.MODULE$.isCompactionBatch(batchId, this.compactInterval()) ? new Path(this.metadataPath(), new StringBuilder(0).append(batchId).append(CompactibleFileStreamLog$.MODULE$.COMPACT_FILE_SUFFIX()).toString()) : new Path(this.metadataPath(), ((Object)BoxesRunTime.boxToLong((long)batchId)).toString());
    }

    @Override
    public long pathToBatchId(Path path) {
        return CompactibleFileStreamLog$.MODULE$.getBatchIdFromFileName(path.getName());
    }

    @Override
    public boolean isBatchFile(Path path) {
        boolean bl;
        try {
            CompactibleFileStreamLog$.MODULE$.getBatchIdFromFileName(path.getName());
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void serialize(T[] logData, OutputStream out) {
        out.write(new StringBuilder(1).append("v").append(this.metadataLogVersion).toString().getBytes(StandardCharsets.UTF_8));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])logData)).foreach((Function1 & Serializable & scala.Serializable)data -> {
            CompactibleFileStreamLog.$anonfun$serialize$1(this, out, data);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public T[] deserialize(InputStream in) {
        Iterator lines = Source$.MODULE$.fromInputStream(in, StandardCharsets.UTF_8.name()).getLines();
        if (!lines.hasNext()) {
            throw new IllegalStateException("Incomplete log file");
        }
        this.validateVersion((String)lines.next(), this.metadataLogVersion);
        return (Object[])lines.map((Function1 & Serializable & scala.Serializable)json -> Serialization$.MODULE$.read(json, this.formats(), this.manifest())).toArray(this.manifest());
    }

    @Override
    public boolean add(long batchId, T[] logs) {
        boolean batchAdded;
        block0: {
            boolean bl = batchAdded = CompactibleFileStreamLog$.MODULE$.isCompactionBatch(batchId, this.compactInterval()) ? this.compact(batchId, logs) : super.add(batchId, logs);
            if (!batchAdded || !this.isDeletingExpiredLog()) break block0;
            this.deleteExpiredLog(batchId);
        }
        return batchAdded;
    }

    @Override
    public void purge(long thresholdBatchId) {
        throw new UnsupportedOperationException("Cannot purge as it might break internal state.");
    }

    private boolean compact(long batchId, T[] logs) {
        Tuple2 tuple2 = Utils$.MODULE$.timeTakenMs((Function0 & Serializable & scala.Serializable)() -> {
            Seq<Object> validBatches = CompactibleFileStreamLog$.MODULE$.getValidBatchesBeforeCompactionBatch(batchId, this.compactInterval());
            return (Seq)((TraversableLike)validBatches.flatMap((Function1 & Serializable & scala.Serializable)id -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.super$get(BoxesRunTime.unboxToLong((Object)id)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException(new StringBuilder(57).append($this.batchIdToPath(id)).append(" doesn't exist when compacting batch ").append(batchId$1).append(" ").append("(compactInterval: ").append($this.compactInterval()).append(")").toString());
            }))), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(logs)), Seq$.MODULE$.canBuildFrom());
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq allLogs = (Seq)tuple2._1();
        long loadElapsedMs = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2((Object)allLogs, (Object)BoxesRunTime.boxToLong((long)loadElapsedMs));
        Tuple2 tuple23 = tuple22;
        Seq allLogs2 = (Seq)tuple23._1();
        long loadElapsedMs2 = tuple23._2$mcJ$sp();
        Seq compactedLogs = this.compactLogs(allLogs2);
        Tuple2 tuple24 = Utils$.MODULE$.timeTakenMs((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.super$add(batchId, (Object[])compactedLogs.toArray(this.manifest())));
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        boolean writeSucceed = tuple24._1$mcZ$sp();
        long writeElapsedMs = tuple24._2$mcJ$sp();
        Tuple2.mcZJ.sp sp2 = new Tuple2.mcZJ.sp(writeSucceed, writeElapsedMs);
        Tuple2.mcZJ.sp sp3 = sp2;
        boolean writeSucceed2 = sp3._1$mcZ$sp();
        long writeElapsedMs2 = sp3._2$mcJ$sp();
        long elapsedMs = loadElapsedMs2 + writeElapsedMs2;
        if (elapsedMs >= (long)CompactibleFileStreamLog$.MODULE$.COMPACT_LATENCY_WARN_THRESHOLD_MS()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Compacting took ").append(elapsedMs).append(" ms (load: ").append(loadElapsedMs2).append(" ms,").append(" write: ").append(writeElapsedMs2).append(" ms) for compact batch ").append(batchId).toString());
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(83).append("Loaded ").append(allLogs2.size()).append(" entries (estimated ").append(SizeEstimator$.MODULE$.estimate((Object)allLogs2)).append(" ").append("bytes in memory), and wrote ").append(compactedLogs.size()).append(" entries for compact batch ").append(batchId).toString());
        } else {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Compacting took ").append(elapsedMs).append(" ms (load: ").append(loadElapsedMs2).append(" ms,").append(" write: ").append(writeElapsedMs2).append(" ms) for compact batch ").append(batchId).toString());
        }
        return writeSucceed2;
    }

    public T[] allFiles() {
        LongRef latestId = LongRef.create((long)BoxesRunTime.unboxToLong((Object)this.getLatest().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3._1$mcJ$sp())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L)));
        while (latestId.elem >= 0L) {
            try {
                Seq logs = (Seq)CompactibleFileStreamLog$.MODULE$.getAllValidBatches(latestId.elem, this.compactInterval()).flatMap((Function1 & Serializable & scala.Serializable)id -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.super$get(BoxesRunTime.unboxToLong((Object)id)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new IllegalStateException(new StringBuilder(46).append($this.batchIdToPath(id)).append(" doesn't exist ").append("(latestId: ").append(latestId$1.elem).append(", compactInterval: ").append($this.compactInterval()).append(")").toString());
                }))), Seq$.MODULE$.canBuildFrom());
                return (Object[])this.compactLogs(logs).toArray(this.manifest());
            }
            catch (IOException e) {
                latestId.elem = CompactibleFileStreamLog$.MODULE$.nextCompactionBatchId(latestId.elem, this.compactInterval());
                super.get(latestId.elem).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw e;
                });
            }
        }
        return (Object[])Array$.MODULE$.empty(this.manifest());
    }

    private void deleteExpiredLog(long currentBatchId) {
        block0: {
            if ((long)this.compactInterval() > currentBatchId + 1L - (long)this.minBatchesToRetain()) break block0;
            long minBatchId = currentBatchId + 1L - (long)this.minBatchesToRetain();
            long minCompactionBatchId = minBatchId - minBatchId % (long)this.compactInterval() - 1L;
            Predef$.MODULE$.assert(CompactibleFileStreamLog$.MODULE$.isCompactionBatch(minCompactionBatchId, this.compactInterval()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append(minCompactionBatchId).append(" is not a compaction batch").toString());
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Current compact batch id = ").append(currentBatchId).append(" ").append("min compaction batch id to delete = ").append(minCompactionBatchId).toString());
            long expiredTime = System.currentTimeMillis() - this.fileCleanupDelayMs();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), path -> {
                boolean bl;
                block3: {
                    try {
                        long batchId = CompactibleFileStreamLog$.MODULE$.getBatchIdFromFileName(path.getName());
                        if (batchId < minCompactionBatchId) {
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                    }
                }
                return bl;
            }))).foreach((Function1 & Serializable & scala.Serializable)f -> {
                CompactibleFileStreamLog.$anonfun$deleteExpiredLog$4(this, expiredTime, f);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ boolean $anonfun$compactInterval$1(FileStatus f) {
        return f.getPath().toString().endsWith(CompactibleFileStreamLog$.MODULE$.COMPACT_FILE_SUFFIX());
    }

    public static final /* synthetic */ void $anonfun$serialize$1(CompactibleFileStreamLog $this, OutputStream out$1, Object data) {
        out$1.write(10);
        out$1.write(Serialization$.MODULE$.write(data, $this.formats()).getBytes(StandardCharsets.UTF_8));
    }

    public static final /* synthetic */ void $anonfun$deleteExpiredLog$4(CompactibleFileStreamLog $this, long expiredTime$1, FileStatus f) {
        block0: {
            if (f.getModificationTime() > expiredTime$1) break block0;
            $this.fileManager().delete(f.getPath());
        }
    }

    public CompactibleFileStreamLog(int metadataLogVersion, SparkSession sparkSession, String path, ClassTag<T> evidence$1) {
        this.metadataLogVersion = metadataLogVersion;
        super(sparkSession, path, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(evidence$1.runtimeClass())));
        this.formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
        this.manifest = Predef$.MODULE$.Manifest().classType(((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass());
        this.minBatchesToRetain = sparkSession.sessionState().conf().minBatchesToRetain();
    }
}

