/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.UnsupportedOperationChecker$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.execution.streaming.ContinuousTrigger;
import org.apache.spark.sql.execution.streaming.MicroBatchExecution;
import org.apache.spark.sql.execution.streaming.StreamExecution;
import org.apache.spark.sql.execution.streaming.StreamingQueryListenerBus;
import org.apache.spark.sql.execution.streaming.StreamingQueryWrapper;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousExecution;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.StreamingQueryException;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Evolving
@ScalaSignature(bytes="\u0006\u0001\teg\u0001\u0002\u0012$\u00019B\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\u0007\u0001\u0002!\t!J!\t\u0011\u0015\u0003!\u0019!C\u0001K\u0019Ca\u0001\u0015\u0001!\u0002\u00139\u0005bB)\u0001\u0005\u0004%IA\u0015\u0005\u0007/\u0002\u0001\u000b\u0011B*\t\u000fa\u0003!\u0019!C\u00053\"1Q\u000e\u0001Q\u0001\niCqa\u001f\u0001C\u0002\u0013%A\u0010C\u0004\u0002\b\u0001\u0001\u000b\u0011B?\t\u0011\u0005%\u0001A1A\u0005\nqDq!a\u0003\u0001A\u0003%Q\u0010C\u0005\u0002\u000e\u0001\u0001\r\u0011\"\u0003\u0002\u0010!I\u0011Q\u0004\u0001A\u0002\u0013%\u0011q\u0004\u0005\t\u0003W\u0001\u0001\u0015)\u0003\u0002\u0012!9\u0011\u0011\u0007\u0001\u0005\u0002\u0005M\u0002bBA\u001e\u0001\u0011\u0005\u0011Q\b\u0005\b\u0003w\u0001A\u0011AA\"\u0011\u001d\ti\u0006\u0001C\u0001\u0003?Bq!!\u0018\u0001\t\u0003\ty\nC\u0004\u0002>\u0002!\t!a\u0018\t\u000f\u0005}\u0006\u0001\"\u0001\u0002B\"9\u0011Q\u001a\u0001\u0005\u0002\u0005=\u0007bBAj\u0001\u0011\u0005\u0011Q\u001b\u0005\t\u00033\u0004A\u0011A\u0013\u0002\\\"9\u0011q\u001e\u0001\u0005\n\u0005E\b\u0002\u0003B6\u0001\u0011\u0005QE!\u001c\t\u0015\tm\u0005!%A\u0005\u0002\u0015\u0012i\n\u0003\u0006\u00032\u0002\t\n\u0011\"\u0001&\u0005;C!Ba-\u0001#\u0003%\t!\nB[\u0011)\u0011I\fAI\u0001\n\u0003)#1\u0018\u0005\t\u0005\u007f\u0003A\u0011A\u0013\u0003B\"9!q\u0019\u0001\u0005\n\t%'!F*ue\u0016\fW.\u001b8h#V,'/_'b]\u0006<WM\u001d\u0006\u0003I\u0015\n\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u0019:\u0013aA:rY*\u0011\u0001&K\u0001\u0006gB\f'o\u001b\u0006\u0003U-\na!\u00199bG\",'\"\u0001\u0017\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001yS\u0007\u0005\u00021g5\t\u0011GC\u00013\u0003\u0015\u00198-\u00197b\u0013\t!\u0014G\u0001\u0004B]f\u0014VM\u001a\t\u0003mej\u0011a\u000e\u0006\u0003q\u001d\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003u]\u0012q\u0001T8hO&tw-\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002>}5\tQ%\u0003\u0002@K\ta1\u000b]1sWN+7o]5p]\u00061A(\u001b8jiz\"\"A\u0011#\u0011\u0005\r\u0003Q\"A\u0012\t\u000bm\u0012\u0001\u0019\u0001\u001f\u0002+M$\u0018\r^3Ti>\u0014XmQ8pe\u0012Lg.\u0019;peV\tq\t\u0005\u0002I\u001d6\t\u0011J\u0003\u0002K\u0017\u0006)1\u000f^1uK*\u0011A\u0005\u0014\u0006\u0003\u001b\u0016\n\u0011\"\u001a=fGV$\u0018n\u001c8\n\u0005=K%\u0001G*uCR,7\u000b^8sK\u000e{wN\u001d3j]\u0006$xN\u001d*fM\u000612\u000f^1uKN#xN]3D_>\u0014H-\u001b8bi>\u0014\b%A\u0006mSN$XM\\3s\u0005V\u001cX#A*\u0011\u0005Q+V\"A&\n\u0005Y[%!G*ue\u0016\fW.\u001b8h#V,'/\u001f'jgR,g.\u001a:CkN\fA\u0002\\5ti\u0016tWM\u001d\"vg\u0002\nQ\"Y2uSZ,\u0017+^3sS\u0016\u001cX#\u0001.\u0011\tm\u0003'M[\u0007\u00029*\u0011QLX\u0001\b[V$\u0018M\u00197f\u0015\ty\u0016'\u0001\u0006d_2dWm\u0019;j_:L!!\u0019/\u0003\u000f!\u000b7\u000f['baB\u00111\r[\u0007\u0002I*\u0011QMZ\u0001\u0005kRLGNC\u0001h\u0003\u0011Q\u0017M^1\n\u0005%$'\u0001B+V\u0013\u0012\u0003\"aQ6\n\u00051\u001c#AD*ue\u0016\fW.\u001b8h#V,'/_\u0001\u000fC\u000e$\u0018N^3Rk\u0016\u0014\u0018.Z:!Q\u0011Aq.\u001f>\u0011\u0005A<X\"A9\u000b\u0005I\u001c\u0018AC2p]\u000e,(O]3oi*\u0011A/^\u0001\u000bC:tw\u000e^1uS>t'\"\u0001<\u0002\u000b)\fg/\u0019=\n\u0005a\f(!C$vCJ$W\r\u001a\"z\u0003\u00151\u0018\r\\;fC\u0005Y\u0018aF1di&4X-U;fe&,7o\u00155be\u0016$Gj\\2l+\u0005i\bc\u0001@\u0002\u00045\tqPC\u0002\u0002\u0002\u0019\fA\u0001\\1oO&\u0019\u0011QA@\u0003\r=\u0013'.Z2u\u0003a\t7\r^5wKF+XM]5fgNC\u0017M]3e\u0019>\u001c7\u000eI\u0001\u0015C^\f\u0017\u000e\u001e+fe6Lg.\u0019;j_:dunY6\u0002+\u0005<\u0018-\u001b;UKJl\u0017N\\1uS>tGj\\2lA\u0005aB.Y:u)\u0016\u0014X.\u001b8bi\u0016$\u0017+^3ss\u0016C8-\u001a9uS>tWCAA\t!\u0015\u0001\u00141CA\f\u0013\r\t)\"\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007\r\u000bI\"C\u0002\u0002\u001c\r\u0012qc\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u00180\u0012=dKB$\u0018n\u001c8\u0002A1\f7\u000f\u001e+fe6Lg.\u0019;fIF+XM]=Fq\u000e,\u0007\u000f^5p]~#S-\u001d\u000b\u0005\u0003C\t9\u0003E\u00021\u0003GI1!!\n2\u0005\u0011)f.\u001b;\t\u0013\u0005%b\"!AA\u0002\u0005E\u0011a\u0001=%c\u0005iB.Y:u)\u0016\u0014X.\u001b8bi\u0016$\u0017+^3ss\u0016C8-\u001a9uS>t\u0007\u0005K\u0003\u0010_f\fy#\t\u0002\u0002\n\u00051\u0011m\u0019;jm\u0016,\"!!\u000e\u0011\tA\n9D[\u0005\u0004\u0003s\t$!B!se\u0006L\u0018aA4fiR\u0019!.a\u0010\t\r\u0005\u0005\u0013\u00031\u0001c\u0003\tIG\rF\u0002k\u0003\u000bBq!!\u0011\u0013\u0001\u0004\t9\u0005\u0005\u0003\u0002J\u0005]c\u0002BA&\u0003'\u00022!!\u00142\u001b\t\tyEC\u0002\u0002R5\na\u0001\u0010:p_Rt\u0014bAA+c\u00051\u0001K]3eK\u001aLA!!\u0017\u0002\\\t11\u000b\u001e:j]\u001eT1!!\u00162\u0003M\tw/Y5u\u0003:LH+\u001a:nS:\fG/[8o)\t\t\t\u0003K\u0003\u0014\u0003G\nI\u0007E\u00031\u0003K\n9\"C\u0002\u0002hE\u0012a\u0001\u001e5s_^\u001c\u0018g\u0002\u0010\u0002H\u0005-\u0014QT\u0019\nG\u00055\u0014QOAJ\u0003o*B!a\u001c\u0002rU\u0011\u0011q\t\u0003\b\u0003gj#\u0019AA?\u0005\u0005!\u0016\u0002BA<\u0003s\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n$bAA>c\u00051A\u000f\u001b:poN\fB!a \u0002\u0006B\u0019\u0001'!!\n\u0007\u0005\r\u0015GA\u0004O_RD\u0017N\\4\u0011\t\u0005\u001d\u0015Q\u0012\b\u0004a\u0005%\u0015bAAFc\u00059\u0001/Y2lC\u001e,\u0017\u0002BAH\u0003#\u0013\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005-\u0015'M\u0005$\u0003+\u000b9*!'\u0002|9\u0019\u0001'a&\n\u0007\u0005m\u0014'M\u0003#aE\nYJA\u0003tG\u0006d\u0017-M\u0002'\u0003/!B!!)\u0002(B\u0019\u0001'a)\n\u0007\u0005\u0015\u0016GA\u0004C_>dW-\u00198\t\u000f\u0005%F\u00031\u0001\u0002,\u0006IA/[7f_V$Xj\u001d\t\u0004a\u00055\u0016bAAXc\t!Aj\u001c8hQ\u0015!\u00121MAZc\u001dq\u0012qIA[\u0003w\u000b\u0014bIA7\u0003k\n9,a\u001e2\u0013\r\n)*a&\u0002:\u0006m\u0014'\u0002\u00121c\u0005m\u0015g\u0001\u0014\u0002\u0018\u0005y!/Z:fiR+'/\\5oCR,G-A\u0006bI\u0012d\u0015n\u001d;f]\u0016\u0014H\u0003BA\u0011\u0003\u0007Dq!!2\u0017\u0001\u0004\t9-\u0001\u0005mSN$XM\\3s!\r\u0019\u0015\u0011Z\u0005\u0004\u0003\u0017\u001c#AF*ue\u0016\fW.\u001b8h#V,'/\u001f'jgR,g.\u001a:\u0002\u001dI,Wn\u001c<f\u0019&\u001cH/\u001a8feR!\u0011\u0011EAi\u0011\u001d\t)m\u0006a\u0001\u0003\u000f\fQ\u0002\\5ti2K7\u000f^3oKJ\u001cHCAAl!\u0015\u0001\u0014qGAd\u0003E\u0001xn\u001d;MSN$XM\\3s\u000bZ,g\u000e\u001e\u000b\u0005\u0003C\ti\u000eC\u0004\u0002`f\u0001\r!!9\u0002\u000b\u00154XM\u001c;\u0011\t\u0005\r\u0018\u0011\u001e\b\u0004\u0007\u0006\u0015\u0018bAAtG\u000512\u000b\u001e:fC6LgnZ)vKJLH*[:uK:,'/\u0003\u0003\u0002l\u00065(!B#wK:$(bAAtG\u0005Y1M]3bi\u0016\fV/\u001a:z)Y\t\u00190!?\u0002\u0000\n\r!1\u0005B\u0017\u0005\u0003\u0012YEa\u0014\u0003T\tu\u0003c\u0001+\u0002v&\u0019\u0011q_&\u0003+M#(/Z1nS:<\u0017+^3ss^\u0013\u0018\r\u001d9fe\"9\u00111 \u000eA\u0002\u0005u\u0018!E;tKJ\u001c\u0006/Z2jM&,GMT1nKB)\u0001'a\u0005\u0002H!9!\u0011\u0001\u000eA\u0002\u0005u\u0018aH;tKJ\u001c\u0006/Z2jM&,Gm\u00115fG.\u0004x.\u001b8u\u0019>\u001c\u0017\r^5p]\"9!Q\u0001\u000eA\u0002\t\u001d\u0011A\u00013g!\u0011\u0011IA!\b\u000f\t\t-!1\u0004\b\u0005\u0005\u001b\u0011IB\u0004\u0003\u0003\u0010\t]a\u0002\u0002B\t\u0005+qA!!\u0014\u0003\u0014%\tA&\u0003\u0002+W%\u0011\u0001&K\u0005\u0003M\u001dJ1!a#&\u0013\u0011\u0011yB!\t\u0003\u0013\u0011\u000bG/\u0019$sC6,'bAAFK!9!Q\u0005\u000eA\u0002\t\u001d\u0012\u0001D3yiJ\fw\n\u001d;j_:\u001c\b\u0003CA%\u0005S\t9%a\u0012\n\t\t-\u00121\f\u0002\u0004\u001b\u0006\u0004\bb\u0002B\u00185\u0001\u0007!\u0011G\u0001\u0005g&t7\u000e\u0005\u0003\u00034\tuRB\u0001B\u001b\u0015\u0011\u00119D!\u000f\u0002\u000f\r\fG/\u00197pO*\u0019!1H\u0013\u0002\u0013\r|gN\\3di>\u0014\u0018\u0002\u0002B \u0005k\u0011Q\u0001V1cY\u0016DqAa\u0011\u001b\u0001\u0004\u0011)%\u0001\u0006pkR\u0004X\u000f^'pI\u0016\u00042a\u0011B$\u0013\r\u0011Ie\t\u0002\u000b\u001fV$\b/\u001e;N_\u0012,\u0007b\u0002B'5\u0001\u0007\u0011\u0011U\u0001\u001akN,G+Z7q\u0007\",7m\u001b9pS:$Hj\\2bi&|g\u000eC\u0004\u0003Ri\u0001\r!!)\u0002;I,7m\u001c<fe\u001a\u0013x.\\\"iK\u000e\\\u0007o\\5oi2{7-\u0019;j_:DqA!\u0016\u001b\u0001\u0004\u00119&A\u0004ue&<w-\u001a:\u0011\u0007\r\u0013I&C\u0002\u0003\\\r\u0012q\u0001\u0016:jO\u001e,'\u000fC\u0004\u0003`i\u0001\rA!\u0019\u0002\u0019Q\u0014\u0018nZ4fe\u000ecwnY6\u0011\t\t\r$qM\u0007\u0003\u0005KR!!Z\u0014\n\t\t%$Q\r\u0002\u0006\u00072|7m[\u0001\u000bgR\f'\u000f^)vKJLH#\u00066\u0003p\tE$1\u000fB;\u0005o\u0012IHa\u001f\u0003~\t}$\u0011\u0011\u0005\b\u0003w\\\u0002\u0019AA\u007f\u0011\u001d\u0011\ta\u0007a\u0001\u0003{DqA!\u0002\u001c\u0001\u0004\u00119\u0001C\u0004\u0003&m\u0001\rAa\n\t\u000f\t=2\u00041\u0001\u00032!9!1I\u000eA\u0002\t\u0015\u0003\"\u0003B'7A\u0005\t\u0019AAQ\u0011%\u0011\tf\u0007I\u0001\u0002\u0004\t\t\u000bC\u0005\u0003Vm\u0001\n\u00111\u0001\u0003X!I!qL\u000e\u0011\u0002\u0003\u0007!\u0011\r\u0015\u00067\t\u0015%\u0011\u0013\t\u0006a\u0005\u0015$q\u0011\t\u0005\u0005\u0013\u0013i)\u0004\u0002\u0003\f*\u0011!\u000fZ\u0005\u0005\u0005\u001f\u0013YI\u0001\tUS6,w.\u001e;Fq\u000e,\u0007\u000f^5p]F:a$a\u0012\u0003\u0014\ne\u0015'C\u0012\u0002n\u0005U$QSA<c%\u0019\u0013QSAL\u0005/\u000bY(M\u0003#aE\nY*M\u0002'\u0005\u000f\u000bAc\u001d;beR\fV/\u001a:zI\u0011,g-Y;mi\u0012:TC\u0001BPU\u0011\t\tK!),\u0005\t\r\u0006\u0003\u0002BS\u0005[k!Aa*\u000b\t\t%&1V\u0001\nk:\u001c\u0007.Z2lK\u0012T!\u0001^\u0019\n\t\t=&q\u0015\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001F:uCJ$\u0018+^3ss\u0012\"WMZ1vYR$\u0003(\u0001\u000bti\u0006\u0014H/U;fef$C-\u001a4bk2$H%O\u000b\u0003\u0005oSCAa\u0016\u0003\"\u0006)2\u000f^1siF+XM]=%I\u00164\u0017-\u001e7uIE\u0002TC\u0001B_U\u0011\u0011\tG!)\u0002-9|G/\u001b4z#V,'/\u001f+fe6Lg.\u0019;j_:$B!!\t\u0003D\"1!Q\u0019\u0011A\u0002)\fq\u0002^3s[&t\u0017\r^3e#V,'/_\u0001\u001bk:\u0014XmZ5ti\u0016\u0014H+\u001a:nS:\fG/\u001a3TiJ,\u0017-\u001c\u000b\u0005\u0003C\u0011Y\r\u0003\u0004\u0003F\u0006\u0002\rA\u001b\u0015\u0004\u0001\t=\u0007\u0003\u0002Bi\u0005+l!Aa5\u000b\u0005Q<\u0013\u0002\u0002Bl\u0005'\u0014\u0001\"\u0012<pYZLgn\u001a")
public class StreamingQueryManager
implements Logging {
    private final SparkSession sparkSession;
    private final StateStoreCoordinatorRef stateStoreCoordinator;
    private final StreamingQueryListenerBus listenerBus;
    @GuardedBy(value="activeQueriesSharedLock")
    private final HashMap<UUID, StreamingQuery> activeQueries;
    private final Object activeQueriesSharedLock;
    private final Object awaitTerminationLock;
    @GuardedBy(value="awaitTerminationLock")
    private Option<StreamingQueryException> lastTerminatedQueryException;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public StateStoreCoordinatorRef stateStoreCoordinator() {
        return this.stateStoreCoordinator;
    }

    private StreamingQueryListenerBus listenerBus() {
        return this.listenerBus;
    }

    private HashMap<UUID, StreamingQuery> activeQueries() {
        return this.activeQueries;
    }

    private Object activeQueriesSharedLock() {
        return this.activeQueriesSharedLock;
    }

    private Object awaitTerminationLock() {
        return this.awaitTerminationLock;
    }

    private Option<StreamingQueryException> lastTerminatedQueryException() {
        return this.lastTerminatedQueryException;
    }

    private void lastTerminatedQueryException_$eq(Option<StreamingQueryException> x$1) {
        this.lastTerminatedQueryException = x$1;
    }

    public StreamingQuery[] active() {
        StreamingQuery[] streamingQueryArray;
        Object object = this.activeQueriesSharedLock();
        synchronized (object) {
            streamingQueryArray = (StreamingQuery[])this.activeQueries().values().toArray(ClassTag$.MODULE$.apply(StreamingQuery.class));
        }
        return streamingQueryArray;
    }

    public StreamingQuery get(UUID id) {
        StreamingQuery streamingQuery;
        Object object = this.activeQueriesSharedLock();
        synchronized (object) {
            streamingQuery = (StreamingQuery)this.activeQueries().get((Object)id).orNull(Predef$.MODULE$.$conforms());
        }
        return streamingQuery;
    }

    public StreamingQuery get(String id) {
        return this.get(UUID.fromString(id));
    }

    public void awaitAnyTermination() throws StreamingQueryException {
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            while (this.lastTerminatedQueryException() == null) {
                this.awaitTerminationLock().wait(10L);
            }
            if (this.lastTerminatedQueryException() != null && this.lastTerminatedQueryException().nonEmpty()) {
                throw (Throwable)this.lastTerminatedQueryException().get();
            }
        }
    }

    public boolean awaitAnyTermination(long timeoutMs) throws StreamingQueryException {
        boolean bl;
        long startTime = System.nanoTime();
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            while (!StreamingQueryManager.isTimedout$1(startTime, timeoutMs) && this.lastTerminatedQueryException() == null) {
                this.awaitTerminationLock().wait(10L);
            }
            if (this.lastTerminatedQueryException() != null && this.lastTerminatedQueryException().nonEmpty()) {
                throw (Throwable)this.lastTerminatedQueryException().get();
            }
            bl = this.lastTerminatedQueryException() != null;
        }
        return bl;
    }

    public void resetTerminated() {
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            this.lastTerminatedQueryException_$eq(null);
        }
    }

    public void addListener(StreamingQueryListener listener) {
        this.listenerBus().addListener(listener);
    }

    public void removeListener(StreamingQueryListener listener) {
        this.listenerBus().removeListener(listener);
    }

    public StreamingQueryListener[] listListeners() {
        return (StreamingQueryListener[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.listenerBus().listeners()).asScala()).toArray(ClassTag$.MODULE$.apply(StreamingQueryListener.class));
    }

    public void postListenerEvent(StreamingQueryListener.Event event) {
        this.listenerBus().post(event);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StreamingQueryWrapper createQuery(Option<String> userSpecifiedName, Option<String> userSpecifiedCheckpointLocation, Dataset<Row> df, Map<String, String> extraOptions, Table sink, OutputMode outputMode, boolean useTempCheckpointLocation, boolean recoverFromCheckpointLocation, Trigger trigger, Clock triggerClock) {
        Tuple2 tuple2;
        Path checkpointPath;
        FileSystem fs;
        BooleanRef deleteCheckpointOnStop = BooleanRef.create((boolean)false);
        String checkpointLocation = (String)userSpecifiedCheckpointLocation.map((Function1 & Serializable & scala.Serializable)userSpecified -> new Path(userSpecified).toString()).orElse((Function0 & Serializable & scala.Serializable)() -> df.sparkSession().sessionState().conf().checkpointLocation().map((Function1 & Serializable & scala.Serializable)location -> new Path(location, (String)userSpecifiedName.getOrElse((Function0 & Serializable & scala.Serializable)() -> UUID.randomUUID().toString())).toString())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            void var3_5;
            if (!useTempCheckpointLocation) {
                throw new AnalysisException(new StringBuilder(119).append("checkpointLocation must be specified either through option(\"checkpointLocation\", ...) or ").append("SparkSession.conf.set(\"").append(SQLConf$.MODULE$.CHECKPOINT_LOCATION().key()).append("\", ...)").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            deleteCheckpointOnStop$1.elem = true;
            String x$1 = "temporary";
            String x$2 = Utils$.MODULE$.createTempDir$default$1();
            String tempDir = Utils$.MODULE$.createTempDir(x$2, x$1).getCanonicalPath();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(235).append("Temporary checkpoint location created which is deleted normally when").append(" the query didn't fail: ").append(tempDir).append(". If it's required to delete it under any").append(" circumstances, please set ").append(SQLConf$.MODULE$.FORCE_DELETE_TEMP_CHECKPOINT_LOCATION().key()).append(" to").append(" true. Important to know deleting temp checkpoint folder is best effort.").toString());
            return var3_5;
        });
        if (!recoverFromCheckpointLocation && (fs = (checkpointPath = new Path(checkpointLocation, "offsets")).getFileSystem(df.sparkSession().sessionState().newHadoopConf())).exists(checkpointPath)) {
            throw new AnalysisException(new StringBuilder(87).append("This query does not support recovering from checkpoint location. ").append("Delete ").append(checkpointPath).append(" to start over.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        LogicalPlan analyzedPlan = df.queryExecution().analyzed();
        df.queryExecution().assertAnalyzed();
        boolean operationCheckEnabled = this.sparkSession.sessionState().conf().isUnsupportedOperationCheckEnabled();
        if (this.sparkSession.sessionState().conf().adaptiveExecutionEnabled()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append(SQLConf$.MODULE$.ADAPTIVE_EXECUTION_ENABLED().key()).append(" ").append("is not supported in streaming DataFrames/Datasets and will be disabled.").toString());
        }
        if ((tuple2 = new Tuple2((Object)sink, (Object)trigger)) != null) {
            Table table = (Table)tuple2._1();
            Trigger trigger2 = (Trigger)tuple2._2();
            if (table instanceof SupportsWrite) {
                SupportsWrite supportsWrite = (SupportsWrite)table;
                if (trigger2 instanceof ContinuousTrigger) {
                    ContinuousTrigger continuousTrigger = (ContinuousTrigger)trigger2;
                    if (!operationCheckEnabled) return new StreamingQueryWrapper(new ContinuousExecution(this.sparkSession, (String)userSpecifiedName.orNull(Predef$.MODULE$.$conforms()), checkpointLocation, analyzedPlan, supportsWrite, continuousTrigger, triggerClock, outputMode, extraOptions, deleteCheckpointOnStop.elem));
                    UnsupportedOperationChecker$.MODULE$.checkForContinuous(analyzedPlan, outputMode);
                    return new StreamingQueryWrapper(new ContinuousExecution(this.sparkSession, (String)userSpecifiedName.orNull(Predef$.MODULE$.$conforms()), checkpointLocation, analyzedPlan, supportsWrite, continuousTrigger, triggerClock, outputMode, extraOptions, deleteCheckpointOnStop.elem));
                }
            }
        }
        if (!operationCheckEnabled) return new StreamingQueryWrapper(new MicroBatchExecution(this.sparkSession, (String)userSpecifiedName.orNull(Predef$.MODULE$.$conforms()), checkpointLocation, analyzedPlan, sink, trigger, triggerClock, outputMode, extraOptions, deleteCheckpointOnStop.elem));
        UnsupportedOperationChecker$.MODULE$.checkForStreaming(analyzedPlan, outputMode);
        return new StreamingQueryWrapper(new MicroBatchExecution(this.sparkSession, (String)userSpecifiedName.orNull(Predef$.MODULE$.$conforms()), checkpointLocation, analyzedPlan, sink, trigger, triggerClock, outputMode, extraOptions, deleteCheckpointOnStop.elem));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StreamingQuery startQuery(Option<String> userSpecifiedName, Option<String> userSpecifiedCheckpointLocation, Dataset<Row> df, Map<String, String> extraOptions, Table sink, OutputMode outputMode, boolean useTempCheckpointLocation, boolean recoverFromCheckpointLocation, Trigger trigger, Clock triggerClock) throws TimeoutException {
        None$ none$;
        StreamingQueryWrapper query = this.createQuery(userSpecifiedName, userSpecifiedCheckpointLocation, df, extraOptions, sink, outputMode, useTempCheckpointLocation, recoverFromCheckpointLocation, trigger, triggerClock);
        Object object = this.activeQueriesSharedLock();
        synchronized (object) {
            None$ none$2;
            userSpecifiedName.foreach((Function1 & Serializable & scala.Serializable)name -> {
                StreamingQueryManager.$anonfun$startQuery$1(this, name);
                return BoxedUnit.UNIT;
            });
            Option activeOption = Option$.MODULE$.apply((Object)this.sparkSession.sharedState().activeStreamingQueries().get(query.id())).orElse((Function0 & Serializable & scala.Serializable)() -> this.activeQueries().get((Object)query.id()));
            boolean shouldStopActiveRun = BoxesRunTime.unboxToBoolean((Object)this.sparkSession.sessionState().conf().getConf(SQLConf$.MODULE$.STREAMING_STOP_ACTIVE_RUN_ON_RESTART()));
            if (activeOption.isDefined()) {
                if (!shouldStopActiveRun) throw new IllegalStateException(new StringBuilder(259).append("Cannot start query with id ").append(query.id()).append(" as another query with same id is ").append("already active. Perhaps you are attempting to restart a query from checkpoint ").append("that is already active. You may stop the old query by setting the SQL ").append("configuration: ").append("spark.conf.set(\"").append(SQLConf$.MODULE$.STREAMING_STOP_ACTIVE_RUN_ON_RESTART().key()).append("\", true) ").append("and retry.").toString());
                StreamingQuery oldQuery = (StreamingQuery)activeOption.get();
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("Stopping existing streaming query [id=").append(query.id()).append(", ").append("runId=").append(oldQuery.runId()).append("], as a new run is being started.").toString());
                none$2 = new Some((Object)oldQuery);
            } else {
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        }
        None$ activeRunOpt = none$;
        activeRunOpt.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.stop();
            return BoxedUnit.UNIT;
        });
        Object object2 = this.activeQueriesSharedLock();
        synchronized (object2) {
            StreamExecution oldActiveQuery = this.sparkSession.sharedState().activeStreamingQueries().put(query.id(), query.streamingQuery());
            if (oldActiveQuery != null) {
                throw new ConcurrentModificationException("Another instance of this query was just started by a concurrent session.");
            }
            this.activeQueries().put((Object)query.id(), (Object)query);
        }
        try {
            query.streamingQuery().start();
            return query;
        }
        catch (Throwable e) {
            this.unregisterTerminatedStream(query);
            throw e;
        }
    }

    public boolean startQuery$default$7() {
        return false;
    }

    public boolean startQuery$default$8() {
        return true;
    }

    public Trigger startQuery$default$9() {
        return Trigger.ProcessingTime(0L);
    }

    public Clock startQuery$default$10() {
        return new SystemClock();
    }

    public void notifyQueryTermination(StreamingQuery terminatedQuery) {
        this.unregisterTerminatedStream(terminatedQuery);
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            if (this.lastTerminatedQueryException() == null || terminatedQuery.exception().nonEmpty()) {
                this.lastTerminatedQueryException_$eq(terminatedQuery.exception());
            }
            this.awaitTerminationLock().notifyAll();
        }
        this.stateStoreCoordinator().deactivateInstances(terminatedQuery.runId());
    }

    private void unregisterTerminatedStream(StreamingQuery terminatedQuery) {
        Object object = this.activeQueriesSharedLock();
        synchronized (object) {
            this.sparkSession.sharedState().activeStreamingQueries().remove(terminatedQuery.id(), terminatedQuery);
            this.activeQueries().$minus$eq((Object)terminatedQuery.id());
        }
    }

    public static final /* synthetic */ void $anonfun$new$2(StreamingQueryManager $this, StreamingQueryListener listener) {
        $this.addListener(listener);
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Registered listener ").append(listener.getClass().getName()).toString());
    }

    public static final /* synthetic */ void $anonfun$new$1(StreamingQueryManager $this, Seq classNames) {
        Utils$.MODULE$.loadExtensions(StreamingQueryListener.class, classNames, $this.sparkSession.sparkContext().conf()).foreach((Function1 & Serializable & scala.Serializable)listener -> {
            StreamingQueryManager.$anonfun$new$2($this, listener);
            return BoxedUnit.UNIT;
        });
    }

    private static final boolean isTimedout$1(long startTime$1, long timeoutMs$1) {
        return System.nanoTime() - startTime$1 >= TimeUnit.MILLISECONDS.toNanos(timeoutMs$1);
    }

    public static final /* synthetic */ boolean $anonfun$startQuery$2(String name$1, StreamingQuery x$1) {
        String string = x$1.name();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$startQuery$1(StreamingQueryManager $this, String name) {
        if ($this.activeQueries().values().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StreamingQueryManager.$anonfun$startQuery$2(name, x$1)))) {
            throw new IllegalArgumentException(new StringBuilder(94).append("Cannot start query with name ").append(name).append(" as a query ").append("with that name is already active in this SparkSession").toString());
        }
    }

    public StreamingQueryManager(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        Logging.$init$((Logging)this);
        this.stateStoreCoordinator = StateStoreCoordinatorRef$.MODULE$.forDriver(sparkSession.sparkContext().env());
        this.listenerBus = new StreamingQueryListenerBus(sparkSession.sparkContext().listenerBus());
        this.activeQueries = new HashMap();
        this.activeQueriesSharedLock = sparkSession.sharedState().activeQueriesLock();
        this.awaitTerminationLock = new Object();
        this.lastTerminatedQueryException = null;
        try {
            ((Option)sparkSession.sparkContext().conf().get((ConfigEntry)StaticSQLConf$.MODULE$.STREAMING_QUERY_LISTENERS())).foreach((Function1 & Serializable & scala.Serializable)classNames -> {
                StreamingQueryManager.$anonfun$new$1(this, classNames);
                return BoxedUnit.UNIT;
            });
            sparkSession.sharedState().streamingQueryStatusListener().foreach((Function1 & Serializable & scala.Serializable)listener -> {
                this.addListener(listener);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception e) {
            throw new SparkException("Exception when registering StreamingQueryListener", (Throwable)e);
        }
    }
}

