/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import java.io.Serializable;
import org.apache.spark.ExecutorAllocationClient;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.internal.config.Streaming$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.DummyInputDStream;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.TestServer;
import org.apache.spark.streaming.TestSuiteBase;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.scheduler.ExecutorAllocationManager;
import org.apache.spark.streaming.scheduler.ReceiverTracker;
import org.apache.spark.streaming.scheduler.StreamManualClock;
import org.apache.spark.streaming.scheduler.StreamManualClock$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.PrivateMethodTester;
import org.scalatest.PrivateMethodTester$PrivateMethod$;
import org.scalatest.Tag;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.time.SpanSugar$;
import org.scalatestplus.mockito.MockitoSugar;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001B\u000e\u001d\u0001\u001dBQA\u0010\u0001\u0005\u0002}BqA\u0011\u0001C\u0002\u0013%1\t\u0003\u0004K\u0001\u0001\u0006I\u0001\u0012\u0005\b\u0017\u0002\u0001\r\u0011\"\u0003M\u0011\u001d\u0001\u0006\u00011A\u0005\nECaa\u0016\u0001!B\u0013i\u0005b\u0002-\u0001\u0001\u0004%I!\u0017\u0005\b;\u0002\u0001\r\u0011\"\u0003_\u0011\u0019\u0001\u0007\u0001)Q\u00055\")\u0011\r\u0001C!E\")1\r\u0001C\u0005I\"91\u0010AI\u0001\n\u0013a\b\"CA\b\u0001E\u0005I\u0011BA\t\u0011%\t)\u0002\u0001b\u0001\n\u0013\t9\u0002\u0003\u0005\u0002\"\u0001\u0001\u000b\u0011BA\r\u0011%\t\u0019\u0003\u0001b\u0001\n\u0013\t9\u0002\u0003\u0005\u0002&\u0001\u0001\u000b\u0011BA\r\u0011%\t9\u0003\u0001b\u0001\n\u0013\t9\u0002\u0003\u0005\u0002*\u0001\u0001\u000b\u0011BA\r\u0011%\tY\u0003\u0001b\u0001\n\u0013\ti\u0003\u0003\u0005\u00028\u0001\u0001\u000b\u0011BA\u0018\u0011\u001d\tI\u0004\u0001C\u0005\u0003wAq!!\u0012\u0001\t\u0013\t9\u0005C\u0004\u0002P\u0001!I!!\u0015\t\u000f\u0005U\u0003\u0001\"\u0003\u0002X!9\u00111\r\u0001\u0005\n\u0005\u0015$AH#yK\u000e,Ho\u001c:BY2|7-\u0019;j_:l\u0015M\\1hKJ\u001cV/\u001b;f\u0015\tib$A\u0005tG\",G-\u001e7fe*\u0011q\u0004I\u0001\ngR\u0014X-Y7j]\u001eT!!\t\u0012\u0002\u000bM\u0004\u0018M]6\u000b\u0005\r\"\u0013AB1qC\u000eDWMC\u0001&\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0001\u0006\f\u00199!\tI#&D\u0001!\u0013\tY\u0003EA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003[9j\u0011AH\u0005\u0003_y\u0011Q\u0002V3tiN+\u0018\u000e^3CCN,\u0007CA\u00197\u001b\u0005\u0011$BA\u001a5\u0003\u001diwnY6ji>T!!\u000e\u0013\u0002\u001bM\u001c\u0017\r\\1uKN$\b\u000f\\;t\u0013\t9$G\u0001\u0007N_\u000e\\\u0017\u000e^8Tk\u001e\f'\u000f\u0005\u0002:y5\t!H\u0003\u0002<I\u0005I1oY1mCR,7\u000f^\u0005\u0003{i\u00121\u0003\u0015:jm\u0006$X-T3uQ>$G+Z:uKJ\fa\u0001P5oSRtD#\u0001!\u0011\u0005\u0005\u0003Q\"\u0001\u000f\u0002'\t\fGo\u00195EkJ\fG/[8o\u001b&dG.[:\u0016\u0003\u0011\u0003\"!\u0012%\u000e\u0003\u0019S\u0011aR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0013\u001a\u0013A\u0001T8oO\u0006!\"-\u0019;dQ\u0012+(/\u0019;j_:l\u0015\u000e\u001c7jg\u0002\n\u0001#\u00197m_\u000e\fG/[8o\u00072LWM\u001c;\u0016\u00035\u0003\"!\u000b(\n\u0005=\u0003#\u0001G#yK\u000e,Ho\u001c:BY2|7-\u0019;j_:\u001cE.[3oi\u0006!\u0012\r\u001c7pG\u0006$\u0018n\u001c8DY&,g\u000e^0%KF$\"AU+\u0011\u0005\u0015\u001b\u0016B\u0001+G\u0005\u0011)f.\u001b;\t\u000fY+\u0011\u0011!a\u0001\u001b\u0006\u0019\u0001\u0010J\u0019\u0002#\u0005dGn\\2bi&|gn\u00117jK:$\b%A\u0003dY>\u001c7.F\u0001[!\t\t5,\u0003\u0002]9\t\t2\u000b\u001e:fC6l\u0015M\\;bY\u000ecwnY6\u0002\u0013\rdwnY6`I\u0015\fHC\u0001*`\u0011\u001d1\u0006\"!AA\u0002i\u000baa\u00197pG.\u0004\u0013A\u00032fM>\u0014X-R1dQR\t!+A\u000bxSRD\u0017\t\u001c7pG\u0006$\u0018n\u001c8NC:\fw-\u001a:\u0015\u0007\u0015\fh\u000f\u0006\u0002SM\")qm\u0003a\u0001Q\u0006!!m\u001c3z!\u0015)\u0015n\u001b8S\u0013\tQgIA\u0005Gk:\u001cG/[8oeA\u0011\u0011\t\\\u0005\u0003[r\u0011qBU3dK&4XM\u001d+sC\u000e\\WM\u001d\t\u0003\u0003>L!\u0001\u001d\u000f\u00033\u0015CXmY;u_J\fE\u000e\\8dCRLwN\\'b]\u0006<WM\u001d\u0005\be.\u0001\n\u00111\u0001t\u0003\u0011\u0019wN\u001c4\u0011\u0005%\"\u0018BA;!\u0005%\u0019\u0006/\u0019:l\u0007>tg\rC\u0004x\u0017A\u0005\t\u0019\u0001=\u0002\u00199,XNU3dK&4XM]:\u0011\u0005\u0015K\u0018B\u0001>G\u0005\rIe\u000e^\u0001 o&$\b.\u00117m_\u000e\fG/[8o\u001b\u0006t\u0017mZ3sI\u0011,g-Y;mi\u0012\nT#A?+\u0005Mt8&A@\u0011\t\u0005\u0005\u00111B\u0007\u0003\u0003\u0007QA!!\u0002\u0002\b\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u00131\u0015AC1o]>$\u0018\r^5p]&!\u0011QBA\u0002\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001 o&$\b.\u00117m_\u000e\fG/[8o\u001b\u0006t\u0017mZ3sI\u0011,g-Y;mi\u0012\u0012TCAA\nU\tAh0A\t`C\u0012$')\u0019;dQB\u0013xn\u0019+j[\u0016,\"!!\u0007\u0011\u000b\u0005m\u0011Q\u0004*\u000e\u0003\u0001I1!a\b=\u00055\u0001&/\u001b<bi\u0016lU\r\u001e5pI\u0006\u0011r,\u00193e\u0005\u0006$8\r\u001b)s_\u000e$\u0016.\\3!\u0003Ey&/Z9vKN$X\t_3dkR|'o]\u0001\u0013?J,\u0017/^3ti\u0016CXmY;u_J\u001c\b%A\u0007`W&dG.\u0012=fGV$xN]\u0001\u000f?.LG\u000e\\#yK\u000e,Ho\u001c:!\u0003iyV\r_3dkR|'/\u00117m_\u000e\fG/[8o\u001b\u0006t\u0017mZ3s+\t\ty\u0003\u0005\u0004\u0002\u001c\u0005u\u0011\u0011\u0007\t\u0005\u000b\u0006Mb.C\u0002\u00026\u0019\u0013aa\u00149uS>t\u0017aG0fq\u0016\u001cW\u000f^8s\u00032dwnY1uS>tW*\u00198bO\u0016\u0014\b%\u0001\tbI\u0012\u0014\u0015\r^2i!J|7\rV5nKR)!+!\u0010\u0002B!1\u0011q\b\fA\u00029\fq!\\1oC\u001e,'\u000f\u0003\u0004\u0002DY\u0001\r\u0001R\u0001\u0007i&lW-T:\u0002!I,\u0017/^3ti\u0016CXmY;u_J\u001cH#\u0002*\u0002J\u0005-\u0003BBA /\u0001\u0007a\u000e\u0003\u0004\u0002N]\u0001\r\u0001_\u0001\t]\u0016<X\t_3dg\u0006a1.\u001b7m\u000bb,7-\u001e;peR\u0019!+a\u0015\t\r\u0005}\u0002\u00041\u0001o\u0003q9W\r^#yK\u000e,Ho\u001c:BY2|7-\u0019;j_:l\u0015M\\1hKJ$B!!\r\u0002Z!9\u00111L\rA\u0002\u0005u\u0013aA:tGB\u0019Q&a\u0018\n\u0007\u0005\u0005dD\u0001\tTiJ,\u0017-\\5oO\u000e{g\u000e^3yi\u0006!r/\u001b;i'R\u0014X-Y7j]\u001e\u001cuN\u001c;fqR$B!a\u001a\u0002rQ\u0019!+!\u001b\t\r\u001dT\u0002\u0019AA6!\u0019)\u0015QNA/%&\u0019\u0011q\u000e$\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\"\u0002:\u001b\u0001\u0004\u0019\b")
public class ExecutorAllocationManagerSuite
extends SparkFunSuite
implements TestSuiteBase,
MockitoSugar,
PrivateMethodTester {
    private final long batchDurationMillis;
    private ExecutorAllocationClient allocationClient;
    private StreamManualClock clock;
    private final PrivateMethodTester.PrivateMethod<BoxedUnit> _addBatchProcTime;
    private final PrivateMethodTester.PrivateMethod<BoxedUnit> _requestExecutors;
    private final PrivateMethodTester.PrivateMethod<BoxedUnit> _killExecutor;
    private final PrivateMethodTester.PrivateMethod<Option<ExecutorAllocationManager>> _executorAllocationManager;
    private volatile PrivateMethodTester$PrivateMethod$ PrivateMethod$module;
    private String checkpointDir;
    private final SparkConf conf;
    private final PatienceConfiguration.Timeout eventuallyTimeout;
    private volatile boolean bitmap$0;

    public PrivateMethodTester.Invoker anyRefToInvoker(Object target) {
        return PrivateMethodTester.anyRefToInvoker$((PrivateMethodTester)this, (Object)target);
    }

    public <T> T mock(ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, classTag);
    }

    public <T> T mock(Answer<?> defaultAnswer, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, defaultAnswer, classTag);
    }

    public <T> T mock(MockSettings mockSettings, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, (MockSettings)mockSettings, classTag);
    }

    public <T> T mock(String name, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, (String)name, classTag);
    }

    @Override
    public /* synthetic */ void org$apache$spark$streaming$TestSuiteBase$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$streaming$TestSuiteBase$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public String framework() {
        return TestSuiteBase.framework$(this);
    }

    @Override
    public String master() {
        return TestSuiteBase.master$(this);
    }

    @Override
    public Duration batchDuration() {
        return TestSuiteBase.batchDuration$(this);
    }

    @Override
    public int numInputPartitions() {
        return TestSuiteBase.numInputPartitions$(this);
    }

    @Override
    public int maxWaitTimeMillis() {
        return TestSuiteBase.maxWaitTimeMillis$(this);
    }

    @Override
    public boolean useManualClock() {
        return TestSuiteBase.useManualClock$(this);
    }

    @Override
    public boolean actuallyWait() {
        return TestSuiteBase.actuallyWait$(this);
    }

    @Override
    public void beforeFunction() {
        TestSuiteBase.beforeFunction$(this);
    }

    @Override
    public void afterFunction() {
        TestSuiteBase.afterFunction$(this);
    }

    @Override
    public void afterEach() {
        TestSuiteBase.afterEach$(this);
    }

    @Override
    public <R> R withStreamingContext(StreamingContext ssc, Function1<StreamingContext, R> block) {
        return (R)TestSuiteBase.withStreamingContext$(this, ssc, block);
    }

    @Override
    public <R> R withTestServer(TestServer testServer, Function1<TestServer, R> block) {
        return (R)TestSuiteBase.withTestServer$(this, testServer, block);
    }

    @Override
    public <U, V> StreamingContext setupStreams(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, int numPartitions, ClassTag<U> evidence$4, ClassTag<V> evidence$5) {
        return TestSuiteBase.setupStreams$(this, input, operation, numPartitions, evidence$4, evidence$5);
    }

    @Override
    public <U, V> int setupStreams$default$3() {
        return TestSuiteBase.setupStreams$default$3$(this);
    }

    @Override
    public <U, V, W> StreamingContext setupStreams(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, ClassTag<U> evidence$6, ClassTag<V> evidence$7, ClassTag<W> evidence$8) {
        return TestSuiteBase.setupStreams$(this, input1, input2, operation, evidence$6, evidence$7, evidence$8);
    }

    @Override
    public <V> Seq<Seq<V>> runStreams(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$9) {
        return TestSuiteBase.runStreams$(this, ssc, numBatches, numExpectedOutput, preStop, evidence$9);
    }

    @Override
    public <V> Function0<BoxedUnit> runStreams$default$4() {
        return TestSuiteBase.runStreams$default$4$(this);
    }

    @Override
    public <V> Seq<Seq<Seq<V>>> runStreamsWithPartitions(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$10) {
        return TestSuiteBase.runStreamsWithPartitions$(this, ssc, numBatches, numExpectedOutput, preStop, evidence$10);
    }

    @Override
    public <V> Function0<BoxedUnit> runStreamsWithPartitions$default$4() {
        return TestSuiteBase.runStreamsWithPartitions$default$4$(this);
    }

    @Override
    public <V> void verifyOutput(Seq<Seq<V>> output, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<V> evidence$11) {
        TestSuiteBase.verifyOutput$(this, output, expectedOutput, useSet, evidence$11);
    }

    @Override
    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<U> evidence$12, ClassTag<V> evidence$13) {
        TestSuiteBase.testOperation$(this, input, operation, expectedOutput, useSet, evidence$12, evidence$13);
    }

    @Override
    public <U, V> boolean testOperation$default$4() {
        return TestSuiteBase.testOperation$default$4$(this);
    }

    @Override
    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$14, ClassTag<V> evidence$15) {
        TestSuiteBase.testOperation$(this, input, operation, expectedOutput, numBatches, useSet, evidence$14, evidence$15);
    }

    @Override
    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, boolean useSet, ClassTag<U> evidence$16, ClassTag<V> evidence$17, ClassTag<W> evidence$18) {
        TestSuiteBase.testOperation$(this, input1, input2, operation, expectedOutput, useSet, evidence$16, evidence$17, evidence$18);
    }

    @Override
    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$19, ClassTag<V> evidence$20, ClassTag<W> evidence$21) {
        TestSuiteBase.testOperation$(this, input1, input2, operation, expectedOutput, numBatches, useSet, evidence$19, evidence$20, evidence$21);
    }

    public PrivateMethodTester$PrivateMethod$ PrivateMethod() {
        if (this.PrivateMethod$module == null) {
            this.PrivateMethod$lzycompute$1();
        }
        return this.PrivateMethod$module;
    }

    private String checkpointDir$lzycompute() {
        ExecutorAllocationManagerSuite executorAllocationManagerSuite = this;
        synchronized (executorAllocationManagerSuite) {
            if (!this.bitmap$0) {
                this.checkpointDir = TestSuiteBase.checkpointDir$(this);
                this.bitmap$0 = true;
            }
        }
        return this.checkpointDir;
    }

    @Override
    public String checkpointDir() {
        return !this.bitmap$0 ? this.checkpointDir$lzycompute() : this.checkpointDir;
    }

    @Override
    public SparkConf conf() {
        return this.conf;
    }

    @Override
    public PatienceConfiguration.Timeout eventuallyTimeout() {
        return this.eventuallyTimeout;
    }

    @Override
    public void org$apache$spark$streaming$TestSuiteBase$_setter_$conf_$eq(SparkConf x$1) {
        this.conf = x$1;
    }

    @Override
    public void org$apache$spark$streaming$TestSuiteBase$_setter_$eventuallyTimeout_$eq(PatienceConfiguration.Timeout x$1) {
        this.eventuallyTimeout = x$1;
    }

    private long batchDurationMillis() {
        return this.batchDurationMillis;
    }

    private ExecutorAllocationClient allocationClient() {
        return this.allocationClient;
    }

    private void allocationClient_$eq(ExecutorAllocationClient x$1) {
        this.allocationClient = x$1;
    }

    private StreamManualClock clock() {
        return this.clock;
    }

    private void clock_$eq(StreamManualClock x$1) {
        this.clock = x$1;
    }

    @Override
    public void beforeEach() {
        this.allocationClient_$eq((ExecutorAllocationClient)this.mock(ClassTag$.MODULE$.apply(ExecutorAllocationClient.class)));
        this.clock_$eq(new StreamManualClock(StreamManualClock$.MODULE$.$lessinit$greater$default$1()));
    }

    private void withAllocationManager(SparkConf conf, int numReceivers, Function2<ReceiverTracker, ExecutorAllocationManager, BoxedUnit> body) {
        ReceiverTracker receiverTracker = (ReceiverTracker)this.mock(ClassTag$.MODULE$.apply(ReceiverTracker.class));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)receiverTracker.numReceivers())).thenReturn((Object)BoxesRunTime.boxToInteger((int)numReceivers));
        ExecutorAllocationManager manager = new ExecutorAllocationManager(this.allocationClient(), receiverTracker, conf, this.batchDurationMillis(), (Clock)this.clock());
        try {
            manager.start();
            body.apply((Object)receiverTracker, (Object)manager);
        }
        finally {
            manager.stop();
        }
    }

    private SparkConf withAllocationManager$default$1() {
        return new SparkConf();
    }

    private int withAllocationManager$default$2() {
        return 1;
    }

    private PrivateMethodTester.PrivateMethod<BoxedUnit> _addBatchProcTime() {
        return this._addBatchProcTime;
    }

    private PrivateMethodTester.PrivateMethod<BoxedUnit> _requestExecutors() {
        return this._requestExecutors;
    }

    private PrivateMethodTester.PrivateMethod<BoxedUnit> _killExecutor() {
        return this._killExecutor;
    }

    private PrivateMethodTester.PrivateMethod<Option<ExecutorAllocationManager>> _executorAllocationManager() {
        return this._executorAllocationManager;
    }

    private void addBatchProcTime(ExecutorAllocationManager manager, long timeMs) {
        this.anyRefToInvoker(manager).invokePrivate(this._addBatchProcTime().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)timeMs)})));
    }

    private void requestExecutors(ExecutorAllocationManager manager, int newExecs) {
        this.anyRefToInvoker(manager).invokePrivate(this._requestExecutors().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)newExecs)})));
    }

    private void killExecutor(ExecutorAllocationManager manager) {
        this.anyRefToInvoker(manager).invokePrivate(this._killExecutor().apply((Seq)Nil$.MODULE$));
    }

    private Option<ExecutorAllocationManager> getExecutorAllocationManager(StreamingContext ssc) {
        return (Option)this.anyRefToInvoker(ssc.scheduler()).invokePrivate(this._executorAllocationManager().apply((Seq)Nil$.MODULE$));
    }

    private void withStreamingContext(SparkConf conf, Function1<StreamingContext, BoxedUnit> body) {
        conf.setMaster("local-cluster[1,1,1024]").setAppName(this.getClass().getSimpleName()).set("spark.streaming.dynamicAllocation.testing", "true");
        this.withStreamingContext(new StreamingContext(conf, Seconds$.MODULE$.apply(1L)), (Function1 & Serializable & scala.Serializable)ssc -> {
            ExecutorAllocationManagerSuite.$anonfun$withStreamingContext$1(body, ssc);
            return BoxedUnit.UNIT;
        });
    }

    private final void PrivateMethod$lzycompute$1() {
        ExecutorAllocationManagerSuite executorAllocationManagerSuite = this;
        synchronized (executorAllocationManagerSuite) {
            if (this.PrivateMethod$module == null) {
                this.PrivateMethod$module = new PrivateMethodTester$PrivateMethod$((PrivateMethodTester)this);
            }
        }
    }

    private final void addBatchProcTimeAndVerifyAllocation$1(double batchProcTimeMs, Function0 body, ExecutorAllocationManager allocationManager$1) {
        Mockito.reset((Object[])new ExecutorAllocationClient[]{this.allocationClient()});
        Mockito.when((Object)this.allocationClient().getExecutorIds()).thenReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2"})));
        this.addBatchProcTime(allocationManager$1, (long)batchProcTimeMs);
        long advancedTime = BoxesRunTime.unboxToLong((Object)Streaming$.MODULE$.STREAMING_DYN_ALLOCATION_SCALING_INTERVAL().defaultValue().get()) * 1000L + 1L;
        long expectedWaitTime = this.clock().getTimeMillis() + advancedTime;
        this.clock().advance(advancedTime);
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(10).seconds()), (Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.clock().isStreamWaitingAt(expectedWaitTime), "ExecutorAllocationManagerSuite.this.clock.isStreamWaitingAt(expectedWaitTime)", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        }, Eventually$.MODULE$.patienceConfig(), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        body.apply$mcV$sp();
    }

    private final void verifyTotalRequestedExecs$1(Option expectedRequestedTotalExecs) {
        if (expectedRequestedTotalExecs.nonEmpty()) {
            Predef$.MODULE$.require(BoxesRunTime.unboxToInt((Object)expectedRequestedTotalExecs.get()) > 0);
            ((ExecutorAllocationClient)Mockito.verify((Object)this.allocationClient(), (VerificationMode)Mockito.times((int)1))).requestTotalExecutors(ArgumentMatchers.eq((int)BoxesRunTime.unboxToInt((Object)expectedRequestedTotalExecs.get())), ArgumentMatchers.eq((int)0), (Map)ArgumentMatchers.eq((Object)Predef$.MODULE$.Map().empty()));
        } else {
            ((ExecutorAllocationClient)Mockito.verify((Object)this.allocationClient(), (VerificationMode)Mockito.never())).requestTotalExecutors(0, 0, Predef$.MODULE$.Map().empty());
        }
    }

    private final void verifyKilledExec$1(Option expectedKilledExec) {
        if (expectedKilledExec.nonEmpty()) {
            ((ExecutorAllocationClient)Mockito.verify((Object)this.allocationClient(), (VerificationMode)Mockito.times((int)1))).killExecutor((String)ArgumentMatchers.eq((Object)expectedKilledExec.get()));
        } else {
            ((ExecutorAllocationClient)Mockito.verify((Object)this.allocationClient(), (VerificationMode)Mockito.never())).killExecutor(null);
        }
    }

    public static final /* synthetic */ void $anonfun$new$2(ExecutorAllocationManagerSuite $this, ReceiverTracker x0$1, ExecutorAllocationManager x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ReceiverTracker receiverTracker = (ReceiverTracker)tuple2._1();
        ExecutorAllocationManager allocationManager = (ExecutorAllocationManager)tuple2._2();
        Mockito.when((Object)receiverTracker.allocatedExecutors()).thenReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new Some((Object)"1"))})));
        $this.addBatchProcTimeAndVerifyAllocation$1($this.batchDurationMillis(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.verifyTotalRequestedExecs$1((Option)new Some((Object)BoxesRunTime.boxToInteger((int)3)));
            $this.verifyKilledExec$1((Option)None$.MODULE$);
        }, allocationManager);
        $this.addBatchProcTimeAndVerifyAllocation$1($this.batchDurationMillis() * 2L, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.verifyTotalRequestedExecs$1((Option)new Some((Object)BoxesRunTime.boxToInteger((int)4)));
            $this.verifyKilledExec$1((Option)None$.MODULE$);
        }, allocationManager);
        $this.addBatchProcTimeAndVerifyAllocation$1((double)$this.batchDurationMillis() * BoxesRunTime.unboxToDouble((Object)Streaming$.MODULE$.STREAMING_DYN_ALLOCATION_SCALING_UP_RATIO().defaultValue().get()) + 1.0, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.verifyTotalRequestedExecs$1((Option)new Some((Object)BoxesRunTime.boxToInteger((int)3)));
            $this.verifyKilledExec$1((Option)None$.MODULE$);
        }, allocationManager);
        $this.addBatchProcTimeAndVerifyAllocation$1((double)$this.batchDurationMillis() * BoxesRunTime.unboxToDouble((Object)Streaming$.MODULE$.STREAMING_DYN_ALLOCATION_SCALING_UP_RATIO().defaultValue().get()) - 1.0, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.verifyTotalRequestedExecs$1((Option)None$.MODULE$);
            $this.verifyKilledExec$1((Option)None$.MODULE$);
        }, allocationManager);
        $this.addBatchProcTimeAndVerifyAllocation$1((double)$this.batchDurationMillis() * BoxesRunTime.unboxToDouble((Object)Streaming$.MODULE$.STREAMING_DYN_ALLOCATION_SCALING_DOWN_RATIO().defaultValue().get()) + 1.0, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.verifyTotalRequestedExecs$1((Option)None$.MODULE$);
            $this.verifyKilledExec$1((Option)None$.MODULE$);
        }, allocationManager);
        $this.addBatchProcTimeAndVerifyAllocation$1((double)$this.batchDurationMillis() * BoxesRunTime.unboxToDouble((Object)Streaming$.MODULE$.STREAMING_DYN_ALLOCATION_SCALING_DOWN_RATIO().defaultValue().get()) - 1.0, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.verifyTotalRequestedExecs$1((Option)None$.MODULE$);
            $this.verifyKilledExec$1((Option)new Some((Object)"2"));
        }, allocationManager);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ String $anonfun$new$11(int x$1) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$1)).toString();
    }

    private final void verifyRequestedExecs$1(int numExecs, int numNewExecs, int expectedRequestedTotalExecs, ExecutorAllocationManager allocationManager) {
        Mockito.reset((Object[])new ExecutorAllocationClient[]{this.allocationClient()});
        Mockito.when((Object)this.allocationClient().getExecutorIds()).thenReturn(RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numExecs).map((Function1 & Serializable & scala.Serializable)x$1 -> ExecutorAllocationManagerSuite.$anonfun$new$11(BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom()));
        this.requestExecutors(allocationManager, numNewExecs);
        ((ExecutorAllocationClient)Mockito.verify((Object)this.allocationClient(), (VerificationMode)Mockito.times((int)1))).requestTotalExecutors(ArgumentMatchers.eq((int)expectedRequestedTotalExecs), ArgumentMatchers.eq((int)0), (Map)ArgumentMatchers.eq((Object)Predef$.MODULE$.Map().empty()));
    }

    public static final /* synthetic */ void $anonfun$new$12(ExecutorAllocationManagerSuite $this, ReceiverTracker x0$2, ExecutorAllocationManager x1$2) {
        ExecutorAllocationManager allocationManager;
        Tuple2 tuple2 = new Tuple2((Object)x0$2, (Object)x1$2);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ExecutorAllocationManager am = allocationManager = (ExecutorAllocationManager)tuple2._2();
        $this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.verifyRequestedExecs$1(0, 0, 0, am), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        $this.verifyRequestedExecs$1(0, 1, 1, am);
        $this.verifyRequestedExecs$1(1, 1, 2, am);
        $this.verifyRequestedExecs$1(2, 2, 4, am);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$14(ExecutorAllocationManagerSuite $this, ReceiverTracker x0$3, ExecutorAllocationManager x1$3) {
        ExecutorAllocationManager allocationManager;
        Tuple2 tuple2 = new Tuple2((Object)x0$3, (Object)x1$3);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ExecutorAllocationManager am = allocationManager = (ExecutorAllocationManager)tuple2._2();
        $this.verifyRequestedExecs$1(0, 1, 2, am);
        $this.verifyRequestedExecs$1(1, 1, 2, am);
        $this.verifyRequestedExecs$1(2, 2, 4, am);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$15(ExecutorAllocationManagerSuite $this, ReceiverTracker x0$4, ExecutorAllocationManager x1$4) {
        ExecutorAllocationManager allocationManager;
        Tuple2 tuple2 = new Tuple2((Object)x0$4, (Object)x1$4);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ExecutorAllocationManager am = allocationManager = (ExecutorAllocationManager)tuple2._2();
        $this.verifyRequestedExecs$1(0, 1, 2, am);
        $this.verifyRequestedExecs$1(0, 3, 3, am);
        $this.verifyRequestedExecs$1(1, 1, 2, am);
        $this.verifyRequestedExecs$1(1, 2, 3, am);
        $this.verifyRequestedExecs$1(2, 1, 3, am);
        $this.verifyRequestedExecs$1(2, 2, 4, am);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$16(ExecutorAllocationManagerSuite $this, ReceiverTracker x0$5, ExecutorAllocationManager x1$5) {
        ExecutorAllocationManager allocationManager;
        Tuple2 tuple2 = new Tuple2((Object)x0$5, (Object)x1$5);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ExecutorAllocationManager am = allocationManager = (ExecutorAllocationManager)tuple2._2();
        $this.verifyRequestedExecs$1(0, 1, 1, am);
        $this.verifyRequestedExecs$1(0, 3, 2, am);
        $this.verifyRequestedExecs$1(1, 2, 2, am);
        $this.verifyRequestedExecs$1(2, 1, 2, am);
        $this.verifyRequestedExecs$1(2, 2, 2, am);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void verifyKilledExec$2(Seq execIds, Map receiverExecIds, Option expectedKilledExec, Tuple2 x) {
        Tuple2 tuple2 = x;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ReceiverTracker receiverTracker = (ReceiverTracker)tuple2._1();
        ExecutorAllocationManager allocationManager = (ExecutorAllocationManager)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)receiverTracker, (Object)allocationManager);
        Tuple2 tuple23 = tuple22;
        ReceiverTracker receiverTracker2 = (ReceiverTracker)tuple23._1();
        ExecutorAllocationManager allocationManager2 = (ExecutorAllocationManager)tuple23._2();
        Mockito.reset((Object[])new ExecutorAllocationClient[]{this.allocationClient()});
        Mockito.when((Object)this.allocationClient().getExecutorIds()).thenReturn((Object)execIds);
        Mockito.when((Object)receiverTracker2.allocatedExecutors()).thenReturn((Object)receiverExecIds);
        this.killExecutor(allocationManager2);
        if (expectedKilledExec.nonEmpty()) {
            ((ExecutorAllocationClient)Mockito.verify((Object)this.allocationClient(), (VerificationMode)Mockito.times((int)1))).killExecutor((String)ArgumentMatchers.eq((Object)expectedKilledExec.get()));
        } else {
            ((ExecutorAllocationClient)Mockito.verify((Object)this.allocationClient(), (VerificationMode)Mockito.never())).killExecutor(null);
        }
    }

    public static final /* synthetic */ void $anonfun$new$18(ExecutorAllocationManagerSuite $this, ReceiverTracker x0$6, ExecutorAllocationManager x1$6) {
        Tuple2 tuple2 = new Tuple2((Object)x0$6, (Object)x1$6);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ReceiverTracker receiverTracker = (ReceiverTracker)tuple2._1();
        ExecutorAllocationManager allocationManager = (ExecutorAllocationManager)tuple2._2();
        Tuple2 rcvrTrackerAndExecAllocMgr = new Tuple2((Object)receiverTracker, (Object)allocationManager);
        $this.verifyKilledExec$2((Seq)Nil$.MODULE$, Predef$.MODULE$.Map().empty(), (Option)None$.MODULE$, rcvrTrackerAndExecAllocMgr);
        $this.verifyKilledExec$2((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2"})), Predef$.MODULE$.Map().empty(), (Option)None$.MODULE$, rcvrTrackerAndExecAllocMgr);
        $this.verifyKilledExec$2((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1"})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new Some((Object)"1"))})), (Option)None$.MODULE$, rcvrTrackerAndExecAllocMgr);
        $this.verifyKilledExec$2((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2"})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new Some((Object)"1"))})), (Option)new Some((Object)"2"), rcvrTrackerAndExecAllocMgr);
        $this.verifyKilledExec$2((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2"})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new Some((Object)"2"))})), (Option)None$.MODULE$, rcvrTrackerAndExecAllocMgr);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$19(ExecutorAllocationManagerSuite $this, ReceiverTracker x0$7, ExecutorAllocationManager x1$7) {
        Tuple2 tuple2 = new Tuple2((Object)x0$7, (Object)x1$7);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ReceiverTracker receiverTracker = (ReceiverTracker)tuple2._1();
        ExecutorAllocationManager allocationManager = (ExecutorAllocationManager)tuple2._2();
        Tuple2 rcvrTrackerAndExecAllocMgr = new Tuple2((Object)receiverTracker, (Object)allocationManager);
        $this.verifyKilledExec$2((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2"})), Predef$.MODULE$.Map().empty(), (Option)None$.MODULE$, rcvrTrackerAndExecAllocMgr);
        $this.verifyKilledExec$2((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2", "3"})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new Some((Object)"1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new Some((Object)"2"))})), (Option)new Some((Object)"3"), rcvrTrackerAndExecAllocMgr);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void validateParams$1(int numReceivers, Option scalingIntervalSecs, Option scalingUpRatio, Option scalingDownRatio, Option minExecs, Option maxExecs) {
        Predef$.MODULE$.require(numReceivers > 0);
        ReceiverTracker receiverTracker = (ReceiverTracker)this.mock(ClassTag$.MODULE$.apply(ReceiverTracker.class));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)receiverTracker.numReceivers())).thenReturn((Object)BoxesRunTime.boxToInteger((int)numReceivers));
        SparkConf conf = new SparkConf();
        Object object = scalingIntervalSecs.nonEmpty() ? conf.set("spark.streaming.dynamicAllocation.scalingInterval", new StringBuilder(1).append(scalingIntervalSecs.get()).append("s").toString()) : BoxedUnit.UNIT;
        Object object2 = scalingUpRatio.nonEmpty() ? conf.set("spark.streaming.dynamicAllocation.scalingUpRatio", scalingUpRatio.get().toString()) : BoxedUnit.UNIT;
        Object object3 = scalingDownRatio.nonEmpty() ? conf.set("spark.streaming.dynamicAllocation.scalingDownRatio", scalingDownRatio.get().toString()) : BoxedUnit.UNIT;
        Object object4 = minExecs.nonEmpty() ? conf.set("spark.streaming.dynamicAllocation.minExecutors", minExecs.get().toString()) : BoxedUnit.UNIT;
        Object object5 = maxExecs.nonEmpty() ? conf.set("spark.streaming.dynamicAllocation.maxExecutors", maxExecs.get().toString()) : BoxedUnit.UNIT;
        new ExecutorAllocationManager(this.allocationClient(), receiverTracker, conf, this.batchDurationMillis(), (Clock)this.clock());
    }

    private static final int validateParams$default$1$1() {
        return 1;
    }

    private static final Option validateParams$default$2$1() {
        return None$.MODULE$;
    }

    private static final Option validateParams$default$3$1() {
        return None$.MODULE$;
    }

    private static final Option validateParams$default$4$1() {
        return None$.MODULE$;
    }

    private static final Option validateParams$default$5$1() {
        return None$.MODULE$;
    }

    private static final Option validateParams$default$6$1() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$new$35(ExecutorAllocationManagerSuite $this, StreamingContext ssc) {
        ssc.start();
        Option<ExecutorAllocationManager> $org_scalatest_assert_macro_left = $this.getExecutorAllocationManager(ssc);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327));
    }

    public static final /* synthetic */ void $anonfun$new$36(ExecutorAllocationManagerSuite $this, StreamingContext ssc) {
        ssc.start();
        Option<ExecutorAllocationManager> $org_scalatest_assert_macro_left = $this.getExecutorAllocationManager(ssc);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
    }

    public static final /* synthetic */ void $anonfun$withStreamingContext$2(RDD x$3) {
    }

    public static final /* synthetic */ void $anonfun$withStreamingContext$1(Function1 body$1, StreamingContext ssc) {
        new DummyInputDStream(ssc).foreachRDD((Function1 & Serializable & scala.Serializable)x$3 -> {
            ExecutorAllocationManagerSuite.$anonfun$withStreamingContext$2(x$3);
            return BoxedUnit.UNIT;
        });
        body$1.apply((Object)ssc);
    }

    public ExecutorAllocationManagerSuite() {
        TestSuiteBase.$init$(this);
        MockitoSugar.$init$((MockitoSugar)this);
        PrivateMethodTester.$init$((PrivateMethodTester)this);
        this.batchDurationMillis = 1000L;
        this.allocationClient = null;
        this.clock = null;
        this.test("basic functionality", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int x$1 = 1;
            SparkConf x$2 = this.withAllocationManager$default$1();
            Function2 & Serializable & scala.Serializable x$3 = (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                ExecutorAllocationManagerSuite.$anonfun$new$2(this, x0$1, x1$1);
                return BoxedUnit.UNIT;
            };
            this.withAllocationManager(x$2, x$1, (Function2<ReceiverTracker, ExecutorAllocationManager, BoxedUnit>)x$3);
        }, new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        this.test("requestExecutors policy", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int x$4 = 1;
            SparkConf x$5 = this.withAllocationManager$default$1();
            Function2 & Serializable & scala.Serializable x$6 = (Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
                ExecutorAllocationManagerSuite.$anonfun$new$12(this, x0$2, x1$2);
                return BoxedUnit.UNIT;
            };
            this.withAllocationManager(x$5, x$4, (Function2<ReceiverTracker, ExecutorAllocationManager, BoxedUnit>)x$6);
            int x$7 = 2;
            SparkConf x$8 = this.withAllocationManager$default$1();
            Function2 & Serializable & scala.Serializable x$9 = (Function2 & Serializable & scala.Serializable)(x0$3, x1$3) -> {
                ExecutorAllocationManagerSuite.$anonfun$new$14(this, x0$3, x1$3);
                return BoxedUnit.UNIT;
            };
            this.withAllocationManager(x$8, x$7, (Function2<ReceiverTracker, ExecutorAllocationManager, BoxedUnit>)x$9);
            this.withAllocationManager(new SparkConf().set("spark.streaming.dynamicAllocation.minExecutors", "2"), this.withAllocationManager$default$2(), (Function2<ReceiverTracker, ExecutorAllocationManager, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$4, x1$4) -> {
                ExecutorAllocationManagerSuite.$anonfun$new$15(this, x0$4, x1$4);
                return BoxedUnit.UNIT;
            });
            this.withAllocationManager(new SparkConf().set("spark.streaming.dynamicAllocation.maxExecutors", "2"), this.withAllocationManager$default$2(), (Function2<ReceiverTracker, ExecutorAllocationManager, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$5, x1$5) -> {
                ExecutorAllocationManagerSuite.$anonfun$new$16(this, x0$5, x1$5);
                return BoxedUnit.UNIT;
            });
        }, new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        this.test("killExecutor policy", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.withAllocationManager(this.withAllocationManager$default$1(), this.withAllocationManager$default$2(), (Function2<ReceiverTracker, ExecutorAllocationManager, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$6, x1$6) -> {
                ExecutorAllocationManagerSuite.$anonfun$new$18(this, x0$6, x1$6);
                return BoxedUnit.UNIT;
            });
            this.withAllocationManager(new SparkConf().set("spark.streaming.dynamicAllocation.minExecutors", "2"), this.withAllocationManager$default$2(), (Function2<ReceiverTracker, ExecutorAllocationManager, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$7, x1$7) -> {
                ExecutorAllocationManagerSuite.$anonfun$new$19(this, x0$7, x1$7);
                return BoxedUnit.UNIT;
            });
        }, new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
        this.test("parameter validation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.validateParams$1(1, ExecutorAllocationManagerSuite.validateParams$default$2$1(), ExecutorAllocationManagerSuite.validateParams$default$3$1(), ExecutorAllocationManagerSuite.validateParams$default$4$1(), ExecutorAllocationManagerSuite.validateParams$default$5$1(), ExecutorAllocationManagerSuite.validateParams$default$6$1());
            int x$10 = 2;
            Some x$11 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
            Option x$12 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
            Option x$13 = ExecutorAllocationManagerSuite.validateParams$default$3$1();
            Option x$14 = ExecutorAllocationManagerSuite.validateParams$default$4$1();
            Option x$15 = ExecutorAllocationManagerSuite.validateParams$default$6$1();
            this.validateParams$1(x$10, x$12, x$13, x$14, (Option)x$11, x$15);
            int x$16 = 2;
            Some x$17 = new Some((Object)BoxesRunTime.boxToInteger((int)3));
            Option x$18 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
            Option x$19 = ExecutorAllocationManagerSuite.validateParams$default$3$1();
            Option x$20 = ExecutorAllocationManagerSuite.validateParams$default$4$1();
            Option x$21 = ExecutorAllocationManagerSuite.validateParams$default$6$1();
            this.validateParams$1(x$16, x$18, x$19, x$20, (Option)x$17, x$21);
            int x$22 = 2;
            Some x$23 = new Some((Object)BoxesRunTime.boxToInteger((int)3));
            Option x$24 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
            Option x$25 = ExecutorAllocationManagerSuite.validateParams$default$3$1();
            Option x$26 = ExecutorAllocationManagerSuite.validateParams$default$4$1();
            Option x$27 = ExecutorAllocationManagerSuite.validateParams$default$5$1();
            this.validateParams$1(x$22, x$24, x$25, x$26, x$27, (Option)x$23);
            int x$28 = 2;
            Some x$29 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
            Option x$30 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
            Option x$31 = ExecutorAllocationManagerSuite.validateParams$default$3$1();
            Option x$32 = ExecutorAllocationManagerSuite.validateParams$default$4$1();
            Option x$33 = ExecutorAllocationManagerSuite.validateParams$default$5$1();
            this.validateParams$1(x$28, x$30, x$31, x$32, x$33, (Option)x$29);
            Some x$34 = new Some((Object)BoxesRunTime.boxToInteger((int)3));
            Some x$35 = new Some((Object)BoxesRunTime.boxToInteger((int)3));
            int x$36 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
            Option x$37 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
            Option x$38 = ExecutorAllocationManagerSuite.validateParams$default$3$1();
            Option x$39 = ExecutorAllocationManagerSuite.validateParams$default$4$1();
            this.validateParams$1(x$36, x$37, x$38, x$39, (Option)x$34, (Option)x$35);
            Some x$40 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
            int x$41 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
            Option x$42 = ExecutorAllocationManagerSuite.validateParams$default$3$1();
            Option x$43 = ExecutorAllocationManagerSuite.validateParams$default$4$1();
            Option x$44 = ExecutorAllocationManagerSuite.validateParams$default$5$1();
            Option x$45 = ExecutorAllocationManagerSuite.validateParams$default$6$1();
            this.validateParams$1(x$41, (Option)x$40, x$42, x$43, x$44, x$45);
            Some x$46 = new Some((Object)BoxesRunTime.boxToDouble((double)1.1));
            int x$47 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
            Option x$48 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
            Option x$49 = ExecutorAllocationManagerSuite.validateParams$default$4$1();
            Option x$50 = ExecutorAllocationManagerSuite.validateParams$default$5$1();
            Option x$51 = ExecutorAllocationManagerSuite.validateParams$default$6$1();
            this.validateParams$1(x$47, x$48, (Option)x$46, x$49, x$50, x$51);
            Some x$52 = new Some((Object)BoxesRunTime.boxToDouble((double)0.1));
            int x$53 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
            Option x$54 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
            Option x$55 = ExecutorAllocationManagerSuite.validateParams$default$3$1();
            Option x$56 = ExecutorAllocationManagerSuite.validateParams$default$5$1();
            Option x$57 = ExecutorAllocationManagerSuite.validateParams$default$6$1();
            this.validateParams$1(x$53, x$54, x$55, (Option)x$52, x$56, x$57);
            Some x$58 = new Some((Object)BoxesRunTime.boxToDouble((double)1.1));
            Some x$59 = new Some((Object)BoxesRunTime.boxToDouble((double)0.1));
            int x$60 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
            Option x$61 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
            Option x$62 = ExecutorAllocationManagerSuite.validateParams$default$5$1();
            Option x$63 = ExecutorAllocationManagerSuite.validateParams$default$6$1();
            this.validateParams$1(x$60, x$61, (Option)x$58, (Option)x$59, x$62, x$63);
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Some x$64 = new Some((Object)BoxesRunTime.boxToInteger((int)0));
                int x$65 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
                Option x$66 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
                Option x$67 = ExecutorAllocationManagerSuite.validateParams$default$3$1();
                Option x$68 = ExecutorAllocationManagerSuite.validateParams$default$4$1();
                Option x$69 = ExecutorAllocationManagerSuite.validateParams$default$6$1();
                this.validateParams$1(x$65, x$66, x$67, x$68, (Option)x$64, x$69);
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Some x$70 = new Some((Object)BoxesRunTime.boxToInteger((int)-1));
                int x$71 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
                Option x$72 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
                Option x$73 = ExecutorAllocationManagerSuite.validateParams$default$3$1();
                Option x$74 = ExecutorAllocationManagerSuite.validateParams$default$4$1();
                Option x$75 = ExecutorAllocationManagerSuite.validateParams$default$6$1();
                this.validateParams$1(x$71, x$72, x$73, x$74, (Option)x$70, x$75);
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Some x$76 = new Some((Object)BoxesRunTime.boxToInteger((int)0));
                int x$77 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
                Option x$78 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
                Option x$79 = ExecutorAllocationManagerSuite.validateParams$default$3$1();
                Option x$80 = ExecutorAllocationManagerSuite.validateParams$default$4$1();
                Option x$81 = ExecutorAllocationManagerSuite.validateParams$default$5$1();
                this.validateParams$1(x$77, x$78, x$79, x$80, x$81, (Option)x$76);
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Some x$82 = new Some((Object)BoxesRunTime.boxToInteger((int)-1));
                int x$83 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
                Option x$84 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
                Option x$85 = ExecutorAllocationManagerSuite.validateParams$default$3$1();
                Option x$86 = ExecutorAllocationManagerSuite.validateParams$default$4$1();
                Option x$87 = ExecutorAllocationManagerSuite.validateParams$default$5$1();
                this.validateParams$1(x$83, x$84, x$85, x$86, x$87, (Option)x$82);
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Some x$88 = new Some((Object)BoxesRunTime.boxToInteger((int)4));
                Some x$89 = new Some((Object)BoxesRunTime.boxToInteger((int)3));
                int x$90 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
                Option x$91 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
                Option x$92 = ExecutorAllocationManagerSuite.validateParams$default$3$1();
                Option x$93 = ExecutorAllocationManagerSuite.validateParams$default$4$1();
                this.validateParams$1(x$90, x$91, x$92, x$93, (Option)x$88, (Option)x$89);
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Some x$94 = new Some((Object)BoxesRunTime.boxToInteger((int)-1));
                int x$95 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
                Option x$96 = ExecutorAllocationManagerSuite.validateParams$default$3$1();
                Option x$97 = ExecutorAllocationManagerSuite.validateParams$default$4$1();
                Option x$98 = ExecutorAllocationManagerSuite.validateParams$default$5$1();
                Option x$99 = ExecutorAllocationManagerSuite.validateParams$default$6$1();
                this.validateParams$1(x$95, (Option)x$94, x$96, x$97, x$98, x$99);
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Some x$100 = new Some((Object)BoxesRunTime.boxToInteger((int)0));
                int x$101 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
                Option x$102 = ExecutorAllocationManagerSuite.validateParams$default$3$1();
                Option x$103 = ExecutorAllocationManagerSuite.validateParams$default$4$1();
                Option x$104 = ExecutorAllocationManagerSuite.validateParams$default$5$1();
                Option x$105 = ExecutorAllocationManagerSuite.validateParams$default$6$1();
                this.validateParams$1(x$101, (Option)x$100, x$102, x$103, x$104, x$105);
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Some x$106 = new Some((Object)BoxesRunTime.boxToDouble((double)-0.1));
                int x$107 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
                Option x$108 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
                Option x$109 = ExecutorAllocationManagerSuite.validateParams$default$4$1();
                Option x$110 = ExecutorAllocationManagerSuite.validateParams$default$5$1();
                Option x$111 = ExecutorAllocationManagerSuite.validateParams$default$6$1();
                this.validateParams$1(x$107, x$108, (Option)x$106, x$109, x$110, x$111);
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 304));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Some x$112 = new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
                int x$113 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
                Option x$114 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
                Option x$115 = ExecutorAllocationManagerSuite.validateParams$default$4$1();
                Option x$116 = ExecutorAllocationManagerSuite.validateParams$default$5$1();
                Option x$117 = ExecutorAllocationManagerSuite.validateParams$default$6$1();
                this.validateParams$1(x$113, x$114, (Option)x$112, x$115, x$116, x$117);
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 307));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Some x$118 = new Some((Object)BoxesRunTime.boxToDouble((double)-0.1));
                int x$119 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
                Option x$120 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
                Option x$121 = ExecutorAllocationManagerSuite.validateParams$default$3$1();
                Option x$122 = ExecutorAllocationManagerSuite.validateParams$default$5$1();
                Option x$123 = ExecutorAllocationManagerSuite.validateParams$default$6$1();
                this.validateParams$1(x$119, x$120, x$121, (Option)x$118, x$122, x$123);
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Some x$124 = new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
                int x$125 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
                Option x$126 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
                Option x$127 = ExecutorAllocationManagerSuite.validateParams$default$3$1();
                Option x$128 = ExecutorAllocationManagerSuite.validateParams$default$5$1();
                Option x$129 = ExecutorAllocationManagerSuite.validateParams$default$6$1();
                this.validateParams$1(x$125, x$126, x$127, (Option)x$124, x$128, x$129);
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Some x$130 = new Some((Object)BoxesRunTime.boxToDouble((double)0.5));
                Some x$131 = new Some((Object)BoxesRunTime.boxToDouble((double)0.5));
                int x$132 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
                Option x$133 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
                Option x$134 = ExecutorAllocationManagerSuite.validateParams$default$5$1();
                Option x$135 = ExecutorAllocationManagerSuite.validateParams$default$6$1();
                this.validateParams$1(x$132, x$133, (Option)x$130, (Option)x$131, x$134, x$135);
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316));
            return (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Some x$136 = new Some((Object)BoxesRunTime.boxToDouble((double)0.3));
                Some x$137 = new Some((Object)BoxesRunTime.boxToDouble((double)0.5));
                int x$138 = ExecutorAllocationManagerSuite.validateParams$default$1$1();
                Option x$139 = ExecutorAllocationManagerSuite.validateParams$default$2$1();
                Option x$140 = ExecutorAllocationManagerSuite.validateParams$default$5$1();
                Option x$141 = ExecutorAllocationManagerSuite.validateParams$default$6$1();
                this.validateParams$1(x$138, x$139, (Option)x$136, (Option)x$137, x$140, x$141);
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
        }, new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
        this.test("enabling and disabling", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.withStreamingContext(new SparkConf(), (Function1<StreamingContext, BoxedUnit>)(Function1 & Serializable & scala.Serializable)ssc -> {
                ExecutorAllocationManagerSuite.$anonfun$new$35(this, ssc);
                return BoxedUnit.UNIT;
            });
            this.withStreamingContext(new SparkConf().set("spark.streaming.dynamicAllocation.enabled", "true"), (Function1<StreamingContext, BoxedUnit>)(Function1 & Serializable & scala.Serializable)ssc -> {
                ExecutorAllocationManagerSuite.$anonfun$new$36(this, ssc);
                return BoxedUnit.UNIT;
            });
            SparkConf confWithBothDynamicAllocationEnabled = new SparkConf().set("spark.streaming.dynamicAllocation.enabled", "true").set(package$.MODULE$.DYN_ALLOCATION_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true)).set(package$.MODULE$.DYN_ALLOCATION_TESTING(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            Predef$.MODULE$.require(Utils$.MODULE$.isDynamicAllocationEnabled(confWithBothDynamicAllocationEnabled));
            this.withStreamingContext(confWithBothDynamicAllocationEnabled, (Function1<StreamingContext, BoxedUnit>)(Function1 & Serializable & scala.Serializable)ssc -> {
                this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ssc.start(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
                return BoxedUnit.UNIT;
            });
        }, new Position("ExecutorAllocationManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
        this._addBatchProcTime = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "addBatchProcTime"));
        this._requestExecutors = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "requestExecutors"));
        this._killExecutor = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "killExecutor"));
        this._executorAllocationManager = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "executorAllocationManager"));
    }
}

