/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler.rate;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.scheduler.rate.PIDRateEstimator;
import org.apache.spark.streaming.scheduler.rate.RateEstimator;
import org.apache.spark.streaming.scheduler.rate.RateEstimator$;
import org.scalactic.Equality;
import org.scalactic.Equality$;
import org.scalactic.Explicitly;
import org.scalactic.Prettifier;
import org.scalactic.Prettifier$;
import org.scalactic.Tolerance;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Entry;
import org.scalatest.Inspectors$;
import org.scalatest.Matchers;
import org.scalatest.Matchers$AllCollected$;
import org.scalatest.Matchers$AtLeastCollected$;
import org.scalatest.Matchers$AtMostCollected$;
import org.scalatest.Matchers$BetweenCollected$;
import org.scalatest.Matchers$EveryCollected$;
import org.scalatest.Matchers$ExactlyCollected$;
import org.scalatest.Matchers$NoCollected$;
import org.scalatest.Matchers$ShouldMethodHelper$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.enablers.Collecting;
import org.scalatest.enablers.Collecting$;
import org.scalatest.enablers.InspectorAsserting$;
import org.scalatest.matchers.Matcher;
import org.scalatest.matchers.MatcherFactory1;
import org.scalatest.words.BeWord;
import org.scalatest.words.CompileWord;
import org.scalatest.words.ContainWord;
import org.scalatest.words.DefinedWord;
import org.scalatest.words.EmptyWord;
import org.scalatest.words.EndWithWord;
import org.scalatest.words.ExistWord;
import org.scalatest.words.FullyMatchWord;
import org.scalatest.words.HaveWord;
import org.scalatest.words.IncludeWord;
import org.scalatest.words.LengthWord;
import org.scalatest.words.MatchPatternWord;
import org.scalatest.words.MatcherWords;
import org.scalatest.words.NoExceptionWord;
import org.scalatest.words.NotWord;
import org.scalatest.words.ReadableWord;
import org.scalatest.words.ResultOfATypeInvocation;
import org.scalatest.words.ResultOfAllElementsOfApplication;
import org.scalatest.words.ResultOfAllOfApplication;
import org.scalatest.words.ResultOfAnTypeInvocation;
import org.scalatest.words.ResultOfAtLeastOneElementOfApplication;
import org.scalatest.words.ResultOfAtLeastOneOfApplication;
import org.scalatest.words.ResultOfAtMostOneElementOfApplication;
import org.scalatest.words.ResultOfAtMostOneOfApplication;
import org.scalatest.words.ResultOfDefinedAt;
import org.scalatest.words.ResultOfGreaterThanComparison;
import org.scalatest.words.ResultOfGreaterThanOrEqualToComparison;
import org.scalatest.words.ResultOfInOrderApplication;
import org.scalatest.words.ResultOfInOrderElementsOfApplication;
import org.scalatest.words.ResultOfInOrderOnlyApplication;
import org.scalatest.words.ResultOfLessThanComparison;
import org.scalatest.words.ResultOfLessThanOrEqualToComparison;
import org.scalatest.words.ResultOfMessageWordApplication;
import org.scalatest.words.ResultOfNoElementsOfApplication;
import org.scalatest.words.ResultOfNoneOfApplication;
import org.scalatest.words.ResultOfOfTypeInvocation;
import org.scalatest.words.ResultOfOneElementOfApplication;
import org.scalatest.words.ResultOfOneOfApplication;
import org.scalatest.words.ResultOfOnlyApplication;
import org.scalatest.words.ResultOfTheSameElementsAsApplication;
import org.scalatest.words.ResultOfTheSameElementsInOrderAsApplication;
import org.scalatest.words.ResultOfTheTypeInvocation;
import org.scalatest.words.ResultOfThrownByApplication;
import org.scalatest.words.ShouldVerb;
import org.scalatest.words.SizeWord;
import org.scalatest.words.SortedWord;
import org.scalatest.words.StartWithWord;
import org.scalatest.words.TypeCheckWord;
import org.scalatest.words.WritableWord;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.GenTraversable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u00152Aa\u0001\u0003\u0001#!)A\u0004\u0001C\u0001;!)\u0001\u0005\u0001C\u0005C\t)\u0002+\u0013#SCR,Wi\u001d;j[\u0006$xN]*vSR,'BA\u0003\u0007\u0003\u0011\u0011\u0018\r^3\u000b\u0005\u001dA\u0011!C:dQ\u0016$W\u000f\\3s\u0015\tI!\"A\u0005tiJ,\u0017-\\5oO*\u00111\u0002D\u0001\u0006gB\f'o\u001b\u0006\u0003\u001b9\ta!\u00199bG\",'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0011b\u0003\u0005\u0002\u0014)5\t!\"\u0003\u0002\u0016\u0015\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"a\u0006\u000e\u000e\u0003aQ!!\u0007\b\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018BA\u000e\u0019\u0005!i\u0015\r^2iKJ\u001c\u0018A\u0002\u001fj]&$h\bF\u0001\u001f!\ty\u0002!D\u0001\u0005\u0003Y\u0019'/Z1uK\u0012+g-Y;mi\u0016\u001bH/[7bi>\u0014H#\u0001\u0012\u0011\u0005}\u0019\u0013B\u0001\u0013\u0005\u0005A\u0001\u0016\n\u0012*bi\u0016,5\u000f^5nCR|'\u000f")
public class PIDRateEstimatorSuite
extends SparkFunSuite
implements Matchers {
    private final Matchers.KeyWord key;
    private final Matchers.ValueWord value;
    private final Matchers.AWord a;
    private final Matchers.AnWord an;
    private final Matchers.TheSameInstanceAsPhrase theSameInstanceAs;
    private final Matchers.RegexWord regex;
    private volatile Matchers$AllCollected$ AllCollected$module;
    private volatile Matchers$EveryCollected$ EveryCollected$module;
    private volatile Matchers$BetweenCollected$ BetweenCollected$module;
    private volatile Matchers$AtLeastCollected$ AtLeastCollected$module;
    private volatile Matchers$AtMostCollected$ AtMostCollected$module;
    private volatile Matchers$NoCollected$ NoCollected$module;
    private volatile Matchers$ExactlyCollected$ ExactlyCollected$module;
    private volatile Matchers$ShouldMethodHelper$ ShouldMethodHelper$module;
    private final Explicitly.DecidedWord decided;
    private final Explicitly.DeterminedWord determined;
    private final Explicitly.TheAfterWord after;
    private final FullyMatchWord fullyMatch;
    private final StartWithWord startWith;
    private final EndWithWord endWith;
    private final IncludeWord include;
    private final HaveWord have;
    private final BeWord be;
    private final ContainWord contain;
    private final NotWord not;
    private final LengthWord length;
    private final SizeWord size;
    private final SortedWord sorted;
    private final DefinedWord defined;
    private final ExistWord exist;
    private final ReadableWord readable;
    private final WritableWord writable;
    private final EmptyWord empty;
    private final CompileWord compile;
    private final TypeCheckWord typeCheck;
    private final MatchPatternWord matchPattern;

    public Matchers.HavePropertyMatcherGenerator convertSymbolToHavePropertyMatcherGenerator(Symbol symbol, Prettifier prettifier, Position pos) {
        return Matchers.convertSymbolToHavePropertyMatcherGenerator$((Matchers)this, (Symbol)symbol, (Prettifier)prettifier, (Position)pos);
    }

    public <T> Matcher<T> equal(TripleEqualsSupport.Spread<T> spread) {
        return Matchers.equal$((Matchers)this, spread);
    }

    public Matcher<Object> equal(Null$ o) {
        return Matchers.equal$((Matchers)this, (Null$)o);
    }

    public <T> ResultOfLessThanComparison<T> $less(T right, Ordering<T> evidence$1) {
        return Matchers.$less$((Matchers)this, right, evidence$1);
    }

    public <T> ResultOfGreaterThanComparison<T> $greater(T right, Ordering<T> evidence$2) {
        return Matchers.$greater$((Matchers)this, right, evidence$2);
    }

    public <T> ResultOfLessThanOrEqualToComparison<T> $less$eq(T right, Ordering<T> evidence$3) {
        return Matchers.$less$eq$((Matchers)this, right, evidence$3);
    }

    public <T> ResultOfGreaterThanOrEqualToComparison<T> $greater$eq(T right, Ordering<T> evidence$4) {
        return Matchers.$greater$eq$((Matchers)this, right, evidence$4);
    }

    public <T> ResultOfDefinedAt<T> definedAt(T right) {
        return Matchers.definedAt$((Matchers)this, right);
    }

    public ResultOfOneOfApplication oneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.oneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfOneElementOfApplication oneElementOf(GenTraversable<Object> elements) {
        return Matchers.oneElementOf$((Matchers)this, elements);
    }

    public ResultOfAtLeastOneOfApplication atLeastOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.atLeastOneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfAtLeastOneElementOfApplication atLeastOneElementOf(GenTraversable<Object> elements) {
        return Matchers.atLeastOneElementOf$((Matchers)this, elements);
    }

    public ResultOfNoneOfApplication noneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.noneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfNoElementsOfApplication noElementsOf(GenTraversable<Object> elements) {
        return Matchers.noElementsOf$((Matchers)this, elements);
    }

    public ResultOfTheSameElementsAsApplication theSameElementsAs(GenTraversable<?> xs) {
        return Matchers.theSameElementsAs$((Matchers)this, xs);
    }

    public ResultOfTheSameElementsInOrderAsApplication theSameElementsInOrderAs(GenTraversable<?> xs) {
        return Matchers.theSameElementsInOrderAs$((Matchers)this, xs);
    }

    public ResultOfOnlyApplication only(Seq<Object> xs, Position pos) {
        return Matchers.only$((Matchers)this, xs, (Position)pos);
    }

    public <T> ResultOfInOrderOnlyApplication inOrderOnly(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.inOrderOnly$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public ResultOfAllOfApplication allOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.allOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfAllElementsOfApplication allElementsOf(GenTraversable<R> elements) {
        return Matchers.allElementsOf$((Matchers)this, elements);
    }

    public ResultOfInOrderApplication inOrder(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.inOrder$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfInOrderElementsOfApplication inOrderElementsOf(GenTraversable<R> elements) {
        return Matchers.inOrderElementsOf$((Matchers)this, elements);
    }

    public ResultOfAtMostOneOfApplication atMostOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles, Position pos) {
        return Matchers.atMostOneOf$((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles, (Position)pos);
    }

    public <R> ResultOfAtMostOneElementOfApplication atMostOneElementOf(GenTraversable<R> elements) {
        return Matchers.atMostOneElementOf$((Matchers)this, elements);
    }

    public ResultOfThrownByApplication thrownBy(Function0<Object> fun) {
        return Matchers.thrownBy$((Matchers)this, fun);
    }

    public ResultOfMessageWordApplication message(String expectedMessage) {
        return Matchers.message$((Matchers)this, (String)expectedMessage);
    }

    public <T> Assertion doCollected(Matchers.Collected collected, GenTraversable<T> xs, Object original, Prettifier prettifier, Position pos, Function1<T, Assertion> fun) {
        return Matchers.doCollected$((Matchers)this, (Matchers.Collected)collected, xs, (Object)original, (Prettifier)prettifier, (Position)pos, fun);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> all(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends GenMap<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> all(MAP xs, Collecting<Tuple2<K, V>, GenTraversable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> all(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> all(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.all$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atLeast(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends GenMap<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> atLeast(int num, MAP xs, Collecting<Tuple2<K, V>, GenTraversable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atLeast(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> atLeast(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atLeast$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> every(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> every(MAP xs, Collecting<Tuple2<K, V>, GenTraversable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> every(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> every(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.every$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> exactly(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends GenMap<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> exactly(int num, MAP xs, Collecting<Tuple2<K, V>, GenTraversable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> exactly(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> exactly(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.exactly$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> no(C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> no(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> no(String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.no$((Matchers)this, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> between(int from, int upTo, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> between(int from, int upTo, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> between(int from, int upTo, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.between$((Matchers)this, (int)from, (int)upTo, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atMost(int num, C xs, Collecting<E, C> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, MAP extends GenMap<Object, Object>> Matchers.ResultOfCollectedAny<Tuple2<K, V>> atMost(int num, MAP xs, Collecting<Tuple2<K, V>, GenTraversable<Tuple2<K, V>>> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <K, V, JMAP extends java.util.Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atMost(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public Matchers.ResultOfCollectedAny<Object> atMost(int num, String xs, Collecting<Object, String> collecting, Prettifier prettifier, Position pos) {
        return Matchers.atMost$((Matchers)this, (int)num, (String)xs, collecting, (Prettifier)prettifier, (Position)pos);
    }

    public <T> ResultOfATypeInvocation<T> a(ClassTag<T> evidence$5) {
        return Matchers.a$((Matchers)this, evidence$5);
    }

    public <T> ResultOfAnTypeInvocation<T> an(ClassTag<T> evidence$6) {
        return Matchers.an$((Matchers)this, evidence$6);
    }

    public <T> ResultOfTheTypeInvocation<T> the(ClassTag<T> evidence$7, Position pos) {
        return Matchers.the$((Matchers)this, evidence$7, (Position)pos);
    }

    public <T> Matchers.AnyShouldWrapper<T> convertToAnyShouldWrapper(T o, Position pos, Prettifier prettifier) {
        return Matchers.convertToAnyShouldWrapper$((Matchers)this, o, (Position)pos, (Prettifier)prettifier);
    }

    public Matchers.StringShouldWrapper convertToStringShouldWrapper(String o, Position pos, Prettifier prettifier) {
        return Matchers.convertToStringShouldWrapper$((Matchers)this, (String)o, (Position)pos, (Prettifier)prettifier);
    }

    public Matchers.RegexWrapper convertToRegexWrapper(Regex o) {
        return Matchers.convertToRegexWrapper$((Matchers)this, (Regex)o);
    }

    public <T> ResultOfOfTypeInvocation<T> of(ClassTag<T> ev) {
        return Matchers.of$((Matchers)this, ev);
    }

    public NoExceptionWord noException(Position pos) {
        return MatcherWords.noException$((MatcherWords)this, (Position)pos);
    }

    public MatcherFactory1<Object, Equality> equal(Object right) {
        return MatcherWords.equal$((MatcherWords)this, (Object)right);
    }

    public ShouldVerb.StringShouldWrapperForVerb convertToStringShouldWrapperForVerb(String o, Position position) {
        return ShouldVerb.convertToStringShouldWrapperForVerb$((ShouldVerb)this, (String)o, (Position)position);
    }

    public <T> Tolerance.PlusOrMinusWrapper<T> convertNumericToPlusOrMinusWrapper(T pivot, Numeric<T> evidence$2) {
        return Tolerance.convertNumericToPlusOrMinusWrapper$((Tolerance)this, pivot, evidence$2);
    }

    public Matchers.KeyWord key() {
        return this.key;
    }

    public Matchers.ValueWord value() {
        return this.value;
    }

    public Matchers.AWord a() {
        return this.a;
    }

    public Matchers.AnWord an() {
        return this.an;
    }

    public Matchers.TheSameInstanceAsPhrase theSameInstanceAs() {
        return this.theSameInstanceAs;
    }

    public Matchers.RegexWord regex() {
        return this.regex;
    }

    public Matchers$AllCollected$ org$scalatest$Matchers$$AllCollected() {
        if (this.AllCollected$module == null) {
            this.org$scalatest$Matchers$$AllCollected$lzycompute$1();
        }
        return this.AllCollected$module;
    }

    public Matchers$EveryCollected$ org$scalatest$Matchers$$EveryCollected() {
        if (this.EveryCollected$module == null) {
            this.org$scalatest$Matchers$$EveryCollected$lzycompute$1();
        }
        return this.EveryCollected$module;
    }

    public Matchers$BetweenCollected$ org$scalatest$Matchers$$BetweenCollected() {
        if (this.BetweenCollected$module == null) {
            this.org$scalatest$Matchers$$BetweenCollected$lzycompute$1();
        }
        return this.BetweenCollected$module;
    }

    public Matchers$AtLeastCollected$ org$scalatest$Matchers$$AtLeastCollected() {
        if (this.AtLeastCollected$module == null) {
            this.org$scalatest$Matchers$$AtLeastCollected$lzycompute$1();
        }
        return this.AtLeastCollected$module;
    }

    public Matchers$AtMostCollected$ org$scalatest$Matchers$$AtMostCollected() {
        if (this.AtMostCollected$module == null) {
            this.org$scalatest$Matchers$$AtMostCollected$lzycompute$1();
        }
        return this.AtMostCollected$module;
    }

    public Matchers$NoCollected$ org$scalatest$Matchers$$NoCollected() {
        if (this.NoCollected$module == null) {
            this.org$scalatest$Matchers$$NoCollected$lzycompute$1();
        }
        return this.NoCollected$module;
    }

    public Matchers$ExactlyCollected$ org$scalatest$Matchers$$ExactlyCollected() {
        if (this.ExactlyCollected$module == null) {
            this.org$scalatest$Matchers$$ExactlyCollected$lzycompute$1();
        }
        return this.ExactlyCollected$module;
    }

    public Matchers$ShouldMethodHelper$ org$scalatest$Matchers$$ShouldMethodHelper() {
        if (this.ShouldMethodHelper$module == null) {
            this.org$scalatest$Matchers$$ShouldMethodHelper$lzycompute$1();
        }
        return this.ShouldMethodHelper$module;
    }

    public void org$scalatest$Matchers$_setter_$key_$eq(Matchers.KeyWord x$1) {
        this.key = x$1;
    }

    public void org$scalatest$Matchers$_setter_$value_$eq(Matchers.ValueWord x$1) {
        this.value = x$1;
    }

    public void org$scalatest$Matchers$_setter_$a_$eq(Matchers.AWord x$1) {
        this.a = x$1;
    }

    public void org$scalatest$Matchers$_setter_$an_$eq(Matchers.AnWord x$1) {
        this.an = x$1;
    }

    public void org$scalatest$Matchers$_setter_$theSameInstanceAs_$eq(Matchers.TheSameInstanceAsPhrase x$1) {
        this.theSameInstanceAs = x$1;
    }

    public void org$scalatest$Matchers$_setter_$regex_$eq(Matchers.RegexWord x$1) {
        this.regex = x$1;
    }

    public Explicitly.DecidedWord decided() {
        return this.decided;
    }

    public Explicitly.DeterminedWord determined() {
        return this.determined;
    }

    public Explicitly.TheAfterWord after() {
        return this.after;
    }

    public void org$scalactic$Explicitly$_setter_$decided_$eq(Explicitly.DecidedWord x$1) {
        this.decided = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$determined_$eq(Explicitly.DeterminedWord x$1) {
        this.determined = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$after_$eq(Explicitly.TheAfterWord x$1) {
        this.after = x$1;
    }

    public FullyMatchWord fullyMatch() {
        return this.fullyMatch;
    }

    public StartWithWord startWith() {
        return this.startWith;
    }

    public EndWithWord endWith() {
        return this.endWith;
    }

    public IncludeWord include() {
        return this.include;
    }

    public HaveWord have() {
        return this.have;
    }

    public BeWord be() {
        return this.be;
    }

    public ContainWord contain() {
        return this.contain;
    }

    public NotWord not() {
        return this.not;
    }

    public LengthWord length() {
        return this.length;
    }

    public SizeWord size() {
        return this.size;
    }

    public SortedWord sorted() {
        return this.sorted;
    }

    public DefinedWord defined() {
        return this.defined;
    }

    public ExistWord exist() {
        return this.exist;
    }

    public ReadableWord readable() {
        return this.readable;
    }

    public WritableWord writable() {
        return this.writable;
    }

    public EmptyWord empty() {
        return this.empty;
    }

    public CompileWord compile() {
        return this.compile;
    }

    public TypeCheckWord typeCheck() {
        return this.typeCheck;
    }

    public MatchPatternWord matchPattern() {
        return this.matchPattern;
    }

    public void org$scalatest$words$MatcherWords$_setter_$fullyMatch_$eq(FullyMatchWord x$1) {
        this.fullyMatch = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$startWith_$eq(StartWithWord x$1) {
        this.startWith = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$endWith_$eq(EndWithWord x$1) {
        this.endWith = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$include_$eq(IncludeWord x$1) {
        this.include = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$have_$eq(HaveWord x$1) {
        this.have = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$be_$eq(BeWord x$1) {
        this.be = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$contain_$eq(ContainWord x$1) {
        this.contain = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$not_$eq(NotWord x$1) {
        this.not = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$length_$eq(LengthWord x$1) {
        this.length = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$size_$eq(SizeWord x$1) {
        this.size = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$sorted_$eq(SortedWord x$1) {
        this.sorted = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$defined_$eq(DefinedWord x$1) {
        this.defined = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$exist_$eq(ExistWord x$1) {
        this.exist = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$readable_$eq(ReadableWord x$1) {
        this.readable = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$writable_$eq(WritableWord x$1) {
        this.writable = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$empty_$eq(EmptyWord x$1) {
        this.empty = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$compile_$eq(CompileWord x$1) {
        this.compile = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$typeCheck_$eq(TypeCheckWord x$1) {
        this.typeCheck = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$matchPattern_$eq(MatchPatternWord x$1) {
        this.matchPattern = x$1;
    }

    private PIDRateEstimator createDefaultEstimator() {
        return new PIDRateEstimator(20L, 1.0, 0.0, 0.0, 10.0);
    }

    private final void org$scalatest$Matchers$$AllCollected$lzycompute$1() {
        PIDRateEstimatorSuite pIDRateEstimatorSuite = this;
        synchronized (pIDRateEstimatorSuite) {
            if (this.AllCollected$module == null) {
                this.AllCollected$module = new Matchers$AllCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$EveryCollected$lzycompute$1() {
        PIDRateEstimatorSuite pIDRateEstimatorSuite = this;
        synchronized (pIDRateEstimatorSuite) {
            if (this.EveryCollected$module == null) {
                this.EveryCollected$module = new Matchers$EveryCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$BetweenCollected$lzycompute$1() {
        PIDRateEstimatorSuite pIDRateEstimatorSuite = this;
        synchronized (pIDRateEstimatorSuite) {
            if (this.BetweenCollected$module == null) {
                this.BetweenCollected$module = new Matchers$BetweenCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$AtLeastCollected$lzycompute$1() {
        PIDRateEstimatorSuite pIDRateEstimatorSuite = this;
        synchronized (pIDRateEstimatorSuite) {
            if (this.AtLeastCollected$module == null) {
                this.AtLeastCollected$module = new Matchers$AtLeastCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$AtMostCollected$lzycompute$1() {
        PIDRateEstimatorSuite pIDRateEstimatorSuite = this;
        synchronized (pIDRateEstimatorSuite) {
            if (this.AtMostCollected$module == null) {
                this.AtMostCollected$module = new Matchers$AtMostCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$NoCollected$lzycompute$1() {
        PIDRateEstimatorSuite pIDRateEstimatorSuite = this;
        synchronized (pIDRateEstimatorSuite) {
            if (this.NoCollected$module == null) {
                this.NoCollected$module = new Matchers$NoCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$ExactlyCollected$lzycompute$1() {
        PIDRateEstimatorSuite pIDRateEstimatorSuite = this;
        synchronized (pIDRateEstimatorSuite) {
            if (this.ExactlyCollected$module == null) {
                this.ExactlyCollected$module = new Matchers$ExactlyCollected$((Matchers)this);
            }
        }
    }

    private final void org$scalatest$Matchers$$ShouldMethodHelper$lzycompute$1() {
        PIDRateEstimatorSuite pIDRateEstimatorSuite = this;
        synchronized (pIDRateEstimatorSuite) {
            if (this.ShouldMethodHelper$module == null) {
                this.ShouldMethodHelper$module = new Matchers$ShouldMethodHelper$((Matchers)this);
            }
        }
    }

    public static final /* synthetic */ Some $anonfun$new$27(int x) {
        return new Some((Object)BoxesRunTime.boxToDouble((double)((double)(x + 1) * 1000.0)));
    }

    public static final /* synthetic */ Some $anonfun$new$34(int x) {
        return new Some((Object)BoxesRunTime.boxToDouble((double)((double)(50 - x) * 1000.0)));
    }

    public static final /* synthetic */ Object $anonfun$new$42(PIDRateEstimatorSuite $this, List res$1, List sched$4, List speeds$1, double minRate$2, int n) {
        BoxedUnit boxedUnit;
        $this.convertToAnyShouldWrapper(res$1.apply(n), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149), Prettifier$.MODULE$.default()).should($this.not()).be((Object)None$.MODULE$);
        if (BoxesRunTime.unboxToDouble((Object)((Option)res$1.apply(n)).get()) > 0.0 && BoxesRunTime.unboxToInt((Object)sched$4.apply(n)) > 0) {
            $this.convertToAnyShouldWrapper(((Option)res$1.apply(n)).get(), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151), Prettifier$.MODULE$.default()).should($this.be().$less(speeds$1.apply(n), (Ordering)Ordering.Double$.MODULE$));
            boxedUnit = $this.convertToAnyShouldWrapper(((Option)res$1.apply(n)).get(), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152), Prettifier$.MODULE$.default()).should($this.be().$greater$eq((Object)BoxesRunTime.boxToDouble((double)minRate$2), (Ordering)Ordering.Double$.MODULE$));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    public PIDRateEstimatorSuite() {
        Tolerance.$init$((Tolerance)this);
        ShouldVerb.$init$((ShouldVerb)this);
        MatcherWords.$init$((MatcherWords)this);
        Explicitly.$init$((Explicitly)this);
        Matchers.$init$((Matchers)this);
        this.test("the right estimator is created", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf();
            conf.set("spark.streaming.backpressure.rateEstimator", "pid");
            RateEstimator pid = RateEstimator$.MODULE$.create(conf, Seconds$.MODULE$.apply(1L));
            return this.convertToAnyShouldWrapper(pid.getClass(), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34), Prettifier$.MODULE$.default()).should(this.equal(PIDRateEstimator.class), (Object)Equality$.MODULE$.default());
        }, new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
        this.test("estimator checks ranges", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.intercept((Function0 & Serializable & scala.Serializable)() -> new PIDRateEstimator(0L, 1.0, 2.0, 3.0, 10.0), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> new PIDRateEstimator(100L, -1.0, 2.0, 3.0, 10.0), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> new PIDRateEstimator(100L, 0.0, -1.0, 3.0, 10.0), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> new PIDRateEstimator(100L, 0.0, 0.0, -1.0, 10.0), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> new PIDRateEstimator(100L, 0.0, 0.0, 0.0, 0.0), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> new PIDRateEstimator(100L, 0.0, 0.0, 0.0, -10.0), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        }, new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        this.test("first estimate is None", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            PIDRateEstimator p = this.createDefaultEstimator();
            return this.convertToAnyShouldWrapper(p.compute(0L, 10L, 10L, 0L), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60), Prettifier$.MODULE$.default()).should(this.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
        }, new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        this.test("second estimate is not None", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            PIDRateEstimator p = this.createDefaultEstimator();
            p.compute(0L, 10L, 10L, 0L);
            return this.convertToAnyShouldWrapper(p.compute(10L, 10L, 10L, 0L), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67), Prettifier$.MODULE$.default()).should(this.equal(new Some((Object)BoxesRunTime.boxToInteger((int)1000))), (Object)Equality$.MODULE$.default());
        }, new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        this.test("no estimate when no time difference between successive calls", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            PIDRateEstimator p = this.createDefaultEstimator();
            p.compute(0L, 10L, 10L, 0L);
            this.convertToAnyShouldWrapper(p.compute(10L, 10L, 10L, 0L), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73), Prettifier$.MODULE$.default()).shouldNot(this.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
            return this.convertToAnyShouldWrapper(p.compute(10L, 10L, 10L, 0L), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74), Prettifier$.MODULE$.default()).should(this.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
        }, new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.test("no estimate when no records in previous batch", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            PIDRateEstimator p = this.createDefaultEstimator();
            p.compute(0L, 10L, 10L, 0L);
            this.convertToAnyShouldWrapper(p.compute(10L, 0L, 10L, 0L), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80), Prettifier$.MODULE$.default()).should(this.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
            return this.convertToAnyShouldWrapper(p.compute(20L, -10L, 10L, 0L), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81), Prettifier$.MODULE$.default()).should(this.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
        }, new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        this.test("no estimate when there is no processing delay", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            PIDRateEstimator p = this.createDefaultEstimator();
            p.compute(0L, 10L, 10L, 0L);
            this.convertToAnyShouldWrapper(p.compute(10L, 10L, 0L, 0L), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87), Prettifier$.MODULE$.default()).should(this.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
            return this.convertToAnyShouldWrapper(p.compute(20L, 10L, -10L, 0L), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88), Prettifier$.MODULE$.default()).should(this.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
        }, new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        this.test("estimate is never less than min rate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double minRate = 5.0;
            PIDRateEstimator p = new PIDRateEstimator(20L, 1.0, 1.0, 0.0, minRate);
            List times = (List)List$.MODULE$.tabulate(50, (Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x -> x * 20);
            List elements = (List)List$.MODULE$.fill(50, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1);
            List proc = (List)List$.MODULE$.fill(50, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 20);
            List sched = (List)List$.MODULE$.fill(50, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 100);
            List res = (List)((List)List$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)50), (Integral)Numeric.IntIsIntegral$.MODULE$)).map((Function1 & Serializable & scala.Serializable)i -> p.compute((long)BoxesRunTime.unboxToInt((Object)times.apply(BoxesRunTime.unboxToInt((Object)i))), (long)BoxesRunTime.unboxToInt((Object)elements.apply(BoxesRunTime.unboxToInt((Object)i))), (long)BoxesRunTime.unboxToInt((Object)proc.apply(BoxesRunTime.unboxToInt((Object)i))), (long)BoxesRunTime.unboxToInt((Object)sched.apply(BoxesRunTime.unboxToInt((Object)i)))), List$.MODULE$.canBuildFrom());
            this.convertToAnyShouldWrapper(res.head(), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102), Prettifier$.MODULE$.default()).should(this.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
            return this.convertToAnyShouldWrapper(res.tail(), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103), Prettifier$.MODULE$.default()).should(this.equal(List$.MODULE$.fill(49, (Function0 & Serializable & scala.Serializable)() -> new Some((Object)BoxesRunTime.boxToDouble((double)minRate)))), (Object)Equality$.MODULE$.default());
        }, new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        this.test("with no accumulated or positive error, |I| > 0, follow the processing speed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            PIDRateEstimator p = new PIDRateEstimator(20L, 1.0, 1.0, 0.0, 10.0);
            List times = (List)List$.MODULE$.tabulate(50, (Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x -> x * 20);
            List elements = (List)List$.MODULE$.tabulate(50, (Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x -> (x + 1) * 20);
            List proc = (List)List$.MODULE$.fill(50, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 20);
            List sched = (List)List$.MODULE$.fill(50, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0);
            List res = (List)((List)List$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)50), (Integral)Numeric.IntIsIntegral$.MODULE$)).map((Function1 & Serializable & scala.Serializable)i -> p.compute((long)BoxesRunTime.unboxToInt((Object)times.apply(BoxesRunTime.unboxToInt((Object)i))), (long)BoxesRunTime.unboxToInt((Object)elements.apply(BoxesRunTime.unboxToInt((Object)i))), (long)BoxesRunTime.unboxToInt((Object)proc.apply(BoxesRunTime.unboxToInt((Object)i))), (long)BoxesRunTime.unboxToInt((Object)sched.apply(BoxesRunTime.unboxToInt((Object)i)))), List$.MODULE$.canBuildFrom());
            this.convertToAnyShouldWrapper(res.head(), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116), Prettifier$.MODULE$.default()).should(this.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
            return this.convertToAnyShouldWrapper(res.tail(), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117), Prettifier$.MODULE$.default()).should(this.equal(((TraversableLike)List$.MODULE$.tabulate(50, (Function1 & Serializable & scala.Serializable)x -> PIDRateEstimatorSuite.$anonfun$new$27(BoxesRunTime.unboxToInt((Object)x)))).tail()), (Object)Equality$.MODULE$.default());
        }, new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        this.test("with no accumulated but some positive error, |I| > 0, follow the processing speed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            PIDRateEstimator p = new PIDRateEstimator(20L, 1.0, 1.0, 0.0, 10.0);
            List times = (List)List$.MODULE$.tabulate(50, (Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x -> x * 20);
            List elements = (List)List$.MODULE$.tabulate(50, (Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x -> (50 - x) * 20);
            List proc = (List)List$.MODULE$.fill(50, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 20);
            List sched = (List)List$.MODULE$.fill(50, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0);
            List res = (List)((List)List$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)50), (Integral)Numeric.IntIsIntegral$.MODULE$)).map((Function1 & Serializable & scala.Serializable)i -> p.compute((long)BoxesRunTime.unboxToInt((Object)times.apply(BoxesRunTime.unboxToInt((Object)i))), (long)BoxesRunTime.unboxToInt((Object)elements.apply(BoxesRunTime.unboxToInt((Object)i))), (long)BoxesRunTime.unboxToInt((Object)proc.apply(BoxesRunTime.unboxToInt((Object)i))), (long)BoxesRunTime.unboxToInt((Object)sched.apply(BoxesRunTime.unboxToInt((Object)i)))), List$.MODULE$.canBuildFrom());
            this.convertToAnyShouldWrapper(res.head(), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131), Prettifier$.MODULE$.default()).should(this.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
            return this.convertToAnyShouldWrapper(res.tail(), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132), Prettifier$.MODULE$.default()).should(this.equal(((TraversableLike)List$.MODULE$.tabulate(50, (Function1 & Serializable & scala.Serializable)x -> PIDRateEstimatorSuite.$anonfun$new$34(BoxesRunTime.unboxToInt((Object)x)))).tail()), (Object)Equality$.MODULE$.default());
        }, new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        this.test("with some accumulated and some positive error, |I| > 0, stay below the processing speed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            double minRate = 10.0;
            PIDRateEstimator p = new PIDRateEstimator(20L, 1.0, 0.01, 0.0, minRate);
            List times = (List)List$.MODULE$.tabulate(50, (Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x -> x * 20);
            Random rng = new Random();
            List elements = (List)List$.MODULE$.tabulate(50, (Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x -> rng.nextInt(1000) + 1000);
            int procDelayMs = 20;
            List proc = (List)List$.MODULE$.fill(50, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> procDelayMs);
            List sched = (List)List$.MODULE$.tabulate(50, (Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x -> rng.nextInt(19) + 1);
            List speeds = (List)elements.map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x -> (double)x / (double)procDelayMs * (double)1000, List$.MODULE$.canBuildFrom());
            List res = (List)((List)List$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)50), (Integral)Numeric.IntIsIntegral$.MODULE$)).map((Function1 & Serializable & scala.Serializable)i -> p.compute((long)BoxesRunTime.unboxToInt((Object)times.apply(BoxesRunTime.unboxToInt((Object)i))), (long)BoxesRunTime.unboxToInt((Object)elements.apply(BoxesRunTime.unboxToInt((Object)i))), (long)BoxesRunTime.unboxToInt((Object)proc.apply(BoxesRunTime.unboxToInt((Object)i))), (long)BoxesRunTime.unboxToInt((Object)sched.apply(BoxesRunTime.unboxToInt((Object)i)))), List$.MODULE$.canBuildFrom());
            this.convertToAnyShouldWrapper(res.head(), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147), Prettifier$.MODULE$.default()).should(this.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
            Inspectors$.MODULE$.forAll((Object)List$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)50), (Integral)Numeric.IntIsIntegral$.MODULE$), (Function1 & Serializable & scala.Serializable)n -> PIDRateEstimatorSuite.$anonfun$new$42(this, res, sched, speeds, minRate, BoxesRunTime.unboxToInt((Object)n)), Collecting$.MODULE$.collectingNatureOfGenTraversable(), InspectorAsserting$.MODULE$.assertingNatureOfT(), Prettifier$.MODULE$.default(), new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        }, new Position("PIDRateEstimatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
    }
}

