/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.deploy.yarn.LocalityPreferredContainerPlacementStrategy;
import org.apache.spark.deploy.yarn.MockResolver;
import org.apache.spark.deploy.yarn.SparkRackResolver;
import org.mockito.Mockito;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u00012Aa\u0001\u0003\u0001\u001f!)A\u0003\u0001C\u0001+!)\u0001\u0004\u0001C\u00053\tqBj\\2bY&$\u0018\u0010\u00157bG\u0016lWM\u001c;TiJ\fG/Z4z'VLG/\u001a\u0006\u0003\u000b\u0019\tA!_1s]*\u0011q\u0001C\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011CE\u0007\u0002\u0011%\u00111\u0003\u0003\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u00051\u0002CA\f\u0001\u001b\u0005!\u0011a\u0002:v]R+7\u000f\u001e\u000b\u00025A\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t!QK\\5u\u0001")
public class LocalityPlacementStrategySuite
extends SparkFunSuite {
    public void org$apache$spark$deploy$yarn$LocalityPlacementStrategySuite$$runTest() {
        YarnConfiguration yarnConf = new YarnConfiguration();
        Resource resource = Resource.newInstance((int)8192, (int)4);
        LocalityPreferredContainerPlacementStrategy strategy = new LocalityPreferredContainerPlacementStrategy(new SparkConf(), (Configuration)yarnConf, resource, (SparkRackResolver)new MockResolver());
        int totalTasks = 32768;
        int totalContainers = totalTasks / 16;
        int totalHosts = totalContainers / 16;
        ContainerId mockId = (ContainerId)Mockito.mock(ContainerId.class);
        Map hosts = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), totalHosts).map((Function1 & Serializable & scala.Serializable)i -> LocalityPlacementStrategySuite.$anonfun$runTest$1(totalTasks, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        IndexedSeq containers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), totalContainers).map((Function1 & Serializable & scala.Serializable)i -> mockId, IndexedSeq$.MODULE$.canBuildFrom());
        int count = containers.size() / hosts.size() / 2;
        HashMap hostToContainerMap = new HashMap();
        ((IterableLike)((IterableLike)hosts.keys().take(hosts.size() / 2)).zipWithIndex(Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LocalityPlacementStrategySuite.$anonfun$runTest$3(containers, count, hostToContainerMap, x0$1);
            return BoxedUnit.UNIT;
        });
        strategy.localityOfRequestedContainers(containers.size() * 2, totalTasks, hosts, hostToContainerMap, (Seq)Nil$.MODULE$);
    }

    public static final /* synthetic */ Tuple2 $anonfun$runTest$1(int totalTasks$1, int i) {
        return new Tuple2((Object)new StringBuilder(5).append("host_").append(i).toString(), (Object)BoxesRunTime.boxToInteger((int)(totalTasks$1 % i)));
    }

    public static final /* synthetic */ void $anonfun$runTest$3(IndexedSeq containers$1, int count$1, HashMap hostToContainerMap$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String host = (String)tuple2._1();
        int i = tuple2._2$mcI$sp();
        HashSet hostContainers = new HashSet();
        ((IterableLike)((IterableLike)containers$1.drop(count$1 * i)).take(i)).foreach((Function1 & Serializable & scala.Serializable)c -> hostContainers.$plus$eq(c));
        hostToContainerMap$1.update((Object)host, (Object)hostContainers);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public LocalityPlacementStrategySuite() {
        this.test("handle large number of containers and tasks (SPARK-18750)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ObjectRef error = ObjectRef.create(null);
            Runnable runnable = new Runnable(this, error){
                private final /* synthetic */ LocalityPlacementStrategySuite $outer;
                private final ObjectRef error$1;

                public void run() {
                    try {
                        this.$outer.org$apache$spark$deploy$yarn$LocalityPlacementStrategySuite$$runTest();
                    }
                    catch (Throwable e) {
                        this.error$1.elem = e;
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.error$1 = error$1;
                }
            };
            Thread thread = new Thread(new ThreadGroup("test"), runnable, "test-thread", 32768L);
            thread.start();
            thread.join();
            if ((Throwable)error.elem != null) {
                StringWriter errors = new StringWriter();
                ((Throwable)error.elem).printStackTrace(new PrintWriter(errors));
                throw this.fail(new StringBuilder(56).append("StackOverflowError should not be thrown; however, got:\n\n").append(errors).toString(), new Position("LocalityPlacementStrategySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
            }
            return BoxedUnit.UNIT;
        }, new Position("LocalityPlacementStrategySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
    }
}

