/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.sparkmeasure;

import ch.cern.sparkmeasure.StageVals;
import ch.cern.sparkmeasure.TaskVals;
import ch.cern.sparkmeasure.Utils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.fasterxml.jackson.module.scala.experimental.ScalaObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Paths;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;

public final class Utils$ {
    public static final Utils$ MODULE$;
    private final ObjectMapper objectMapper;
    private final ObjectWriter objectWriter;

    static {
        new Utils$();
    }

    public ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    public ObjectWriter objectWriter() {
        return this.objectWriter;
    }

    public String formatDuration(long milliseconds) {
        if (milliseconds < 100L) {
            return new StringOps(Predef$.MODULE$.augmentString("%d ms")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)milliseconds)}));
        }
        double seconds = (double)milliseconds / (double)1000;
        if (seconds < 1.0) {
            return new StringOps(Predef$.MODULE$.augmentString("%.1f s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)seconds)}));
        }
        if (seconds < (double)60) {
            return new StringOps(Predef$.MODULE$.augmentString("%.0f s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)seconds)}));
        }
        double minutes = seconds / (double)60;
        if (minutes < (double)10) {
            return new StringOps(Predef$.MODULE$.augmentString("%.1f min")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)minutes)}));
        }
        if (minutes < (double)60) {
            return new StringOps(Predef$.MODULE$.augmentString("%.0f min")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)minutes)}));
        }
        double hours = minutes / (double)60;
        return new StringOps(Predef$.MODULE$.augmentString("%.1f h")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)hours)}));
    }

    public String formatBytes(long bytes) {
        Tuple2 tuple2;
        long trillion = 0x10000000000L;
        long billion = 0x40000000L;
        long million = 0x100000L;
        long thousand = 1024L;
        Tuple2 tuple22 = bytes >= 2L * trillion ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)(bytes / trillion)), (Object)" TB") : (bytes >= 2L * billion ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)(bytes / billion)), (Object)" GB") : (bytes >= 2L * million ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)(bytes / million)), (Object)" MB") : (tuple2 = bytes >= 2L * thousand ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)(bytes / thousand)), (Object)" KB") : new Tuple2((Object)BoxesRunTime.boxToDouble((double)bytes), (Object)" Bytes"))));
        if (tuple2 != null) {
            String unit;
            Tuple2 tuple23;
            double value = tuple2._1$mcD$sp();
            String unit2 = (String)tuple2._2();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)value), (Object)unit2);
            double value2 = tuple24._1$mcD$sp();
            String string = unit = (String)tuple24._2();
            String string2 = " Bytes";
            return !(string != null ? !string.equals(string2) : string2 != null) ? new StringOps(Predef$.MODULE$.augmentString("%d%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((int)value2)), unit})) : new StringOps(Predef$.MODULE$.augmentString("%.1f%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)value2), unit}));
        }
        throw new MatchError((Object)tuple2);
    }

    public String prettyPrintValues(String metric, long value) {
        String name = metric.toLowerCase();
        String basicValue = ((Object)BoxesRunTime.boxToLong((long)value)).toString();
        String optionalValueWithUnits = name.contains("time") || name.contains("duration") ? new StringBuilder().append((Object)" (").append((Object)this.formatDuration(value)).append((Object)")").toString() : (name.contains("bytes") || name.contains("size") ? new StringBuilder().append((Object)" (").append((Object)this.formatBytes(value)).append((Object)")").toString() : "");
        return new StringBuilder().append((Object)metric).append((Object)" => ").append((Object)basicValue).append((Object)optionalValueWithUnits).toString();
    }

    /*
     * WARNING - void declaration
     */
    public <T> ListBuffer<T> readSerialized(String metricsFileName) {
        ListBuffer listBuffer;
        String fullPath = ((Object)Paths.get(metricsFileName, new String[0])).toString();
        Utils.ObjectInputStreamWithCustomClassLoader ois = new Utils.ObjectInputStreamWithCustomClassLoader(new FileInputStream(fullPath));
        try {
            listBuffer = (ListBuffer)ois.readObject();
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        ois.close();
        return listBuffer;
    }

    /*
     * WARNING - void declaration
     */
    public void writeSerialized(String fullPath, Object metricsData) {
        ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(fullPath));
        try {
            os.writeObject(metricsData);
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        os.close();
    }

    public ListBuffer<StageVals> readSerializedStageMetrics(String stageMetricsFileName) {
        return this.readSerialized(stageMetricsFileName);
    }

    public ListBuffer<TaskVals> readSerializedTaskMetrics(String stageMetricsFileName) {
        return this.readSerialized(stageMetricsFileName);
    }

    /*
     * WARNING - void declaration
     */
    public void writeSerializedJSON(String fullPath, Object metricsData) {
        FileOutputStream os = new FileOutputStream(fullPath);
        try {
            this.objectWriter().writeValue((OutputStream)os, metricsData);
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        os.close();
    }

    /*
     * WARNING - void declaration
     */
    public List<StageVals> readSerializedStageMetricsJSON(String stageMetricsFileName) {
        List list;
        String fullPath = ((Object)Paths.get(stageMetricsFileName, new String[0])).toString();
        FileInputStream is = new FileInputStream(fullPath);
        try {
            list = (List)((ScalaObjectMapper)this.objectMapper()).readValue((InputStream)is, ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(StageVals.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        is.close();
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public List<TaskVals> readSerializedTaskMetricsJSON(String taskMetricsFileName) {
        List list;
        String fullPath = ((Object)Paths.get(taskMetricsFileName, new String[0])).toString();
        FileInputStream is = new FileInputStream(fullPath);
        try {
            list = (List)((ScalaObjectMapper)this.objectMapper()).readValue((InputStream)is, ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(TaskVals.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        is.close();
        return list;
    }

    private Utils$() {
        MODULE$ = this;
        this.objectMapper = new ScalaObjectMapper(){
            private final Class<Map<?, ?>> com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$$MAP;
            private final Class<Iterable<?>> com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$$ITERABLE;
            private final Class<Option<?>> com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$$OPTION;

            public Class<Map<?, ?>> com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$$MAP() {
                return this.com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$$MAP;
            }

            public Class<Iterable<?>> com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$$ITERABLE() {
                return this.com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$$ITERABLE;
            }

            public Class<Option<?>> com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$$OPTION() {
                return this.com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$$OPTION;
            }

            public void com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$_setter_$com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$$MAP_$eq(Class x$1) {
                this.com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$$MAP = x$1;
            }

            public void com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$_setter_$com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$$ITERABLE_$eq(Class x$1) {
                this.com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$$ITERABLE = x$1;
            }

            public void com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$_setter_$com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$$OPTION_$eq(Class x$1) {
                this.com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$$OPTION = x$1;
            }

            public final <Target, MixinSource> ObjectMapper addMixin(Manifest<Target> evidence$1, Manifest<MixinSource> evidence$2) {
                return ScalaObjectMapper.class.addMixin((ObjectMapper)this, evidence$1, evidence$2);
            }

            public final <Target, MixinSource> ObjectMapper addMixInAnnotations(Manifest<Target> evidence$3, Manifest<MixinSource> evidence$4) {
                return ScalaObjectMapper.class.addMixInAnnotations((ObjectMapper)this, evidence$3, evidence$4);
            }

            public final <T> Class<?> findMixInClassFor(Manifest<T> evidence$5) {
                return ScalaObjectMapper.class.findMixInClassFor((ObjectMapper)this, evidence$5);
            }

            public <T> JavaType constructType(Manifest<T> m) {
                return ScalaObjectMapper.class.constructType((ObjectMapper)this, m);
            }

            public <T> T readValue(JsonParser jp, Manifest<T> evidence$6) {
                return (T)ScalaObjectMapper.class.readValue((ObjectMapper)this, (JsonParser)jp, evidence$6);
            }

            public <T> MappingIterator<T> readValues(JsonParser jp, Manifest<T> evidence$7) {
                return ScalaObjectMapper.class.readValues((ObjectMapper)this, (JsonParser)jp, evidence$7);
            }

            public <T> T treeToValue(TreeNode n, Manifest<T> evidence$8) {
                return (T)ScalaObjectMapper.class.treeToValue((ObjectMapper)this, (TreeNode)n, evidence$8);
            }

            public <T> boolean canSerialize(Manifest<T> evidence$9) {
                return ScalaObjectMapper.class.canSerialize((ObjectMapper)this, evidence$9);
            }

            public <T> boolean canDeserialize(Manifest<T> evidence$10) {
                return ScalaObjectMapper.class.canDeserialize((ObjectMapper)this, evidence$10);
            }

            public <T> T readValue(File src, Manifest<T> evidence$11) {
                return (T)ScalaObjectMapper.class.readValue((ObjectMapper)this, (File)src, evidence$11);
            }

            public <T> T readValue(URL src, Manifest<T> evidence$12) {
                return (T)ScalaObjectMapper.class.readValue((ObjectMapper)this, (URL)src, evidence$12);
            }

            public <T> T readValue(String content, Manifest<T> evidence$13) {
                return (T)ScalaObjectMapper.class.readValue((ObjectMapper)this, (String)content, evidence$13);
            }

            public <T> T readValue(Reader src, Manifest<T> evidence$14) {
                return (T)ScalaObjectMapper.class.readValue((ObjectMapper)this, (Reader)src, evidence$14);
            }

            public <T> T readValue(InputStream src, Manifest<T> evidence$15) {
                return (T)ScalaObjectMapper.class.readValue((ObjectMapper)this, (InputStream)src, evidence$15);
            }

            public <T> T readValue(byte[] src, Manifest<T> evidence$16) {
                return (T)ScalaObjectMapper.class.readValue((ObjectMapper)this, (byte[])src, evidence$16);
            }

            public <T> T readValue(byte[] src, int offset, int len, Manifest<T> evidence$17) {
                return (T)ScalaObjectMapper.class.readValue((ObjectMapper)this, (byte[])src, (int)offset, (int)len, evidence$17);
            }

            public <T> ObjectWriter writerWithView(Manifest<T> evidence$18) {
                return ScalaObjectMapper.class.writerWithView((ObjectMapper)this, evidence$18);
            }

            public <T> ObjectWriter writerWithType(Manifest<T> evidence$19) {
                return ScalaObjectMapper.class.writerWithType((ObjectMapper)this, evidence$19);
            }

            public <T> ObjectWriter writerFor(Manifest<T> evidence$20) {
                return ScalaObjectMapper.class.writerFor((ObjectMapper)this, evidence$20);
            }

            public <T> ObjectReader reader(Manifest<T> evidence$21) {
                return ScalaObjectMapper.class.reader((ObjectMapper)this, evidence$21);
            }

            public <T> ObjectReader readerFor(Manifest<T> evidence$22) {
                return ScalaObjectMapper.class.readerFor((ObjectMapper)this, evidence$22);
            }

            public <T> ObjectReader readerWithView(Manifest<T> evidence$23) {
                return ScalaObjectMapper.class.readerWithView((ObjectMapper)this, evidence$23);
            }

            public <T> T convertValue(Object fromValue, Manifest<T> evidence$24) {
                return (T)ScalaObjectMapper.class.convertValue((ObjectMapper)this, (Object)fromValue, evidence$24);
            }

            public <T> JsonSchema generateJsonSchema(Manifest<T> evidence$25) {
                return ScalaObjectMapper.class.generateJsonSchema((ObjectMapper)this, evidence$25);
            }

            public <T> void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, Manifest<T> evidence$26) {
                ScalaObjectMapper.class.acceptJsonFormatVisitor((ObjectMapper)this, (JsonFormatVisitorWrapper)visitor, evidence$26);
            }
            {
                ScalaObjectMapper.class.$init$((ObjectMapper)this);
            }
        };
        this.objectMapper().registerModule((Module)DefaultScalaModule$.MODULE$);
        this.objectWriter = this.objectMapper().writer((PrettyPrinter)new DefaultPrettyPrinter());
    }
}

