/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.sparkmeasure;

import ch.cern.sparkmeasure.Utils$;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkConf;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.apache.spark.scheduler.SparkListenerApplicationStart;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerStageSubmitted;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionEnd;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionStart;
import org.influxdb.BatchOptions;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}c\u0001B\u0001\u0003\u0001%\u0011A\"\u00138gYVDHIQ*j].T!a\u0001\u0003\u0002\u0019M\u0004\u0018M]6nK\u0006\u001cXO]3\u000b\u0005\u00151\u0011\u0001B2fe:T\u0011aB\u0001\u0003G\"\u001c\u0001a\u0005\u0002\u0001\u0015A\u00111\u0002F\u0007\u0002\u0019)\u0011QBD\u0001\ng\u000eDW\rZ;mKJT!a\u0004\t\u0002\u000bM\u0004\u0018M]6\u000b\u0005E\u0011\u0012AB1qC\u000eDWMC\u0001\u0014\u0003\ry'oZ\u0005\u0003+1\u0011Qb\u00159be.d\u0015n\u001d;f]\u0016\u0014\b\u0002C\f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r\u0002\t\r|gN\u001a\t\u00033ii\u0011AD\u0005\u000379\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u000bu\u0001A\u0011\u0001\u0010\u0002\rqJg.\u001b;?)\ty\u0012\u0005\u0005\u0002!\u00015\t!\u0001C\u0003\u00189\u0001\u0007\u0001\u0004\u0003\u0005$\u0001!\u0015\r\u0011\"\u0001%\u0003\u0019awnZ4feV\tQ\u0005\u0005\u0002'S5\tqE\u0003\u0002)%\u0005)1\u000f\u001c45U&\u0011!f\n\u0002\u0007\u0019><w-\u001a:\t\u00111\u0002\u0001\u0012!Q!\n\u0015\nq\u0001\\8hO\u0016\u0014\b\u0005C\u0004/\u0001\t\u0007I\u0011A\u0018\u0002\u0007U\u0014H.F\u00011!\t\ttG\u0004\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14'\u0001\u0004Qe\u0016$WMZ\u0005\u0003qe\u0012aa\u0015;sS:<'B\u0001\u001c4\u0011\u0019Y\u0004\u0001)A\u0005a\u0005!QO\u001d7!\u0011)i\u0004\u0001%A\u0001\u0004\u0003\u0006IAP\u0001\u0004q\u0012\n\u0004\u0003\u0002\u001a@aAJ!\u0001Q\u001a\u0003\rQ+\b\u000f\\33\u0011\u001d\u0011\u0005A1A\u0005\u0002=\n\u0001\"^:fe:\fW.\u001a\u0005\u0007\t\u0002\u0001\u000b\u0011\u0002\u0019\u0002\u0013U\u001cXM\u001d8b[\u0016\u0004\u0003b\u0002$\u0001\u0005\u0004%\taL\u0001\ta\u0006\u001c8o^8sI\"1\u0001\n\u0001Q\u0001\nA\n\u0011\u0002]1tg^|'\u000f\u001a\u0011\t\u000f)\u0003!\u0019!C\u0001\u0017\u0006A\u0011N\u001c4mkb$%)F\u0001M!\ti\u0005+D\u0001O\u0015\ty%#\u0001\u0005j]\u001adW\u000f\u001f3c\u0013\t\tfJ\u0001\u0005J]\u001adW\u000f\u001f#C\u0011\u0019\u0019\u0006\u0001)A\u0005\u0019\u0006I\u0011N\u001c4mkb$%\t\t\u0005\b+\u0002\u0011\r\u0011\"\u00010\u0003\u0019!'MT1nK\"1q\u000b\u0001Q\u0001\nA\nq\u0001\u001a2OC6,\u0007\u0005C\u0004Z\u0001\t\u0007I\u0011A&\u0002\u0011\u0011\fG/\u00192bg\u0016Daa\u0017\u0001!\u0002\u0013a\u0015!\u00033bi\u0006\u0014\u0017m]3!\u0011\u001di\u0006A1A\u0005\u0002y\u000bq\u0002\\8h'R\fw-Z'fiJL7m]\u000b\u0002?B\u0011!\u0007Y\u0005\u0003CN\u0012qAQ8pY\u0016\fg\u000e\u0003\u0004d\u0001\u0001\u0006IaX\u0001\u0011Y><7\u000b^1hK6+GO]5dg\u0002Bq!\u001a\u0001A\u0002\u0013\u0005a-A\u0003baBLE-F\u0001h!\tAW.D\u0001j\u0015\tQ7.\u0001\u0003mC:<'\"\u00017\u0002\t)\fg/Y\u0005\u0003q%Dqa\u001c\u0001A\u0002\u0013\u0005\u0001/A\u0005baBLEm\u0018\u0013fcR\u0011\u0011\u000f\u001e\t\u0003eIL!a]\u001a\u0003\tUs\u0017\u000e\u001e\u0005\b{9\f\t\u00111\u0001h\u0011\u00191\b\u0001)Q\u0005O\u00061\u0011\r\u001d9JI\u0002BQ\u0001\u001f\u0001\u0005Be\f\u0001c\u001c8Ti\u0006<WmU;c[&$H/\u001a3\u0015\u0005ET\b\"B>x\u0001\u0004a\u0018AD:uC\u001e,7+\u001e2nSR$X\r\u001a\t\u0003\u0017uL!A \u0007\u00037M\u0003\u0018M]6MSN$XM\\3s'R\fw-Z*vE6LG\u000f^3e\u0011\u001d\t\t\u0001\u0001C!\u0003\u0007\t\u0001c\u001c8Ti\u0006<WmQ8na2,G/\u001a3\u0015\u0007E\f)\u0001C\u0004\u0002\b}\u0004\r!!\u0003\u0002\u001dM$\u0018mZ3D_6\u0004H.\u001a;fIB\u00191\"a\u0003\n\u0007\u00055ABA\u000eTa\u0006\u00148\u000eT5ti\u0016tWM]*uC\u001e,7i\\7qY\u0016$X\r\u001a\u0005\b\u0003#\u0001A\u0011IA\n\u00031ygn\u0014;iKJ,e/\u001a8u)\r\t\u0018Q\u0003\u0005\t\u0003/\ty\u00011\u0001\u0002\u001a\u0005)QM^3oiB\u00191\"a\u0007\n\u0007\u0005uAB\u0001\nTa\u0006\u00148\u000eT5ti\u0016tWM]#wK:$\bbBA\u0011\u0001\u0011\u0005\u00131E\u0001\u000b_:TuNY*uCJ$HcA9\u0002&!A\u0011qEA\u0010\u0001\u0004\tI#\u0001\u0005k_\n\u001cF/\u0019:u!\rY\u00111F\u0005\u0004\u0003[a!!F*qCJ\\G*[:uK:,'OS8c'R\f'\u000f\u001e\u0005\b\u0003c\u0001A\u0011IA\u001a\u0003!ygNS8c\u000b:$GcA9\u00026!A\u0011qGA\u0018\u0001\u0004\tI$\u0001\u0004k_\n,e\u000e\u001a\t\u0004\u0017\u0005m\u0012bAA\u001f\u0019\t\u00192\u000b]1sW2K7\u000f^3oKJTuNY#oI\"9\u0011\u0011\t\u0001\u0005B\u0005\r\u0013AE8o\u0003B\u0004H.[2bi&|gn\u0015;beR$2!]A#\u0011!\t9%a\u0010A\u0002\u0005%\u0013\u0001E1qa2L7-\u0019;j_:\u001cF/\u0019:u!\rY\u00111J\u0005\u0004\u0003\u001bb!!H*qCJ\\G*[:uK:,'/\u00119qY&\u001c\u0017\r^5p]N#\u0018M\u001d;\t\u000f\u0005E\u0003\u0001\"\u0011\u0002T\u0005\u0001rN\\!qa2L7-\u0019;j_:,e\u000e\u001a\u000b\u0004c\u0006U\u0003\u0002CA,\u0003\u001f\u0002\r!!\u0017\u0002\u001d\u0005\u0004\b\u000f\\5dCRLwN\\#oIB\u00191\"a\u0017\n\u0007\u0005uCBA\u000eTa\u0006\u00148\u000eT5ti\u0016tWM]!qa2L7-\u0019;j_:,e\u000e\u001a")
public class InfluxDBSink
extends SparkListener {
    private Logger logger;
    private final String url;
    private final /* synthetic */ Tuple2 x$1;
    private final String username;
    private final String password;
    private final InfluxDB influxDB;
    private final String dbName;
    private final InfluxDB database;
    private final boolean logStageMetrics;
    private String appId;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        InfluxDBSink influxDBSink = this;
        synchronized (influxDBSink) {
            if (!this.bitmap$0) {
                this.logger = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String url() {
        return this.url;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public InfluxDB influxDB() {
        return this.influxDB;
    }

    public String dbName() {
        return this.dbName;
    }

    public InfluxDB database() {
        return this.database;
    }

    public boolean logStageMetrics() {
        return this.logStageMetrics;
    }

    public String appId() {
        return this.appId;
    }

    public void appId_$eq(String x$1) {
        this.appId = x$1;
    }

    public void onStageSubmitted(SparkListenerStageSubmitted stageSubmitted) {
        long submissionTime = BoxesRunTime.unboxToLong((Object)stageSubmitted.stageInfo().submissionTime().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        int attemptNumber = stageSubmitted.stageInfo().attemptNumber();
        int stageId = stageSubmitted.stageInfo().stageId();
        Point point = Point.measurement((String)"stages_started").tag("applicationId", this.appId()).addField("stageId", (long)stageId).addField("attemptNUmber", (long)attemptNumber).time(submissionTime, TimeUnit.MILLISECONDS).build();
        this.database().write(point);
    }

    public void onStageCompleted(SparkListenerStageCompleted stageCompleted) {
        int stageId = stageCompleted.stageInfo().stageId();
        long submissionTime = BoxesRunTime.unboxToLong((Object)stageCompleted.stageInfo().submissionTime().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        long completionTime = BoxesRunTime.unboxToLong((Object)stageCompleted.stageInfo().completionTime().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        int attemptNumber = stageCompleted.stageInfo().attemptNumber();
        Point point1 = Point.measurement((String)"stages_ended").tag("applicationId", this.appId()).time(completionTime, TimeUnit.MILLISECONDS).addField("stageId", (long)stageId).addField("attemptNumber", (long)attemptNumber).addField("submissionTime", submissionTime).build();
        this.database().write(point1);
        if (this.logStageMetrics()) {
            TaskMetrics taskmetrics = stageCompleted.stageInfo().taskMetrics();
            Point point2 = Point.measurement((String)"stage_metrics").tag("applicationId", this.appId()).time(completionTime, TimeUnit.MILLISECONDS).addField("stageId", (long)stageId).addField("attemptNumber", (long)attemptNumber).addField("failureReason", (String)stageCompleted.stageInfo().failureReason().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            })).addField("submissionTime", submissionTime).addField("completionTime", completionTime).addField("executorRunTime", taskmetrics.executorRunTime()).addField("executorCpuTime", taskmetrics.executorCpuTime()).addField("executorDeserializeCpuTime", taskmetrics.executorDeserializeCpuTime()).addField("executorDeserializeTime", taskmetrics.executorDeserializeTime()).addField("jvmGCTime", taskmetrics.jvmGCTime()).addField("memoryBytesSpilled", taskmetrics.memoryBytesSpilled()).addField("peakExecutionMemory", taskmetrics.peakExecutionMemory()).addField("resultSerializationTime", taskmetrics.resultSerializationTime()).addField("resultSize", taskmetrics.resultSize()).addField("bytesRead", taskmetrics.inputMetrics().bytesRead()).addField("recordsRead", taskmetrics.inputMetrics().recordsRead()).addField("bytesWritten", taskmetrics.outputMetrics().bytesWritten()).addField("recordsWritten", taskmetrics.outputMetrics().recordsWritten()).addField("shuffleTotalBytesRead", taskmetrics.shuffleReadMetrics().totalBytesRead()).addField("shuffleRemoteBytesRead", taskmetrics.shuffleReadMetrics().remoteBytesRead()).addField("shuffleLocalBytesRead", taskmetrics.shuffleReadMetrics().localBytesRead()).addField("shuffleTotalBlocksFetched", taskmetrics.shuffleReadMetrics().totalBlocksFetched()).addField("shuffleLocalBlocksFetched", taskmetrics.shuffleReadMetrics().localBlocksFetched()).addField("shuffleRemoteBlocksFetched", taskmetrics.shuffleReadMetrics().remoteBlocksFetched()).addField("shuffleRecordsRead", taskmetrics.shuffleReadMetrics().recordsRead()).addField("shuffleFetchWaitTime", taskmetrics.shuffleReadMetrics().fetchWaitTime()).addField("shuffleBytesWritten", taskmetrics.shuffleWriteMetrics().bytesWritten()).addField("shuffleRecordsWritten", taskmetrics.shuffleWriteMetrics().recordsWritten()).addField("shuffleWriteTime", taskmetrics.shuffleWriteMetrics().writeTime()).build();
            this.database().write(point2);
        }
    }

    public void onOtherEvent(SparkListenerEvent event) {
        SparkListenerEvent sparkListenerEvent = event;
        if (sparkListenerEvent instanceof SparkListenerSQLExecutionStart) {
            SparkListenerSQLExecutionStart sparkListenerSQLExecutionStart = (SparkListenerSQLExecutionStart)sparkListenerEvent;
            long startTime = sparkListenerSQLExecutionStart.time();
            long queryId = sparkListenerSQLExecutionStart.executionId();
            Point point = Point.measurement((String)"queries_started").tag("applicationId", this.appId()).time(startTime, TimeUnit.MILLISECONDS).addField("queryId", queryId).build();
            this.database().write(point);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerSQLExecutionEnd) {
            SparkListenerSQLExecutionEnd sparkListenerSQLExecutionEnd = (SparkListenerSQLExecutionEnd)sparkListenerEvent;
            long endTime = sparkListenerSQLExecutionEnd.time();
            long queryId = sparkListenerSQLExecutionEnd.executionId();
            Point point = Point.measurement((String)"queries_ended").tag("applicationId", this.appId()).time(endTime, TimeUnit.MILLISECONDS).addField("queryId", queryId).build();
            this.database().write(point);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void onJobStart(SparkListenerJobStart jobStart) {
        long startTime = jobStart.time();
        int jobId = jobStart.jobId();
        Point point = Point.measurement((String)"jobs_started").tag("applicationId", this.appId()).time(startTime, TimeUnit.MILLISECONDS).addField("jobID", (long)jobId).build();
        this.database().write(point);
    }

    public void onJobEnd(SparkListenerJobEnd jobEnd) {
        long completionTime = jobEnd.time();
        int jobId = jobEnd.jobId();
        Point point = Point.measurement((String)"jobs_ended").tag("applicationId", this.appId()).time(completionTime, TimeUnit.MILLISECONDS).addField("jobID", (long)jobId).build();
        this.database().write(point);
    }

    public void onApplicationStart(SparkListenerApplicationStart applicationStart) {
        this.appId_$eq((String)applicationStart.appId().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "noAppId";
            }
        }));
    }

    public void onApplicationEnd(SparkListenerApplicationEnd applicationEnd) {
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Spark application ended, timestamp = ", ", closing InfluxDB connection."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)applicationEnd.time())})));
        this.influxDB().close();
    }

    public InfluxDBSink(SparkConf conf) {
        this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Custom monitoring listener with InfluxDB sink initializing, now attempting to connect to InfluxDB"})).s((Seq)Nil$.MODULE$));
        this.url = Utils$.MODULE$.parseInfluxDBURL(conf, this.logger());
        Tuple2<String, String> tuple2 = Utils$.MODULE$.parseInfluxDBCredentials(conf, this.logger());
        if (tuple2 != null) {
            String string;
            Tuple2 tuple22;
            String username = (String)tuple2._1();
            String password = (String)tuple2._2();
            this.x$1 = tuple22 = new Tuple2((Object)username, (Object)password);
            this.username = (String)this.x$1._1();
            this.password = (String)this.x$1._2();
            String string2 = this.username();
            InfluxDB influxDB = string2.isEmpty() ? InfluxDBFactory.connect((String)this.url()) : InfluxDBFactory.connect((String)this.url(), (String)this.username(), (String)this.password());
            this.influxDB = influxDB;
            this.dbName = Utils$.MODULE$.parseInfluxDBName(conf, this.logger());
            if (!this.influxDB().databaseExists(this.dbName())) {
                this.influxDB().createDatabase(this.dbName());
            }
            this.database = this.influxDB().setDatabase(this.dbName());
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"using INfluxDB database ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dbName()})));
            this.logStageMetrics = Utils$.MODULE$.parseInfluxDBStagemetrics(conf, this.logger());
            this.influxDB().enableBatch(BatchOptions.DEFAULTS.actions(1000).flushDuration(1000));
            this.appId = "noAppId";
            Option option = SparkSession$.MODULE$.getActiveSession();
            if (option instanceof Some) {
                Some some = (Some)option;
                SparkSession sparkSession = (SparkSession)some.x();
                string = sparkSession.sparkContext().applicationId();
            } else {
                string = "noAppId";
            }
            this.appId_$eq(string);
            return;
        }
        throw new MatchError(tuple2);
    }
}

