/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.sparkmeasure;

import ch.cern.sparkmeasure.InfluxDBSink;
import ch.cern.sparkmeasure.Utils$;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkConf;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.scheduler.SparkListenerTaskStart;
import org.apache.spark.scheduler.TaskInfo;
import org.influxdb.dto.Point;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001a2A!\u0001\u0002\u0001\u0013\t!\u0012J\u001c4mkb$%iU5oW\u0016CH/\u001a8eK\u0012T!a\u0001\u0003\u0002\u0019M\u0004\u0018M]6nK\u0006\u001cXO]3\u000b\u0005\u00151\u0011\u0001B2fe:T\u0011aB\u0001\u0003G\"\u001c\u0001a\u0005\u0002\u0001\u0015A\u00111\u0002D\u0007\u0002\u0005%\u0011QB\u0001\u0002\r\u0013:4G.\u001e=E\u0005NKgn\u001b\u0005\t\u001f\u0001\u0011\t\u0011)A\u0005!\u0005!1m\u001c8g!\t\t\u0002$D\u0001\u0013\u0015\t\u0019B#A\u0003ta\u0006\u00148N\u0003\u0002\u0016-\u00051\u0011\r]1dQ\u0016T\u0011aF\u0001\u0004_J<\u0017BA\r\u0013\u0005%\u0019\u0006/\u0019:l\u0007>tg\rC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0003;y\u0001\"a\u0003\u0001\t\u000b=Q\u0002\u0019\u0001\t\t\u000b\u0001\u0002A\u0011I\u0011\u0002\u0017=tG+Y:l'R\f'\u000f\u001e\u000b\u0003E!\u0002\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u0012A!\u00168ji\")\u0011f\ba\u0001U\u0005IA/Y:l'R\f'\u000f\u001e\t\u0003W9j\u0011\u0001\f\u0006\u0003[I\t\u0011b]2iK\u0012,H.\u001a:\n\u0005=b#AF*qCJ\\G*[:uK:,'\u000fV1tWN#\u0018M\u001d;\t\u000bE\u0002A\u0011\t\u001a\u0002\u0013=tG+Y:l\u000b:$GC\u0001\u00124\u0011\u0015!\u0004\u00071\u00016\u0003\u001d!\u0018m]6F]\u0012\u0004\"a\u000b\u001c\n\u0005]b#\u0001F*qCJ\\G*[:uK:,'\u000fV1tW\u0016sG\r")
public class InfluxDBSinkExtended
extends InfluxDBSink {
    public void onTaskStart(SparkListenerTaskStart taskStart) {
        TaskInfo taskInfo = taskStart.taskInfo();
        Point point = Point.measurement((String)"tasks_started").tag("applicationId", this.appId()).time(taskInfo.launchTime(), TimeUnit.MICROSECONDS).addField("taskId", taskInfo.taskId()).addField("attemptNumber", (long)taskInfo.attemptNumber()).addField("stageId", (long)taskStart.stageId()).build();
        this.database().write(point);
    }

    public void onTaskEnd(SparkListenerTaskEnd taskEnd) {
        TaskInfo taskInfo = taskEnd.taskInfo();
        TaskMetrics taskmetrics = taskEnd.taskMetrics();
        Point point1 = Point.measurement((String)"tasks_ended").tag("applicationId", this.appId()).time(taskInfo.finishTime(), TimeUnit.MILLISECONDS).addField("taskId", taskInfo.taskId()).addField("attemptNumber", (long)taskInfo.attemptNumber()).addField("launchTime", taskInfo.launchTime()).addField("stageId", (long)taskEnd.stageId()).build();
        this.database().write(point1);
        Point point2 = Point.measurement((String)"task_metrics").tag("applicationId", this.appId()).time(taskInfo.finishTime(), TimeUnit.MILLISECONDS).addField("taskId", taskInfo.taskId()).addField("attemptNumber", (long)taskInfo.attemptNumber()).addField("stageId", (long)taskEnd.stageId()).addField("launchTime", taskInfo.launchTime()).addField("completionTime", taskInfo.finishTime()).addField("failed", taskInfo.failed()).addField("speculative", taskInfo.speculative()).addField("killed", taskInfo.killed()).addField("finished", taskInfo.finished()).addField("executorId", taskInfo.executorId()).addField("duration", taskInfo.duration()).addField("successful", taskInfo.successful()).addField("host", taskInfo.host()).addField("taskLocality", (long)Utils$.MODULE$.encodeTaskLocality(taskInfo.taskLocality())).addField("executorRunTime", taskmetrics.executorRunTime()).addField("executorCpuTime", taskmetrics.executorCpuTime()).addField("executorDeserializeCpuTime", taskmetrics.executorDeserializeCpuTime()).addField("executorDeserializeTime", taskmetrics.executorDeserializeTime()).addField("jvmGCTime", taskmetrics.jvmGCTime()).addField("memoryBytesSpilled", taskmetrics.memoryBytesSpilled()).addField("peakExecutionMemory", taskmetrics.peakExecutionMemory()).addField("resultSerializationTime", taskmetrics.resultSerializationTime()).addField("resultSize", taskmetrics.resultSize()).addField("bytesRead", taskmetrics.inputMetrics().bytesRead()).addField("recordsRead", taskmetrics.inputMetrics().recordsRead()).addField("bytesWritten", taskmetrics.outputMetrics().bytesWritten()).addField("recordsWritten", taskmetrics.outputMetrics().recordsWritten()).addField("shuffleTotalBytesRead", taskmetrics.shuffleReadMetrics().totalBytesRead()).addField("shuffleRemoteBytesRead", taskmetrics.shuffleReadMetrics().remoteBytesRead()).addField("shuffleLocalBytesRead", taskmetrics.shuffleReadMetrics().localBytesRead()).addField("shuffleTotalBlocksFetched", taskmetrics.shuffleReadMetrics().totalBlocksFetched()).addField("shuffleLocalBlocksFetched", taskmetrics.shuffleReadMetrics().localBlocksFetched()).addField("shuffleRemoteBlocksFetched", taskmetrics.shuffleReadMetrics().remoteBlocksFetched()).addField("shuffleRecordsRead", taskmetrics.shuffleReadMetrics().recordsRead()).addField("shuffleFetchWaitTime", taskmetrics.shuffleReadMetrics().fetchWaitTime()).addField("shuffleBytesWritten", taskmetrics.shuffleWriteMetrics().bytesWritten()).addField("shuffleRecordsWritten", taskmetrics.shuffleWriteMetrics().recordsWritten()).addField("shuffleWriteTime", taskmetrics.shuffleWriteMetrics().writeTime()).build();
        this.database().write(point2);
    }

    public InfluxDBSinkExtended(SparkConf conf) {
        super(conf);
    }
}

