/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.sparkmeasure;

import org.apache.spark.SparkConf;
import org.apache.spark.scheduler.TaskLocality$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Utils$ {
    public static final Utils$ MODULE$;

    static {
        new Utils$();
    }

    public String formatDuration(long milliseconds) {
        if (milliseconds < 100L) {
            return new StringOps(Predef$.MODULE$.augmentString("%d ms")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)milliseconds)}));
        }
        double seconds = (double)milliseconds / (double)1000;
        if (seconds < 1.0) {
            return new StringOps(Predef$.MODULE$.augmentString("%.1f s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)seconds)}));
        }
        if (seconds < (double)60) {
            return new StringOps(Predef$.MODULE$.augmentString("%.0f s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)seconds)}));
        }
        double minutes = seconds / (double)60;
        if (minutes < (double)10) {
            return new StringOps(Predef$.MODULE$.augmentString("%.1f min")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)minutes)}));
        }
        if (minutes < (double)60) {
            return new StringOps(Predef$.MODULE$.augmentString("%.0f min")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)minutes)}));
        }
        double hours = minutes / (double)60;
        return new StringOps(Predef$.MODULE$.augmentString("%.1f h")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)hours)}));
    }

    public String formatBytes(long bytes) {
        Tuple2 tuple2;
        long trillion = 0x10000000000L;
        long billion = 0x40000000L;
        long million = 0x100000L;
        long thousand = 1024L;
        Tuple2 tuple22 = bytes >= 2L * trillion ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)(bytes / trillion)), (Object)" TB") : (bytes >= 2L * billion ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)(bytes / billion)), (Object)" GB") : (bytes >= 2L * million ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)(bytes / million)), (Object)" MB") : (tuple2 = bytes >= 2L * thousand ? new Tuple2((Object)BoxesRunTime.boxToDouble((double)(bytes / thousand)), (Object)" KB") : new Tuple2((Object)BoxesRunTime.boxToDouble((double)bytes), (Object)" Bytes"))));
        if (tuple2 != null) {
            String unit;
            Tuple2 tuple23;
            double value = tuple2._1$mcD$sp();
            String unit2 = (String)tuple2._2();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)value), (Object)unit2);
            double value2 = tuple24._1$mcD$sp();
            String string = unit = (String)tuple24._2();
            String string2 = " Bytes";
            return !(string != null ? !string.equals(string2) : string2 != null) ? new StringOps(Predef$.MODULE$.augmentString("%d%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((int)value2)), unit})) : new StringOps(Predef$.MODULE$.augmentString("%.1f%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)value2), unit}));
        }
        throw new MatchError((Object)tuple2);
    }

    public String prettyPrintValues(String metric, long value) {
        String name = metric.toLowerCase();
        String basicValue = ((Object)BoxesRunTime.boxToLong((long)value)).toString();
        String optionalValueWithUnits = name.contains("time") || name.contains("duration") ? new StringBuilder().append((Object)" (").append((Object)this.formatDuration(value)).append((Object)")").toString() : (name.contains("bytes") || name.contains("size") ? new StringBuilder().append((Object)" (").append((Object)this.formatBytes(value)).append((Object)")").toString() : "");
        return new StringBuilder().append((Object)metric).append((Object)" => ").append((Object)basicValue).append((Object)optionalValueWithUnits).toString();
    }

    public int encodeTaskLocality(Enumeration.Value taskLocality) {
        int n;
        Enumeration.Value value = taskLocality;
        Enumeration.Value value2 = TaskLocality$.MODULE$.PROCESS_LOCAL();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            n = 0;
        } else {
            Enumeration.Value value4 = TaskLocality$.MODULE$.NODE_LOCAL();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                n = 1;
            } else {
                Enumeration.Value value6 = TaskLocality$.MODULE$.RACK_LOCAL();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    n = 2;
                } else {
                    Enumeration.Value value8 = TaskLocality$.MODULE$.NO_PREF();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        n = 3;
                    } else {
                        Enumeration.Value value10 = TaskLocality$.MODULE$.ANY();
                        Enumeration.Value value11 = value;
                        n = !(value10 != null ? !value10.equals(value11) : value11 != null) ? 4 : -1;
                    }
                }
            }
        }
        return n;
    }

    public String parseMetricsFormat(SparkConf conf, Logger logger, String defaultFormat) {
        String metricsFormat = conf.get("spark.sparkmeasure.outputFormat", defaultFormat);
        String string = metricsFormat;
        boolean bl = "json".equals(string) ? true : ("java".equals(string) ? true : "json_to_hadoop".equals(string));
        if (bl) {
            logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using ", " as serialization format."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metricsFormat})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            logger.warn(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid serialization format: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metricsFormat}))).append((Object)" Configure with: spark.sparkmeasure.outputFormat=json|javaser|json_to_hadoop").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return metricsFormat;
    }

    public boolean parsePrintToStdout(SparkConf conf, Logger logger, boolean defaultVal) {
        boolean printToStdout = conf.getBoolean("spark.sparkmeasure.printToStdout", defaultVal);
        if (printToStdout) {
            logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Will print metrics output to stdout in JSON format"})).s((Seq)Nil$.MODULE$));
        }
        return printToStdout;
    }

    public String parseMetricsFilename(SparkConf conf, Logger logger, String defaultFileName) {
        String metricsFileName = conf.get("spark.sparkmeasure.outputFilename", defaultFileName);
        if (metricsFileName.isEmpty()) {
            logger.warn("No output file will be written. If you want to write the output to a file, configure with spark.sparkmeasure.outputFilename=<output file>");
        } else {
            logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing output to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metricsFileName})));
        }
        return metricsFileName;
    }

    /*
     * WARNING - void declaration
     */
    public String parseInfluxDBURL(SparkConf conf, Logger logger) {
        void var3_3;
        String influxdbURL = conf.get("spark.sparkmeasure.influxdbURL", "");
        if (influxdbURL.isEmpty()) {
            logger.error("InfluxDB URL not found, this will make the listener fail.");
            throw new RuntimeException();
        }
        logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found URL for InfluxDB: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{influxdbURL})));
        return var3_3;
    }

    public Tuple2<String, String> parseInfluxDBCredentials(SparkConf conf, Logger logger) {
        String influxdbUsername = conf.get("spark.sparkmeasure.influxdbUsername", "");
        String influxdbPassword = conf.get("spark.sparkmeasure.influxdbPassword", "");
        if (influxdbUsername.isEmpty() && influxdbPassword.isEmpty()) {
            logger.warn("Credentials for InfluxDB connection not found, using empty username and password, InfluxDB must be running with auth-enabled=false");
        } else {
            logger.info("Credentials for InfluxDB connection found");
        }
        return new Tuple2((Object)influxdbUsername, (Object)influxdbPassword);
    }

    /*
     * WARNING - void declaration
     */
    public String parseInfluxDBName(SparkConf conf, Logger logger) {
        void var3_3;
        String influxdbName = conf.get("spark.sparkmeasure.influxdbName", "sparkmeasure");
        logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"InfluxDB name: s", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{influxdbName})));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public boolean parseInfluxDBStagemetrics(SparkConf conf, Logger logger) {
        void var3_3;
        boolean influxdbStagemetrics = conf.getBoolean("spark.sparkmeasure.influxdbStagemetrics", false);
        logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log also stagemetrics: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Object)BoxesRunTime.boxToBoolean((boolean)influxdbStagemetrics)).toString()})));
        return (boolean)var3_3;
    }

    private Utils$() {
        MODULE$ = this;
    }
}

