/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.sparkmeasure;

import ch.cern.sparkmeasure.IOUtils$;
import ch.cern.sparkmeasure.StageInfoRecorderListener;
import ch.cern.sparkmeasure.Utils$;
import org.apache.spark.SparkConf;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001M3A!\u0001\u0002\u0001\u0013\tQb\t\\5hQR\u0014VmY8sI\u0016\u00148\u000b^1hK6+GO]5dg*\u00111\u0001B\u0001\rgB\f'o[7fCN,(/\u001a\u0006\u0003\u000b\u0019\tAaY3s]*\tq!\u0001\u0002dQ\u000e\u00011C\u0001\u0001\u000b!\tYA\"D\u0001\u0003\u0013\ti!AA\rTi\u0006<W-\u00138g_J+7m\u001c:eKJd\u0015n\u001d;f]\u0016\u0014\b\u0002C\b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\t\u0002\t\r|gN\u001a\t\u0003#ai\u0011A\u0005\u0006\u0003'Q\tQa\u001d9be.T!!\u0006\f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0012aA8sO&\u0011\u0011D\u0005\u0002\n'B\f'o[\"p]\u001aDQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtDCA\u000f\u001f!\tY\u0001\u0001C\u0003\u00105\u0001\u0007\u0001\u0003\u0003\u0005!\u0001!\u0015\r\u0011\"\u0001\"\u0003\u0019awnZ4feV\t!\u0005\u0005\u0002$M5\tAE\u0003\u0002&-\u0005)1\u000f\u001c45U&\u0011q\u0005\n\u0002\u0007\u0019><w-\u001a:\t\u0011%\u0002\u0001\u0012!Q!\n\t\nq\u0001\\8hO\u0016\u0014\b\u0005C\u0004,\u0001\t\u0007I\u0011\u0001\u0017\u0002\u001b5,GO]5dg\u001a{'/\\1u+\u0005i\u0003C\u0001\u00185\u001d\ty#'D\u00011\u0015\u0005\t\u0014!B:dC2\f\u0017BA\u001a1\u0003\u0019\u0001&/\u001a3fM&\u0011QG\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005M\u0002\u0004B\u0002\u001d\u0001A\u0003%Q&\u0001\bnKR\u0014\u0018nY:G_Jl\u0017\r\u001e\u0011\t\u000fi\u0002!\u0019!C\u0001Y\u0005yQ.\u001a;sS\u000e\u001ch)\u001b7f]\u0006lW\r\u0003\u0004=\u0001\u0001\u0006I!L\u0001\u0011[\u0016$(/[2t\r&dWM\\1nK\u0002BqA\u0010\u0001C\u0002\u0013\u0005q(A\u0007qe&tG\u000fV8Ti\u0012|W\u000f^\u000b\u0002\u0001B\u0011q&Q\u0005\u0003\u0005B\u0012qAQ8pY\u0016\fg\u000e\u0003\u0004E\u0001\u0001\u0006I\u0001Q\u0001\u000faJLg\u000e\u001e+p'R$w.\u001e;!\u0011\u00151\u0005\u0001\"\u0011H\u0003Ayg.\u00119qY&\u001c\u0017\r^5p]\u0016sG\r\u0006\u0002I\u0017B\u0011q&S\u0005\u0003\u0015B\u0012A!\u00168ji\")A*\u0012a\u0001\u001b\u0006q\u0011\r\u001d9mS\u000e\fG/[8o\u000b:$\u0007C\u0001(R\u001b\u0005y%B\u0001)\u0013\u0003%\u00198\r[3ek2,'/\u0003\u0002S\u001f\nY2\u000b]1sW2K7\u000f^3oKJ\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8F]\u0012\u0004")
public class FlightRecorderStageMetrics
extends StageInfoRecorderListener {
    private final SparkConf conf;
    private Logger logger;
    private final String metricsFormat;
    private final String metricsFilename;
    private final boolean printToStdout;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        FlightRecorderStageMetrics flightRecorderStageMetrics = this;
        synchronized (flightRecorderStageMetrics) {
            if (!this.bitmap$0) {
                this.logger = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String metricsFormat() {
        return this.metricsFormat;
    }

    public String metricsFilename() {
        return this.metricsFilename;
    }

    public boolean printToStdout() {
        return this.printToStdout;
    }

    public void onApplicationEnd(SparkListenerApplicationEnd applicationEnd) {
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Spark application ended, timestamp = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)applicationEnd.time())})));
        if (this.printToStdout()) {
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Printing Stage metrics values serialized to JSON to stdout"})).s((Seq)Nil$.MODULE$));
            String stringMetrics = IOUtils$.MODULE$.writeToStringSerializedJSON(new Tuple2((Object)this.metricsFilename(), this.stageMetricsData()));
            Predef$.MODULE$.print((Object)"Stage metrics values serialized to JSON:");
            Predef$.MODULE$.print((Object)stringMetrics);
        }
        if (this.metricsFilename().isEmpty()) {
            this.logger().warn("No Stage Metrics output file written.");
        } else {
            String string = this.metricsFormat();
            if ("json".equals(string)) {
                this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing Stage Metrics data serialized as json to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.metricsFilename()})));
                IOUtils$.MODULE$.writeSerializedJSON(this.metricsFilename(), this.stageMetricsData());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if ("java".equals(string)) {
                this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing Stage Metrics data serialized with java serialization to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.metricsFilename()})));
                IOUtils$.MODULE$.writeSerialized(this.metricsFilename(), this.stageMetricsData());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if ("json_to_hadoop".equals(string)) {
                this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing Stage Metrics data with json serialization to Hadoop filesystem to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.metricsFilename()})));
                IOUtils$.MODULE$.writeSerializedJSONToHadoop(this.metricsFilename(), this.stageMetricsData(), this.conf);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"StageMetrics data could not be written"})).s((Seq)Nil$.MODULE$));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public FlightRecorderStageMetrics(SparkConf conf) {
        this.conf = conf;
        this.metricsFormat = Utils$.MODULE$.parseMetricsFormat(conf, this.logger(), "json");
        this.metricsFilename = Utils$.MODULE$.parseMetricsFilename(conf, this.logger(), "/tmp/stageMetrics_flightRecorder");
        this.printToStdout = Utils$.MODULE$.parsePrintToStdout(conf, this.logger(), false);
    }
}

