/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.sparkmeasure;

import ch.cern.sparkmeasure.IOUtils$;
import ch.cern.sparkmeasure.TaskInfoRecorderListener;
import ch.cern.sparkmeasure.TaskInfoRecorderListener$;
import ch.cern.sparkmeasure.Utils$;
import org.apache.spark.SparkConf;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001M3A!\u0001\u0002\u0001\u0013\tIb\t\\5hQR\u0014VmY8sI\u0016\u0014H+Y:l\u001b\u0016$(/[2t\u0015\t\u0019A!\u0001\u0007ta\u0006\u00148.\\3bgV\u0014XM\u0003\u0002\u0006\r\u0005!1-\u001a:o\u0015\u00059\u0011AA2i\u0007\u0001\u0019\"\u0001\u0001\u0006\u0011\u0005-aQ\"\u0001\u0002\n\u00055\u0011!\u0001\u0007+bg.LeNZ8SK\u000e|'\u000fZ3s\u0019&\u001cH/\u001a8fe\"Aq\u0002\u0001B\u0001B\u0003%\u0001#\u0001\u0003d_:4\u0007CA\t\u0019\u001b\u0005\u0011\"BA\n\u0015\u0003\u0015\u0019\b/\u0019:l\u0015\t)b#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002/\u0005\u0019qN]4\n\u0005e\u0011\"!C*qCJ\\7i\u001c8g\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\u0011QD\b\t\u0003\u0017\u0001AQa\u0004\u000eA\u0002AA\u0001\u0002\t\u0001\t\u0006\u0004%\t!I\u0001\u0007Y><w-\u001a:\u0016\u0003\t\u0002\"a\t\u0014\u000e\u0003\u0011R!!\n\f\u0002\u000bMdg\r\u000e6\n\u0005\u001d\"#A\u0002'pO\u001e,'\u000f\u0003\u0005*\u0001!\u0005\t\u0015)\u0003#\u0003\u001dawnZ4fe\u0002Bqa\u000b\u0001C\u0002\u0013\u0005A&A\u0007nKR\u0014\u0018nY:G_Jl\u0017\r^\u000b\u0002[A\u0011a\u0006\u000e\b\u0003_Ij\u0011\u0001\r\u0006\u0002c\u0005)1oY1mC&\u00111\u0007M\u0001\u0007!J,G-\u001a4\n\u0005U2$AB*ue&twM\u0003\u00024a!1\u0001\b\u0001Q\u0001\n5\na\"\\3ue&\u001c7OR8s[\u0006$\b\u0005C\u0004;\u0001\t\u0007I\u0011\u0001\u0017\u0002\u001f5,GO]5dg\u001aKG.\u001a8b[\u0016Da\u0001\u0010\u0001!\u0002\u0013i\u0013\u0001E7fiJL7m\u001d$jY\u0016t\u0017-\\3!\u0011\u001dq\u0004A1A\u0005\u0002}\nQ\u0002\u001d:j]R$vn\u0015;e_V$X#\u0001!\u0011\u0005=\n\u0015B\u0001\"1\u0005\u001d\u0011un\u001c7fC:Da\u0001\u0012\u0001!\u0002\u0013\u0001\u0015A\u00049sS:$Hk\\*uI>,H\u000f\t\u0005\u0006\r\u0002!\teR\u0001\u0011_:\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8F]\u0012$\"\u0001S&\u0011\u0005=J\u0015B\u0001&1\u0005\u0011)f.\u001b;\t\u000b1+\u0005\u0019A'\u0002\u001d\u0005\u0004\b\u000f\\5dCRLwN\\#oIB\u0011a*U\u0007\u0002\u001f*\u0011\u0001KE\u0001\ng\u000eDW\rZ;mKJL!AU(\u00037M\u0003\u0018M]6MSN$XM\\3s\u0003B\u0004H.[2bi&|g.\u00128e\u0001")
public class FlightRecorderTaskMetrics
extends TaskInfoRecorderListener {
    private final SparkConf conf;
    private Logger logger;
    private final String metricsFormat;
    private final String metricsFilename;
    private final boolean printToStdout;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        FlightRecorderTaskMetrics flightRecorderTaskMetrics = this;
        synchronized (flightRecorderTaskMetrics) {
            if (!this.bitmap$0) {
                this.logger = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String metricsFormat() {
        return this.metricsFormat;
    }

    public String metricsFilename() {
        return this.metricsFilename;
    }

    public boolean printToStdout() {
        return this.printToStdout;
    }

    public void onApplicationEnd(SparkListenerApplicationEnd applicationEnd) {
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Spark application ended, timestamp = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)applicationEnd.time())})));
        if (this.printToStdout()) {
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Printing Task metrics values serialized to JSON to stdout"})).s((Seq)Nil$.MODULE$));
            String stringMetrics = IOUtils$.MODULE$.writeToStringSerializedJSON(new Tuple2((Object)this.metricsFilename(), this.taskMetricsData()));
            Predef$.MODULE$.print((Object)"Task metrics values serialized to JSON:");
            Predef$.MODULE$.print((Object)stringMetrics);
        }
        if (this.metricsFilename().isEmpty()) {
            this.logger().warn("No Task Metrics output file written.");
        } else {
            String string = this.metricsFormat();
            if ("json".equals(string)) {
                this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing Task Metrics data serialized as json to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.metricsFilename()})));
                IOUtils$.MODULE$.writeSerializedJSON(this.metricsFilename(), this.taskMetricsData());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if ("java".equals(string)) {
                this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing Task Metrics data serialized with java serialization to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.metricsFilename()})));
                IOUtils$.MODULE$.writeSerialized(this.metricsFilename(), this.taskMetricsData());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if ("json_to_hadoop".equals(string)) {
                this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing Task Metrics data with json serialization to Hadoop filesystem to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.metricsFilename()})));
                IOUtils$.MODULE$.writeSerializedJSONToHadoop(this.metricsFilename(), this.taskMetricsData(), this.conf);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"StageMetrics data could not be written"})).s((Seq)Nil$.MODULE$));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public FlightRecorderTaskMetrics(SparkConf conf) {
        this.conf = conf;
        super(TaskInfoRecorderListener$.MODULE$.$lessinit$greater$default$1());
        this.metricsFormat = Utils$.MODULE$.parseMetricsFormat(conf, this.logger(), "json");
        this.metricsFilename = Utils$.MODULE$.parseMetricsFilename(conf, this.logger(), "/tmp/taskMetrics_flightRecorder");
        this.printToStdout = Utils$.MODULE$.parsePrintToStdout(conf, this.logger(), false);
    }
}

