/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.sparkmeasure;

import ch.cern.sparkmeasure.IOUtils;
import ch.cern.sparkmeasure.StageVals;
import ch.cern.sparkmeasure.TaskVals;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.fasterxml.jackson.module.scala.experimental.ScalaObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.file.Paths;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;

public final class IOUtils$ {
    public static final IOUtils$ MODULE$;
    private final ObjectMapper objectMapper;
    private final ObjectWriter objectWriter;

    static {
        new IOUtils$();
    }

    public ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    public ObjectWriter objectWriter() {
        return this.objectWriter;
    }

    /*
     * WARNING - void declaration
     */
    public <T> ListBuffer<T> readSerialized(String metricsFileName) {
        ListBuffer listBuffer;
        String fullPath = metricsFileName;
        IOUtils.ObjectInputStreamWithCustomClassLoader ois = new IOUtils.ObjectInputStreamWithCustomClassLoader(new FileInputStream(fullPath));
        try {
            listBuffer = (ListBuffer)ois.readObject();
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        ois.close();
        return listBuffer;
    }

    /*
     * WARNING - void declaration
     */
    public void writeSerialized(String fullPath, Object metricsData) {
        ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(fullPath));
        try {
            os.writeObject(metricsData);
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        os.close();
    }

    public ListBuffer<StageVals> readSerializedStageMetrics(String stageMetricsFileName) {
        return this.readSerialized(stageMetricsFileName);
    }

    public ListBuffer<TaskVals> readSerializedTaskMetrics(String stageMetricsFileName) {
        return this.readSerialized(stageMetricsFileName);
    }

    /*
     * WARNING - void declaration
     */
    public void writeSerializedJSON(String fullPath, Object metricsData) {
        FileOutputStream os = new FileOutputStream(fullPath);
        try {
            this.objectWriter().writeValue((OutputStream)os, metricsData);
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        os.close();
    }

    /*
     * WARNING - void declaration
     */
    public void writeSerializedJSONToHadoop(String fullPath, Object metricsData, SparkConf conf) {
        URI fullPathUri = URI.create(fullPath);
        Path hdfswritepath = new Path(fullPath);
        Configuration hadoopConf = new Configuration();
        String keyId = System.getenv("AWS_ACCESS_KEY_ID");
        String accessKey = System.getenv("AWS_SECRET_ACCESS_KEY");
        if (keyId != null && accessKey != null) {
            hadoopConf.set("fs.s3.awsAccessKeyId", keyId);
            hadoopConf.set("fs.s3n.awsAccessKeyId", keyId);
            hadoopConf.set("fs.s3a.access.key", keyId);
            hadoopConf.set("fs.s3.awsSecretAccessKey", accessKey);
            hadoopConf.set("fs.s3n.awsSecretAccessKey", accessKey);
            hadoopConf.set("fs.s3a.secret.key", accessKey);
            String sessionToken = System.getenv("AWS_SESSION_TOKEN");
            if (sessionToken != null) {
                hadoopConf.set("fs.s3a.session.token", sessionToken);
            }
        }
        Predef$.MODULE$.refArrayOps((Object[])conf.getAll()).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> check$ifrefutable$1) {
                Tuple2<String, String> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> x$1) {
                Tuple2<String, String> tuple2 = x$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    boolean bl = key.startsWith("spark.hadoop.");
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        }).foreach((Function1)new Serializable(hadoopConf){
            public static final long serialVersionUID = 0L;
            private final Configuration hadoopConf$1;

            public final void apply(Tuple2<String, String> x$2) {
                Tuple2<String, String> tuple2 = x$2;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    this.hadoopConf$1.set(key.substring("spark.hadoop.".length()), value);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.hadoopConf$1 = hadoopConf$1;
            }
        });
        String serializedMetrics = this.writeToStringSerializedJSON(metricsData);
        FileSystem fs = FileSystem.get((URI)fullPathUri, (Configuration)hadoopConf);
        FSDataOutputStream outputStream = fs.create(hdfswritepath);
        try {
            outputStream.writeBytes(serializedMetrics);
        }
        catch (Throwable throwable) {
            void var12_12;
            var12_12.close();
            throw throwable;
        }
        outputStream.close();
    }

    public String writeToStringSerializedJSON(Object metricsData) {
        return this.objectWriter().writeValueAsString(metricsData);
    }

    /*
     * WARNING - void declaration
     */
    public List<StageVals> readSerializedStageMetricsJSON(String stageMetricsFileName) {
        List list;
        String fullPath = ((Object)Paths.get(stageMetricsFileName, new String[0])).toString();
        FileInputStream is = new FileInputStream(fullPath);
        try {
            list = (List)((ScalaObjectMapper)this.objectMapper()).readValue((InputStream)is, ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(StageVals.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        is.close();
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public List<TaskVals> readSerializedTaskMetricsJSON(String taskMetricsFileName) {
        List list;
        String fullPath = ((Object)Paths.get(taskMetricsFileName, new String[0])).toString();
        FileInputStream is = new FileInputStream(fullPath);
        try {
            list = (List)((ScalaObjectMapper)this.objectMapper()).readValue((InputStream)is, ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(TaskVals.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        is.close();
        return list;
    }

    private IOUtils$() {
        MODULE$ = this;
        this.objectMapper = new ScalaObjectMapper(){
            private final Class<Map<?, ?>> com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$$MAP;
            private final Class<Option<?>> com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$$OPTION;
            private final Class<Iterable<?>> com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$$ITERABLE;

            public Class<Map<?, ?>> com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$$MAP() {
                return this.com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$$MAP;
            }

            public Class<Option<?>> com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$$OPTION() {
                return this.com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$$OPTION;
            }

            public Class<Iterable<?>> com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$$ITERABLE() {
                return this.com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$$ITERABLE;
            }

            public void com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$_setter_$com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$$MAP_$eq(Class x$1) {
                this.com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$$MAP = x$1;
            }

            public void com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$_setter_$com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$$OPTION_$eq(Class x$1) {
                this.com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$$OPTION = x$1;
            }

            public void com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$_setter_$com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$$ITERABLE_$eq(Class x$1) {
                this.com$fasterxml$jackson$module$scala$experimental$ScalaObjectMapper$$ITERABLE = x$1;
            }

            public final <Target, MixinSource> ObjectMapper addMixin(Manifest<Target> evidence$1, Manifest<MixinSource> evidence$2) {
                return ScalaObjectMapper.class.addMixin((ObjectMapper)this, evidence$1, evidence$2);
            }

            public final <Target, MixinSource> ObjectMapper addMixInAnnotations(Manifest<Target> evidence$3, Manifest<MixinSource> evidence$4) {
                return ScalaObjectMapper.class.addMixInAnnotations((ObjectMapper)this, evidence$3, evidence$4);
            }

            public final <T> Class<?> findMixInClassFor(Manifest<T> evidence$5) {
                return ScalaObjectMapper.class.findMixInClassFor((ObjectMapper)this, evidence$5);
            }

            public <T> JavaType constructType(Manifest<T> m) {
                return ScalaObjectMapper.class.constructType((ObjectMapper)this, m);
            }

            public <T> T readValue(JsonParser jp, Manifest<T> evidence$6) {
                return (T)ScalaObjectMapper.class.readValue((ObjectMapper)this, (JsonParser)jp, evidence$6);
            }

            public <T> MappingIterator<T> readValues(JsonParser jp, Manifest<T> evidence$7) {
                return ScalaObjectMapper.class.readValues((ObjectMapper)this, (JsonParser)jp, evidence$7);
            }

            public <T> T treeToValue(TreeNode n, Manifest<T> evidence$8) {
                return (T)ScalaObjectMapper.class.treeToValue((ObjectMapper)this, (TreeNode)n, evidence$8);
            }

            public <T> boolean canSerialize(Manifest<T> evidence$9) {
                return ScalaObjectMapper.class.canSerialize((ObjectMapper)this, evidence$9);
            }

            public <T> boolean canDeserialize(Manifest<T> evidence$10) {
                return ScalaObjectMapper.class.canDeserialize((ObjectMapper)this, evidence$10);
            }

            public <T> T readValue(File src, Manifest<T> evidence$11) {
                return (T)ScalaObjectMapper.class.readValue((ObjectMapper)this, (File)src, evidence$11);
            }

            public <T> T readValue(URL src, Manifest<T> evidence$12) {
                return (T)ScalaObjectMapper.class.readValue((ObjectMapper)this, (URL)src, evidence$12);
            }

            public <T> T readValue(String content, Manifest<T> evidence$13) {
                return (T)ScalaObjectMapper.class.readValue((ObjectMapper)this, (String)content, evidence$13);
            }

            public <T> T readValue(Reader src, Manifest<T> evidence$14) {
                return (T)ScalaObjectMapper.class.readValue((ObjectMapper)this, (Reader)src, evidence$14);
            }

            public <T> T readValue(InputStream src, Manifest<T> evidence$15) {
                return (T)ScalaObjectMapper.class.readValue((ObjectMapper)this, (InputStream)src, evidence$15);
            }

            public <T> T readValue(byte[] src, Manifest<T> evidence$16) {
                return (T)ScalaObjectMapper.class.readValue((ObjectMapper)this, (byte[])src, evidence$16);
            }

            public <T> T readValue(byte[] src, int offset, int len, Manifest<T> evidence$17) {
                return (T)ScalaObjectMapper.class.readValue((ObjectMapper)this, (byte[])src, (int)offset, (int)len, evidence$17);
            }

            public <T> ObjectWriter writerWithView(Manifest<T> evidence$18) {
                return ScalaObjectMapper.class.writerWithView((ObjectMapper)this, evidence$18);
            }

            public <T> ObjectWriter writerWithType(Manifest<T> evidence$19) {
                return ScalaObjectMapper.class.writerWithType((ObjectMapper)this, evidence$19);
            }

            public <T> ObjectWriter writerFor(Manifest<T> evidence$20) {
                return ScalaObjectMapper.class.writerFor((ObjectMapper)this, evidence$20);
            }

            public <T> ObjectReader reader(Manifest<T> evidence$21) {
                return ScalaObjectMapper.class.reader((ObjectMapper)this, evidence$21);
            }

            public <T> ObjectReader readerFor(Manifest<T> evidence$22) {
                return ScalaObjectMapper.class.readerFor((ObjectMapper)this, evidence$22);
            }

            public <T> ObjectReader readerWithView(Manifest<T> evidence$23) {
                return ScalaObjectMapper.class.readerWithView((ObjectMapper)this, evidence$23);
            }

            public <T> T convertValue(Object fromValue, Manifest<T> evidence$24) {
                return (T)ScalaObjectMapper.class.convertValue((ObjectMapper)this, (Object)fromValue, evidence$24);
            }

            public <T> JsonSchema generateJsonSchema(Manifest<T> evidence$25) {
                return ScalaObjectMapper.class.generateJsonSchema((ObjectMapper)this, evidence$25);
            }

            public <T> void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, Manifest<T> evidence$26) {
                ScalaObjectMapper.class.acceptJsonFormatVisitor((ObjectMapper)this, (JsonFormatVisitorWrapper)visitor, evidence$26);
            }
            {
                ScalaObjectMapper.class.$init$((ObjectMapper)this);
            }
        };
        this.objectMapper().registerModule((Module)DefaultScalaModule$.MODULE$);
        this.objectWriter = this.objectMapper().writer((PrettyPrinter)new DefaultPrettyPrinter());
    }
}

