/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.sparkmeasure;

import ch.cern.sparkmeasure.Utils$;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkConf;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.apache.spark.scheduler.SparkListenerApplicationStart;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerExecutorAdded;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerStageSubmitted;
import org.apache.spark.scheduler.cluster.ExecutorInfo;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionEnd;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionStart;
import org.influxdb.BatchOptions;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]d\u0001B\u0001\u0003\u0001%\u0011A\"\u00138gYVDHIQ*j].T!a\u0001\u0003\u0002\u0019M\u0004\u0018M]6nK\u0006\u001cXO]3\u000b\u0005\u00151\u0011\u0001B2fe:T\u0011aB\u0001\u0003G\"\u001c\u0001a\u0005\u0002\u0001\u0015A\u00111\u0002F\u0007\u0002\u0019)\u0011QBD\u0001\ng\u000eDW\rZ;mKJT!a\u0004\t\u0002\u000bM\u0004\u0018M]6\u000b\u0005E\u0011\u0012AB1qC\u000eDWMC\u0001\u0014\u0003\ry'oZ\u0005\u0003+1\u0011Qb\u00159be.d\u0015n\u001d;f]\u0016\u0014\b\u0002C\f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r\u0002\t\r|gN\u001a\t\u00033ii\u0011AD\u0005\u000379\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u000bu\u0001A\u0011\u0001\u0010\u0002\rqJg.\u001b;?)\ty\u0012\u0005\u0005\u0002!\u00015\t!\u0001C\u0003\u00189\u0001\u0007\u0001\u0004\u0003\u0005$\u0001!\u0015\r\u0011\"\u0001%\u0003\u0019awnZ4feV\tQ\u0005\u0005\u0002'S5\tqE\u0003\u0002)%\u0005)1\u000f\u001c45U&\u0011!f\n\u0002\u0007\u0019><w-\u001a:\t\u00111\u0002\u0001\u0012!Q!\n\u0015\nq\u0001\\8hO\u0016\u0014\b\u0005C\u0004/\u0001\t\u0007I\u0011A\u0018\u0002\u0007U\u0014H.F\u00011!\t\ttG\u0004\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14'\u0001\u0004Qe\u0016$WMZ\u0005\u0003qe\u0012aa\u0015;sS:<'B\u0001\u001c4\u0011\u0019Y\u0004\u0001)A\u0005a\u0005!QO\u001d7!\u0011)i\u0004\u0001%A\u0001\u0004\u0003\u0006IAP\u0001\u0004q\u0012\n\u0004\u0003\u0002\u001a@aAJ!\u0001Q\u001a\u0003\rQ+\b\u000f\\33\u0011\u001d\u0011\u0005A1A\u0005\u0002=\n\u0001\"^:fe:\fW.\u001a\u0005\u0007\t\u0002\u0001\u000b\u0011\u0002\u0019\u0002\u0013U\u001cXM\u001d8b[\u0016\u0004\u0003b\u0002$\u0001\u0005\u0004%\taL\u0001\ta\u0006\u001c8o^8sI\"1\u0001\n\u0001Q\u0001\nA\n\u0011\u0002]1tg^|'\u000f\u001a\u0011\t\u000f)\u0003!\u0019!C\u0001\u0017\u0006A\u0011N\u001c4mkb$%)F\u0001M!\ti\u0005+D\u0001O\u0015\ty%#\u0001\u0005j]\u001adW\u000f\u001f3c\u0013\t\tfJ\u0001\u0005J]\u001adW\u000f\u001f#C\u0011\u0019\u0019\u0006\u0001)A\u0005\u0019\u0006I\u0011N\u001c4mkb$%\t\t\u0005\b+\u0002\u0011\r\u0011\"\u00010\u0003\u0019!'MT1nK\"1q\u000b\u0001Q\u0001\nA\nq\u0001\u001a2OC6,\u0007\u0005C\u0004Z\u0001\t\u0007I\u0011A&\u0002\u0011\u0011\fG/\u00192bg\u0016Daa\u0017\u0001!\u0002\u0013a\u0015!\u00033bi\u0006\u0014\u0017m]3!\u0011\u001di\u0006A1A\u0005\u0002y\u000bq\u0002\\8h'R\fw-Z'fiJL7m]\u000b\u0002?B\u0011!\u0007Y\u0005\u0003CN\u0012qAQ8pY\u0016\fg\u000e\u0003\u0004d\u0001\u0001\u0006IaX\u0001\u0011Y><7\u000b^1hK6+GO]5dg\u0002Bq!\u001a\u0001C\u0002\u0013\u0005a,A\u0006f]\u0006\u0014G.\u001a\"bi\u000eD\u0007BB4\u0001A\u0003%q,\u0001\u0007f]\u0006\u0014G.\u001a\"bi\u000eD\u0007\u0005C\u0004j\u0001\u0001\u0007I\u0011\u00016\u0002\u000b\u0005\u0004\b/\u00133\u0016\u0003-\u0004\"\u0001\\9\u000e\u00035T!A\\8\u0002\t1\fgn\u001a\u0006\u0002a\u0006!!.\u0019<b\u0013\tAT\u000eC\u0004t\u0001\u0001\u0007I\u0011\u0001;\u0002\u0013\u0005\u0004\b/\u00133`I\u0015\fHCA;y!\t\u0011d/\u0003\u0002xg\t!QK\\5u\u0011\u001di$/!AA\u0002-DaA\u001f\u0001!B\u0013Y\u0017AB1qa&#\u0007\u0005C\u0003}\u0001\u0011\u0005S0A\bp]\u0016CXmY;u_J\fE\rZ3e)\t)h\u0010\u0003\u0004\u0000w\u0002\u0007\u0011\u0011A\u0001\u000eKb,7-\u001e;pe\u0006#G-\u001a3\u0011\u0007-\t\u0019!C\u0002\u0002\u00061\u0011!d\u00159be.d\u0015n\u001d;f]\u0016\u0014X\t_3dkR|'/\u00113eK\u0012Dq!!\u0003\u0001\t\u0003\nY!\u0001\tp]N#\u0018mZ3Tk\nl\u0017\u000e\u001e;fIR\u0019Q/!\u0004\t\u0011\u0005=\u0011q\u0001a\u0001\u0003#\tab\u001d;bO\u0016\u001cVOY7jiR,G\rE\u0002\f\u0003'I1!!\u0006\r\u0005m\u0019\u0006/\u0019:l\u0019&\u001cH/\u001a8feN#\u0018mZ3Tk\nl\u0017\u000e\u001e;fI\"9\u0011\u0011\u0004\u0001\u0005B\u0005m\u0011\u0001E8o'R\fw-Z\"p[BdW\r^3e)\r)\u0018Q\u0004\u0005\t\u0003?\t9\u00021\u0001\u0002\"\u0005q1\u000f^1hK\u000e{W\u000e\u001d7fi\u0016$\u0007cA\u0006\u0002$%\u0019\u0011Q\u0005\u0007\u00037M\u0003\u0018M]6MSN$XM\\3s'R\fw-Z\"p[BdW\r^3e\u0011\u001d\tI\u0003\u0001C!\u0003W\tAb\u001c8Pi\",'/\u0012<f]R$2!^A\u0017\u0011!\ty#a\nA\u0002\u0005E\u0012!B3wK:$\bcA\u0006\u00024%\u0019\u0011Q\u0007\u0007\u0003%M\u0003\u0018M]6MSN$XM\\3s\u000bZ,g\u000e\u001e\u0005\b\u0003s\u0001A\u0011IA\u001e\u0003)ygNS8c'R\f'\u000f\u001e\u000b\u0004k\u0006u\u0002\u0002CA \u0003o\u0001\r!!\u0011\u0002\u0011)|'m\u0015;beR\u00042aCA\"\u0013\r\t)\u0005\u0004\u0002\u0016'B\f'o\u001b'jgR,g.\u001a:K_\n\u001cF/\u0019:u\u0011\u001d\tI\u0005\u0001C!\u0003\u0017\n\u0001b\u001c8K_\n,e\u000e\u001a\u000b\u0004k\u00065\u0003\u0002CA(\u0003\u000f\u0002\r!!\u0015\u0002\r)|'-\u00128e!\rY\u00111K\u0005\u0004\u0003+b!aE*qCJ\\G*[:uK:,'OS8c\u000b:$\u0007bBA-\u0001\u0011\u0005\u00131L\u0001\u0013_:\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8Ti\u0006\u0014H\u000fF\u0002v\u0003;B\u0001\"a\u0018\u0002X\u0001\u0007\u0011\u0011M\u0001\u0011CB\u0004H.[2bi&|gn\u0015;beR\u00042aCA2\u0013\r\t)\u0007\u0004\u0002\u001e'B\f'o\u001b'jgR,g.\u001a:BaBd\u0017nY1uS>t7\u000b^1si\"9\u0011\u0011\u000e\u0001\u0005B\u0005-\u0014\u0001E8o\u0003B\u0004H.[2bi&|g.\u00128e)\r)\u0018Q\u000e\u0005\t\u0003_\n9\u00071\u0001\u0002r\u0005q\u0011\r\u001d9mS\u000e\fG/[8o\u000b:$\u0007cA\u0006\u0002t%\u0019\u0011Q\u000f\u0007\u00037M\u0003\u0018M]6MSN$XM\\3s\u0003B\u0004H.[2bi&|g.\u00128e\u0001")
public class InfluxDBSink
extends SparkListener {
    private Logger logger;
    private final String url;
    private final /* synthetic */ Tuple2 x$1;
    private final String username;
    private final String password;
    private final InfluxDB influxDB;
    private final String dbName;
    private final InfluxDB database;
    private final boolean logStageMetrics;
    private final boolean enableBatch;
    private String appId;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        InfluxDBSink influxDBSink = this;
        synchronized (influxDBSink) {
            if (!this.bitmap$0) {
                this.logger = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String url() {
        return this.url;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public InfluxDB influxDB() {
        return this.influxDB;
    }

    public String dbName() {
        return this.dbName;
    }

    public InfluxDB database() {
        return this.database;
    }

    public boolean logStageMetrics() {
        return this.logStageMetrics;
    }

    public boolean enableBatch() {
        return this.enableBatch;
    }

    public String appId() {
        return this.appId;
    }

    public void appId_$eq(String x$1) {
        this.appId = x$1;
    }

    public void onExecutorAdded(SparkListenerExecutorAdded executorAdded) {
        String executorId = executorAdded.executorId();
        ExecutorInfo executorInfo = executorAdded.executorInfo();
        long startTime = executorAdded.time();
        Point point = Point.measurement((String)"executors_started").tag("applicationId", this.appId()).addField("executorId", executorId).addField("executorHost", executorInfo.executorHost()).addField("totalCores", (long)executorInfo.totalCores()).time(startTime, TimeUnit.MILLISECONDS).build();
        this.database().write(point);
    }

    public void onStageSubmitted(SparkListenerStageSubmitted stageSubmitted) {
        long submissionTime = BoxesRunTime.unboxToLong((Object)stageSubmitted.stageInfo().submissionTime().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        int attemptNumber = stageSubmitted.stageInfo().attemptNumber();
        int stageId = stageSubmitted.stageInfo().stageId();
        Point point = Point.measurement((String)"stages_started").tag("applicationId", this.appId()).addField("stageId", (long)stageId).addField("attemptNUmber", (long)attemptNumber).time(submissionTime, TimeUnit.MILLISECONDS).build();
        this.database().write(point);
    }

    public void onStageCompleted(SparkListenerStageCompleted stageCompleted) {
        int stageId = stageCompleted.stageInfo().stageId();
        long submissionTime = BoxesRunTime.unboxToLong((Object)stageCompleted.stageInfo().submissionTime().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        long completionTime = BoxesRunTime.unboxToLong((Object)stageCompleted.stageInfo().completionTime().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        int attemptNumber = stageCompleted.stageInfo().attemptNumber();
        Point point1 = Point.measurement((String)"stages_ended").tag("applicationId", this.appId()).time(completionTime, TimeUnit.MILLISECONDS).addField("stageId", (long)stageId).addField("attemptNumber", (long)attemptNumber).addField("submissionTime", submissionTime).build();
        this.database().write(point1);
        if (this.logStageMetrics()) {
            TaskMetrics taskmetrics = stageCompleted.stageInfo().taskMetrics();
            Point point2 = Point.measurement((String)"stage_metrics").tag("applicationId", this.appId()).time(completionTime, TimeUnit.MILLISECONDS).addField("stageId", (long)stageId).addField("attemptNumber", (long)attemptNumber).addField("failureReason", (String)stageCompleted.stageInfo().failureReason().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            })).addField("submissionTime", submissionTime).addField("completionTime", completionTime).addField("executorRunTime", taskmetrics.executorRunTime()).addField("executorCpuTime", taskmetrics.executorCpuTime()).addField("executorDeserializeCpuTime", taskmetrics.executorDeserializeCpuTime()).addField("executorDeserializeTime", taskmetrics.executorDeserializeTime()).addField("jvmGCTime", taskmetrics.jvmGCTime()).addField("memoryBytesSpilled", taskmetrics.memoryBytesSpilled()).addField("peakExecutionMemory", taskmetrics.peakExecutionMemory()).addField("resultSerializationTime", taskmetrics.resultSerializationTime()).addField("resultSize", taskmetrics.resultSize()).addField("bytesRead", taskmetrics.inputMetrics().bytesRead()).addField("recordsRead", taskmetrics.inputMetrics().recordsRead()).addField("bytesWritten", taskmetrics.outputMetrics().bytesWritten()).addField("recordsWritten", taskmetrics.outputMetrics().recordsWritten()).addField("shuffleTotalBytesRead", taskmetrics.shuffleReadMetrics().totalBytesRead()).addField("shuffleRemoteBytesRead", taskmetrics.shuffleReadMetrics().remoteBytesRead()).addField("shuffleRemoteBytesReadToDisk", taskmetrics.shuffleReadMetrics().remoteBytesReadToDisk()).addField("shuffleLocalBytesRead", taskmetrics.shuffleReadMetrics().localBytesRead()).addField("shuffleTotalBlocksFetched", taskmetrics.shuffleReadMetrics().totalBlocksFetched()).addField("shuffleLocalBlocksFetched", taskmetrics.shuffleReadMetrics().localBlocksFetched()).addField("shuffleRemoteBlocksFetched", taskmetrics.shuffleReadMetrics().remoteBlocksFetched()).addField("shuffleRecordsRead", taskmetrics.shuffleReadMetrics().recordsRead()).addField("shuffleFetchWaitTime", taskmetrics.shuffleReadMetrics().fetchWaitTime()).addField("shuffleBytesWritten", taskmetrics.shuffleWriteMetrics().bytesWritten()).addField("shuffleRecordsWritten", taskmetrics.shuffleWriteMetrics().recordsWritten()).addField("shuffleWriteTime", taskmetrics.shuffleWriteMetrics().writeTime()).build();
            this.database().write(point2);
        }
    }

    public void onOtherEvent(SparkListenerEvent event) {
        SparkListenerEvent sparkListenerEvent = event;
        if (sparkListenerEvent instanceof SparkListenerSQLExecutionStart) {
            SparkListenerSQLExecutionStart sparkListenerSQLExecutionStart = (SparkListenerSQLExecutionStart)sparkListenerEvent;
            long startTime = sparkListenerSQLExecutionStart.time();
            long queryId = sparkListenerSQLExecutionStart.executionId();
            String description = sparkListenerSQLExecutionStart.description();
            Point point = Point.measurement((String)"queries_started").tag("applicationId", this.appId()).time(startTime, TimeUnit.MILLISECONDS).addField("description", description).addField("queryId", queryId).build();
            this.database().write(point);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerSQLExecutionEnd) {
            SparkListenerSQLExecutionEnd sparkListenerSQLExecutionEnd = (SparkListenerSQLExecutionEnd)sparkListenerEvent;
            long endTime = sparkListenerSQLExecutionEnd.time();
            long queryId = sparkListenerSQLExecutionEnd.executionId();
            Point point = Point.measurement((String)"queries_ended").tag("applicationId", this.appId()).time(endTime, TimeUnit.MILLISECONDS).addField("queryId", queryId).build();
            this.database().write(point);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void onJobStart(SparkListenerJobStart jobStart) {
        long startTime = jobStart.time();
        int jobId = jobStart.jobId();
        Point point = Point.measurement((String)"jobs_started").tag("applicationId", this.appId()).time(startTime, TimeUnit.MILLISECONDS).addField("jobID", (long)jobId).build();
        this.database().write(point);
    }

    public void onJobEnd(SparkListenerJobEnd jobEnd) {
        long completionTime = jobEnd.time();
        int jobId = jobEnd.jobId();
        Point point = Point.measurement((String)"jobs_ended").tag("applicationId", this.appId()).time(completionTime, TimeUnit.MILLISECONDS).addField("jobID", (long)jobId).build();
        this.database().write(point);
    }

    public void onApplicationStart(SparkListenerApplicationStart applicationStart) {
        this.appId_$eq((String)applicationStart.appId().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "noAppId";
            }
        }));
    }

    public void onApplicationEnd(SparkListenerApplicationEnd applicationEnd) {
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Spark application ended, timestamp = ", ", closing InfluxDB connection."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)applicationEnd.time())})));
        this.influxDB().close();
    }

    public InfluxDBSink(SparkConf conf) {
        this.logger().warn("Custom monitoring listener with InfluxDB sink initializing. Now attempting to connect to InfluxDB");
        this.url = Utils$.MODULE$.parseInfluxDBURL(conf, this.logger());
        Tuple2<String, String> tuple2 = Utils$.MODULE$.parseInfluxDBCredentials(conf, this.logger());
        if (tuple2 != null) {
            String string;
            Tuple2 tuple22;
            String username = (String)tuple2._1();
            String password = (String)tuple2._2();
            this.x$1 = tuple22 = new Tuple2((Object)username, (Object)password);
            this.username = (String)this.x$1._1();
            this.password = (String)this.x$1._2();
            String string2 = this.username();
            InfluxDB influxDB = string2.isEmpty() ? InfluxDBFactory.connect((String)this.url()) : InfluxDBFactory.connect((String)this.url(), (String)this.username(), (String)this.password());
            this.influxDB = influxDB;
            this.dbName = Utils$.MODULE$.parseInfluxDBName(conf, this.logger());
            if (!this.influxDB().databaseExists(this.dbName())) {
                this.influxDB().createDatabase(this.dbName());
            }
            this.database = this.influxDB().setDatabase(this.dbName());
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"using InfluxDB database ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dbName()})));
            this.logStageMetrics = Utils$.MODULE$.parseInfluxDBStagemetrics(conf, this.logger());
            this.enableBatch = conf.getBoolean("spark.sparkmeasure.influxdbEnableBatch", true);
            Object object = this.enableBatch() ? this.influxDB().enableBatch(BatchOptions.DEFAULTS.actions(1000).flushDuration(1000)) : BoxedUnit.UNIT;
            this.appId = "noAppId";
            Option option = SparkSession$.MODULE$.getActiveSession();
            if (option instanceof Some) {
                Some some = (Some)option;
                SparkSession sparkSession = (SparkSession)some.x();
                string = sparkSession.sparkContext().applicationId();
            } else {
                string = "noAppId";
            }
            this.appId_$eq(string);
            return;
        }
        throw new MatchError(tuple2);
    }
}

