/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.sparkmeasure;

import ch.cern.sparkmeasure.Utils$;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkConf;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.apache.spark.scheduler.SparkListenerApplicationStart;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerStageSubmitted;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionEnd;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionStart;
import org.influxdb.BatchOptions;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001B\u000f\u001f\u0001\u0015B\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\u0006o\u0001!\t\u0001\u000f\u0005\ty\u0001A)\u0019!C\u0001{!9A\t\u0001b\u0001\n\u0003)\u0005BB*\u0001A\u0003%a\t\u0003\u0006U\u0001A\u0005\t1!Q\u0001\nUCq!\u0017\u0001C\u0002\u0013\u0005Q\t\u0003\u0004[\u0001\u0001\u0006IA\u0012\u0005\b7\u0002\u0011\r\u0011\"\u0001F\u0011\u0019a\u0006\u0001)A\u0005\r\"9Q\f\u0001b\u0001\n\u0003q\u0006BB3\u0001A\u0003%q\fC\u0004g\u0001\t\u0007I\u0011A#\t\r\u001d\u0004\u0001\u0015!\u0003G\u0011\u001dA\u0007A1A\u0005\u0002yCa!\u001b\u0001!\u0002\u0013y\u0006b\u00026\u0001\u0005\u0004%\ta\u001b\u0005\u0007_\u0002\u0001\u000b\u0011\u00027\t\u000fA\u0004\u0001\u0019!C\u0001c\"9\u0011\u0010\u0001a\u0001\n\u0003Q\bBB@\u0001A\u0003&!\u000fC\u0004\u0002\u0002\u0001!\t%a\u0001\t\u000f\u0005=\u0001\u0001\"\u0011\u0002\u0012!9\u0011Q\u0004\u0001\u0005B\u0005}\u0001bBA\u0016\u0001\u0011\u0005\u0013Q\u0006\u0005\b\u0003s\u0001A\u0011IA\u001e\u0011\u001d\t9\u0005\u0001C!\u0003\u0013Bq!!\u0016\u0001\t\u0003\n9F\u0001\u0007J]\u001adW\u000f\u001f#C'&t7N\u0003\u0002 A\u0005a1\u000f]1sW6,\u0017m];sK*\u0011\u0011EI\u0001\u0005G\u0016\u0014hNC\u0001$\u0003\t\u0019\u0007n\u0001\u0001\u0014\u0005\u00011\u0003CA\u00141\u001b\u0005A#BA\u0015+\u0003%\u00198\r[3ek2,'O\u0003\u0002,Y\u0005)1\u000f]1sW*\u0011QFL\u0001\u0007CB\f7\r[3\u000b\u0003=\n1a\u001c:h\u0013\t\t\u0004FA\u0007Ta\u0006\u00148\u000eT5ti\u0016tWM]\u0001\u0005G>tg\r\u0005\u00025k5\t!&\u0003\u00027U\tI1\u000b]1sW\u000e{gNZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005eZ\u0004C\u0001\u001e\u0001\u001b\u0005q\u0002\"\u0002\u001a\u0003\u0001\u0004\u0019\u0014A\u00027pO\u001e,'/F\u0001?!\ty$)D\u0001A\u0015\t\te&A\u0003tY\u001a$$.\u0003\u0002D\u0001\n1Aj\\4hKJ\f1!\u001e:m+\u00051\u0005CA$Q\u001d\tAe\n\u0005\u0002J\u00196\t!J\u0003\u0002LI\u00051AH]8pizR\u0011!T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f2\u000ba\u0001\u0015:fI\u00164\u0017BA)S\u0005\u0019\u0019FO]5oO*\u0011q\nT\u0001\u0005kJd\u0007%A\u0002yIE\u0002BAV,G\r6\tA*\u0003\u0002Y\u0019\n1A+\u001e9mKJ\n\u0001\"^:fe:\fW.Z\u0001\nkN,'O\\1nK\u0002\n\u0001\u0002]1tg^|'\u000fZ\u0001\na\u0006\u001c8o^8sI\u0002\n\u0001\"\u001b8gYVDHIQ\u000b\u0002?B\u0011\u0001mY\u0007\u0002C*\u0011!ML\u0001\tS:4G.\u001e=eE&\u0011A-\u0019\u0002\t\u0013:4G.\u001e=E\u0005\u0006I\u0011N\u001c4mkb$%\tI\u0001\u0007I\nt\u0015-\\3\u0002\u000f\u0011\u0014g*Y7fA\u0005AA-\u0019;bE\u0006\u001cX-A\u0005eCR\f'-Y:fA\u0005yAn\\4Ti\u0006<W-T3ue&\u001c7/F\u0001m!\t1V.\u0003\u0002o\u0019\n9!i\\8mK\u0006t\u0017\u0001\u00057pON#\u0018mZ3NKR\u0014\u0018nY:!\u0003\u0015\t\u0007\u000f]%e+\u0005\u0011\bCA:y\u001b\u0005!(BA;w\u0003\u0011a\u0017M\\4\u000b\u0003]\fAA[1wC&\u0011\u0011\u000b^\u0001\nCB\u0004\u0018\nZ0%KF$\"a\u001f@\u0011\u0005Yc\u0018BA?M\u0005\u0011)f.\u001b;\t\u000fQ#\u0012\u0011!a\u0001e\u00061\u0011\r\u001d9JI\u0002\n\u0001c\u001c8Ti\u0006<WmU;c[&$H/\u001a3\u0015\u0007m\f)\u0001C\u0004\u0002\bY\u0001\r!!\u0003\u0002\u001dM$\u0018mZ3Tk\nl\u0017\u000e\u001e;fIB\u0019q%a\u0003\n\u0007\u00055\u0001FA\u000eTa\u0006\u00148\u000eT5ti\u0016tWM]*uC\u001e,7+\u001e2nSR$X\rZ\u0001\u0011_:\u001cF/Y4f\u0007>l\u0007\u000f\\3uK\u0012$2a_A\n\u0011\u001d\t)b\u0006a\u0001\u0003/\tab\u001d;bO\u0016\u001cu.\u001c9mKR,G\rE\u0002(\u00033I1!a\u0007)\u0005m\u0019\u0006/\u0019:l\u0019&\u001cH/\u001a8feN#\u0018mZ3D_6\u0004H.\u001a;fI\u0006aqN\\(uQ\u0016\u0014XI^3oiR\u001910!\t\t\u000f\u0005\r\u0002\u00041\u0001\u0002&\u0005)QM^3oiB\u0019q%a\n\n\u0007\u0005%\u0002F\u0001\nTa\u0006\u00148\u000eT5ti\u0016tWM]#wK:$\u0018AC8o\u0015>\u00147\u000b^1siR\u001910a\f\t\u000f\u0005E\u0012\u00041\u0001\u00024\u0005A!n\u001c2Ti\u0006\u0014H\u000fE\u0002(\u0003kI1!a\u000e)\u0005U\u0019\u0006/\u0019:l\u0019&\u001cH/\u001a8fe*{'m\u0015;beR\f\u0001b\u001c8K_\n,e\u000e\u001a\u000b\u0004w\u0006u\u0002bBA 5\u0001\u0007\u0011\u0011I\u0001\u0007U>\u0014WI\u001c3\u0011\u0007\u001d\n\u0019%C\u0002\u0002F!\u00121c\u00159be.d\u0015n\u001d;f]\u0016\u0014(j\u001c2F]\u0012\f!c\u001c8BaBd\u0017nY1uS>t7\u000b^1siR\u001910a\u0013\t\u000f\u000553\u00041\u0001\u0002P\u0005\u0001\u0012\r\u001d9mS\u000e\fG/[8o'R\f'\u000f\u001e\t\u0004O\u0005E\u0013bAA*Q\ti2\u000b]1sW2K7\u000f^3oKJ\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8Ti\u0006\u0014H/\u0001\tp]\u0006\u0003\b\u000f\\5dCRLwN\\#oIR\u001910!\u0017\t\u000f\u0005mC\u00041\u0001\u0002^\u0005q\u0011\r\u001d9mS\u000e\fG/[8o\u000b:$\u0007cA\u0014\u0002`%\u0019\u0011\u0011\r\u0015\u00037M\u0003\u0018M]6MSN$XM\\3s\u0003B\u0004H.[2bi&|g.\u00128e\u0001")
public class InfluxDBSink
extends SparkListener {
    private Logger logger;
    private final String url;
    private final /* synthetic */ Tuple2 x$1;
    private final String username;
    private final String password;
    private final InfluxDB influxDB;
    private final String dbName;
    private final InfluxDB database;
    private final boolean logStageMetrics;
    private String appId;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        InfluxDBSink influxDBSink = this;
        synchronized (influxDBSink) {
            if (!this.bitmap$0) {
                this.logger = LoggerFactory.getLogger((String)this.getClass().getName());
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public String url() {
        return this.url;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public InfluxDB influxDB() {
        return this.influxDB;
    }

    public String dbName() {
        return this.dbName;
    }

    public InfluxDB database() {
        return this.database;
    }

    public boolean logStageMetrics() {
        return this.logStageMetrics;
    }

    public String appId() {
        return this.appId;
    }

    public void appId_$eq(String x$1) {
        this.appId = x$1;
    }

    public void onStageSubmitted(SparkListenerStageSubmitted stageSubmitted) {
        long submissionTime = BoxesRunTime.unboxToLong((Object)stageSubmitted.stageInfo().submissionTime().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        int attemptNumber = stageSubmitted.stageInfo().attemptNumber();
        int stageId = stageSubmitted.stageInfo().stageId();
        Point point = Point.measurement((String)"stages_started").tag("applicationId", this.appId()).addField("stageId", (long)stageId).addField("attemptNUmber", (long)attemptNumber).time(submissionTime, TimeUnit.MILLISECONDS).build();
        this.database().write(point);
    }

    public void onStageCompleted(SparkListenerStageCompleted stageCompleted) {
        block0: {
            int stageId = stageCompleted.stageInfo().stageId();
            long submissionTime = BoxesRunTime.unboxToLong((Object)stageCompleted.stageInfo().submissionTime().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
            long completionTime = BoxesRunTime.unboxToLong((Object)stageCompleted.stageInfo().completionTime().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
            int attemptNumber = stageCompleted.stageInfo().attemptNumber();
            Point point1 = Point.measurement((String)"stages_ended").tag("applicationId", this.appId()).time(completionTime, TimeUnit.MILLISECONDS).addField("stageId", (long)stageId).addField("attemptNumber", (long)attemptNumber).addField("submissionTime", submissionTime).build();
            this.database().write(point1);
            if (!this.logStageMetrics()) break block0;
            TaskMetrics taskmetrics = stageCompleted.stageInfo().taskMetrics();
            Point point2 = Point.measurement((String)"stage_metrics").tag("applicationId", this.appId()).time(completionTime, TimeUnit.MILLISECONDS).addField("stageId", (long)stageId).addField("attemptNumber", (long)attemptNumber).addField("failureReason", (String)stageCompleted.stageInfo().failureReason().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).addField("submissionTime", submissionTime).addField("completionTime", completionTime).addField("executorRunTime", taskmetrics.executorRunTime()).addField("executorCpuTime", taskmetrics.executorCpuTime()).addField("executorDeserializeCpuTime", taskmetrics.executorDeserializeCpuTime()).addField("executorDeserializeTime", taskmetrics.executorDeserializeTime()).addField("jvmGCTime", taskmetrics.jvmGCTime()).addField("memoryBytesSpilled", taskmetrics.memoryBytesSpilled()).addField("peakExecutionMemory", taskmetrics.peakExecutionMemory()).addField("resultSerializationTime", taskmetrics.resultSerializationTime()).addField("resultSize", taskmetrics.resultSize()).addField("bytesRead", taskmetrics.inputMetrics().bytesRead()).addField("recordsRead", taskmetrics.inputMetrics().recordsRead()).addField("bytesWritten", taskmetrics.outputMetrics().bytesWritten()).addField("recordsWritten", taskmetrics.outputMetrics().recordsWritten()).addField("shuffleTotalBytesRead", taskmetrics.shuffleReadMetrics().totalBytesRead()).addField("shuffleRemoteBytesRead", taskmetrics.shuffleReadMetrics().remoteBytesRead()).addField("shuffleLocalBytesRead", taskmetrics.shuffleReadMetrics().localBytesRead()).addField("shuffleTotalBlocksFetched", taskmetrics.shuffleReadMetrics().totalBlocksFetched()).addField("shuffleLocalBlocksFetched", taskmetrics.shuffleReadMetrics().localBlocksFetched()).addField("shuffleRemoteBlocksFetched", taskmetrics.shuffleReadMetrics().remoteBlocksFetched()).addField("shuffleRecordsRead", taskmetrics.shuffleReadMetrics().recordsRead()).addField("shuffleFetchWaitTime", taskmetrics.shuffleReadMetrics().fetchWaitTime()).addField("shuffleBytesWritten", taskmetrics.shuffleWriteMetrics().bytesWritten()).addField("shuffleRecordsWritten", taskmetrics.shuffleWriteMetrics().recordsWritten()).addField("shuffleWriteTime", taskmetrics.shuffleWriteMetrics().writeTime()).build();
            this.database().write(point2);
        }
    }

    public void onOtherEvent(SparkListenerEvent event) {
        SparkListenerEvent sparkListenerEvent = event;
        if (sparkListenerEvent instanceof SparkListenerSQLExecutionStart) {
            SparkListenerSQLExecutionStart sparkListenerSQLExecutionStart = (SparkListenerSQLExecutionStart)sparkListenerEvent;
            long startTime = sparkListenerSQLExecutionStart.time();
            long queryId = sparkListenerSQLExecutionStart.executionId();
            Point point = Point.measurement((String)"queries_started").tag("applicationId", this.appId()).time(startTime, TimeUnit.MILLISECONDS).addField("queryId", queryId).build();
            this.database().write(point);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerSQLExecutionEnd) {
            SparkListenerSQLExecutionEnd sparkListenerSQLExecutionEnd = (SparkListenerSQLExecutionEnd)sparkListenerEvent;
            long endTime = sparkListenerSQLExecutionEnd.time();
            long queryId = sparkListenerSQLExecutionEnd.executionId();
            Point point = Point.measurement((String)"queries_ended").tag("applicationId", this.appId()).time(endTime, TimeUnit.MILLISECONDS).addField("queryId", queryId).build();
            this.database().write(point);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void onJobStart(SparkListenerJobStart jobStart) {
        long startTime = jobStart.time();
        int jobId = jobStart.jobId();
        Point point = Point.measurement((String)"jobs_started").tag("applicationId", this.appId()).time(startTime, TimeUnit.MILLISECONDS).addField("jobID", (long)jobId).build();
        this.database().write(point);
    }

    public void onJobEnd(SparkListenerJobEnd jobEnd) {
        long completionTime = jobEnd.time();
        int jobId = jobEnd.jobId();
        Point point = Point.measurement((String)"jobs_ended").tag("applicationId", this.appId()).time(completionTime, TimeUnit.MILLISECONDS).addField("jobID", (long)jobId).build();
        this.database().write(point);
    }

    public void onApplicationStart(SparkListenerApplicationStart applicationStart) {
        this.appId_$eq((String)applicationStart.appId().getOrElse((Function0 & Serializable & scala.Serializable)() -> "noAppId"));
    }

    public void onApplicationEnd(SparkListenerApplicationEnd applicationEnd) {
        this.logger().info(new StringBuilder(67).append("Spark application ended, timestamp = ").append(applicationEnd.time()).append(", closing InfluxDB connection.").toString());
        this.influxDB().close();
    }

    public InfluxDBSink(SparkConf conf) {
        String string;
        this.logger().warn("Custom monitoring listener with InfluxDB sink initializing, now attempting to connect to InfluxDB");
        this.url = Utils$.MODULE$.parseInfluxDBURL(conf, this.logger());
        Tuple2<String, String> tuple2 = Utils$.MODULE$.parseInfluxDBCredentials(conf, this.logger());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String username = (String)tuple2._1();
        String password = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)username, (Object)password);
        this.x$1 = tuple22;
        this.username = (String)this.x$1._1();
        this.password = (String)this.x$1._2();
        String string2 = this.username();
        InfluxDB influxDB = string2.isEmpty() ? InfluxDBFactory.connect((String)this.url()) : InfluxDBFactory.connect((String)this.url(), (String)this.username(), (String)this.password());
        this.influxDB = influxDB;
        this.dbName = Utils$.MODULE$.parseInfluxDBName(conf, this.logger());
        if (!this.influxDB().databaseExists(this.dbName())) {
            this.influxDB().createDatabase(this.dbName());
        }
        this.database = this.influxDB().setDatabase(this.dbName());
        this.logger().info(new StringBuilder(24).append("using INfluxDB database ").append(this.dbName()).toString());
        this.logStageMetrics = Utils$.MODULE$.parseInfluxDBStagemetrics(conf, this.logger());
        this.influxDB().enableBatch(BatchOptions.DEFAULTS.actions(1000).flushDuration(1000));
        this.appId = "noAppId";
        Option option = SparkSession$.MODULE$.getActiveSession();
        if (option instanceof Some) {
            Some some = (Some)option;
            SparkSession sparkSession = (SparkSession)some.value();
            string = sparkSession.sparkContext().applicationId();
        } else {
            string = "noAppId";
        }
        this.appId_$eq(string);
    }
}

