/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.sparkmeasure;

import ch.cern.sparkmeasure.Utils$;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkConf;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.apache.spark.scheduler.SparkListenerApplicationStart;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerExecutorAdded;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerStageSubmitted;
import org.apache.spark.scheduler.cluster.ExecutorInfo;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionEnd;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionStart;
import org.influxdb.BatchOptions;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001\u0002\u0011\"\u0001!B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\u0006u\u0001!\ta\u000f\u0005\t\u007f\u0001A)\u0019!C\u0001\u0001\"9q\t\u0001b\u0001\n\u0003A\u0005B\u0002,\u0001A\u0003%\u0011\n\u0003\u0006X\u0001A\u0005\t1!Q\u0001\naCq\u0001\u0018\u0001C\u0002\u0013\u0005\u0001\n\u0003\u0004^\u0001\u0001\u0006I!\u0013\u0005\b=\u0002\u0011\r\u0011\"\u0001I\u0011\u0019y\u0006\u0001)A\u0005\u0013\"9\u0001\r\u0001b\u0001\n\u0003\t\u0007B\u00025\u0001A\u0003%!\rC\u0004j\u0001\t\u0007I\u0011\u0001%\t\r)\u0004\u0001\u0015!\u0003J\u0011\u001dY\u0007A1A\u0005\u0002\u0005Da\u0001\u001c\u0001!\u0002\u0013\u0011\u0007bB7\u0001\u0005\u0004%\tA\u001c\u0005\u0007e\u0002\u0001\u000b\u0011B8\t\u000fM\u0004!\u0019!C\u0001]\"1A\u000f\u0001Q\u0001\n=Dq!\u001e\u0001A\u0002\u0013\u0005a\u000fC\u0004\u007f\u0001\u0001\u0007I\u0011A@\t\u000f\u0005%\u0001\u0001)Q\u0005o\"9\u00111\u0002\u0001\u0005B\u00055\u0001bBA\r\u0001\u0011\u0005\u00131\u0004\u0005\b\u0003O\u0001A\u0011IA\u0015\u0011\u001d\t)\u0004\u0001C!\u0003oAq!a\u0011\u0001\t\u0003\n)\u0005C\u0004\u0002R\u0001!\t%a\u0015\t\u000f\u0005}\u0003\u0001\"\u0011\u0002b!9\u0011Q\u000e\u0001\u0005B\u0005=$\u0001D%oM2,\b\u0010\u0012\"TS:\\'B\u0001\u0012$\u00031\u0019\b/\u0019:l[\u0016\f7/\u001e:f\u0015\t!S%\u0001\u0003dKJt'\"\u0001\u0014\u0002\u0005\rD7\u0001A\n\u0003\u0001%\u0002\"AK\u001a\u000e\u0003-R!\u0001L\u0017\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(B\u0001\u00180\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0014'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002e\u0005\u0019qN]4\n\u0005QZ#!D*qCJ\\G*[:uK:,'/\u0001\u0003d_:4\u0007CA\u001c9\u001b\u0005i\u0013BA\u001d.\u0005%\u0019\u0006/\u0019:l\u0007>tg-\u0001\u0004=S:LGO\u0010\u000b\u0003yy\u0002\"!\u0010\u0001\u000e\u0003\u0005BQ!\u000e\u0002A\u0002Y\na\u0001\\8hO\u0016\u0014X#A!\u0011\u0005\t+U\"A\"\u000b\u0005\u0011\u000b\u0014!B:mMRR\u0017B\u0001$D\u0005\u0019aunZ4fe\u0006\u0019QO\u001d7\u0016\u0003%\u0003\"AS*\u000f\u0005-\u000b\u0006C\u0001'P\u001b\u0005i%B\u0001((\u0003\u0019a$o\\8u})\t\u0001+A\u0003tG\u0006d\u0017-\u0003\u0002S\u001f\u00061\u0001K]3eK\u001aL!\u0001V+\u0003\rM#(/\u001b8h\u0015\t\u0011v*\u0001\u0003ve2\u0004\u0013a\u0001=%cA!\u0011LW%J\u001b\u0005y\u0015BA.P\u0005\u0019!V\u000f\u001d7fe\u0005AQo]3s]\u0006lW-A\u0005vg\u0016\u0014h.Y7fA\u0005A\u0001/Y:to>\u0014H-A\u0005qCN\u001cxo\u001c:eA\u0005A\u0011N\u001c4mkb$%)F\u0001c!\t\u0019g-D\u0001e\u0015\t)\u0017'\u0001\u0005j]\u001adW\u000f\u001f3c\u0013\t9GM\u0001\u0005J]\u001adW\u000f\u001f#C\u0003%IgN\u001a7vq\u0012\u0013\u0005%\u0001\u0004eE:\u000bW.Z\u0001\bI\nt\u0015-\\3!\u0003!!\u0017\r^1cCN,\u0017!\u00033bi\u0006\u0014\u0017m]3!\u0003=awnZ*uC\u001e,W*\u001a;sS\u000e\u001cX#A8\u0011\u0005e\u0003\u0018BA9P\u0005\u001d\u0011un\u001c7fC:\f\u0001\u0003\\8h'R\fw-Z'fiJL7m\u001d\u0011\u0002\u0017\u0015t\u0017M\u00197f\u0005\u0006$8\r[\u0001\rK:\f'\r\\3CCR\u001c\u0007\u000eI\u0001\u0006CB\u0004\u0018\nZ\u000b\u0002oB\u0011\u00010`\u0007\u0002s*\u0011!p_\u0001\u0005Y\u0006twMC\u0001}\u0003\u0011Q\u0017M^1\n\u0005QK\u0018!C1qa&#w\fJ3r)\u0011\t\t!a\u0002\u0011\u0007e\u000b\u0019!C\u0002\u0002\u0006=\u0013A!\u00168ji\"9qKFA\u0001\u0002\u00049\u0018AB1qa&#\u0007%A\bp]\u0016CXmY;u_J\fE\rZ3e)\u0011\t\t!a\u0004\t\u000f\u0005E\u0001\u00041\u0001\u0002\u0014\u0005iQ\r_3dkR|'/\u00113eK\u0012\u00042AKA\u000b\u0013\r\t9b\u000b\u0002\u001b'B\f'o\u001b'jgR,g.\u001a:Fq\u0016\u001cW\u000f^8s\u0003\u0012$W\rZ\u0001\u0011_:\u001cF/Y4f'V\u0014W.\u001b;uK\u0012$B!!\u0001\u0002\u001e!9\u0011qD\rA\u0002\u0005\u0005\u0012AD:uC\u001e,7+\u001e2nSR$X\r\u001a\t\u0004U\u0005\r\u0012bAA\u0013W\tY2\u000b]1sW2K7\u000f^3oKJ\u001cF/Y4f'V\u0014W.\u001b;uK\u0012\f\u0001c\u001c8Ti\u0006<WmQ8na2,G/\u001a3\u0015\t\u0005\u0005\u00111\u0006\u0005\b\u0003[Q\u0002\u0019AA\u0018\u00039\u0019H/Y4f\u0007>l\u0007\u000f\\3uK\u0012\u00042AKA\u0019\u0013\r\t\u0019d\u000b\u0002\u001c'B\f'o\u001b'jgR,g.\u001a:Ti\u0006<WmQ8na2,G/\u001a3\u0002\u0019=tw\n\u001e5fe\u00163XM\u001c;\u0015\t\u0005\u0005\u0011\u0011\b\u0005\b\u0003wY\u0002\u0019AA\u001f\u0003\u0015)g/\u001a8u!\rQ\u0013qH\u0005\u0004\u0003\u0003Z#AE*qCJ\\G*[:uK:,'/\u0012<f]R\f!b\u001c8K_\n\u001cF/\u0019:u)\u0011\t\t!a\u0012\t\u000f\u0005%C\u00041\u0001\u0002L\u0005A!n\u001c2Ti\u0006\u0014H\u000fE\u0002+\u0003\u001bJ1!a\u0014,\u0005U\u0019\u0006/\u0019:l\u0019&\u001cH/\u001a8fe*{'m\u0015;beR\f\u0001b\u001c8K_\n,e\u000e\u001a\u000b\u0005\u0003\u0003\t)\u0006C\u0004\u0002Xu\u0001\r!!\u0017\u0002\r)|'-\u00128e!\rQ\u00131L\u0005\u0004\u0003;Z#aE*qCJ\\G*[:uK:,'OS8c\u000b:$\u0017AE8o\u0003B\u0004H.[2bi&|gn\u0015;beR$B!!\u0001\u0002d!9\u0011Q\r\u0010A\u0002\u0005\u001d\u0014\u0001E1qa2L7-\u0019;j_:\u001cF/\u0019:u!\rQ\u0013\u0011N\u0005\u0004\u0003WZ#!H*qCJ\\G*[:uK:,'/\u00119qY&\u001c\u0017\r^5p]N#\u0018M\u001d;\u0002!=t\u0017\t\u001d9mS\u000e\fG/[8o\u000b:$G\u0003BA\u0001\u0003cBq!a\u001d \u0001\u0004\t)(\u0001\bbaBd\u0017nY1uS>tWI\u001c3\u0011\u0007)\n9(C\u0002\u0002z-\u00121d\u00159be.d\u0015n\u001d;f]\u0016\u0014\u0018\t\u001d9mS\u000e\fG/[8o\u000b:$\u0007")
public class InfluxDBSink
extends SparkListener {
    private Logger logger;
    private final String url;
    private final /* synthetic */ Tuple2 x$1;
    private final String username;
    private final String password;
    private final InfluxDB influxDB;
    private final String dbName;
    private final InfluxDB database;
    private final boolean logStageMetrics;
    private final boolean enableBatch;
    private String appId;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        InfluxDBSink influxDBSink = this;
        synchronized (influxDBSink) {
            if (!this.bitmap$0) {
                this.logger = LoggerFactory.getLogger((String)this.getClass().getName());
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public String url() {
        return this.url;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public InfluxDB influxDB() {
        return this.influxDB;
    }

    public String dbName() {
        return this.dbName;
    }

    public InfluxDB database() {
        return this.database;
    }

    public boolean logStageMetrics() {
        return this.logStageMetrics;
    }

    public boolean enableBatch() {
        return this.enableBatch;
    }

    public String appId() {
        return this.appId;
    }

    public void appId_$eq(String x$1) {
        this.appId = x$1;
    }

    public void onExecutorAdded(SparkListenerExecutorAdded executorAdded) {
        String executorId = executorAdded.executorId();
        ExecutorInfo executorInfo = executorAdded.executorInfo();
        long startTime = executorAdded.time();
        Point point = Point.measurement((String)"executors_started").tag("applicationId", this.appId()).addField("executorId", executorId).addField("executorHost", executorInfo.executorHost()).addField("totalCores", (long)executorInfo.totalCores()).time(startTime, TimeUnit.MILLISECONDS).build();
        this.database().write(point);
    }

    public void onStageSubmitted(SparkListenerStageSubmitted stageSubmitted) {
        long submissionTime = BoxesRunTime.unboxToLong((Object)stageSubmitted.stageInfo().submissionTime().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        int attemptNumber = stageSubmitted.stageInfo().attemptNumber();
        int stageId = stageSubmitted.stageInfo().stageId();
        Point point = Point.measurement((String)"stages_started").tag("applicationId", this.appId()).addField("stageId", (long)stageId).addField("attemptNUmber", (long)attemptNumber).time(submissionTime, TimeUnit.MILLISECONDS).build();
        this.database().write(point);
    }

    public void onStageCompleted(SparkListenerStageCompleted stageCompleted) {
        block0: {
            int stageId = stageCompleted.stageInfo().stageId();
            long submissionTime = BoxesRunTime.unboxToLong((Object)stageCompleted.stageInfo().submissionTime().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
            long completionTime = BoxesRunTime.unboxToLong((Object)stageCompleted.stageInfo().completionTime().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
            int attemptNumber = stageCompleted.stageInfo().attemptNumber();
            Point point1 = Point.measurement((String)"stages_ended").tag("applicationId", this.appId()).time(completionTime, TimeUnit.MILLISECONDS).addField("stageId", (long)stageId).addField("attemptNumber", (long)attemptNumber).addField("submissionTime", submissionTime).build();
            this.database().write(point1);
            if (!this.logStageMetrics()) break block0;
            TaskMetrics taskmetrics = stageCompleted.stageInfo().taskMetrics();
            Point point2 = Point.measurement((String)"stage_metrics").tag("applicationId", this.appId()).time(completionTime, TimeUnit.MILLISECONDS).addField("stageId", (long)stageId).addField("attemptNumber", (long)attemptNumber).addField("failureReason", (String)stageCompleted.stageInfo().failureReason().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).addField("submissionTime", submissionTime).addField("completionTime", completionTime).addField("executorRunTime", taskmetrics.executorRunTime()).addField("executorCpuTime", taskmetrics.executorCpuTime()).addField("executorDeserializeCpuTime", taskmetrics.executorDeserializeCpuTime()).addField("executorDeserializeTime", taskmetrics.executorDeserializeTime()).addField("jvmGCTime", taskmetrics.jvmGCTime()).addField("memoryBytesSpilled", taskmetrics.memoryBytesSpilled()).addField("peakExecutionMemory", taskmetrics.peakExecutionMemory()).addField("resultSerializationTime", taskmetrics.resultSerializationTime()).addField("resultSize", taskmetrics.resultSize()).addField("bytesRead", taskmetrics.inputMetrics().bytesRead()).addField("recordsRead", taskmetrics.inputMetrics().recordsRead()).addField("bytesWritten", taskmetrics.outputMetrics().bytesWritten()).addField("recordsWritten", taskmetrics.outputMetrics().recordsWritten()).addField("shuffleTotalBytesRead", taskmetrics.shuffleReadMetrics().totalBytesRead()).addField("shuffleRemoteBytesRead", taskmetrics.shuffleReadMetrics().remoteBytesRead()).addField("shuffleLocalBytesRead", taskmetrics.shuffleReadMetrics().localBytesRead()).addField("shuffleTotalBlocksFetched", taskmetrics.shuffleReadMetrics().totalBlocksFetched()).addField("shuffleLocalBlocksFetched", taskmetrics.shuffleReadMetrics().localBlocksFetched()).addField("shuffleRemoteBlocksFetched", taskmetrics.shuffleReadMetrics().remoteBlocksFetched()).addField("shuffleRecordsRead", taskmetrics.shuffleReadMetrics().recordsRead()).addField("shuffleFetchWaitTime", taskmetrics.shuffleReadMetrics().fetchWaitTime()).addField("shuffleBytesWritten", taskmetrics.shuffleWriteMetrics().bytesWritten()).addField("shuffleRecordsWritten", taskmetrics.shuffleWriteMetrics().recordsWritten()).addField("shuffleWriteTime", taskmetrics.shuffleWriteMetrics().writeTime()).build();
            this.database().write(point2);
        }
    }

    public void onOtherEvent(SparkListenerEvent event) {
        SparkListenerEvent sparkListenerEvent = event;
        if (sparkListenerEvent instanceof SparkListenerSQLExecutionStart) {
            SparkListenerSQLExecutionStart sparkListenerSQLExecutionStart = (SparkListenerSQLExecutionStart)sparkListenerEvent;
            long startTime = sparkListenerSQLExecutionStart.time();
            long queryId = sparkListenerSQLExecutionStart.executionId();
            String description = sparkListenerSQLExecutionStart.description();
            Point point = Point.measurement((String)"queries_started").tag("applicationId", this.appId()).time(startTime, TimeUnit.MILLISECONDS).addField("description", description).addField("queryId", queryId).build();
            this.database().write(point);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerSQLExecutionEnd) {
            SparkListenerSQLExecutionEnd sparkListenerSQLExecutionEnd = (SparkListenerSQLExecutionEnd)sparkListenerEvent;
            long endTime = sparkListenerSQLExecutionEnd.time();
            long queryId = sparkListenerSQLExecutionEnd.executionId();
            Point point = Point.measurement((String)"queries_ended").tag("applicationId", this.appId()).time(endTime, TimeUnit.MILLISECONDS).addField("queryId", queryId).build();
            this.database().write(point);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void onJobStart(SparkListenerJobStart jobStart) {
        long startTime = jobStart.time();
        int jobId = jobStart.jobId();
        Point point = Point.measurement((String)"jobs_started").tag("applicationId", this.appId()).time(startTime, TimeUnit.MILLISECONDS).addField("jobID", (long)jobId).build();
        this.database().write(point);
    }

    public void onJobEnd(SparkListenerJobEnd jobEnd) {
        long completionTime = jobEnd.time();
        int jobId = jobEnd.jobId();
        Point point = Point.measurement((String)"jobs_ended").tag("applicationId", this.appId()).time(completionTime, TimeUnit.MILLISECONDS).addField("jobID", (long)jobId).build();
        this.database().write(point);
    }

    public void onApplicationStart(SparkListenerApplicationStart applicationStart) {
        this.appId_$eq((String)applicationStart.appId().getOrElse((Function0 & Serializable & scala.Serializable)() -> "noAppId"));
    }

    public void onApplicationEnd(SparkListenerApplicationEnd applicationEnd) {
        this.logger().info(new StringBuilder(67).append("Spark application ended, timestamp = ").append(applicationEnd.time()).append(", closing InfluxDB connection.").toString());
        this.influxDB().close();
    }

    public InfluxDBSink(SparkConf conf) {
        String string;
        this.logger().warn("Custom monitoring listener with InfluxDB sink initializing. Now attempting to connect to InfluxDB");
        this.url = Utils$.MODULE$.parseInfluxDBURL(conf, this.logger());
        Tuple2<String, String> tuple2 = Utils$.MODULE$.parseInfluxDBCredentials(conf, this.logger());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String username = (String)tuple2._1();
        String password = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)username, (Object)password);
        this.x$1 = tuple22;
        this.username = (String)this.x$1._1();
        this.password = (String)this.x$1._2();
        String string2 = this.username();
        InfluxDB influxDB = string2.isEmpty() ? InfluxDBFactory.connect((String)this.url()) : InfluxDBFactory.connect((String)this.url(), (String)this.username(), (String)this.password());
        this.influxDB = influxDB;
        this.dbName = Utils$.MODULE$.parseInfluxDBName(conf, this.logger());
        if (!this.influxDB().databaseExists(this.dbName())) {
            this.influxDB().createDatabase(this.dbName());
        }
        this.database = this.influxDB().setDatabase(this.dbName());
        this.logger().info(new StringBuilder(24).append("using InfluxDB database ").append(this.dbName()).toString());
        this.logStageMetrics = Utils$.MODULE$.parseInfluxDBStagemetrics(conf, this.logger());
        this.enableBatch = conf.getBoolean("spark.sparkmeasure.influxdbEnableBatch", true);
        Object object = this.enableBatch() ? this.influxDB().enableBatch(BatchOptions.DEFAULTS.actions(1000).flushDuration(1000)) : BoxedUnit.UNIT;
        this.appId = "noAppId";
        Option option = SparkSession$.MODULE$.getActiveSession();
        if (option instanceof Some) {
            Some some = (Some)option;
            SparkSession sparkSession = (SparkSession)some.value();
            string = sparkSession.sparkContext().applicationId();
        } else {
            string = "noAppId";
        }
        this.appId_$eq(string);
    }
}

